
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MapGenDecoderAttributes.h
    \\brief Definition of MapGenDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MapGenDecoderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MapGenDecoderAttributes::MapGenDecoderAttributes():
	path_(ParameterManager::getString("mapgen_input_file_name")),
	record_(ParameterManager::getInt("mapgen_record"))
	
	 
{
} 


MapGenDecoderAttributes::~MapGenDecoderAttributes()
{
	
}

    
void MapGenDecoderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "mapgen_input_file_name", path_, params);
	setAttribute(prefix, "mapgen_record", record_, params);
	
	
}

void MapGenDecoderAttributes::copy(const MapGenDecoderAttributes& other)
{
	path_ = other.path_;
	record_ = other.record_;
	
} 


bool MapGenDecoderAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "mapgen")  )
		return true;
	
	return false;
}

void MapGenDecoderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "mapgen")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void MapGenDecoderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " path = " <<  path_;
	out << " record = " <<  record_;
	
	out << "]" << "\n";
}

void MapGenDecoderAttributes::toxml(ostream& out)  const
{
	out <<  "\"mapgen\""; 
	out << ", \"mapgen_input_file_name\":";
	niceprint(out,path_);
	out << ", \"mapgen_record\":";
	niceprint(out,record_);
	
}

static MagicsParameter<string> mapgen_input_file_name("mapgen_input_file_name", "", "");
static MagicsParameter<int> mapgen_record("mapgen_record", -1, "");
