
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ListColourTechniqueAttributes.h
    \\brief Definition of ListColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "ListColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ListColourTechniqueAttributes::ListColourTechniqueAttributes():
	values_(ParameterManager::getStringArray("contour_shade_colour_list"))
	
	 
{
} 


ListColourTechniqueAttributes::~ListColourTechniqueAttributes()
{
	
}

    
void ListColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	setAttribute(prefix, "contour_shade_colour_list", values_, params);
	
	
}

void ListColourTechniqueAttributes::copy(const ListColourTechniqueAttributes& other)
{
	values_ = other.values_;
	
} 


bool ListColourTechniqueAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "list")  )
		return true;
	
	return false;
}

void ListColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "list")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void ListColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " values = " <<  values_;
	
	out << "]" << "\n";
}

void ListColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"list\""; 
	out << ", \"contour_shade_colour_list\":";
	niceprint(out,values_);
	
}

static MagicsParameter<stringarray> contour_shade_colour_list("contour_shade_colour_list", stringarray(), "");
