
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file InputMatrixAttributes.h
    \\brief Definition of InputMatrix Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "InputMatrixAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

InputMatrixAttributes::InputMatrixAttributes():
	simple_field_(ParameterManager::getBool("input_simple_field")),
	metadata_(ParameterManager::getString("input_metadata")),
	mapping_(ParameterManager::getString("input_field_subpage_mapping")),
	suppress_below_(ParameterManager::getDouble("input_field_suppress_below")),
	suppress_above_(ParameterManager::getDouble("input_field_suppress_above"))
	,
	field_(MagTranslator<Matrix, Matrix>().magics("input_field")),
	u_component_(MagTranslator<Matrix, Matrix>().magics("input_wind_u_component")),
	v_component_(MagTranslator<Matrix, Matrix>().magics("input_wind_v_component")),
	organization_(MagTranslator<string, InputMatrixInterpretor>().magics("input_field_organization")),
	wind_speed_(MagTranslator<Matrix, Matrix>().magics("input_wind_speed")),
	wind_direction_(MagTranslator<Matrix, Matrix>().magics("input_wind_direction"))
	 
{
} 


InputMatrixAttributes::~InputMatrixAttributes()
{
	
}

    
void InputMatrixAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "input";
	
	setAttribute(prefix, "input_simple_field", simple_field_, params);
	setAttribute(prefix, "input_metadata", metadata_, params);
	setAttribute(prefix, "input_field_subpage_mapping", mapping_, params);
	setAttribute(prefix, "input_field_suppress_below", suppress_below_, params);
	setAttribute(prefix, "input_field_suppress_above", suppress_above_, params);
	
	setAttribute(prefix, "input_field", field_, params);
	setAttribute(prefix, "input_wind_u_component", u_component_, params);
	setAttribute(prefix, "input_wind_v_component", v_component_, params);
	setMember(prefix, "input_field_organization", organization_, params);
	setAttribute(prefix, "input_wind_speed", wind_speed_, params);
	setAttribute(prefix, "input_wind_direction", wind_direction_, params);
	
}

void InputMatrixAttributes::copy(const InputMatrixAttributes& other)
{
	simple_field_ = other.simple_field_;
	metadata_ = other.metadata_;
	mapping_ = other.mapping_;
	suppress_below_ = other.suppress_below_;
	suppress_above_ = other.suppress_above_;
	field_ = other.field_;
	u_component_ = other.u_component_;
	v_component_ = other.v_component_;
	organization_ = unique_ptr<InputMatrixInterpretor>(other.organization_->clone());
	wind_speed_ = other.wind_speed_;
	wind_direction_ = other.wind_direction_;
	
} 


bool InputMatrixAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "matrix")  )
		return true;
	if ( acceptNode(node, organization_) )
		return true;
	
	return false;
}

void InputMatrixAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "matrix")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), organization_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), organization_, *elt); 
		
	}
}

void InputMatrixAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " simple_field = " <<  simple_field_;
	out << " metadata = " <<  metadata_;
	out << " mapping = " <<  mapping_;
	out << " suppress_below = " <<  suppress_below_;
	out << " suppress_above = " <<  suppress_above_;
	out << " field = " <<  field_;
	out << " u_component = " <<  u_component_;
	out << " v_component = " <<  v_component_;
	out << " organization = " <<  *organization_;
	out << " wind_speed = " <<  wind_speed_;
	out << " wind_direction = " <<  wind_direction_;
	
	out << "]" << "\n";
}

void InputMatrixAttributes::toxml(ostream& out)  const
{
	out <<  "\"matrix\""; 
	out << ", \"input_simple_field\":";
	niceprint(out,simple_field_);
	out << ", \"input_metadata\":";
	niceprint(out,metadata_);
	out << ", \"input_field_subpage_mapping\":";
	niceprint(out,mapping_);
	out << ", \"input_field_suppress_below\":";
	niceprint(out,suppress_below_);
	out << ", \"input_field_suppress_above\":";
	niceprint(out,suppress_above_);
	out << ", \"input_field\":";
	niceprint(out, field_);
	out << ", \"input_wind_u_component\":";
	niceprint(out, u_component_);
	out << ", \"input_wind_v_component\":";
	niceprint(out, v_component_);
	out << ", \"input_field_organization\":";
	organization_->toxml(out);
	out << ", \"input_wind_speed\":";
	niceprint(out, wind_speed_);
	out << ", \"input_wind_direction\":";
	niceprint(out, wind_direction_);
	
}

static MagicsParameter<string> input_simple_field("input_simple_field", "off", "");
static MagicsParameter<string> input_metadata("input_metadata", "{}", "");
static MagicsParameter<string> input_field_subpage_mapping("input_field_subpage_mapping", "upper_left", "");
static MagicsParameter<double> input_field_suppress_below("input_field_suppress_below", -1.0e+21, "");
static MagicsParameter<double> input_field_suppress_above("input_field_suppress_above", 1.0e+21, "");
static MagicsParameter<Matrix> input_field("input_field", Matrix(), ""); 
static MagicsParameter<Matrix> input_wind_u_component("input_wind_u_component", Matrix(), ""); 
static MagicsParameter<Matrix> input_wind_v_component("input_wind_v_component", Matrix(), ""); 
static MagicsParameter<string> input_field_organization("input_field_organization", "regular", ""); 
static MagicsParameter<Matrix> input_wind_speed("input_wind_speed", Matrix(), ""); 
static MagicsParameter<Matrix> input_wind_direction("input_wind_direction", Matrix(), ""); 
#include "InputMatrixInterpretor.h"
static SimpleObjectMaker<InputMatrixRegularInterpretor , InputMatrixInterpretor> gaussian_InputMatrixRegularInterpretor("gaussian");
static SimpleObjectMaker<InputMatrixRegularInterpretor , InputMatrixInterpretor> regular_InputMatrixRegularInterpretor("regular");
static SimpleObjectMaker<InputMatrixIrregularInterpretor , InputMatrixInterpretor> irregular_InputMatrixIrregularInterpretor("irregular");
static SimpleObjectMaker<InputMatrixIrregularInterpretor , InputMatrixInterpretor> nonregular_InputMatrixIrregularInterpretor("nonregular");
