
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HatchPolyShadingMethodAttributes.h
    \\brief Definition of HatchPolyShadingMethod Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "HatchPolyShadingMethodAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

HatchPolyShadingMethodAttributes::HatchPolyShadingMethodAttributes():
	index_(ParameterManager::getInt("contour_shade_hatch_index")),
	thickness_(ParameterManager::getInt("contour_shade_hatch_thickness")),
	density_(ParameterManager::getDouble("contour_shade_hatch_density"))
	
	 
{
} 


HatchPolyShadingMethodAttributes::~HatchPolyShadingMethodAttributes()
{
	
}

    
void HatchPolyShadingMethodAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade_hatch";
	
	setAttribute(prefix, "contour_shade_hatch_index", index_, params);
	setAttribute(prefix, "contour_shade_hatch_thickness", thickness_, params);
	setAttribute(prefix, "contour_shade_hatch_density", density_, params);
	
	
}

void HatchPolyShadingMethodAttributes::copy(const HatchPolyShadingMethodAttributes& other)
{
	index_ = other.index_;
	thickness_ = other.thickness_;
	density_ = other.density_;
	
} 


bool HatchPolyShadingMethodAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "hatch")  )
		return true;
	
	return false;
}

void HatchPolyShadingMethodAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "hatch")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void HatchPolyShadingMethodAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " index = " <<  index_;
	out << " thickness = " <<  thickness_;
	out << " density = " <<  density_;
	
	out << "]" << "\n";
}

void HatchPolyShadingMethodAttributes::toxml(ostream& out)  const
{
	out <<  "\"hatch\""; 
	out << ", \"contour_shade_hatch_index\":";
	niceprint(out,index_);
	out << ", \"contour_shade_hatch_thickness\":";
	niceprint(out,thickness_);
	out << ", \"contour_shade_hatch_density\":";
	niceprint(out,density_);
	
}

static MagicsParameter<int> contour_shade_hatch_index("contour_shade_hatch_index", 0, "");
static MagicsParameter<int> contour_shade_hatch_thickness("contour_shade_hatch_thickness", 1, "");
static MagicsParameter<double> contour_shade_hatch_density("contour_shade_hatch_density", 18.0, "");
