
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GraphPlottingAttributes.h
    \\brief Definition of GraphPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "GraphPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

GraphPlottingAttributes::GraphPlottingAttributes():
	legend_(ParameterManager::getBool("legend")),
	legend_text_(ParameterManager::getString("legend_user_text"))
	,
	type_(MagTranslator<string, Graph>().magics("graph_type"))
	 
{
} 


GraphPlottingAttributes::~GraphPlottingAttributes()
{
	
}

    
void GraphPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "legend", legend_, params);
	setAttribute(prefix, "legend_user_text", legend_text_, params);
	
	setMember(prefix, "graph_type", type_, params);
	
}

void GraphPlottingAttributes::copy(const GraphPlottingAttributes& other)
{
	legend_ = other.legend_;
	legend_text_ = other.legend_text_;
	type_ = unique_ptr<Graph>(other.type_->clone());
	
} 


bool GraphPlottingAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "graph")  )
		return true;
	if ( acceptNode(node, type_) )
		return true;
	
	return false;
}

void GraphPlottingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "graph")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), type_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), type_, *elt); 
		
	}
}

void GraphPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " legend = " <<  legend_;
	out << " legend_text = " <<  legend_text_;
	out << " type = " <<  *type_;
	
	out << "]" << "\n";
}

void GraphPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"graph\""; 
	out << ", \"legend\":";
	niceprint(out,legend_);
	out << ", \"legend_user_text\":";
	niceprint(out,legend_text_);
	out << ", \"graph_type\":";
	type_->toxml(out);
	
}

static MagicsParameter<string> legend("legend", "off", "");
static MagicsParameter<string> legend_user_text("legend_user_text", "", "");
static MagicsParameter<string> graph_type("graph_type", "curve", ""); 
#include "Curve.h"
#include "Bar.h"
static SimpleObjectMaker<Curve , Graph> curve_Curve("curve");
static SimpleObjectMaker<Bar , Graph> bar_Bar("bar");
static SimpleObjectMaker<GraphFlag , Graph> flag_GraphFlag("flag");
static SimpleObjectMaker<GraphArrow , Graph> arrow_GraphArrow("arrow");
static SimpleObjectMaker<CurveArea , Graph> area_CurveArea("area");
