
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file GeoJsonDriverAttributes.h
    \\brief Definition of GeoJsonDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "GeoJsonDriverAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

GeoJsonDriverAttributes::GeoJsonDriverAttributes():
	zip_(ParameterManager::getBool("geojson_zip")),
	description_(ParameterManager::getString("geojson_description")),
	author_(ParameterManager::getString("geojson_author")),
	link_(ParameterManager::getString("geojson_link")),
	coastlines_(ParameterManager::getBool("geojson_coastlines"))
	
	 
{
} 


GeoJsonDriverAttributes::~GeoJsonDriverAttributes()
{
	
}

    
void GeoJsonDriverAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "GeoJson";
	
	setAttribute(prefix, "geojson_zip", zip_, params);
	setAttribute(prefix, "geojson_description", description_, params);
	setAttribute(prefix, "geojson_author", author_, params);
	setAttribute(prefix, "geojson_link", link_, params);
	setAttribute(prefix, "geojson_coastlines", coastlines_, params);
	
	
}

void GeoJsonDriverAttributes::copy(const GeoJsonDriverAttributes& other)
{
	zip_ = other.zip_;
	description_ = other.description_;
	author_ = other.author_;
	link_ = other.link_;
	coastlines_ = other.coastlines_;
	
} 


bool GeoJsonDriverAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "GeoJson")  )
		return true;
	
	return false;
}

void GeoJsonDriverAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "GeoJson")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void GeoJsonDriverAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " zip = " <<  zip_;
	out << " description = " <<  description_;
	out << " author = " <<  author_;
	out << " link = " <<  link_;
	out << " coastlines = " <<  coastlines_;
	
	out << "]" << "\n";
}

void GeoJsonDriverAttributes::toxml(ostream& out)  const
{
	out <<  "\"GeoJson\""; 
	out << ", \"geojson_zip\":";
	niceprint(out,zip_);
	out << ", \"geojson_description\":";
	niceprint(out,description_);
	out << ", \"geojson_author\":";
	niceprint(out,author_);
	out << ", \"geojson_link\":";
	niceprint(out,link_);
	out << ", \"geojson_coastlines\":";
	niceprint(out,coastlines_);
	
}

static MagicsParameter<string> geojson_zip("geojson_zip", "off", "");
static MagicsParameter<string> geojson_description("geojson_description", "Generated by Magics++", "");
static MagicsParameter<string> geojson_author("geojson_author", "", "");
static MagicsParameter<string> geojson_link("geojson_link", "", "");
static MagicsParameter<string> geojson_coastlines("geojson_coastlines", "off", "");
