
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file FortranSceneNodeAttributes.h
    \\brief Definition of FortranSceneNode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "FortranSceneNodeAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

FortranSceneNodeAttributes::FortranSceneNodeAttributes():
	x_(ParameterManager::getDouble("page_x_position")),
	y_(ParameterManager::getDouble("page_y_position")),
	width_(ParameterManager::getDouble("page_x_length")),
	height_(ParameterManager::getDouble("page_y_length")),
	frame_(ParameterManager::getBool("page_frame")),
	frame_thickness_(ParameterManager::getInt("page_frame_thickness")),
	plot_layout_(ParameterManager::getString("layout")),
	plot_start_(ParameterManager::getString("plot_start")),
	plot_direction_(ParameterManager::getString("plot_direction")),
	theme_(ParameterManager::getString("page_theme")),
	skinny_(ParameterManager::getBool("skinny_mode"))
	,
	frame_colour_(MagTranslator<string, Colour>().magics("page_frame_colour")),
	frame_line_style_(MagTranslator<string, LineStyle>().magics("page_frame_line_style")),
	page_id_(MagTranslator<string, NoPageID>().magics("page_id_line"))
	 
{
} 


FortranSceneNodeAttributes::~FortranSceneNodeAttributes()
{
	
}

    
void FortranSceneNodeAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "page";
	
	setAttribute(prefix, "page_x_position", x_, params);
	setAttribute(prefix, "page_y_position", y_, params);
	setAttribute(prefix, "page_x_length", width_, params);
	setAttribute(prefix, "page_y_length", height_, params);
	setAttribute(prefix, "page_frame", frame_, params);
	setAttribute(prefix, "page_frame_thickness", frame_thickness_, params);
	setAttribute(prefix, "layout", plot_layout_, params);
	setAttribute(prefix, "plot_start", plot_start_, params);
	setAttribute(prefix, "plot_direction", plot_direction_, params);
	setAttribute(prefix, "page_theme", theme_, params);
	setAttribute(prefix, "skinny_mode", skinny_, params);
	
	setMember(prefix, "page_frame_colour", frame_colour_, params);
	setAttribute(prefix, "page_frame_line_style", frame_line_style_, params);
	setMember(prefix, "page_id_line", page_id_, params);
	
}

void FortranSceneNodeAttributes::copy(const FortranSceneNodeAttributes& other)
{
	x_ = other.x_;
	y_ = other.y_;
	width_ = other.width_;
	height_ = other.height_;
	frame_ = other.frame_;
	frame_thickness_ = other.frame_thickness_;
	plot_layout_ = other.plot_layout_;
	plot_start_ = other.plot_start_;
	plot_direction_ = other.plot_direction_;
	theme_ = other.theme_;
	skinny_ = other.skinny_;
	frame_colour_ = unique_ptr<Colour>(other.frame_colour_->clone());
	frame_line_style_ = other.frame_line_style_;
	page_id_ = unique_ptr<NoPageID>(other.page_id_->clone());
	
} 


bool FortranSceneNodeAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "page")  )
		return true;
	if ( acceptNode(node, page_id_) )
		return true;
	
	return false;
}

void FortranSceneNodeAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "page")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), page_id_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), page_id_, *elt); 
		
	}
}

void FortranSceneNodeAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " x = " <<  x_;
	out << " y = " <<  y_;
	out << " width = " <<  width_;
	out << " height = " <<  height_;
	out << " frame = " <<  frame_;
	out << " frame_thickness = " <<  frame_thickness_;
	out << " plot_layout = " <<  plot_layout_;
	out << " plot_start = " <<  plot_start_;
	out << " plot_direction = " <<  plot_direction_;
	out << " theme = " <<  theme_;
	out << " skinny = " <<  skinny_;
	out << " frame_colour = " <<  *frame_colour_;
	out << " frame_line_style = " <<  frame_line_style_;
	out << " page_id = " <<  *page_id_;
	
	out << "]" << "\n";
}

void FortranSceneNodeAttributes::toxml(ostream& out)  const
{
	out <<  "\"page\""; 
	out << ", \"page_x_position\":";
	niceprint(out,x_);
	out << ", \"page_y_position\":";
	niceprint(out,y_);
	out << ", \"page_x_length\":";
	niceprint(out,width_);
	out << ", \"page_y_length\":";
	niceprint(out,height_);
	out << ", \"page_frame\":";
	niceprint(out,frame_);
	out << ", \"page_frame_thickness\":";
	niceprint(out,frame_thickness_);
	out << ", \"layout\":";
	niceprint(out,plot_layout_);
	out << ", \"plot_start\":";
	niceprint(out,plot_start_);
	out << ", \"plot_direction\":";
	niceprint(out,plot_direction_);
	out << ", \"page_theme\":";
	niceprint(out,theme_);
	out << ", \"skinny_mode\":";
	niceprint(out,skinny_);
	out << ", \"page_frame_colour\":";
	niceprint(out, *frame_colour_);
	out << ", \"page_frame_line_style\":";
	niceprint(out, frame_line_style_);
	out << ", \"page_id_line\":";
	page_id_->toxml(out);
	
}

static MagicsParameter<double> page_x_position("page_x_position", 0, "");
static MagicsParameter<double> page_y_position("page_y_position", 0, "");
static MagicsParameter<double> page_x_length("page_x_length", 29.7, "");
static MagicsParameter<double> page_y_length("page_y_length", 21, "");
static MagicsParameter<string> page_frame("page_frame", "off", "");
static MagicsParameter<int> page_frame_thickness("page_frame_thickness", 2, "");
static MagicsParameter<string> layout("layout", "automatic", "");
static MagicsParameter<string> plot_start("plot_start", "bottom", "");
static MagicsParameter<string> plot_direction("plot_direction", "vertical", "");
static MagicsParameter<string> page_theme("page_theme", "super_page_theme", "");
static MagicsParameter<string> skinny_mode("skinny_mode", "off", "");
static MagicsParameter<string> page_frame_colour("page_frame_colour", "charcoal", ""); 
static MagicsParameter<string> page_frame_line_style("page_frame_line_style", "solid", ""); 
static MagicsParameter<string> page_id_line("page_id_line", "on", ""); 
#include "PageID.h"
static SimpleObjectMaker<PageID , NoPageID> on_PageID("on");
static SimpleObjectMaker<NoPageID , NoPageID> off_NoPageID("off");
