
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file FixedTableModeAttributes.h
    \\brief Definition of FixedTableMode Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "FixedTableModeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


FixedTableModeWrapper::FixedTableModeWrapper(): fixedtablemode_(new FixedTableMode())

{

	
	
	LookupTableModeWrapper::object(fixedtablemode_);
	
	
} 
FixedTableModeWrapper::FixedTableModeWrapper(FixedTableMode* fixedtablemode): fixedtablemode_(fixedtablemode)
{
	
	
	LookupTableModeWrapper::object(fixedtablemode_);
	
} 

FixedTableModeWrapper::~FixedTableModeWrapper()
{
	
}

void FixedTableModeWrapper::set(const MagRequest& request)
{
	
	
	
	LookupTableModeWrapper::set(request);
	

	intarray levels_value;
	for (int i = 0; i < request.countValues("IMAGE_LEVEL_LIST"); i++)
		levels_value.push_back((int)request("IMAGE_LEVEL_LIST", i));
	if ( !levels_value.empty() ) 
		fixedtablemode_->levels_ = levels_value;
	intarray indexes_value;
	for (int i = 0; i < request.countValues("IMAGE_INDEX_LIST"); i++)
		indexes_value.push_back((int)request("IMAGE_INDEX_LIST", i));
	if ( !indexes_value.empty() ) 
		fixedtablemode_->indexes_ = indexes_value;
	
	
}

void FixedTableModeWrapper::print(ostream& out)  const
{
	out << "FixedTableModeWrapper[]";
}


    



