
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsgramDecoderAttributes.h
    \\brief Definition of EpsgramDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "EpsgramDecoderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

EpsgramDecoderAttributes::EpsgramDecoderAttributes():
	title_(ParameterManager::getStringArray("eps_title")),
	type_(ParameterManager::getString("eps_type")),
	database_(ParameterManager::getString("eps_database")),
	title_text_(ParameterManager::getString("eps_title_text")),
	param_(ParameterManager::getString("eps_parameter")),
	param_title_(ParameterManager::getString("eps_parameter_title")),
	latitude_(ParameterManager::getDouble("eps_latitude")),
	longitude_(ParameterManager::getDouble("eps_longitude")),
	param_hour_shift_(ParameterManager::getDouble("eps_parameter_hour_shift")),
	param_scaling_factor_(ParameterManager::getDouble("eps_parameter_scaling_factor")),
	param_offset_factor_(ParameterManager::getDouble("eps_parameter_offset_factor")),
	date_(ParameterManager::getString("eps_date")),
	time_(ParameterManager::getString("eps_time")),
	long_title_(ParameterManager::getBool("eps_long_title")),
	long_title_station_(ParameterManager::getBool("eps_long_title_station")),
	long_title_height_(ParameterManager::getBool("eps_long_title_height")),
	long_title_point_(ParameterManager::getBool("eps_long_title_point")),
	station_(ParameterManager::getString("eps_station_name")),
	height_(ParameterManager::getDouble("eps_station_height")),
	correction_(ParameterManager::getBool("eps_temperature_correction")),
	percentile_(ParameterManager::getDouble("eps_y_axis_percentile")),
	threshold_(ParameterManager::getDouble("eps_y_axis_threshold"))
	
	 
{
} 


EpsgramDecoderAttributes::~EpsgramDecoderAttributes()
{
	
}

    
void EpsgramDecoderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "eps";
	
	setAttribute(prefix, "eps_title", title_, params);
	setAttribute(prefix, "eps_type", type_, params);
	setAttribute(prefix, "eps_database", database_, params);
	setAttribute(prefix, "eps_title_text", title_text_, params);
	setAttribute(prefix, "eps_parameter", param_, params);
	setAttribute(prefix, "eps_parameter_title", param_title_, params);
	setAttribute(prefix, "eps_latitude", latitude_, params);
	setAttribute(prefix, "eps_longitude", longitude_, params);
	setAttribute(prefix, "eps_parameter_hour_shift", param_hour_shift_, params);
	setAttribute(prefix, "eps_parameter_scaling_factor", param_scaling_factor_, params);
	setAttribute(prefix, "eps_parameter_offset_factor", param_offset_factor_, params);
	setAttribute(prefix, "eps_date", date_, params);
	setAttribute(prefix, "eps_time", time_, params);
	setAttribute(prefix, "eps_long_title", long_title_, params);
	setAttribute(prefix, "eps_long_title_station", long_title_station_, params);
	setAttribute(prefix, "eps_long_title_height", long_title_height_, params);
	setAttribute(prefix, "eps_long_title_point", long_title_point_, params);
	setAttribute(prefix, "eps_station_name", station_, params);
	setAttribute(prefix, "eps_station_height", height_, params);
	setAttribute(prefix, "eps_temperature_correction", correction_, params);
	setAttribute(prefix, "eps_y_axis_percentile", percentile_, params);
	setAttribute(prefix, "eps_y_axis_threshold", threshold_, params);
	
	
}

void EpsgramDecoderAttributes::copy(const EpsgramDecoderAttributes& other)
{
	title_ = other.title_;
	type_ = other.type_;
	database_ = other.database_;
	title_text_ = other.title_text_;
	param_ = other.param_;
	param_title_ = other.param_title_;
	latitude_ = other.latitude_;
	longitude_ = other.longitude_;
	param_hour_shift_ = other.param_hour_shift_;
	param_scaling_factor_ = other.param_scaling_factor_;
	param_offset_factor_ = other.param_offset_factor_;
	date_ = other.date_;
	time_ = other.time_;
	long_title_ = other.long_title_;
	long_title_station_ = other.long_title_station_;
	long_title_height_ = other.long_title_height_;
	long_title_point_ = other.long_title_point_;
	station_ = other.station_;
	height_ = other.height_;
	correction_ = other.correction_;
	percentile_ = other.percentile_;
	threshold_ = other.threshold_;
	
} 


bool EpsgramDecoderAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "epsgram")  )
		return true;
	
	return false;
}

void EpsgramDecoderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epsgram")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void EpsgramDecoderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " title = " <<  title_;
	out << " type = " <<  type_;
	out << " database = " <<  database_;
	out << " title_text = " <<  title_text_;
	out << " param = " <<  param_;
	out << " param_title = " <<  param_title_;
	out << " latitude = " <<  latitude_;
	out << " longitude = " <<  longitude_;
	out << " param_hour_shift = " <<  param_hour_shift_;
	out << " param_scaling_factor = " <<  param_scaling_factor_;
	out << " param_offset_factor = " <<  param_offset_factor_;
	out << " date = " <<  date_;
	out << " time = " <<  time_;
	out << " long_title = " <<  long_title_;
	out << " long_title_station = " <<  long_title_station_;
	out << " long_title_height = " <<  long_title_height_;
	out << " long_title_point = " <<  long_title_point_;
	out << " station = " <<  station_;
	out << " height = " <<  height_;
	out << " correction = " <<  correction_;
	out << " percentile = " <<  percentile_;
	out << " threshold = " <<  threshold_;
	
	out << "]" << "\n";
}

void EpsgramDecoderAttributes::toxml(ostream& out)  const
{
	out <<  "\"epsgram\""; 
	out << ", \"eps_title\":";
	niceprint(out,title_);
	out << ", \"eps_type\":";
	niceprint(out,type_);
	out << ", \"eps_database\":";
	niceprint(out,database_);
	out << ", \"eps_title_text\":";
	niceprint(out,title_text_);
	out << ", \"eps_parameter\":";
	niceprint(out,param_);
	out << ", \"eps_parameter_title\":";
	niceprint(out,param_title_);
	out << ", \"eps_latitude\":";
	niceprint(out,latitude_);
	out << ", \"eps_longitude\":";
	niceprint(out,longitude_);
	out << ", \"eps_parameter_hour_shift\":";
	niceprint(out,param_hour_shift_);
	out << ", \"eps_parameter_scaling_factor\":";
	niceprint(out,param_scaling_factor_);
	out << ", \"eps_parameter_offset_factor\":";
	niceprint(out,param_offset_factor_);
	out << ", \"eps_date\":";
	niceprint(out,date_);
	out << ", \"eps_time\":";
	niceprint(out,time_);
	out << ", \"eps_long_title\":";
	niceprint(out,long_title_);
	out << ", \"eps_long_title_station\":";
	niceprint(out,long_title_station_);
	out << ", \"eps_long_title_height\":";
	niceprint(out,long_title_height_);
	out << ", \"eps_long_title_point\":";
	niceprint(out,long_title_point_);
	out << ", \"eps_station_name\":";
	niceprint(out,station_);
	out << ", \"eps_station_height\":";
	niceprint(out,height_);
	out << ", \"eps_temperature_correction\":";
	niceprint(out,correction_);
	out << ", \"eps_y_axis_percentile\":";
	niceprint(out,percentile_);
	out << ", \"eps_y_axis_threshold\":";
	niceprint(out,threshold_);
	
}

static MagicsParameter<stringarray> eps_title("eps_title", stringarray(), "");
static MagicsParameter<string> eps_type("eps_type", "eps10", "");
static MagicsParameter<string> eps_database("eps_database", "/vol/epsgram/data/spotbase/epsdb", "");
static MagicsParameter<string> eps_title_text("eps_title_text", "EPS Meteogram", "");
static MagicsParameter<string> eps_parameter("eps_parameter", "", "");
static MagicsParameter<string> eps_parameter_title("eps_parameter_title", "", "");
static MagicsParameter<double> eps_latitude("eps_latitude", 0, "");
static MagicsParameter<double> eps_longitude("eps_longitude", 0, "");
static MagicsParameter<double> eps_parameter_hour_shift("eps_parameter_hour_shift", 0, "");
static MagicsParameter<double> eps_parameter_scaling_factor("eps_parameter_scaling_factor", 1, "");
static MagicsParameter<double> eps_parameter_offset_factor("eps_parameter_offset_factor", 0, "");
static MagicsParameter<string> eps_date("eps_date", "-1", "");
static MagicsParameter<string> eps_time("eps_time", "0000", "");
static MagicsParameter<string> eps_long_title("eps_long_title", "off", "");
static MagicsParameter<string> eps_long_title_station("eps_long_title_station", "on", "");
static MagicsParameter<string> eps_long_title_height("eps_long_title_height", "on", "");
static MagicsParameter<string> eps_long_title_point("eps_long_title_point", "on", "");
static MagicsParameter<string> eps_station_name("eps_station_name", "", "");
static MagicsParameter<double> eps_station_height("eps_station_height", INT_MAX, "");
static MagicsParameter<string> eps_temperature_correction("eps_temperature_correction", "yes", "");
static MagicsParameter<double> eps_y_axis_percentile("eps_y_axis_percentile", 1, "");
static MagicsParameter<double> eps_y_axis_threshold("eps_y_axis_threshold", 50, "");
