
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EpsShadeAttributes.h
    \\brief Definition of EpsShade Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "EpsShadeWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


EpsShadeWrapper::EpsShadeWrapper(): epsshade_(new EpsShade())

{

	
	
	
} 
EpsShadeWrapper::EpsShadeWrapper(EpsShade* epsshade): epsshade_(epsshade)
{
	
	
} 

EpsShadeWrapper::~EpsShadeWrapper()
{
	
}

void EpsShadeWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("EPS_SHADE_LINE_THICKNESS") ) {
		int line_thickness_value = request("EPS_SHADE_LINE_THICKNESS");
		epsshade_->line_thickness_ = line_thickness_value;
		}
	
	if  (request.countValues("EPS_SHADE_COLOUR") ) {
		string colour_value = request("EPS_SHADE_COLOUR");
		epsshade_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	if  (request.countValues("EPS_SHADE_LINE_COLOUR") ) {
		string line_colour_value = request("EPS_SHADE_LINE_COLOUR");
		epsshade_->line_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(line_colour_value));
	}
		
	
	if  (request.countValues("EPS_SHADE_LINE_STYLE") ) {
		string line_style_value = request("EPS_SHADE_LINE_STYLE");
		epsshade_->line_style_ = MagTranslator<string, LineStyle>()(line_style_value);
	}
		
	
}

void EpsShadeWrapper::print(ostream& out)  const
{
	out << "EpsShadeWrapper[]";
}


    






