
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EmagramAttributes.h
    \\brief Definition of Emagram Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "EmagramWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


EmagramWrapper::EmagramWrapper(): emagram_(new Emagram())

{

	
	
	TransformationWrapper::object(emagram_);
	
	
} 
EmagramWrapper::EmagramWrapper(Emagram* emagram): emagram_(emagram)
{
	
	
	TransformationWrapper::object(emagram_);
	
} 

EmagramWrapper::~EmagramWrapper()
{
	
}

void EmagramWrapper::set(const MagRequest& request)
{
	
	
	
	TransformationWrapper::set(request);
	

	if  (request.countValues("X_MIN") ) {
		double x_min_value = request("X_MIN");
		emagram_->x_min_ = x_min_value;
		}
	if  (request.countValues("SUBPAGE_X_AUTOMATIC") ) {
		string x_automatic_value = request("SUBPAGE_X_AUTOMATIC");
		emagram_->x_automatic_ = MagTranslator<string, bool>()(x_automatic_value);
		}
	if  (request.countValues("SUBPAGE_Y_AUTOMATIC") ) {
		string y_automatic_value = request("SUBPAGE_Y_AUTOMATIC");
		emagram_->y_automatic_ = MagTranslator<string, bool>()(y_automatic_value);
		}
	if  (request.countValues("X_MAX") ) {
		double x_max_value = request("X_MAX");
		emagram_->x_max_ = x_max_value;
		}
	if  (request.countValues("Y_MIN") ) {
		double y_min_value = request("Y_MIN");
		emagram_->y_min_ = y_min_value;
		}
	if  (request.countValues("Y_MAX") ) {
		double y_max_value = request("Y_MAX");
		emagram_->y_max_ = y_max_value;
		}
	if  (request.countValues("THERMO_ANNOTATION_WIDTH") ) {
		double annotation_width_value = request("THERMO_ANNOTATION_WIDTH");
		emagram_->annotation_width_ = annotation_width_value;
		}
	
	
}

void EmagramWrapper::print(ostream& out)  const
{
	out << "EmagramWrapper[]";
}


    



