
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file EfigramDecoderAttributes.h
    \\brief Definition of EfigramDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "EfigramDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


EfigramDecoderWrapper::EfigramDecoderWrapper(): efigramdecoder_(new EfigramDecoder())

{

	
	
	
} 
EfigramDecoderWrapper::EfigramDecoderWrapper(EfigramDecoder* efigramdecoder): efigramdecoder_(efigramdecoder)
{
	
	
} 

EfigramDecoderWrapper::~EfigramDecoderWrapper()
{
	
}

void EfigramDecoderWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("EFI_ROOT_DATABASE") ) {
		string database_value = request("EFI_ROOT_DATABASE");
		efigramdecoder_->database_ = database_value;
		}
	if  (request.countValues("EFI_LEGEND_ROOT_DATABASE") ) {
		string legend_database_value = request("EFI_LEGEND_ROOT_DATABASE");
		efigramdecoder_->legend_database_ = legend_database_value;
		}
	if  (request.countValues("EFI_CLIM_ROOT_DATABASE") ) {
		string clim_database_value = request("EFI_CLIM_ROOT_DATABASE");
		efigramdecoder_->clim_database_ = clim_database_value;
		}
	stringarray  dates_value;
	for (int i = 0; i < request.countValues("EFI_DATES"); i++)
		dates_value.push_back((string)request("EFI_DATES", i));
	if ( !dates_value.empty() ) 
		efigramdecoder_->dates_ = dates_value;
	if  (request.countValues("EFI_CLIM_PARAMETER") ) {
		string clim_param_value = request("EFI_CLIM_PARAMETER");
		efigramdecoder_->clim_param_ = clim_param_value;
		}
	if  (request.countValues("EFI_CLIM_DATE") ) {
		string clim_date_value = request("EFI_CLIM_DATE");
		efigramdecoder_->clim_date_ = clim_date_value;
		}
	if  (request.countValues("EFI_CLIM_STEP") ) {
		int clim_step_value = request("EFI_CLIM_STEP");
		efigramdecoder_->clim_step_ = clim_step_value;
		}
	intarray steps_value;
	for (int i = 0; i < request.countValues("EFI_STEPS"); i++)
		steps_value.push_back((int)request("EFI_STEPS", i));
	if ( !steps_value.empty() ) 
		efigramdecoder_->steps_ = steps_value;
	if  (request.countValues("EFI_PARAMETER") ) {
		string param_value = request("EFI_PARAMETER");
		efigramdecoder_->param_ = param_value;
		}
	if  (request.countValues("EFI_LONG_TITLE") ) {
		string long_title_value = request("EFI_LONG_TITLE");
		efigramdecoder_->long_title_ = MagTranslator<string, bool>()(long_title_value);
		}
	if  (request.countValues("EFI_TITLE") ) {
		string title_value = request("EFI_TITLE");
		efigramdecoder_->title_ = MagTranslator<string, bool>()(title_value);
		}
	if  (request.countValues("EFI_LATITUDE") ) {
		double latitude_value = request("EFI_LATITUDE");
		efigramdecoder_->latitude_ = latitude_value;
		}
	if  (request.countValues("EFI_LONGITUDE") ) {
		double longitude_value = request("EFI_LONGITUDE");
		efigramdecoder_->longitude_ = longitude_value;
		}
	if  (request.countValues("EFI_LEGEND") ) {
		string legend_value = request("EFI_LEGEND");
		efigramdecoder_->legend_ = MagTranslator<string, bool>()(legend_value);
		}
	stringarray  legend_colours_value;
	for (int i = 0; i < request.countValues("EFI_LEGEND_COLOUR_LIST"); i++)
		legend_colours_value.push_back((string)request("EFI_LEGEND_COLOUR_LIST", i));
	if ( !legend_colours_value.empty() ) 
		efigramdecoder_->legend_colours_ = legend_colours_value;
	if  (request.countValues("EFI_LEGEND_BOX_TYPE") ) {
		string legend_type_value = request("EFI_LEGEND_BOX_TYPE");
		efigramdecoder_->legend_type_ = legend_type_value;
		}
	if  (request.countValues("EFI_LEGEND_NORMAL_THICKNESS") ) {
		int legend_normal_thickness_value = request("EFI_LEGEND_NORMAL_THICKNESS");
		efigramdecoder_->legend_normal_thickness_ = legend_normal_thickness_value;
		}
	
	if  (request.countValues("EFI_LEGEND_NORMAL_COLOUR") ) {
		string legend_normal_colour_value = request("EFI_LEGEND_NORMAL_COLOUR");
		efigramdecoder_->legend_normal_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(legend_normal_colour_value));
	}
		
	
}

void EfigramDecoderWrapper::print(ostream& out)  const
{
	out << "EfigramDecoderWrapper[]";
}


    




