
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file DateGribLoopStepAttributes.h
    \\brief Definition of DateGribLoopStep Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "DateGribLoopStepWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


DateGribLoopStepWrapper::DateGribLoopStepWrapper(): dategribloopstep_(new DateGribLoopStep())

{

	
	
	GribLoopStepWrapper::object(dategribloopstep_);
	
	
} 
DateGribLoopStepWrapper::DateGribLoopStepWrapper(DateGribLoopStep* dategribloopstep): dategribloopstep_(dategribloopstep)
{
	
	
	GribLoopStepWrapper::object(dategribloopstep_);
	
} 

DateGribLoopStepWrapper::~DateGribLoopStepWrapper()
{
	
}

void DateGribLoopStepWrapper::set(const MagRequest& request)
{
	
	
	
	GribLoopStepWrapper::set(request);
	

	if  (request.countValues("GRIB_LOOP_STEP_SPAN") ) {
		double span_value = request("GRIB_LOOP_STEP_SPAN");
		dategribloopstep_->span_ = span_value;
		}
	
	
		string address_mode_value = request.countValues("GRIB_FILE_ADDRESS_MODE") ?  (string) request("GRIB_FILE_ADDRESS_MODE") : "record";
	MagLog::debug() << " GRIB_FILE_ADDRESS_MODE set to " << address_mode_value << endl;
	GribAddressModeWrapper* address_mode_wrapper = 0;
#ifdef MAGICS_EXCEPTION
	try
#endif
	{
		address_mode_wrapper = SimpleFactory<GribAddressModeWrapper>::create(address_mode_value);
	}
#ifdef MAGICS_EXCEPTION
	 catch (NoFactoryException) {
#else
	 if (!address_mode_wrapper) {
#endif
		MagLog::warning() << "[" << address_mode_value << "] is not a valid value for address_mode: reset to default -> [record]" << endl;
		address_mode_wrapper = SimpleFactory<GribAddressModeWrapper>::create("record");
	}
	address_mode_wrapper->set(request);
	dategribloopstep_->address_mode_ =  unique_ptr<GribAddressMode>(address_mode_wrapper->object());
	delete address_mode_wrapper;
	
}

void DateGribLoopStepWrapper::print(ostream& out)  const
{
	out << "DateGribLoopStepWrapper[]";
}


    



#include "GribAddressRecordModeWrapper.h"
static SimpleObjectMaker<GribAddressRecordMode, GribAddressMode> DateGribLoopStep_grib_file_address_mode_record ("record");
static SimpleObjectMaker<GribAddressRecordModeWrapper, GribAddressModeWrapper> DateGribLoopStep_grib_file_address_mode_record_wrapper ("record");


#include "GribAddressByteModeWrapper.h"
static SimpleObjectMaker<GribAddressByteMode, GribAddressMode> DateGribLoopStep_grib_file_address_mode_byte_offset ("byte_offset");
static SimpleObjectMaker<GribAddressByteModeWrapper, GribAddressModeWrapper> DateGribLoopStep_grib_file_address_mode_byte_offset_wrapper ("byte_offset");



