
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CurveAreaAttributes.h
    \\brief Definition of CurveArea Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "CurveAreaAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CurveAreaAttributes::CurveAreaAttributes():
	
	shade_(MagTranslator<string, GraphShade>().magics("graph_shade"))
	 
{
} 


CurveAreaAttributes::~CurveAreaAttributes()
{
	
}

    
void CurveAreaAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	
	setMember(prefix, "graph_shade", shade_, params);
	
}

void CurveAreaAttributes::copy(const CurveAreaAttributes& other)
{
	shade_ = unique_ptr<GraphShade>(other.shade_->clone());
	
} 


bool CurveAreaAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	if ( acceptNode(node, shade_) )
		return true;
	
	return false;
}

void CurveAreaAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), shade_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), shade_, *elt); 
		
	}
}

void CurveAreaAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " shade = " <<  *shade_;
	
	out << "]" << "\n";
}

void CurveAreaAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"graph_shade\":";
	shade_->toxml(out);
	
}

static MagicsParameter<string> graph_shade("graph_shade", "on", ""); 
#include "GraphShade.h"
static SimpleObjectMaker<GraphShade , GraphShade> shading_GraphShade("shading");
static SimpleObjectMaker<GraphShade , GraphShade> on_GraphShade("on");
static SimpleObjectMaker<NoGraphShade , GraphShade> noshading_NoGraphShade("noshading");
static SimpleObjectMaker<NoGraphShade , GraphShade> off_NoGraphShade("off");
