
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CitiesAttributes.h
    \\brief Definition of Cities Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "CitiesWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


CitiesWrapper::CitiesWrapper(): cities_(new Cities())

{

	
	
	NoCitiesWrapper::object(cities_);
	
	
} 
CitiesWrapper::CitiesWrapper(Cities* cities): cities_(cities)
{
	
	
	NoCitiesWrapper::object(cities_);
	
} 

CitiesWrapper::~CitiesWrapper()
{
	
}

void CitiesWrapper::set(const MagRequest& request)
{
	
	
	
	NoCitiesWrapper::set(request);
	

	if  (request.countValues("MAP_CITIES_UNIT_SYSTEM") ) {
		string unit_value = request("MAP_CITIES_UNIT_SYSTEM");
		cities_->unit_ = unit_value;
		}
	if  (request.countValues("MAP_CITIES_FONT") ) {
		string font_name_value = request("MAP_CITIES_FONT");
		cities_->font_name_ = font_name_value;
		}
	if  (request.countValues("MAP_CITIES_FONT_STYLE") ) {
		string font_style_value = request("MAP_CITIES_FONT_STYLE");
		cities_->font_style_ = font_style_value;
		}
	if  (request.countValues("MAP_CITIES_TEXT_BLANKING") ) {
		string blanking_value = request("MAP_CITIES_TEXT_BLANKING");
		cities_->blanking_ = MagTranslator<string, bool>()(blanking_value);
		}
	if  (request.countValues("MAP_CITIES_FONT_SIZE") ) {
		double font_size_value = request("MAP_CITIES_FONT_SIZE");
		cities_->font_size_ = font_size_value;
		}
	if  (request.countValues("MAP_CITIES_NAME_POSITION") ) {
		string position_value = request("MAP_CITIES_NAME_POSITION");
		cities_->position_ = position_value;
		}
	if  (request.countValues("MAP_CITIES_MARKER") ) {
		string marker_value = request("MAP_CITIES_MARKER");
		cities_->marker_ = marker_value;
		}
	if  (request.countValues("MAP_CITIES_MARKER_HEIGHT") ) {
		double marker_height_value = request("MAP_CITIES_MARKER_HEIGHT");
		cities_->marker_height_ = marker_height_value;
		}
	
	if  (request.countValues("MAP_CITIES_FONT_COLOUR") ) {
		string font_colour_value = request("MAP_CITIES_FONT_COLOUR");
		cities_->font_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(font_colour_value));
	}
		
	if  (request.countValues("MAP_CITIES_MARKER_COLOUR") ) {
		string marker_colour_value = request("MAP_CITIES_MARKER_COLOUR");
		cities_->marker_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(marker_colour_value));
	}
		
	
}

void CitiesWrapper::print(ostream& out)  const
{
	out << "CitiesWrapper[]";
}


    





