
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file CitiesAttributes.h
    \\brief Definition of Cities Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "CitiesAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

CitiesAttributes::CitiesAttributes():
	unit_(ParameterManager::getString("map_cities_unit_system")),
	font_name_(ParameterManager::getString("map_cities_font")),
	font_style_(ParameterManager::getString("map_cities_font_style")),
	blanking_(ParameterManager::getBool("map_cities_text_blanking")),
	font_size_(ParameterManager::getDouble("map_cities_font_size")),
	position_(ParameterManager::getString("map_cities_name_position")),
	marker_(ParameterManager::getString("map_cities_marker")),
	marker_height_(ParameterManager::getDouble("map_cities_marker_height"))
	,
	font_colour_(MagTranslator<string, Colour>().magics("map_cities_font_colour")),
	marker_colour_(MagTranslator<string, Colour>().magics("map_cities_marker_colour"))
	 
{
} 


CitiesAttributes::~CitiesAttributes()
{
	
}

    
void CitiesAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "map_cities_unit_system", unit_, params);
	setAttribute(prefix, "map_cities_font", font_name_, params);
	setAttribute(prefix, "map_cities_font_style", font_style_, params);
	setAttribute(prefix, "map_cities_text_blanking", blanking_, params);
	setAttribute(prefix, "map_cities_font_size", font_size_, params);
	setAttribute(prefix, "map_cities_name_position", position_, params);
	setAttribute(prefix, "map_cities_marker", marker_, params);
	setAttribute(prefix, "map_cities_marker_height", marker_height_, params);
	
	setMember(prefix, "map_cities_font_colour", font_colour_, params);
	setMember(prefix, "map_cities_marker_colour", marker_colour_, params);
	
}

void CitiesAttributes::copy(const CitiesAttributes& other)
{
	unit_ = other.unit_;
	font_name_ = other.font_name_;
	font_style_ = other.font_style_;
	blanking_ = other.blanking_;
	font_size_ = other.font_size_;
	position_ = other.position_;
	marker_ = other.marker_;
	marker_height_ = other.marker_height_;
	font_colour_ = unique_ptr<Colour>(other.font_colour_->clone());
	marker_colour_ = unique_ptr<Colour>(other.marker_colour_->clone());
	
} 


bool CitiesAttributes::accept(const string& node)
{	
	
	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void CitiesAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void CitiesAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " unit = " <<  unit_;
	out << " font_name = " <<  font_name_;
	out << " font_style = " <<  font_style_;
	out << " blanking = " <<  blanking_;
	out << " font_size = " <<  font_size_;
	out << " position = " <<  position_;
	out << " marker = " <<  marker_;
	out << " marker_height = " <<  marker_height_;
	out << " font_colour = " <<  *font_colour_;
	out << " marker_colour = " <<  *marker_colour_;
	
	out << "]" << "\n";
}

void CitiesAttributes::toxml(ostream& out)  const
{
	out <<  "\"\""; 
	out << ", \"map_cities_unit_system\":";
	niceprint(out,unit_);
	out << ", \"map_cities_font\":";
	niceprint(out,font_name_);
	out << ", \"map_cities_font_style\":";
	niceprint(out,font_style_);
	out << ", \"map_cities_text_blanking\":";
	niceprint(out,blanking_);
	out << ", \"map_cities_font_size\":";
	niceprint(out,font_size_);
	out << ", \"map_cities_name_position\":";
	niceprint(out,position_);
	out << ", \"map_cities_marker\":";
	niceprint(out,marker_);
	out << ", \"map_cities_marker_height\":";
	niceprint(out,marker_height_);
	out << ", \"map_cities_font_colour\":";
	niceprint(out, *font_colour_);
	out << ", \"map_cities_marker_colour\":";
	niceprint(out, *marker_colour_);
	
}

static MagicsParameter<string> map_cities_unit_system("map_cities_unit_system", "percent", "");
static MagicsParameter<string> map_cities_font("map_cities_font", "sansserif", "");
static MagicsParameter<string> map_cities_font_style("map_cities_font_style", "normal", "");
static MagicsParameter<string> map_cities_text_blanking("map_cities_text_blanking", "on", "");
static MagicsParameter<double> map_cities_font_size("map_cities_font_size", 2.5, "");
static MagicsParameter<string> map_cities_name_position("map_cities_name_position", "above", "");
static MagicsParameter<string> map_cities_marker("map_cities_marker", "plus", "");
static MagicsParameter<double> map_cities_marker_height("map_cities_marker_height", 0.7, "");
static MagicsParameter<string> map_cities_font_colour("map_cities_font_colour", "navy", ""); 
static MagicsParameter<string> map_cities_marker_colour("map_cities_marker_colour", "evergreen", ""); 
