
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotBoxBorderAttributes.h
    \\brief Definition of BoxPlotBoxBorder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 2020-09-24
*/

#include "MagRequest.h" 
#include "BoxPlotBoxBorderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


BoxPlotBoxBorderWrapper::BoxPlotBoxBorderWrapper(): boxplotboxborder_(new BoxPlotBoxBorder())

{

	
	
	NoBoxPlotBoxBorderWrapper::object(boxplotboxborder_);
	
	
} 
BoxPlotBoxBorderWrapper::BoxPlotBoxBorderWrapper(BoxPlotBoxBorder* boxplotboxborder): boxplotboxborder_(boxplotboxborder)
{
	
	
	NoBoxPlotBoxBorderWrapper::object(boxplotboxborder_);
	
} 

BoxPlotBoxBorderWrapper::~BoxPlotBoxBorderWrapper()
{
	
}

void BoxPlotBoxBorderWrapper::set(const MagRequest& request)
{
	
	
	
	NoBoxPlotBoxBorderWrapper::set(request);
	

	if  (request.countValues("BOXPLOT_BOX_BORDER_THICKNESS") ) {
		int thickness_value = request("BOXPLOT_BOX_BORDER_THICKNESS");
		boxplotboxborder_->thickness_ = thickness_value;
		}
	
	if  (request.countValues("BOXPLOT_BOX_BORDER_COLOUR") ) {
		string colour_value = request("BOXPLOT_BOX_BORDER_COLOUR");
		boxplotboxborder_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_BOX_BORDER_LINE_STYLE") ) {
		string style_value = request("BOXPLOT_BOX_BORDER_LINE_STYLE");
		boxplotboxborder_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	
}

void BoxPlotBoxBorderWrapper::print(ostream& out)  const
{
	out << "BoxPlotBoxBorderWrapper[]";
}


    





