# ===----------------------------------------------------------------------===##
#
# Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
# ===----------------------------------------------------------------------===##

import operator
import os.path

from libcxx.header_information import module_headers
from libcxx.header_information import header_restrictions
from libcxx.header_information import headers_not_available


libcxx_module_directory = os.path.join(
    os.path.dirname(os.path.dirname(os.path.realpath(__file__))), "modules"
)
with open(
    os.path.join(libcxx_module_directory, "std.cppm.in"), "w"
) as std_module_cpp_in:
    std_module_cpp_in.write(
        """\
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING, this entire header is generated by
// utils/generate_std_cppm_in.py
// DO NOT MODIFY!

module;

#include <__config>

// The headers of Table 24: C++ library headers [tab:headers.cpp]
// and the headers of Table 25: C++ headers for C library facilities [tab:headers.cpp.c]
"""
    )
    for header in module_headers:
        if header in header_restrictions:
            std_module_cpp_in.write(
                f"""\
#if {header_restrictions[header]}
#  include <{header}>
#endif
"""
            )
        else:
            std_module_cpp_in.write(f"#include <{header}>\n")

    std_module_cpp_in.write("\n// *** Headers not yet available ***\n")
    for header in sorted(headers_not_available):
        std_module_cpp_in.write(
            f"""\
#if __has_include(<{header}>)
#  error "update the header information for <{header}> in libcxx/utils/generate_std_cppm_in.py"
#endif //   __has_include(<{header}>)
"""
        )

    std_module_cpp_in.write(
        """
export module std;

@LIBCXX_MODULE_STD_INCLUDE_SOURCES@
"""
    )
