; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLBW

declare <8 x i64> @llvm.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <32 x i16> @llvm.fshl.v32i16(<32 x i16>, <32 x i16>, <32 x i16>)
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

;
; Variable Shifts
;

define <8 x i64> @var_funnnel_v8i64(<8 x i64> %x, <8 x i64> %amt) nounwind {
; AVX512-LABEL: var_funnnel_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprolvq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %x, <8 x i64> %amt)
  ret <8 x i64> %res
}

define <16 x i32> @var_funnnel_v16i32(<16 x i32> %x, <16 x i32> %amt) nounwind {
; AVX512-LABEL: var_funnnel_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprolvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %x, <16 x i32> %amt)
  ret <16 x i32> %res
}

define <32 x i16> @var_funnnel_v32i16(<32 x i16> %x, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm3
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512F-NEXT:    vpsllvd %zmm4, %zmm2, %zmm4
; AVX512F-NEXT:    vpmovdw %zmm4, %ymm4
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm3, %ymm3
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512F-NEXT:    vpsllvd %zmm3, %zmm0, %zmm3
; AVX512F-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512F-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vpsubw %ymm1, %ymm4, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm5, %zmm2, %zmm2
; AVX512F-NEXT:    vpmovdw %zmm2, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpsubw %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpand %ymm6, %ymm1, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm3
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm4, %zmm2, %zmm4
; AVX512VL-NEXT:    vpmovdw %zmm4, %ymm4
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm3, %ymm3
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm3, %zmm0, %zmm3
; AVX512VL-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsubw %ymm1, %ymm4, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm5, %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovdw %zmm2, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpsubw %ymm1, %ymm4, %ymm1
; AVX512VL-NEXT:    vpand %ymm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512VL-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandq %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vpsllvw %zmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsubw %zmm1, %zmm4, %zmm1
; AVX512BW-NEXT:    vpandq %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBW-NEXT:    vpandq %zmm2, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpsllvw %zmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsubw %zmm1, %zmm4, %zmm1
; AVX512VLBW-NEXT:    vpandq %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlvw %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %x, <32 x i16> %amt)
  ret <32 x i16> %res
}

define <64 x i8> @var_funnnel_v64i8(<64 x i8> %x, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; AVX512F-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512F-NEXT:    vpsubb %ymm5, %ymm6, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512F-NEXT:    vpsrlw $2, %ymm3, %ymm8
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm9, %ymm8, %ymm8
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm8, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm8
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm10 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm10, %ymm8, %ymm8
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm8, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $4, %ymm0, %ymm5
; AVX512F-NEXT:    vpand %ymm4, %ymm5, %ymm4
; AVX512F-NEXT:    vpsubb %ymm1, %ymm6, %ymm5
; AVX512F-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512F-NEXT:    vpsrlw $2, %ymm4, %ymm6
; AVX512F-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $1, %ymm4, %ymm6
; AVX512F-NEXT:    vpand %ymm6, %ymm10, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512F-NEXT:    vpsllw $4, %ymm2, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; AVX512F-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $2, %ymm2, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm4
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $2, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; AVX512F-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm3, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; AVX512VL-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vpsubb %ymm5, %ymm6, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VL-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512VL-NEXT:    vpsrlw $2, %ymm3, %ymm8
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm9 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm9, %ymm8, %ymm8
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm8, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm3, %ymm8
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm10 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm10, %ymm8, %ymm8
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm8, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm5
; AVX512VL-NEXT:    vpand %ymm4, %ymm5, %ymm4
; AVX512VL-NEXT:    vpsubb %ymm1, %ymm6, %ymm5
; AVX512VL-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpsrlw $2, %ymm4, %ymm6
; AVX512VL-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $1, %ymm4, %ymm6
; AVX512VL-NEXT:    vpand %ymm6, %ymm10, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512VL-NEXT:    vpsllw $4, %ymm2, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm6
; AVX512VL-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $2, %ymm2, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw $5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $2, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm1, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm3, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpsubb %zmm1, %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512BW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k2
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpblendmb %zmm2, %zmm0, %zmm2 {%k2}
; AVX512BW-NEXT:    vpsrlw $2, %zmm2, %zmm5
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsrlw $1, %zmm2, %zmm5
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k1}
; AVX512BW-NEXT:    vpandq %zmm3, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllw $5, %zmm1, %zmm1
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm3
; AVX512BW-NEXT:    vpmovb2m %zmm3, %k1
; AVX512BW-NEXT:    vpmovb2m %zmm1, %k2
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k2}
; AVX512BW-NEXT:    vpsllw $2, %zmm0, %zmm1
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm1
; AVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsubb %zmm1, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpblendmb %zmm2, %zmm0, %zmm2 {%k2}
; AVX512VLBW-NEXT:    vpsrlw $2, %zmm2, %zmm5
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLBW-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm2, %zmm5
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm5, %zmm2 {%k1}
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllw $5, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpaddb %zmm1, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpmovb2m %zmm3, %k1
; AVX512VLBW-NEXT:    vpmovb2m %zmm1, %k2
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm1
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k2}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm0, %zmm1
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %x, <64 x i8> %amt)
  ret <64 x i8> %res
}

;
; Uniform Variable Shifts
;

define <8 x i64> @splatvar_funnnel_v8i64(<8 x i64> %x, <8 x i64> %amt) nounwind {
; AVX512-LABEL: splatvar_funnnel_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq %xmm1, %zmm1
; AVX512-NEXT:    vprolvq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %splat = shufflevector <8 x i64> %amt, <8 x i64> undef, <8 x i32> zeroinitializer
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %x, <8 x i64> %splat)
  ret <8 x i64> %res
}

define <16 x i32> @splatvar_funnnel_v16i32(<16 x i32> %x, <16 x i32> %amt) nounwind {
; AVX512-LABEL: splatvar_funnnel_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastd %xmm1, %zmm1
; AVX512-NEXT:    vprolvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %splat = shufflevector <16 x i32> %amt, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %x, <16 x i32> %splat)
  ret <16 x i32> %res
}

define <32 x i16> @splatvar_funnnel_v32i16(<32 x i16> %x, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm3
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX512F-NEXT:    vpsllw %xmm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512F-NEXT:    vpbroadcastw %xmm1, %ymm1
; AVX512F-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vpsubw %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm3
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm2, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vpbroadcastw %xmm1, %ymm1
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsubw %ymm1, %ymm4, %ymm1
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm1, %zmm2, %zmm1
; AVX512VL-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %xmm1, %xmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsubw %xmm1, %xmm4, %xmm1
; AVX512BW-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw %xmm1, %xmm1
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15]
; AVX512VLBW-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsubw %xmm1, %xmm4, %xmm1
; AVX512VLBW-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512VLBW-NEXT:    retq
  %splat = shufflevector <32 x i16> %amt, <32 x i16> undef, <32 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %x, <32 x i16> %splat)
  ret <32 x i16> %res
}

define <64 x i8> @splatvar_funnnel_v64i8(<64 x i8> %x, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpbroadcastb %xmm1, %ymm5
; AVX512F-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512F-NEXT:    vpsubb %ymm5, %ymm6, %ymm5
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512F-NEXT:    vpsrlw $2, %ymm3, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm7, %ymm6, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm9 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512F-NEXT:    vpaddb %ymm8, %ymm8, %ymm10
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $4, %ymm0, %ymm6
; AVX512F-NEXT:    vpand %ymm4, %ymm6, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512F-NEXT:    vpsrlw $2, %ymm4, %ymm5
; AVX512F-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $1, %ymm4, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm9, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm1
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; AVX512F-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vpsllw %xmm1, %xmm4, %xmm4
; AVX512F-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX512F-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm3, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpbroadcastb %xmm1, %ymm5
; AVX512VL-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vpsubb %ymm5, %ymm6, %ymm5
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm3
; AVX512VL-NEXT:    vpsrlw $2, %ymm3, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm7, %ymm6, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm3, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm9 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm6, %ymm9, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm8, %ymm8, %ymm10
; AVX512VL-NEXT:    vpblendvb %ymm10, %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm6
; AVX512VL-NEXT:    vpand %ymm4, %ymm6, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpsrlw $2, %ymm4, %ymm5
; AVX512VL-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $1, %ymm4, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm9, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm10, %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm4, %zmm3
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm1
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm1, %ymm2, %ymm2
; AVX512VL-NEXT:    vpcmpeqd %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsllw %xmm1, %xmm4, %xmm4
; AVX512VL-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX512VL-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm3, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %xmm1, %xmm1
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512BW-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,zero,zero,zero,zero,xmm3[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512BW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512BW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512BW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512BW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512BW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsubb %xmm1, %xmm4, %xmm1
; AVX512BW-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw %xmm1, %xmm5, %xmm1
; AVX512BW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512BW-NEXT:    vpbroadcastb %xmm1, %zmm1
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastb %xmm1, %xmm1
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm2 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLBW-NEXT:    vpand %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,zero,zero,zero,zero,xmm3[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VLBW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLBW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VLBW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VLBW-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsubb %xmm1, %xmm4, %xmm1
; AVX512VLBW-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm1 = xmm1[0],zero,zero,zero,zero,zero,zero,zero,xmm1[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpsrlw %xmm1, %xmm5, %xmm1
; AVX512VLBW-NEXT:    vpsrlw $8, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpbroadcastb %xmm1, %zmm1
; AVX512VLBW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm0, %zmm3, %zmm0
; AVX512VLBW-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %x, <64 x i8> %splat)
  ret <64 x i8> %res
}

;
; Constant Shifts
;

define <8 x i64> @constant_funnnel_v8i64(<8 x i64> %x) nounwind {
; AVX512-LABEL: constant_funnnel_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprolvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %x, <8 x i64> <i64 4, i64 14, i64 50, i64 60, i64 4, i64 14, i64 50, i64 60>)
  ret <8 x i64> %res
}

define <16 x i32> @constant_funnnel_v16i32(<16 x i32> %x) nounwind {
; AVX512-LABEL: constant_funnnel_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprolvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %x, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>)
  ret <16 x i32> %res
}

define <32 x i16> @constant_funnnel_v32i16(<32 x i16> %x) nounwind {
; AVX512F-LABEL: constant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm1, %ymm3
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm4 = xmm1[0],xmm3[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-NEXT:    vpmulhuw %ymm2, %ymm0, %ymm2
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1,2,3,4,5,6,7]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512F-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512VL-NEXT:    vpmulhuw %ymm2, %ymm1, %ymm3
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm4 = xmm1[0],xmm3[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX512VL-NEXT:    vpmulhuw %ymm2, %ymm0, %ymm2
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm4 = xmm0[0],xmm2[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm2, %zmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm0, %zmm1
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm0, %zmm1
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %x, <32 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>)
  ret <32 x i16> %res
}

define <64 x i8> @constant_funnnel_v64i8(<64 x i8> %x) nounwind {
; AVX512F-LABEL: constant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpsllw $4, %ymm1, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512F-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512F-NEXT:    vpblendvb %ymm4, %ymm2, %ymm1, %ymm2
; AVX512F-NEXT:    vpsllw $2, %ymm2, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpaddb %ymm4, %ymm4, %ymm7
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm5, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm5
; AVX512F-NEXT:    vpaddb %ymm7, %ymm7, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm5, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm5
; AVX512F-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm4, %ymm3, %ymm0, %ymm3
; AVX512F-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512F-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm3[8],ymm1[9],ymm3[9],ymm1[10],ymm3[10],ymm1[11],ymm3[11],ymm1[12],ymm3[12],ymm1[13],ymm3[13],ymm1[14],ymm3[14],ymm1[15],ymm3[15],ymm1[24],ymm3[24],ymm1[25],ymm3[25],ymm1[26],ymm3[26],ymm1[27],ymm3[27],ymm1[28],ymm3[28],ymm1[29],ymm3[29],ymm1[30],ymm3[30],ymm1[31],ymm3[31]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512F-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[4],ymm3[4],ymm1[5],ymm3[5],ymm1[6],ymm3[6],ymm1[7],ymm3[7],ymm1[16],ymm3[16],ymm1[17],ymm3[17],ymm1[18],ymm3[18],ymm1[19],ymm3[19],ymm1[20],ymm3[20],ymm1[21],ymm3[21],ymm1[22],ymm3[22],ymm1[23],ymm3[23]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512F-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm6, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm3[8],ymm0[9],ymm3[9],ymm0[10],ymm3[10],ymm0[11],ymm3[11],ymm0[12],ymm3[12],ymm0[13],ymm3[13],ymm0[14],ymm3[14],ymm0[15],ymm3[15],ymm0[24],ymm3[24],ymm0[25],ymm3[25],ymm0[26],ymm3[26],ymm0[27],ymm3[27],ymm0[28],ymm3[28],ymm0[29],ymm3[29],ymm0[30],ymm3[30],ymm0[31],ymm3[31]
; AVX512F-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[1],ymm3[1],ymm0[2],ymm3[2],ymm0[3],ymm3[3],ymm0[4],ymm3[4],ymm0[5],ymm3[5],ymm0[6],ymm3[6],ymm0[7],ymm3[7],ymm0[16],ymm3[16],ymm0[17],ymm3[17],ymm0[18],ymm3[18],ymm0[19],ymm3[19],ymm0[20],ymm3[20],ymm0[21],ymm3[21],ymm0[22],ymm3[22],ymm0[23],ymm3[23]
; AVX512F-NEXT:    vpmullw %ymm6, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512F-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm0, %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vpsllw $4, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm4 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VL-NEXT:    # ymm4 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpblendvb %ymm4, %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsllw $2, %ymm2, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm5
; AVX512VL-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm4, %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512VL-NEXT:    vpand %ymm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm1[8],ymm3[8],ymm1[9],ymm3[9],ymm1[10],ymm3[10],ymm1[11],ymm3[11],ymm1[12],ymm3[12],ymm1[13],ymm3[13],ymm1[14],ymm3[14],ymm1[15],ymm3[15],ymm1[24],ymm3[24],ymm1[25],ymm3[25],ymm1[26],ymm3[26],ymm1[27],ymm3[27],ymm1[28],ymm3[28],ymm1[29],ymm3[29],ymm1[30],ymm3[30],ymm1[31],ymm3[31]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[4],ymm3[4],ymm1[5],ymm3[5],ymm1[6],ymm3[6],ymm1[7],ymm3[7],ymm1[16],ymm3[16],ymm1[17],ymm3[17],ymm1[18],ymm3[18],ymm1[19],ymm3[19],ymm1[20],ymm3[20],ymm1[21],ymm3[21],ymm1[22],ymm3[22],ymm1[23],ymm3[23]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512VL-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpackuswb %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm0[8],ymm3[8],ymm0[9],ymm3[9],ymm0[10],ymm3[10],ymm0[11],ymm3[11],ymm0[12],ymm3[12],ymm0[13],ymm3[13],ymm0[14],ymm3[14],ymm0[15],ymm3[15],ymm0[24],ymm3[24],ymm0[25],ymm3[25],ymm0[26],ymm3[26],ymm0[27],ymm3[27],ymm0[28],ymm3[28],ymm0[29],ymm3[29],ymm0[30],ymm3[30],ymm0[31],ymm3[31]
; AVX512VL-NEXT:    vpmullw %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $8, %ymm4, %ymm4
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[1],ymm3[1],ymm0[2],ymm3[2],ymm0[3],ymm3[3],ymm0[4],ymm3[4],ymm0[5],ymm3[5],ymm0[6],ymm3[6],ymm0[7],ymm3[7],ymm0[16],ymm3[16],ymm0[17],ymm3[17],ymm0[18],ymm3[18],ymm0[19],ymm3[19],ymm0[20],ymm3[20],ymm0[21],ymm3[21],ymm0[22],ymm3[22],ymm0[23],ymm3[23]
; AVX512VL-NEXT:    vpmullw %ymm6, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlw $8, %ymm0, %ymm0
; AVX512VL-NEXT:    vpackuswb %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm0, %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpblendmb %zmm2, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm2, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm2 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2 {%k1}
; AVX512BW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; AVX512BW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm0, %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm1 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLBW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLBW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpblendmb %zmm2, %zmm0, %zmm2 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm2, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm2 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovb2m %zmm1, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2 {%k1}
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm0[8],zmm1[8],zmm0[9],zmm1[9],zmm0[10],zmm1[10],zmm0[11],zmm1[11],zmm0[12],zmm1[12],zmm0[13],zmm1[13],zmm0[14],zmm1[14],zmm0[15],zmm1[15],zmm0[24],zmm1[24],zmm0[25],zmm1[25],zmm0[26],zmm1[26],zmm0[27],zmm1[27],zmm0[28],zmm1[28],zmm0[29],zmm1[29],zmm0[30],zmm1[30],zmm0[31],zmm1[31],zmm0[40],zmm1[40],zmm0[41],zmm1[41],zmm0[42],zmm1[42],zmm0[43],zmm1[43],zmm0[44],zmm1[44],zmm0[45],zmm1[45],zmm0[46],zmm1[46],zmm0[47],zmm1[47],zmm0[56],zmm1[56],zmm0[57],zmm1[57],zmm0[58],zmm1[58],zmm0[59],zmm1[59],zmm0[60],zmm1[60],zmm0[61],zmm1[61],zmm0[62],zmm1[62],zmm0[63],zmm1[63]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpunpcklbw {{.*#+}} zmm0 = zmm0[0],zmm1[0],zmm0[1],zmm1[1],zmm0[2],zmm1[2],zmm0[3],zmm1[3],zmm0[4],zmm1[4],zmm0[5],zmm1[5],zmm0[6],zmm1[6],zmm0[7],zmm1[7],zmm0[16],zmm1[16],zmm0[17],zmm1[17],zmm0[18],zmm1[18],zmm0[19],zmm1[19],zmm0[20],zmm1[20],zmm0[21],zmm1[21],zmm0[22],zmm1[22],zmm0[23],zmm1[23],zmm0[32],zmm1[32],zmm0[33],zmm1[33],zmm0[34],zmm1[34],zmm0[35],zmm1[35],zmm0[36],zmm1[36],zmm0[37],zmm1[37],zmm0[38],zmm1[38],zmm0[39],zmm1[39],zmm0[48],zmm1[48],zmm0[49],zmm1[49],zmm0[50],zmm1[50],zmm0[51],zmm1[51],zmm0[52],zmm1[52],zmm0[53],zmm1[53],zmm0[54],zmm1[54],zmm0[55],zmm1[55]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpackuswb %zmm3, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm0, %zmm2, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %x, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

;
; Uniform Constant Shifts
;

define <8 x i64> @splatconstant_funnnel_v8i64(<8 x i64> %x) nounwind {
; AVX512-LABEL: splatconstant_funnnel_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprolq $14, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %x, <8 x i64> <i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14>)
  ret <8 x i64> %res
}

define <16 x i32> @splatconstant_funnnel_v16i32(<16 x i32> %x) nounwind {
; AVX512-LABEL: splatconstant_funnnel_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vprold $4, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %x, <16 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>)
  ret <16 x i32> %res
}

define <32 x i16> @splatconstant_funnnel_v32i16(<32 x i16> %x) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlw $9, %ymm0, %ymm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsrlw $9, %ymm2, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $7, %ymm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlw $9, %ymm0, %ymm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsrlw $9, %ymm2, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $7, %ymm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $9, %zmm0, %zmm1
; AVX512BW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $9, %zmm0, %zmm1
; AVX512VLBW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %x, <32 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <32 x i16> %res
}

define <64 x i8> @splatconstant_funnnel_v64i8(<64 x i8> %x) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm3, %ymm4, %ymm3
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512F-NEXT:    vpsllw $4, %ymm1, %ymm1
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm3, %ymm4, %ymm3
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm3, %zmm2
; AVX512VL-NEXT:    vpsllw $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpand %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm1
; AVX512BW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm1
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %x, <64 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <64 x i8> %res
}
