; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=ALL --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=ALL,AVX,AVX2,AVX2-SLOW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fast-variable-shuffle | FileCheck %s --check-prefixes=ALL,AVX,AVX2,AVX2-FAST
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+fast-variable-shuffle | FileCheck %s --check-prefixes=ALL,AVX,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+fast-variable-shuffle | FileCheck %s --check-prefixes=ALL,AVX,AVX512,AVX512DQ

;
; add
;

define <4 x i32> @trunc_add_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_add_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm3, %xmm1
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_add_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_add_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm6, %xmm2
; SSE-NEXT:    paddq %xmm7, %xmm3
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    paddq %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm3[1,2,3],xmm1[4],xmm3[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2,3],xmm2[4],xmm3[5,6,7]
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm3[1,2,3],xmm0[4],xmm3[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0],xmm3[1,2,3],xmm4[4],xmm3[5,6,7]
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_add_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_add_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_add_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_add_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    paddq {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm5, %xmm1, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm6, %xmm2, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm7, %xmm3, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vpaddq %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpackusdw %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpackusdw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm3
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm3
; AVX1-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpaddq %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpaddq %ymm7, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpaddq %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpaddq %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpaddq %ymm7, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpaddq %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpaddq %zmm3, %zmm1, %zmm1
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_add_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_add_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255]
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm2
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_add_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_add_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    paddw %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpaddw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackuswb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_add_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_add_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_add_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = add <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <8 x i16> @trunc_add_v8i32_v8i16_sext_8i8(<16 x i8> %a0, <8 x i32> %a1) {
; SSE-LABEL: trunc_add_v8i32_v8i16_sext_8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    packssdw %xmm2, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE-NEXT:    psraw $8, %xmm0
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_v8i32_v8i16_sext_8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_v8i32_v8i16_sext_8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_add_v8i32_v8i16_sext_8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512-NEXT:    vpmovsxbw %xmm0, %xmm0
; AVX512-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = sext <8 x i8> %1 to <8 x i32>
  %3 = add <8 x i32> %2, %a1
  %4 = trunc <8 x i32> %3 to <8 x i16>
  ret <8 x i16> %4
}

;
; add to constant
;

define <4 x i32> @trunc_add_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    paddd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_add_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    paddw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_add_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    paddw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_add_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpaddw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_add_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    paddb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_add_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_add_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_add_const_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_add_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    paddb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_add_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = add <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_add_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_add_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    paddb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_add_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_add_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_add_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_add_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_add_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpaddb {{.*}}(%rip), %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = add <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; sub
;

define <4 x i32> @trunc_sub_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_sub_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psubq %xmm3, %xmm1
; SSE-NEXT:    psubq %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_sub_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_sub_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubq %xmm6, %xmm2
; SSE-NEXT:    psubq %xmm7, %xmm3
; SSE-NEXT:    psubq %xmm4, %xmm0
; SSE-NEXT:    psubq %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0],xmm3[1,2,3],xmm1[4],xmm3[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0],xmm3[1,2,3],xmm2[4],xmm3[5,6,7]
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0],xmm3[1,2,3],xmm0[4],xmm3[5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm4[0],xmm3[1,2,3],xmm4[4],xmm3[5,6,7]
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpsubq %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpsubq %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_sub_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_sub_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psubd %xmm2, %xmm0
; SSE-NEXT:    psubd %xmm3, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_sub_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_sub_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    psubq {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubq %xmm4, %xmm0, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm5, %xmm1, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm7, %xmm3, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vpsubq %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpackusdw %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpackusdw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm3
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm3
; AVX1-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vpsubq %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vpsubq %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpsubq %ymm7, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vpsubq %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2i128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpsubq %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpsubq %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpsubq %ymm7, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpsubq %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpsubq %zmm3, %zmm1, %zmm1
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_sub_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_sub_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubd %xmm4, %xmm0
; SSE-NEXT:    psubd %xmm5, %xmm1
; SSE-NEXT:    psubd %xmm6, %xmm2
; SSE-NEXT:    psubd %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubd %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpsubd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255]
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm2
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_sub_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_sub_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubw %xmm2, %xmm0
; SSE-NEXT:    psubw %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsubw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackuswb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_sub_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_sub_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_sub_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = sub <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_ext_sub_v16i16_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SSE-LABEL: trunc_ext_sub_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ext_sub_v16i16_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %a = zext <16 x i8> %x to <16 x i16>
  %b = zext <16 x i8> %y to <16 x i16>
  %c = sub <16 x i16> %a, %b
  %d = trunc <16 x i16> %c to <16 x i8>
  ret <16 x i8> %d
}

;
; sub to constant
;

define <4 x i32> @trunc_sub_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    psubd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vpsubd {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vpsubd {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpsubd {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpsubd {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_sub_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    psubw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_sub_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    psubw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpsubw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_sub_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    psubb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_sub_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_sub_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_const_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_sub_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    psubb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_sub_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = sub <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_sub_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_sub_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    psubb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_sub_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_sub_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_sub_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_sub_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_sub_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = sub <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_ext_sub_const_rhs_v16i16_v16i8(<16 x i8> %x) {
; SSE-LABEL: trunc_ext_sub_const_rhs_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psubb {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ext_sub_const_rhs_v16i16_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsubb {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %a = zext <16 x i8> %x to <16 x i16>
  %b = sub <16 x i16> %a, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %c = trunc <16 x i16> %b to <16 x i8>
  ret <16 x i8> %c
}

define <16 x i8> @trunc_ext_sub_const_lhs_v16i16_v16i8(<16 x i8> %x) {
; SSE-LABEL: trunc_ext_sub_const_lhs_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; SSE-NEXT:    psubb %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_ext_sub_const_lhs_v16i16_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
; AVX-NEXT:    vpsubb %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %a = zext <16 x i8> %x to <16 x i16>
  %b = sub <16 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>, %a
  %c = trunc <16 x i16> %b to <16 x i8>
  ret <16 x i8> %c
}

;
; mul
;

define <4 x i32> @trunc_mul_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_mul_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pmuludq %xmm3, %xmm1
; SSE-NEXT:    pmuludq %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX2-SLOW-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_v4i64_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovqd %zmm1, %ymm1
; AVX512F-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512F-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_v4i64_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovqd %zmm1, %ymm1
; AVX512BW-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512BW-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_v4i64_v4i32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512DQ-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512DQ-NEXT:    vpmullq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_mul_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_mul_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE-NEXT:    movsd {{.*#+}} xmm6 = xmm4[0],xmm6[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    pmullw %xmm6, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm4[0,2],ymm0[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_v8i64_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512F-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512F-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_v8i64_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512BW-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512BW-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_v8i64_v8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullq %zmm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_mul_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_mul_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_mul_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_mul_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pmuludq {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmuludq %xmm4, %xmm0, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmuludq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq %xmm6, %xmm2, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpmuludq %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpmuludq %xmm7, %xmm3, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vpmuludq %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255]
; AVX1-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpackusdw %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vpand %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vpackusdw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm4, %xmm3
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm7, %xmm8, %xmm3
; AVX1-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm7, %xmm8
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm8 = xmm7[0,2],xmm8[0,2]
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm3, %xmm7
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,2],xmm7[0,2]
; AVX2-SLOW-NEXT:    vpmulld %xmm8, %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm6, %xmm7
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[0,2],xmm7[0,2]
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm2, %xmm7
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm7[0,2]
; AVX2-SLOW-NEXT:    vpmulld %xmm6, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm5, %xmm7
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[0,2],xmm7[0,2]
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm1, %xmm7
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm7[0,2]
; AVX2-SLOW-NEXT:    vpmulld %xmm5, %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[0,2],xmm5[0,2]
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm5[0,2]
; AVX2-SLOW-NEXT:    vpmulld %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm8 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm7, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm8, %ymm3
; AVX2-FAST-NEXT:    vpmulld %xmm7, %xmm3, %xmm3
; AVX2-FAST-NEXT:    vpermd %ymm6, %ymm8, %ymm6
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm8, %ymm2
; AVX2-FAST-NEXT:    vpmulld %xmm6, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm5, %ymm8, %ymm5
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm8, %ymm1
; AVX2-FAST-NEXT:    vpmulld %xmm5, %xmm1, %xmm1
; AVX2-FAST-NEXT:    vpermd %ymm4, %ymm8, %ymm4
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm8, %ymm0
; AVX2-FAST-NEXT:    vpmulld %xmm4, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_v16i64_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmuludq %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpmuludq %zmm3, %zmm1, %zmm1
; AVX512F-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512F-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_v16i64_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmuludq %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmuludq %zmm3, %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512BW-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_v16i64_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullq %zmm2, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmullq %zmm3, %zmm1, %zmm1
; AVX512DQ-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512DQ-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_mul_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_mul_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm8, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm6, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm7, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulld %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmulld %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmulld %xmm3, %xmm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmulld %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255]
; AVX1-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm3, %xmm4, %xmm2
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmulld %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmulld %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmulld %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_mul_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_mul_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmullw %xmm2, %xmm0
; SSE-NEXT:    pmullw %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpackuswb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullw %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <8 x i16> @trunc_mul_v8i32_v8i16_zext_8i8(<16 x i8> %a0, <8 x i32> %a1) {
; SSE-LABEL: trunc_mul_v8i32_v8i16_zext_8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm3, %xmm3
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1],xmm0[2],xmm3[2],xmm0[3],xmm3[3],xmm0[4],xmm3[4],xmm0[5],xmm3[5],xmm0[6],xmm3[6],xmm0[7],xmm3[7]
; SSE-NEXT:    pslld $16, %xmm2
; SSE-NEXT:    psrad $16, %xmm2
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    packssdw %xmm2, %xmm1
; SSE-NEXT:    pmullw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_v8i32_v8i16_zext_8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_v8i32_v8i16_zext_8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpshufb {{.*#+}} ymm1 = ymm1[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_v8i32_v8i16_zext_8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmullw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = shufflevector <16 x i8> %a0, <16 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = zext <8 x i8> %1 to <8 x i32>
  %3 = mul <8 x i32> %2, %a1
  %4 = trunc <8 x i32> %3 to <8 x i16>
  ret <8 x i16> %4
}

;
; mul to constant
;

define <4 x i32> @trunc_mul_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm1
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_mul_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    pmullw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_mul_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pmullw {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_mul_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm0
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm1
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm2
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm3
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm4
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm5
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm6
; SSE-NEXT:    pmuludq {{.*}}(%rip), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm0, %xmm8
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm1, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm2, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm3, %xmm7
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vpmuludq {{.*}}(%rip), %xmm3, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpand %xmm4, %xmm7, %xmm7
; AVX1-NEXT:    vpackusdw %xmm3, %xmm7, %xmm3
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm6, %xmm6
; AVX1-NEXT:    vpackusdw %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm5, %xmm3
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm8, %xmm3
; AVX1-NEXT:    vpackusdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[0,2],xmm4[0,2]
; AVX2-SLOW-NEXT:    vpmulld {{.*}}(%rip), %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[0,2],xmm4[0,2]
; AVX2-SLOW-NEXT:    vpmulld {{.*}}(%rip), %xmm3, %xmm3
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm5[0,2]
; AVX2-SLOW-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm5[0,2]
; AVX2-SLOW-NEXT:    vpmulld {{.*}}(%rip), %xmm1, %xmm1
; AVX2-SLOW-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpmulld {{.*}}(%rip), %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vpmulld {{.*}}(%rip), %xmm3, %xmm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vpmulld {{.*}}(%rip), %xmm1, %xmm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmuludq {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vpmuludq {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512F-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmuludq {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmuludq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512BW-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_const_v16i64_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullq {{.*}}(%rip), %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmullq {{.*}}(%rip), %zmm1, %zmm1
; AVX512DQ-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512DQ-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_mul_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [0,1,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm1[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm4[0],xmm1[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [8,9,10,11]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [12,13,14,15]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm4, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pmuludq %xmm5, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255]
; AVX1-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_mul_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmulld {{.*}}(%rip), %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = mul <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_mul_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_mul_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmullw {{.*}}(%rip), %xmm0
; SSE-NEXT:    pmullw {{.*}}(%rip), %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_mul_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmullw {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackuswb %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_mul_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_mul_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmullw {{.*}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_mul_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpmullw {{.*}}(%rip), %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_mul_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmullw {{.*}}(%rip), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = mul <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; and
;

define <4 x i32> @trunc_and_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_and_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    andps %xmm3, %xmm1
; SSE-NEXT:    andps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_and_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_and_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pand %xmm6, %xmm2
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_and_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_and_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_and_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_and_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_and_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm8 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm7, %ymm8, %ymm7
; AVX1-NEXT:    vandps %ymm7, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm7
; AVX1-NEXT:    vpackusdw %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm6, %ymm8, %ymm6
; AVX1-NEXT:    vandps %ymm6, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpackusdw %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm5, %ymm8, %ymm3
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm8, %ymm3
; AVX1-NEXT:    vandps %ymm3, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vandps %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vandps %ymm7, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vandps %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpand %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpand %ymm7, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpand %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpandq %zmm3, %zmm1, %zmm1
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_and_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_and_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm3, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm1, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm5, %xmm0
; SSE-NEXT:    packuswb %xmm6, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_and_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_and_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_and_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_and_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_and_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_and_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = and <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; and to constant
;

define <4 x i32> @trunc_and_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    andps {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vandps {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vandps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vandps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_and_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    andpd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_and_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_and_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_and_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_and_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_and_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_and_const_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_and_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_and_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = and <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_and_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_and_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_and_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_and_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_and_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_and_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_and_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = and <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; xor
;

define <4 x i32> @trunc_xor_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_xor_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm3, %xmm1
; SSE-NEXT:    xorps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_xor_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_xor_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_xor_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_xor_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_xor_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_xor_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm5, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm6, %ymm2, %ymm2
; AVX1-NEXT:    vxorps %ymm7, %ymm3, %ymm3
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vxorps %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vxorps %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vxorps %ymm7, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vxorps %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpxor %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpxor %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpxor %ymm7, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpxor %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxorq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpxorq %zmm3, %zmm1, %zmm1
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_xor_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_xor_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_xor_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_xor_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_xor_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_xor_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_xor_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = xor <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; xor to constant
;

define <4 x i32> @trunc_xor_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    xorps {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vxorps {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vxorps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vxorps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_xor_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    xorpd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_xor_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pxor {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_xor_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    pxor {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_xor_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_xor_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_const_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_xor_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    pxor {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_xor_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = xor <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_xor_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_xor_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    pxor {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_xor_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_xor_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_xor_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_xor_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_xor_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpxor {{.*}}(%rip), %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = xor <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; or
;

define <4 x i32> @trunc_or_v4i64_v4i32(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE-LABEL: trunc_or_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    orps %xmm3, %xmm1
; SSE-NEXT:    orps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <4 x i64> %a0, %a1
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_or_v8i64_v8i16(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE-LABEL: trunc_or_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vorps %ymm3, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <8 x i64> %a0, %a1
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_or_v8i32_v8i16(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: trunc_or_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_or_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <8 x i32> %a0, %a1
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_or_v16i64_v16i8(<16 x i64> %a0, <16 x i64> %a1) nounwind {
; SSE-LABEL: trunc_or_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm5, %ymm1, %ymm1
; AVX1-NEXT:    vorps %ymm6, %ymm2, %ymm2
; AVX1-NEXT:    vorps %ymm7, %ymm3, %ymm3
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vorps %ymm5, %ymm1, %ymm1
; AVX2-SLOW-NEXT:    vorps %ymm4, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vorps %ymm7, %ymm3, %ymm3
; AVX2-SLOW-NEXT:    vorps %ymm6, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vpor %ymm5, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vpor %ymm4, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpor %ymm7, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpor %ymm6, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vporq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vporq %zmm3, %zmm1, %zmm1
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <16 x i64> %a0, %a1
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_or_v16i32_v16i8(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: trunc_or_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    por %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_or_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <16 x i32> %a0, %a1
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_or_v16i16_v16i8(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: trunc_or_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_or_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_or_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_or_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = or <16 x i16> %a0, %a1
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; or to constant
;

define <4 x i32> @trunc_or_const_v4i64_v4i32(<4 x i64> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    orps {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v4i64_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vorps {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_const_v4i64_v4i32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX2-SLOW-NEXT:    vorps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_const_v4i64_v4i32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FAST-NEXT:    vorps {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_const_v4i64_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <4 x i64> %a0, <i64 0, i64 1, i64 2, i64 3>
  %2 = trunc <4 x i64> %1 to <4 x i32>
  ret <4 x i32> %2
}

define <8 x i16> @trunc_or_const_v8i64_v8i16(<8 x i64> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v8i64_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,2,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,2,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE-NEXT:    orpd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v8i64_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_const_v8i64_v8i16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-SLOW-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_const_v8i64_v8i16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm2, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_const_v8i64_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <8 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7>
  %2 = trunc <8 x i64> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <8 x i16> @trunc_or_const_v8i32_v8i16(<8 x i32> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v8i32_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $16, %xmm1
; SSE-NEXT:    psrad $16, %xmm1
; SSE-NEXT:    pslld $16, %xmm0
; SSE-NEXT:    psrad $16, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    por {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v8i32_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vpshufb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_const_v8i32_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufb {{.*#+}} ymm0 = ymm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_or_const_v8i32_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <8 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = trunc <8 x i32> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i8> @trunc_or_const_v16i64_v16i8(<16 x i64> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v16i64_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0]
; SSE-NEXT:    pand %xmm8, %xmm7
; SSE-NEXT:    pand %xmm8, %xmm6
; SSE-NEXT:    packuswb %xmm7, %xmm6
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pand %xmm8, %xmm4
; SSE-NEXT:    packuswb %xmm5, %xmm4
; SSE-NEXT:    packuswb %xmm6, %xmm4
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm4, %xmm0
; SSE-NEXT:    por {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v16i64_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm4 = [255,255,255,255]
; AVX1-NEXT:    vandps %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm4, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpackusdw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vandps %ymm4, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-SLOW-LABEL: trunc_or_const_v16i64_v16i8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm2 = ymm2[0,2],ymm4[0,2],ymm2[4,6],ymm4[4,6]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-SLOW-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX2-SLOW-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm5[0,2],ymm0[4,6],ymm5[4,6]
; AVX2-SLOW-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-SLOW-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-SLOW-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: trunc_or_const_v16i64_v16i8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,2,4,6,4,6,6,7]
; AVX2-FAST-NEXT:    vpermd %ymm2, %ymm4, %ymm2
; AVX2-FAST-NEXT:    vpermd %ymm3, %ymm4, %ymm3
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,2,3]
; AVX2-FAST-NEXT:    vmovdqa {{.*#+}} xmm5 = [255,255,255,255,255,255,255,255]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX2-FAST-NEXT:    vpermd %ymm0, %ymm4, %ymm0
; AVX2-FAST-NEXT:    vpermd %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-FAST-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-FAST-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpackuswb %xmm2, %xmm0, %xmm0
; AVX2-FAST-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX512-LABEL: trunc_or_const_v16i64_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <16 x i64> %a0, <i64 0, i64 1, i64 2, i64 3, i64 4, i64 5, i64 6, i64 7, i64 8, i64 9, i64 10, i64 11, i64 12, i64 13, i64 14, i64 15>
  %2 = trunc <16 x i64> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_or_const_v16i32_v16i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v16i32_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    packuswb %xmm2, %xmm0
; SSE-NEXT:    por {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v16i32_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_const_v16i32_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm2 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm3 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %xmm3, %xmm1, %xmm1
; AVX2-NEXT:    vpshufb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpand %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_or_const_v16i32_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = or <16 x i32> %a0, <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = trunc <16 x i32> %1 to <16 x i8>
  ret <16 x i8> %2
}

define <16 x i8> @trunc_or_const_v16i16_v16i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: trunc_or_const_v16i16_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    por {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_or_const_v16i16_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_or_const_v16i16_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_or_const_v16i16_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_or_const_v16i16_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512DQ-LABEL: trunc_or_const_v16i16_v16i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vpor {{.*}}(%rip), %xmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
  %1 = or <16 x i16> %a0, <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  %2 = trunc <16 x i16> %1 to <16 x i8>
  ret <16 x i8> %2
}

;
; complex patterns - often created by vectorizer
;

define <4 x i32> @mul_add_const_v4i64_v4i32(<4 x i32> %a0, <4 x i32> %a1) nounwind {
; SSE-LABEL: mul_add_const_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,1,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,1,1,3]
; SSE-NEXT:    pmuludq %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pmuludq %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    paddd {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: mul_add_const_v4i64_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpaddd {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = sext <4 x i32> %a0 to <4 x i64>
  %2 = sext <4 x i32> %a1 to <4 x i64>
  %3 = mul <4 x i64> %1, %2
  %4 = add <4 x i64> %3, <i64 -3, i64 -1, i64 1, i64 3>
  %5 = trunc <4 x i64> %4 to <4 x i32>
  ret <4 x i32> %5
}

define <4 x i32> @mul_add_self_v4i64_v4i32(<4 x i32> %a0, <4 x i32> %a1) nounwind {
; SSE-LABEL: mul_add_self_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,1,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,1,1,3]
; SSE-NEXT:    pmuludq %xmm2, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pmuludq %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    paddd %xmm0, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: mul_add_self_v4i64_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = sext <4 x i32> %a0 to <4 x i64>
  %2 = sext <4 x i32> %a1 to <4 x i64>
  %3 = mul <4 x i64> %1, %2
  %4 = add <4 x i64> %3, %3
  %5 = trunc <4 x i64> %4 to <4 x i32>
  ret <4 x i32> %5
}

define <4 x i32> @mul_add_multiuse_v4i64_v4i32(<4 x i32> %a0, <4 x i32> %a1) nounwind {
; SSE-LABEL: mul_add_multiuse_v4i64_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,1,1,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[2,1,3,3]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[0,1,1,3]
; SSE-NEXT:    pmuludq %xmm2, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,1,3,3]
; SSE-NEXT:    pmuludq %xmm3, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,2],xmm1[0,2]
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: mul_add_multiuse_v4i64_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmulld %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = sext <4 x i32> %a0 to <4 x i64>
  %2 = sext <4 x i32> %a1 to <4 x i64>
  %3 = mul <4 x i64> %1, %2
  %4 = add <4 x i64> %1, %3
  %5 = trunc <4 x i64> %4 to <4 x i32>
  ret <4 x i32> %5
}
