; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp,+fp64 -verify-machineinstrs %s -o - | FileCheck %s

; i32

define void @vst3_v2i32(<2 x i32> *%src, <6 x i32> *%dst) {
; CHECK-LABEL: vst3_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldm.w r0, {r2, r3, r12, lr}
; CHECK-NEXT:    ldrd r4, r0, [r0, #16]
; CHECK-NEXT:    vmov.32 q1[0], r2
; CHECK-NEXT:    vmov.32 q1[1], r3
; CHECK-NEXT:    vmov.32 q0[0], r4
; CHECK-NEXT:    vmov.32 q1[2], r12
; CHECK-NEXT:    vmov.32 q0[1], r0
; CHECK-NEXT:    vmov.32 q1[3], lr
; CHECK-NEXT:    vmov.f32 s8, s7
; CHECK-NEXT:    vmov.f32 s10, s1
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    vmov.f64 d4, d2
; CHECK-NEXT:    vmov.f32 s9, s6
; CHECK-NEXT:    vmov.f32 s10, s0
; CHECK-NEXT:    vmov.f32 s11, s5
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    strd r2, r0, [r1, #16]
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <2 x i32>, <2 x i32>* %src, i32 0
  %l1 = load <2 x i32>, <2 x i32>* %s1, align 4
  %s2 = getelementptr <2 x i32>, <2 x i32>* %src, i32 1
  %l2 = load <2 x i32>, <2 x i32>* %s2, align 4
  %s3 = getelementptr <2 x i32>, <2 x i32>* %src, i32 2
  %l3 = load <2 x i32>, <2 x i32>* %s3, align 4
  %t1 = shufflevector <2 x i32> %l1, <2 x i32> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i32> %l3, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i32> %t1, <4 x i32> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i32> %s, <6 x i32> *%dst
  ret void
}

define void @vst3_v4i32(<4 x i32> *%src, <12 x i32> *%dst) {
; CHECK-LABEL: vst3_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vmov.f32 s4, s9
; CHECK-NEXT:    vmov.f64 d6, d8
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.f32 s5, s1
; CHECK-NEXT:    vdup.32 q5, r0
; CHECK-NEXT:    vmov.f32 s13, s8
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov r0, s11
; CHECK-NEXT:    vmov.f32 s7, s10
; CHECK-NEXT:    vdup.32 q2, r0
; CHECK-NEXT:    vmov.f32 s15, s17
; CHECK-NEXT:    vmov.f32 s1, s19
; CHECK-NEXT:    vmov.f32 s6, s18
; CHECK-NEXT:    vmov.f32 s14, s22
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.f32 s2, s10
; CHECK-NEXT:    vstrw.32 q3, [r1]
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i32>, <4 x i32>* %src, i32 0
  %l1 = load <4 x i32>, <4 x i32>* %s1, align 4
  %s2 = getelementptr <4 x i32>, <4 x i32>* %src, i32 1
  %l2 = load <4 x i32>, <4 x i32>* %s2, align 4
  %s3 = getelementptr <4 x i32>, <4 x i32>* %src, i32 2
  %l3 = load <4 x i32>, <4 x i32>* %s3, align 4
  %t1 = shufflevector <4 x i32> %l1, <4 x i32> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i32> %l3, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i32> %t1, <8 x i32> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %s, <12 x i32> *%dst
  ret void
}

define void @vst3_v8i32(<8 x i32> *%src, <24 x i32> *%dst) {
; CHECK-LABEL: vst3_v8i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #48
; CHECK-NEXT:    sub sp, #48
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vmov.f64 d6, d1
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #64]
; CHECK-NEXT:    vstrw.32 q4, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q5, [sp] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q6, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s13, s23
; CHECK-NEXT:    vmov r2, s7
; CHECK-NEXT:    vmov.f32 s15, s3
; CHECK-NEXT:    vdup.32 q2, r2
; CHECK-NEXT:    vmov.f32 s14, s10
; CHECK-NEXT:    vmov.f64 d4, d8
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f32 s9, s24
; CHECK-NEXT:    vmov.f32 s11, s17
; CHECK-NEXT:    vmov q4, q5
; CHECK-NEXT:    vmov.f32 s21, s4
; CHECK-NEXT:    vmov r0, s28
; CHECK-NEXT:    vmov.f32 s23, s17
; CHECK-NEXT:    vdup.32 q4, r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.f32 s0, s5
; CHECK-NEXT:    vdup.32 q6, r0
; CHECK-NEXT:    vmov.f32 s10, s18
; CHECK-NEXT:    vldrw.u32 q4, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s3, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s22, s26
; CHECK-NEXT:    vldrw.u32 q6, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vstrw.32 q5, [r1, #48]
; CHECK-NEXT:    vmov.f32 s4, s17
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vmov.f32 s5, s29
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    vmov.f32 s28, s30
; CHECK-NEXT:    vmov r0, s19
; CHECK-NEXT:    vmov.f32 s7, s18
; CHECK-NEXT:    vdup.32 q4, r0
; CHECK-NEXT:    vmov.f32 s29, s27
; CHECK-NEXT:    vmov.f32 s6, s26
; CHECK-NEXT:    vmov.f32 s30, s18
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vstrw.32 q7, [r1, #32]
; CHECK-NEXT:    add sp, #48
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x i32>, <8 x i32>* %src, i32 0
  %l1 = load <8 x i32>, <8 x i32>* %s1, align 4
  %s2 = getelementptr <8 x i32>, <8 x i32>* %src, i32 1
  %l2 = load <8 x i32>, <8 x i32>* %s2, align 4
  %s3 = getelementptr <8 x i32>, <8 x i32>* %src, i32 2
  %l3 = load <8 x i32>, <8 x i32>* %s3, align 4
  %t1 = shufflevector <8 x i32> %l1, <8 x i32> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i32> %l3, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i32> %t1, <16 x i32> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i32> %s, <24 x i32> *%dst
  ret void
}

define void @vst3_v16i32(<16 x i32> *%src, <48 x i32> *%dst) {
; CHECK-LABEL: vst3_v16i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #160
; CHECK-NEXT:    sub sp, #160
; CHECK-NEXT:    vldrw.u32 q1, [r0, #144]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #128]
; CHECK-NEXT:    vldrw.u32 q5, [r0]
; CHECK-NEXT:    vstrw.32 q1, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #80]
; CHECK-NEXT:    vmov.f32 s8, s1
; CHECK-NEXT:    vldrw.u32 q4, [r0, #176]
; CHECK-NEXT:    vstrw.32 q1, [sp, #144] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vmov.f32 s9, s13
; CHECK-NEXT:    vldrw.u32 q6, [r0, #112]
; CHECK-NEXT:    vstrw.32 q1, [sp, #128] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #160]
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vldrw.u32 q7, [r0, #48]
; CHECK-NEXT:    vstrw.32 q1, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #96]
; CHECK-NEXT:    vmov.f32 s10, s22
; CHECK-NEXT:    vstrw.32 q1, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vstrw.32 q2, [r1, #16]
; CHECK-NEXT:    vstrw.32 q1, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d2, d7
; CHECK-NEXT:    vdup.32 q2, r0
; CHECK-NEXT:    vmov.f32 s5, s23
; CHECK-NEXT:    vmov.f32 s7, s15
; CHECK-NEXT:    vmov.f32 s6, s10
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vmov.f64 d2, d9
; CHECK-NEXT:    vmov.f32 s5, s31
; CHECK-NEXT:    vmov.f32 s7, s19
; CHECK-NEXT:    vmov r0, s27
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vdup.32 q1, r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmov.f32 s10, s6
; CHECK-NEXT:    vmov.f64 d2, d10
; CHECK-NEXT:    vstrw.32 q2, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s5, s0
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov.f32 s7, s21
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f64 d0, d14
; CHECK-NEXT:    vstrw.32 q1, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s1, s24
; CHECK-NEXT:    vmov.f32 s3, s29
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmov q1, q0
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov.f32 s16, s25
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q1, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s19, s26
; CHECK-NEXT:    vldrw.u32 q6, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s30
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vmov.f32 s28, s5
; CHECK-NEXT:    vstrw.32 q4, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s29, s1
; CHECK-NEXT:    vmov.f32 s31, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d8, d1
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vmov r0, s11
; CHECK-NEXT:    vldrw.u32 q2, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s17, s7
; CHECK-NEXT:    vmov.f32 s30, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d6, d5
; CHECK-NEXT:    vstrw.32 q7, [r1, #112]
; CHECK-NEXT:    vmov.f32 s13, s7
; CHECK-NEXT:    vldrw.u32 q1, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s19, s3
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov r0, s27
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov.f32 s15, s11
; CHECK-NEXT:    vstrw.32 q4, [r1, #128]
; CHECK-NEXT:    vmov.f32 s14, s2
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    vmov.f32 s21, s4
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f32 s23, s1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.f32 s22, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q5, [r1, #96]
; CHECK-NEXT:    vmov.f64 d2, d0
; CHECK-NEXT:    vmov.f32 s5, s24
; CHECK-NEXT:    vmov q6, q0
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q1, [r1, #48]
; CHECK-NEXT:    vmov.f32 s8, s1
; CHECK-NEXT:    vmov.f32 s11, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s10, s26
; CHECK-NEXT:    vstrw.32 q0, [r1, #144]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q2, [r1, #64]
; CHECK-NEXT:    vstrw.32 q0, [r1, #160]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1, #176]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #160
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x i32>, <16 x i32>* %src, i32 0
  %l1 = load <16 x i32>, <16 x i32>* %s1, align 4
  %s2 = getelementptr <16 x i32>, <16 x i32>* %src, i32 1
  %l2 = load <16 x i32>, <16 x i32>* %s2, align 4
  %s3 = getelementptr <16 x i32>, <16 x i32>* %src, i32 2
  %l3 = load <16 x i32>, <16 x i32>* %s3, align 4
  %t1 = shufflevector <16 x i32> %l1, <16 x i32> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i32> %l3, <16 x i32> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i32> %t1, <32 x i32> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i32> %s, <48 x i32> *%dst
  ret void
}

; i16

define void @vst3_v2i16(<2 x i16> *%src, <6 x i16> *%dst) {
; CHECK-LABEL: vst3_v2i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    ldrh r2, [r0, #6]
; CHECK-NEXT:    ldrh r3, [r0, #4]
; CHECK-NEXT:    ldrh.w r12, [r0, #8]
; CHECK-NEXT:    vmov.16 q0[4], r2
; CHECK-NEXT:    ldrh.w lr, [r0, #2]
; CHECK-NEXT:    vmov.32 q1[0], r3
; CHECK-NEXT:    ldrh r4, [r0]
; CHECK-NEXT:    vmov.32 q1[2], r2
; CHECK-NEXT:    ldrh r0, [r0, #10]
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmov.32 q0[0], r4
; CHECK-NEXT:    vmov.32 q0[2], lr
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vdup.32 q1, r12
; CHECK-NEXT:    vmov.f32 s3, s2
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    str r0, [r1, #8]
; CHECK-NEXT:    pop {r4, pc}
entry:
  %s1 = getelementptr <2 x i16>, <2 x i16>* %src, i32 0
  %l1 = load <2 x i16>, <2 x i16>* %s1, align 4
  %s2 = getelementptr <2 x i16>, <2 x i16>* %src, i32 1
  %l2 = load <2 x i16>, <2 x i16>* %s2, align 4
  %s3 = getelementptr <2 x i16>, <2 x i16>* %src, i32 2
  %l3 = load <2 x i16>, <2 x i16>* %s3, align 4
  %t1 = shufflevector <2 x i16> %l1, <2 x i16> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i16> %l3, <2 x i16> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i16> %t1, <4 x i16> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i16> %s, <6 x i16> *%dst
  ret void
}

define void @vst3_v4i16(<4 x i16> *%src, <12 x i16> *%dst) {
; CHECK-LABEL: vst3_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrh.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrh.u32 q1, [r0]
; CHECK-NEXT:    vldrh.u32 q3, [r0, #8]
; CHECK-NEXT:    vmov.f64 d0, d5
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    vmov r0, s15
; CHECK-NEXT:    vdup.32 q4, r0
; CHECK-NEXT:    vmov.f32 s3, s11
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.f32 s2, s18
; CHECK-NEXT:    vmov.16 q4[0], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vstrh.32 q0, [r1, #16]
; CHECK-NEXT:    vmov.16 q4[1], r0
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q4[2], r0
; CHECK-NEXT:    vmov r0, s5
; CHECK-NEXT:    vmov.16 q4[3], r0
; CHECK-NEXT:    vmov r0, s13
; CHECK-NEXT:    vmov.16 q4[4], r0
; CHECK-NEXT:    vmov r0, s9
; CHECK-NEXT:    vmov.16 q4[5], r0
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.16 q4[6], r0
; CHECK-NEXT:    vmov r0, s14
; CHECK-NEXT:    vmov.16 q4[7], r0
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i16>, <4 x i16>* %src, i32 0
  %l1 = load <4 x i16>, <4 x i16>* %s1, align 4
  %s2 = getelementptr <4 x i16>, <4 x i16>* %src, i32 1
  %l2 = load <4 x i16>, <4 x i16>* %s2, align 4
  %s3 = getelementptr <4 x i16>, <4 x i16>* %src, i32 2
  %l3 = load <4 x i16>, <4 x i16>* %s3, align 4
  %t1 = shufflevector <4 x i16> %l1, <4 x i16> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i16> %l3, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i16> %t1, <8 x i16> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i16> %s, <12 x i16> *%dst
  ret void
}

define void @vst3_v8i16(<8 x i16> *%src, <24 x i16> *%dst) {
; CHECK-LABEL: vst3_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vldrw.u32 q4, [r0, #16]
; CHECK-NEXT:    vmov.u16 r2, q1[2]
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    vmov.u16 r2, q2[3]
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov.u16 r2, q1[4]
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov.u16 r2, q2[5]
; CHECK-NEXT:    vmov.16 q0[7], r2
; CHECK-NEXT:    vmov.u16 r2, q2[0]
; CHECK-NEXT:    vmov.16 q3[0], r2
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u16 r0, q4[1]
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov.u16 r0, q2[2]
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vdup.32 q5, r2
; CHECK-NEXT:    vmov.f32 s13, s8
; CHECK-NEXT:    vmov.u16 r2, q5[2]
; CHECK-NEXT:    vmov.u16 r0, q3[3]
; CHECK-NEXT:    vmov.16 q6[2], r2
; CHECK-NEXT:    vmov r2, s11
; CHECK-NEXT:    vmov.16 q6[3], r0
; CHECK-NEXT:    vmov.u16 r0, q3[4]
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vmov.u16 r0, q5[5]
; CHECK-NEXT:    vmov.16 q6[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[5]
; CHECK-NEXT:    vmov.16 q5[1], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov.f32 s13, s25
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q1[7]
; CHECK-NEXT:    vmov.f32 s14, s26
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vdup.32 q6, r2
; CHECK-NEXT:    vmov.f32 s1, s5
; CHECK-NEXT:    vmov.u16 r2, q6[2]
; CHECK-NEXT:    vmov.f32 s22, s7
; CHECK-NEXT:    vrev32.16 q4, q4
; CHECK-NEXT:    vmov.16 q7[2], r2
; CHECK-NEXT:    vmov.u16 r0, q5[3]
; CHECK-NEXT:    vmov.u16 r2, q4[2]
; CHECK-NEXT:    vmov.f32 s2, s10
; CHECK-NEXT:    vmov.16 q7[3], r0
; CHECK-NEXT:    vmov.u16 r0, q5[4]
; CHECK-NEXT:    vstrw.32 q3, [r1]
; CHECK-NEXT:    vmov.16 q3[2], r2
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.16 q7[4], r0
; CHECK-NEXT:    vmov.u16 r0, q6[5]
; CHECK-NEXT:    vmov.16 q3[3], r2
; CHECK-NEXT:    vmov.u16 r2, q0[4]
; CHECK-NEXT:    vmov.16 q7[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov.16 q3[4], r2
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov.f32 s21, s29
; CHECK-NEXT:    vmov.f32 s1, s13
; CHECK-NEXT:    vmov.f32 s22, s30
; CHECK-NEXT:    vmov.f32 s2, s14
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vstrw.32 q0, [r1, #16]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x i16>, <8 x i16>* %src, i32 0
  %l1 = load <8 x i16>, <8 x i16>* %s1, align 4
  %s2 = getelementptr <8 x i16>, <8 x i16>* %src, i32 1
  %l2 = load <8 x i16>, <8 x i16>* %s2, align 4
  %s3 = getelementptr <8 x i16>, <8 x i16>* %src, i32 2
  %l3 = load <8 x i16>, <8 x i16>* %s3, align 4
  %t1 = shufflevector <8 x i16> %l1, <8 x i16> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i16> %l3, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i16> %t1, <16 x i16> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i16> %s, <24 x i16> *%dst
  ret void
}

define void @vst3_v16i16(<16 x i16> *%src, <48 x i16> *%dst) {
; CHECK-LABEL: vst3_v16i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #160
; CHECK-NEXT:    sub sp, #160
; CHECK-NEXT:    vldrw.u32 q0, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #48]
; CHECK-NEXT:    vmov.u16 r2, q0[0]
; CHECK-NEXT:    vstrw.32 q0, [sp, #128] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov.u16 r2, q1[0]
; CHECK-NEXT:    vmov.16 q2[1], r2
; CHECK-NEXT:    vmov.u16 r2, q1[1]
; CHECK-NEXT:    vmov.16 q2[4], r2
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.16 q2[6], r2
; CHECK-NEXT:    vmov.u16 r2, q1[2]
; CHECK-NEXT:    vmov.16 q2[7], r2
; CHECK-NEXT:    vmov q7, q1
; CHECK-NEXT:    vmov.f32 s9, s0
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vmov.u16 r2, q2[3]
; CHECK-NEXT:    vmov q3, q2
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov q1, q0
; CHECK-NEXT:    vdup.32 q0, r3
; CHECK-NEXT:    vstrw.32 q2, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vmov.u16 r3, q0[2]
; CHECK-NEXT:    vstrw.32 q7, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q2[2], r3
; CHECK-NEXT:    vmov.16 q2[3], r2
; CHECK-NEXT:    vmov.u16 r2, q3[4]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #32]
; CHECK-NEXT:    vmov.16 q2[4], r2
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #64]
; CHECK-NEXT:    vmov.16 q2[5], r2
; CHECK-NEXT:    vmov.u16 r2, q3[5]
; CHECK-NEXT:    vmov.16 q5[0], r2
; CHECK-NEXT:    vmov.u16 r2, q0[5]
; CHECK-NEXT:    vmov.16 q5[1], r2
; CHECK-NEXT:    vmov.u16 r2, q3[6]
; CHECK-NEXT:    vmov.16 q5[3], r2
; CHECK-NEXT:    vmov.u16 r2, q3[7]
; CHECK-NEXT:    vmov.16 q5[6], r2
; CHECK-NEXT:    vmov.u16 r2, q0[7]
; CHECK-NEXT:    vmov.16 q5[7], r2
; CHECK-NEXT:    vstrw.32 q0, [sp, #144] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s22, s3
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vstrw.32 q2, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vmov.u16 r2, q5[3]
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vmov q2, q0
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vstrw.32 q2, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov.u16 r0, q0[2]
; CHECK-NEXT:    vmov.16 q4[2], r0
; CHECK-NEXT:    vmov.u16 r0, q5[4]
; CHECK-NEXT:    vmov.16 q4[3], r2
; CHECK-NEXT:    vmov.16 q4[4], r0
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov.16 q4[5], r0
; CHECK-NEXT:    vmov.u16 r0, q2[0]
; CHECK-NEXT:    vmov.16 q6[0], r0
; CHECK-NEXT:    vmov.u16 r0, q3[0]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q6[1], r0
; CHECK-NEXT:    vmov.u16 r0, q3[1]
; CHECK-NEXT:    vstrw.32 q4, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vmov.u16 r0, q2[2]
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmov.16 q6[6], r0
; CHECK-NEXT:    vmov.u16 r0, q3[2]
; CHECK-NEXT:    vdup.32 q0, r2
; CHECK-NEXT:    vmov.16 q6[7], r0
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.f32 s25, s8
; CHECK-NEXT:    vmov.16 q2[2], r2
; CHECK-NEXT:    vmov.u16 r0, q6[3]
; CHECK-NEXT:    vmov q4, q1
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov.u16 r0, q6[4]
; CHECK-NEXT:    vmov.16 q2[4], r0
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov.16 q2[5], r0
; CHECK-NEXT:    vmov.u16 r0, q7[5]
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[5]
; CHECK-NEXT:    vmov.16 q0[1], r0
; CHECK-NEXT:    vmov.u16 r0, q7[6]
; CHECK-NEXT:    vmov.16 q0[3], r0
; CHECK-NEXT:    vmov.u16 r0, q7[7]
; CHECK-NEXT:    vmov.16 q0[6], r0
; CHECK-NEXT:    vmov.u16 r0, q1[7]
; CHECK-NEXT:    vldrw.u32 q1, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q0[7], r0
; CHECK-NEXT:    vmov.f32 s2, s19
; CHECK-NEXT:    vstrw.32 q2, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vmov r2, s7
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vdup.32 q7, r2
; CHECK-NEXT:    vrev32.16 q3, q3
; CHECK-NEXT:    vmov.u16 r2, q7[2]
; CHECK-NEXT:    vstrw.32 q3, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q2[2], r2
; CHECK-NEXT:    vstrw.32 q4, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov.u16 r0, q0[4]
; CHECK-NEXT:    vmov.16 q2[4], r0
; CHECK-NEXT:    vmov.u16 r0, q7[5]
; CHECK-NEXT:    vmov.16 q2[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov.16 q3[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[3]
; CHECK-NEXT:    vmov.16 q3[1], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vldrw.u32 q7, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q3[6], r0
; CHECK-NEXT:    vmov.u16 r0, q1[5]
; CHECK-NEXT:    vldrw.u32 q1, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vldrw.u32 q4, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vrev32.16 q7, q7
; CHECK-NEXT:    vmov.16 q3[7], r0
; CHECK-NEXT:    vmov.u16 r0, q1[2]
; CHECK-NEXT:    vstrw.32 q7, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q7[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov.f32 s1, s9
; CHECK-NEXT:    vmov.16 q7[1], r0
; CHECK-NEXT:    vmov.u16 r0, q1[4]
; CHECK-NEXT:    vldrw.u32 q1, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s2, s10
; CHECK-NEXT:    vldrw.u32 q2, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q7[6], r0
; CHECK-NEXT:    vmov.f32 s25, s5
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov.f32 s26, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q0, [r1, #80]
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vmov.16 q7[7], r0
; CHECK-NEXT:    vmov.f32 s22, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov.f32 s9, s5
; CHECK-NEXT:    vmov.16 q0[2], r2
; CHECK-NEXT:    vmov.f32 s10, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q5, [r1, #32]
; CHECK-NEXT:    vstrw.32 q2, [r1, #48]
; CHECK-NEXT:    vmov.f32 s29, s5
; CHECK-NEXT:    vldrw.u32 q1, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s30, s18
; CHECK-NEXT:    vstrw.32 q6, [r1]
; CHECK-NEXT:    vmov.u16 r2, q7[3]
; CHECK-NEXT:    vmov.f32 s13, s5
; CHECK-NEXT:    vmov.16 q0[3], r2
; CHECK-NEXT:    vmov.u16 r2, q7[4]
; CHECK-NEXT:    vmov.16 q0[4], r2
; CHECK-NEXT:    vldrw.u32 q1, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov.f32 s29, s1
; CHECK-NEXT:    vmov.f32 s30, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s14, s6
; CHECK-NEXT:    vstrw.32 q7, [r1, #16]
; CHECK-NEXT:    vmov.u16 r2, q0[2]
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov.16 q0[2], r2
; CHECK-NEXT:    vmov.u16 r2, q3[3]
; CHECK-NEXT:    vmov.16 q0[3], r2
; CHECK-NEXT:    vmov.u16 r2, q3[4]
; CHECK-NEXT:    vmov.16 q0[4], r2
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov.f32 s13, s1
; CHECK-NEXT:    vmov.f32 s14, s2
; CHECK-NEXT:    vstrw.32 q3, [r1, #64]
; CHECK-NEXT:    add sp, #160
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x i16>, <16 x i16>* %src, i32 0
  %l1 = load <16 x i16>, <16 x i16>* %s1, align 4
  %s2 = getelementptr <16 x i16>, <16 x i16>* %src, i32 1
  %l2 = load <16 x i16>, <16 x i16>* %s2, align 4
  %s3 = getelementptr <16 x i16>, <16 x i16>* %src, i32 2
  %l3 = load <16 x i16>, <16 x i16>* %s3, align 4
  %t1 = shufflevector <16 x i16> %l1, <16 x i16> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i16> %l3, <16 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i16> %t1, <32 x i16> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i16> %s, <48 x i16> *%dst
  ret void
}

; i8

define void @vst3_v2i8(<2 x i8> *%src, <6 x i8> *%dst) {
; CHECK-LABEL: vst3_v2i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    ldrb r2, [r0]
; CHECK-NEXT:    movs r6, #0
; CHECK-NEXT:    ldrb r3, [r0, #1]
; CHECK-NEXT:    vmov.32 q0[0], r2
; CHECK-NEXT:    ldrb.w r12, [r0, #2]
; CHECK-NEXT:    vmov.32 q0[2], r3
; CHECK-NEXT:    ldrb.w lr, [r0, #3]
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    ldrb r5, [r0, #5]
; CHECK-NEXT:    vmov.16 q0[0], r4
; CHECK-NEXT:    ldrb r0, [r0, #4]
; CHECK-NEXT:    vmov.16 q0[1], r12
; CHECK-NEXT:    mov r2, sp
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    add r0, sp, #8
; CHECK-NEXT:    vmov.16 q0[3], r3
; CHECK-NEXT:    vmov.16 q0[4], lr
; CHECK-NEXT:    vmov.16 q0[5], r5
; CHECK-NEXT:    vmov.16 q0[6], r6
; CHECK-NEXT:    vmov.16 q0[7], r6
; CHECK-NEXT:    vstrb.16 q0, [r2]
; CHECK-NEXT:    vstrb.16 q0, [r0]
; CHECK-NEXT:    vldrh.u32 q0, [r0]
; CHECK-NEXT:    ldr r2, [sp]
; CHECK-NEXT:    str r2, [r1]
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    strh r0, [r1, #4]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %s1 = getelementptr <2 x i8>, <2 x i8>* %src, i32 0
  %l1 = load <2 x i8>, <2 x i8>* %s1, align 4
  %s2 = getelementptr <2 x i8>, <2 x i8>* %src, i32 1
  %l2 = load <2 x i8>, <2 x i8>* %s2, align 4
  %s3 = getelementptr <2 x i8>, <2 x i8>* %src, i32 2
  %l3 = load <2 x i8>, <2 x i8>* %s3, align 4
  %t1 = shufflevector <2 x i8> %l1, <2 x i8> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i8> %l3, <2 x i8> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i8> %t1, <4 x i8> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i8> %s, <6 x i8> *%dst
  ret void
}

define void @vst3_v4i8(<4 x i8> *%src, <12 x i8> *%dst) {
; CHECK-LABEL: vst3_v4i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrb.u32 q1, [r0]
; CHECK-NEXT:    vldrb.u32 q2, [r0, #4]
; CHECK-NEXT:    vldrb.u32 q3, [r0, #8]
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    vmov r0, s5
; CHECK-NEXT:    vmov.16 q0[3], r0
; CHECK-NEXT:    vmov r0, s9
; CHECK-NEXT:    vmov.16 q0[4], r0
; CHECK-NEXT:    vmov r0, s13
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.16 q0[6], r0
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    vmov.16 q0[7], r0
; CHECK-NEXT:    vmov r0, s14
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov r0, s11
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov r0, s15
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vstrb.16 q0, [r1]
; CHECK-NEXT:    vmov r0, s18
; CHECK-NEXT:    str r0, [r1, #8]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i8>, <4 x i8>* %src, i32 0
  %l1 = load <4 x i8>, <4 x i8>* %s1, align 4
  %s2 = getelementptr <4 x i8>, <4 x i8>* %src, i32 1
  %l2 = load <4 x i8>, <4 x i8>* %s2, align 4
  %s3 = getelementptr <4 x i8>, <4 x i8>* %src, i32 2
  %l3 = load <4 x i8>, <4 x i8>* %s3, align 4
  %t1 = shufflevector <4 x i8> %l1, <4 x i8> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i8> %l3, <4 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i8> %t1, <8 x i8> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i8> %s, <12 x i8> *%dst
  ret void
}

define void @vst3_v8i8(<8 x i8> *%src, <24 x i8> *%dst) {
; CHECK-LABEL: vst3_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vldrb.u16 q1, [r0, #8]
; CHECK-NEXT:    vldrb.u16 q2, [r0, #16]
; CHECK-NEXT:    vldrb.u16 q3, [r0]
; CHECK-NEXT:    vmov.u16 r2, q1[5]
; CHECK-NEXT:    vmov.16 q0[0], r2
; CHECK-NEXT:    vmov.u16 r2, q2[5]
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov.u16 r2, q1[6]
; CHECK-NEXT:    vmov.16 q0[3], r2
; CHECK-NEXT:    vmov.u16 r2, q1[7]
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov.u16 r2, q2[7]
; CHECK-NEXT:    vmov r0, s15
; CHECK-NEXT:    vmov.16 q0[7], r2
; CHECK-NEXT:    vdup.32 q4, r0
; CHECK-NEXT:    vmov.f32 s2, s11
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov.u16 r2, q0[3]
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q0[4]
; CHECK-NEXT:    vmov.16 q5[3], r2
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q3[0]
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u16 r0, q2[0]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u16 r0, q3[1]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u16 r0, q1[1]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u16 r0, q2[1]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u16 r0, q3[2]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u16 r0, q1[2]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u16 r0, q2[2]
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov.u16 r0, q3[3]
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov.u16 r0, q1[3]
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov.u16 r0, q2[3]
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vmov.u16 r0, q3[4]
; CHECK-NEXT:    vmov.8 q4[12], r0
; CHECK-NEXT:    vmov.u16 r0, q1[4]
; CHECK-NEXT:    vmov.8 q4[13], r0
; CHECK-NEXT:    vmov.u16 r0, q2[4]
; CHECK-NEXT:    vmov.f32 s1, s21
; CHECK-NEXT:    vmov.8 q4[14], r0
; CHECK-NEXT:    vmov.u16 r0, q3[5]
; CHECK-NEXT:    vmov.f32 s2, s22
; CHECK-NEXT:    vmov.8 q4[15], r0
; CHECK-NEXT:    vstrb.16 q0, [r1, #16]
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x i8>, <8 x i8>* %src, i32 0
  %l1 = load <8 x i8>, <8 x i8>* %s1, align 4
  %s2 = getelementptr <8 x i8>, <8 x i8>* %src, i32 1
  %l2 = load <8 x i8>, <8 x i8>* %s2, align 4
  %s3 = getelementptr <8 x i8>, <8 x i8>* %src, i32 2
  %l3 = load <8 x i8>, <8 x i8>* %s3, align 4
  %t1 = shufflevector <8 x i8> %l1, <8 x i8> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x i8> %l3, <8 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x i8> %t1, <16 x i8> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i8> %s, <24 x i8> *%dst
  ret void
}

define void @vst3_v16i8(<16 x i8> *%src, <48 x i8> *%dst) {
; CHECK-LABEL: vst3_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vmov.u8 r3, q3[0]
; CHECK-NEXT:    vmov.u8 r0, q2[0]
; CHECK-NEXT:    vmov.8 q5[0], r3
; CHECK-NEXT:    vmov.u8 r2, q1[0]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q3[1]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q2[1]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q3[2]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[2]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q3[3]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[3]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q3[4]
; CHECK-NEXT:    vmov.8 q4[2], r2
; CHECK-NEXT:    vmov.u8 r2, q1[2]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q2[4]
; CHECK-NEXT:    vmov.8 q4[8], r2
; CHECK-NEXT:    vmov.u8 r2, q1[3]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[5]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vmov.8 q4[11], r2
; CHECK-NEXT:    vmov.u8 r2, q1[4]
; CHECK-NEXT:    vmov.u8 r0, q5[0]
; CHECK-NEXT:    vmov.8 q4[14], r2
; CHECK-NEXT:    vmov.8 q0[0], r0
; CHECK-NEXT:    vmov.f32 s17, s4
; CHECK-NEXT:    vmov.u8 r0, q5[1]
; CHECK-NEXT:    vmov.8 q0[1], r0
; CHECK-NEXT:    vmov.u8 r2, q4[2]
; CHECK-NEXT:    vmov.8 q0[2], r2
; CHECK-NEXT:    vmov.u8 r0, q5[3]
; CHECK-NEXT:    vmov.8 q0[3], r0
; CHECK-NEXT:    vmov.u8 r0, q5[4]
; CHECK-NEXT:    vmov.8 q0[4], r0
; CHECK-NEXT:    vmov.u8 r0, q4[5]
; CHECK-NEXT:    vmov.8 q0[5], r0
; CHECK-NEXT:    vmov.u8 r0, q5[6]
; CHECK-NEXT:    vmov.8 q0[6], r0
; CHECK-NEXT:    vmov.u8 r0, q5[7]
; CHECK-NEXT:    vmov.8 q0[7], r0
; CHECK-NEXT:    vmov.u8 r0, q4[8]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u8 r0, q5[9]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u8 r0, q5[10]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u8 r0, q4[11]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u8 r0, q5[12]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u8 r0, q5[13]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u8 r0, q4[14]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u8 r0, q5[15]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    vmov.u8 r0, q2[5]
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q2[6]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q2[7]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q2[8]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[9]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q2[10]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vmov.u8 r0, q5[0]
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q5[1]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q3[7]
; CHECK-NEXT:    vmov.8 q6[5], r0
; CHECK-NEXT:    vmov.u8 r0, q3[8]
; CHECK-NEXT:    vmov.8 q6[8], r0
; CHECK-NEXT:    vmov.u8 r0, q3[9]
; CHECK-NEXT:    vmov.8 q6[11], r0
; CHECK-NEXT:    vmov.f32 s24, s13
; CHECK-NEXT:    vmov.f32 s27, s14
; CHECK-NEXT:    vmov.u8 r0, q6[2]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q5[3]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q5[4]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q6[5]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q5[6]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q5[7]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u8 r0, q6[8]
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov.u8 r0, q5[9]
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov.u8 r0, q5[10]
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov.u8 r0, q6[11]
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vmov.u8 r0, q5[12]
; CHECK-NEXT:    vmov.8 q4[12], r0
; CHECK-NEXT:    vmov.u8 r0, q5[13]
; CHECK-NEXT:    vmov.8 q4[13], r0
; CHECK-NEXT:    vmov.u8 r0, q6[14]
; CHECK-NEXT:    vmov.8 q4[14], r0
; CHECK-NEXT:    vmov.u8 r0, q5[15]
; CHECK-NEXT:    vmov.8 q4[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q3[11]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q3[12]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q3[13]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q3[14]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q3[15]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.u8 r0, q5[0]
; CHECK-NEXT:    vmov.8 q1[0], r0
; CHECK-NEXT:    vmov.u8 r0, q5[1]
; CHECK-NEXT:    vmov.8 q1[1], r0
; CHECK-NEXT:    vmov.u8 r0, q2[11]
; CHECK-NEXT:    vmov.8 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q2[12]
; CHECK-NEXT:    vmov.8 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q2[13]
; CHECK-NEXT:    vmov.8 q3[8], r0
; CHECK-NEXT:    vmov.u8 r0, q2[14]
; CHECK-NEXT:    vmov.8 q3[11], r0
; CHECK-NEXT:    vmov.u8 r0, q2[15]
; CHECK-NEXT:    vmov.8 q3[14], r0
; CHECK-NEXT:    vmov.u8 r0, q3[2]
; CHECK-NEXT:    vmov.8 q1[2], r0
; CHECK-NEXT:    vmov.u8 r0, q5[3]
; CHECK-NEXT:    vmov.8 q1[3], r0
; CHECK-NEXT:    vmov.u8 r0, q5[4]
; CHECK-NEXT:    vmov.8 q1[4], r0
; CHECK-NEXT:    vmov.u8 r0, q3[5]
; CHECK-NEXT:    vmov.8 q1[5], r0
; CHECK-NEXT:    vmov.u8 r0, q5[6]
; CHECK-NEXT:    vmov.8 q1[6], r0
; CHECK-NEXT:    vmov.u8 r0, q5[7]
; CHECK-NEXT:    vmov.8 q1[7], r0
; CHECK-NEXT:    vmov.u8 r0, q3[8]
; CHECK-NEXT:    vmov.8 q1[8], r0
; CHECK-NEXT:    vmov.u8 r0, q5[9]
; CHECK-NEXT:    vmov.8 q1[9], r0
; CHECK-NEXT:    vmov.u8 r0, q5[10]
; CHECK-NEXT:    vmov.8 q1[10], r0
; CHECK-NEXT:    vmov.u8 r0, q3[11]
; CHECK-NEXT:    vmov.8 q1[11], r0
; CHECK-NEXT:    vmov.u8 r0, q5[12]
; CHECK-NEXT:    vmov.8 q1[12], r0
; CHECK-NEXT:    vmov.u8 r0, q5[13]
; CHECK-NEXT:    vmov.8 q1[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[14]
; CHECK-NEXT:    vmov.8 q1[14], r0
; CHECK-NEXT:    vmov.u8 r0, q5[15]
; CHECK-NEXT:    vmov.8 q1[15], r0
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x i8>, <16 x i8>* %src, i32 0
  %l1 = load <16 x i8>, <16 x i8>* %s1, align 4
  %s2 = getelementptr <16 x i8>, <16 x i8>* %src, i32 1
  %l2 = load <16 x i8>, <16 x i8>* %s2, align 4
  %s3 = getelementptr <16 x i8>, <16 x i8>* %src, i32 2
  %l3 = load <16 x i8>, <16 x i8>* %s3, align 4
  %t1 = shufflevector <16 x i8> %l1, <16 x i8> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x i8> %l3, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x i8> %t1, <32 x i8> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i8> %s, <48 x i8> *%dst
  ret void
}

; i64

define void @vst3_v2i64(<2 x i64> *%src, <6 x i64> *%dst) {
; CHECK-LABEL: vst3_v2i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vmov.f64 d6, d5
; CHECK-NEXT:    vmov.f32 s13, s11
; CHECK-NEXT:    vmov.f32 s14, s2
; CHECK-NEXT:    vmov.f32 s15, s3
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vmov.f32 s3, s7
; CHECK-NEXT:    vmov.f32 s6, s8
; CHECK-NEXT:    vmov.f32 s7, s9
; CHECK-NEXT:    vstrb.8 q1, [r1], #32
; CHECK-NEXT:    vstrw.32 q3, [r1]
; CHECK-NEXT:    vstrw.32 q0, [r1, #-16]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x i64>, <2 x i64>* %src, i32 0
  %l1 = load <2 x i64>, <2 x i64>* %s1, align 4
  %s2 = getelementptr <2 x i64>, <2 x i64>* %src, i32 1
  %l2 = load <2 x i64>, <2 x i64>* %s2, align 4
  %s3 = getelementptr <2 x i64>, <2 x i64>* %src, i32 2
  %l3 = load <2 x i64>, <2 x i64>* %s3, align 4
  %t1 = shufflevector <2 x i64> %l1, <2 x i64> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x i64> %l3, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x i64> %t1, <4 x i64> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i64> %s, <6 x i64> *%dst
  ret void
}

define void @vst3_v4i64(<4 x i64> *%src, <12 x i64> *%dst) {
; CHECK-LABEL: vst3_v4i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vmov.f64 d10, d2
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #64]
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vmov.f32 s22, s28
; CHECK-NEXT:    vmov.f32 s23, s29
; CHECK-NEXT:    vmov.f64 d14, d12
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f32 s29, s25
; CHECK-NEXT:    vmov.f64 d8, d7
; CHECK-NEXT:    vmov.f32 s30, s12
; CHECK-NEXT:    vmov.f32 s17, s15
; CHECK-NEXT:    vmov.f32 s31, s13
; CHECK-NEXT:    vldrw.u32 q3, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vstrw.32 q7, [r1, #48]
; CHECK-NEXT:    vmov.f32 s4, s8
; CHECK-NEXT:    vmov.f32 s19, s3
; CHECK-NEXT:    vmov.f32 s2, s26
; CHECK-NEXT:    vstrw.32 q4, [r1, #80]
; CHECK-NEXT:    vmov.f32 s5, s9
; CHECK-NEXT:    vmov.f32 s8, s14
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.f32 s3, s27
; CHECK-NEXT:    vmov.f32 s9, s15
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vstrw.32 q2, [r1, #32]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x i64>, <4 x i64>* %src, i32 0
  %l1 = load <4 x i64>, <4 x i64>* %s1, align 4
  %s2 = getelementptr <4 x i64>, <4 x i64>* %src, i32 1
  %l2 = load <4 x i64>, <4 x i64>* %s2, align 4
  %s3 = getelementptr <4 x i64>, <4 x i64>* %src, i32 2
  %l3 = load <4 x i64>, <4 x i64>* %s3, align 4
  %t1 = shufflevector <4 x i64> %l1, <4 x i64> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x i64> %l3, <4 x i64> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x i64> %t1, <8 x i64> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i64> %s, <12 x i64> *%dst
  ret void
}

; f32

define void @vst3_v2f32(<2 x float> *%src, <6 x float> *%dst) {
; CHECK-LABEL: vst3_v2f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldr s0, [r0]
; CHECK-NEXT:    vldr s3, [r0, #4]
; CHECK-NEXT:    vldr s1, [r0, #8]
; CHECK-NEXT:    ldr r2, [r0, #20]
; CHECK-NEXT:    vldr s2, [r0, #16]
; CHECK-NEXT:    ldr r0, [r0, #12]
; CHECK-NEXT:    strd r0, r2, [r1, #16]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x float>, <2 x float>* %src, i32 0
  %l1 = load <2 x float>, <2 x float>* %s1, align 4
  %s2 = getelementptr <2 x float>, <2 x float>* %src, i32 1
  %l2 = load <2 x float>, <2 x float>* %s2, align 4
  %s3 = getelementptr <2 x float>, <2 x float>* %src, i32 2
  %l3 = load <2 x float>, <2 x float>* %s3, align 4
  %t1 = shufflevector <2 x float> %l1, <2 x float> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x float> %l3, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x float> %t1, <4 x float> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x float> %s, <6 x float> *%dst
  ret void
}

define void @vst3_v4f32(<4 x float> *%src, <12 x float> *%dst) {
; CHECK-LABEL: vst3_v4f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vldrw.u32 q3, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #32]
; CHECK-NEXT:    vmov.f64 d8, d6
; CHECK-NEXT:    vmov.f32 s17, s4
; CHECK-NEXT:    vmov.f32 s8, s5
; CHECK-NEXT:    vmov.f32 s19, s13
; CHECK-NEXT:    vmov.f32 s9, s1
; CHECK-NEXT:    vmov.f32 s18, s0
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vstrw.32 q4, [r1]
; CHECK-NEXT:    vmov.f32 s11, s6
; CHECK-NEXT:    vmov.f32 s1, s15
; CHECK-NEXT:    vmov.f32 s10, s14
; CHECK-NEXT:    vmov.f32 s2, s7
; CHECK-NEXT:    vstrw.32 q2, [r1, #16]
; CHECK-NEXT:    vstrw.32 q0, [r1, #32]
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x float>, <4 x float>* %src, i32 0
  %l1 = load <4 x float>, <4 x float>* %s1, align 4
  %s2 = getelementptr <4 x float>, <4 x float>* %src, i32 1
  %l2 = load <4 x float>, <4 x float>* %s2, align 4
  %s3 = getelementptr <4 x float>, <4 x float>* %src, i32 2
  %l3 = load <4 x float>, <4 x float>* %s3, align 4
  %t1 = shufflevector <4 x float> %l1, <4 x float> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x float> %l3, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x float> %t1, <8 x float> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x float> %s, <12 x float> *%dst
  ret void
}

define void @vst3_v8f32(<8 x float> *%src, <24 x float> *%dst) {
; CHECK-LABEL: vst3_v8f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vldrw.u32 q4, [r0]
; CHECK-NEXT:    vldrw.u32 q7, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vmov.f64 d10, d8
; CHECK-NEXT:    vldrw.u32 q3, [r0, #48]
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [r0, #64]
; CHECK-NEXT:    vmov.f32 s21, s28
; CHECK-NEXT:    vmov.f64 d14, d12
; CHECK-NEXT:    vmov.f64 d4, d1
; CHECK-NEXT:    vmov.f32 s29, s12
; CHECK-NEXT:    vmov.f32 s9, s27
; CHECK-NEXT:    vmov.f32 s31, s25
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov.f32 s30, s0
; CHECK-NEXT:    vmov.f32 s0, s13
; CHECK-NEXT:    vstrw.32 q7, [r1, #48]
; CHECK-NEXT:    vmov.f32 s3, s14
; CHECK-NEXT:    vmov.f32 s2, s26
; CHECK-NEXT:    vldrw.u32 q6, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s10, s15
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vmov.f32 s23, s17
; CHECK-NEXT:    vstrw.32 q2, [r1, #80]
; CHECK-NEXT:    vmov.f32 s12, s25
; CHECK-NEXT:    vmov.f32 s13, s5
; CHECK-NEXT:    vmov.f32 s22, s4
; CHECK-NEXT:    vmov.f32 s4, s6
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f32 s15, s26
; CHECK-NEXT:    vmov.f32 s5, s19
; CHECK-NEXT:    vmov.f32 s14, s18
; CHECK-NEXT:    vmov.f32 s6, s27
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x float>, <8 x float>* %src, i32 0
  %l1 = load <8 x float>, <8 x float>* %s1, align 4
  %s2 = getelementptr <8 x float>, <8 x float>* %src, i32 1
  %l2 = load <8 x float>, <8 x float>* %s2, align 4
  %s3 = getelementptr <8 x float>, <8 x float>* %src, i32 2
  %l3 = load <8 x float>, <8 x float>* %s3, align 4
  %t1 = shufflevector <8 x float> %l1, <8 x float> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x float> %l3, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x float> %t1, <16 x float> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x float> %s, <24 x float> *%dst
  ret void
}

define void @vst3_v16f32(<16 x float> *%src, <48 x float> *%dst) {
; CHECK-LABEL: vst3_v16f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #160
; CHECK-NEXT:    sub sp, #160
; CHECK-NEXT:    vldrw.u32 q5, [r0, #96]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #64]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #128]
; CHECK-NEXT:    vldrw.u32 q6, [r0]
; CHECK-NEXT:    vstrw.32 q5, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q5, [r0, #80]
; CHECK-NEXT:    vmov.f32 s16, s1
; CHECK-NEXT:    vldrw.u32 q3, [r0, #160]
; CHECK-NEXT:    vstrw.32 q5, [sp, #144] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q5, [r0, #48]
; CHECK-NEXT:    vmov.f32 s17, s5
; CHECK-NEXT:    vstrw.32 q3, [sp, #128] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s19, s2
; CHECK-NEXT:    vstrw.32 q5, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vmov.f32 s18, s26
; CHECK-NEXT:    vldrw.u32 q7, [r0, #144]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #176]
; CHECK-NEXT:    vstrw.32 q5, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q5, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q3, [r0, #112]
; CHECK-NEXT:    vstrw.32 q4, [r1, #16]
; CHECK-NEXT:    vmov.f64 d8, d3
; CHECK-NEXT:    vstrw.32 q5, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q5, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q7, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s17, s27
; CHECK-NEXT:    vmov.f32 s19, s7
; CHECK-NEXT:    vmov.f32 s18, s3
; CHECK-NEXT:    vstrw.32 q4, [r1, #32]
; CHECK-NEXT:    vmov.f64 d8, d5
; CHECK-NEXT:    vmov.f32 s17, s23
; CHECK-NEXT:    vmov.f32 s19, s11
; CHECK-NEXT:    vmov.f32 s18, s15
; CHECK-NEXT:    vstrw.32 q4, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d8, d12
; CHECK-NEXT:    vmov.f32 s17, s0
; CHECK-NEXT:    vmov.f32 s19, s25
; CHECK-NEXT:    vmov.f32 s18, s4
; CHECK-NEXT:    vmov q1, q5
; CHECK-NEXT:    vmov.f64 d0, d2
; CHECK-NEXT:    vstrw.32 q4, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s1, s12
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s8, s13
; CHECK-NEXT:    vstrw.32 q0, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s11, s14
; CHECK-NEXT:    vldrw.u32 q0, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s10, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q2, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov.f64 d8, d1
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vmov.f32 s20, s5
; CHECK-NEXT:    vmov.f32 s21, s1
; CHECK-NEXT:    vmov.f32 s23, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vmov q6, q1
; CHECK-NEXT:    vmov.f32 s17, s7
; CHECK-NEXT:    vmov.f32 s22, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s19, s3
; CHECK-NEXT:    vmov q0, q6
; CHECK-NEXT:    vmov.f32 s13, s7
; CHECK-NEXT:    vstrw.32 q5, [r1, #112]
; CHECK-NEXT:    vmov.f32 s15, s31
; CHECK-NEXT:    vldrw.u32 q7, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s11
; CHECK-NEXT:    vldrw.u32 q2, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s25, s28
; CHECK-NEXT:    vldrw.u32 q7, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s27, s1
; CHECK-NEXT:    vldrw.u32 q0, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s14, s11
; CHECK-NEXT:    vstrw.32 q4, [r1, #128]
; CHECK-NEXT:    vmov.f32 s26, s0
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f64 d0, d2
; CHECK-NEXT:    vstrw.32 q6, [r1, #96]
; CHECK-NEXT:    vmov.f32 s1, s8
; CHECK-NEXT:    vmov q2, q1
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    vldrw.u32 q1, [sp, #144] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s2, s28
; CHECK-NEXT:    vstrw.32 q0, [r1, #48]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s28, s5
; CHECK-NEXT:    vstrw.32 q0, [r1, #144]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s31, s6
; CHECK-NEXT:    vstrw.32 q0, [r1, #160]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s30, s10
; CHECK-NEXT:    vstrw.32 q0, [r1, #176]
; CHECK-NEXT:    vldrw.u32 q0, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q7, [r1, #64]
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    add sp, #160
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x float>, <16 x float>* %src, i32 0
  %l1 = load <16 x float>, <16 x float>* %s1, align 4
  %s2 = getelementptr <16 x float>, <16 x float>* %src, i32 1
  %l2 = load <16 x float>, <16 x float>* %s2, align 4
  %s3 = getelementptr <16 x float>, <16 x float>* %src, i32 2
  %l3 = load <16 x float>, <16 x float>* %s3, align 4
  %t1 = shufflevector <16 x float> %l1, <16 x float> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x float> %l3, <16 x float> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x float> %t1, <32 x float> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x float> %s, <48 x float> *%dst
  ret void
}

; f16

define void @vst3_v2f16(<2 x half> *%src, <6 x half> *%dst) {
; CHECK-LABEL: vst3_v2f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldmia r0, {s4, s5}
; CHECK-NEXT:    vmov r2, s5
; CHECK-NEXT:    ldr r0, [r0, #8]
; CHECK-NEXT:    vmov r3, s4
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vmov.16 q0[0], r3
; CHECK-NEXT:    vmov.32 q2[0], r0
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s4, s5
; CHECK-NEXT:    vmov.16 q0[3], r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmovx.f16 s4, s8
; CHECK-NEXT:    vmov.16 q0[4], r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    vmov r3, s2
; CHECK-NEXT:    stm r1!, {r0, r2, r3}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x half>, <2 x half>* %src, i32 0
  %l1 = load <2 x half>, <2 x half>* %s1, align 4
  %s2 = getelementptr <2 x half>, <2 x half>* %src, i32 1
  %l2 = load <2 x half>, <2 x half>* %s2, align 4
  %s3 = getelementptr <2 x half>, <2 x half>* %src, i32 2
  %l3 = load <2 x half>, <2 x half>* %s3, align 4
  %t1 = shufflevector <2 x half> %l1, <2 x half> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x half> %l3, <2 x half> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x half> %t1, <4 x half> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x half> %s, <6 x half> *%dst
  ret void
}

define void @vst3_v4f16(<4 x half> *%src, <12 x half> *%dst) {
; CHECK-LABEL: vst3_v4f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    ldm.w r0, {r2, r3, r12, lr}
; CHECK-NEXT:    vmov.32 q0[0], r2
; CHECK-NEXT:    vmov.32 q0[1], r3
; CHECK-NEXT:    vmov.32 q0[2], r12
; CHECK-NEXT:    vmov.32 q0[3], lr
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmovx.f16 s12, s0
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov.16 q2[0], r3
; CHECK-NEXT:    vmov.16 q2[1], r2
; CHECK-NEXT:    ldrd r2, r0, [r0, #16]
; CHECK-NEXT:    vmovx.f16 s0, s3
; CHECK-NEXT:    vmov.32 q1[0], r2
; CHECK-NEXT:    vmov.32 q1[1], r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.16 q2[2], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s12, s2
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vmov.16 q2[4], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmov.16 q2[5], r0
; CHECK-NEXT:    vmov r0, s1
; CHECK-NEXT:    vmov.16 q2[6], r0
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vmov.16 q2[7], r0
; CHECK-NEXT:    vmov r2, s5
; CHECK-NEXT:    vstrw.32 q2, [r1]
; CHECK-NEXT:    vmovx.f16 s8, s1
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov.16 q2[1], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmovx.f16 s0, s5
; CHECK-NEXT:    vmov.16 q2[2], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov r0, s9
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    strd r2, r0, [r1, #16]
; CHECK-NEXT:    pop {r7, pc}
entry:
  %s1 = getelementptr <4 x half>, <4 x half>* %src, i32 0
  %l1 = load <4 x half>, <4 x half>* %s1, align 4
  %s2 = getelementptr <4 x half>, <4 x half>* %src, i32 1
  %l2 = load <4 x half>, <4 x half>* %s2, align 4
  %s3 = getelementptr <4 x half>, <4 x half>* %src, i32 2
  %l3 = load <4 x half>, <4 x half>* %s3, align 4
  %t1 = shufflevector <4 x half> %l1, <4 x half> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x half> %l3, <4 x half> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x half> %t1, <8 x half> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x half> %s, <12 x half> *%dst
  ret void
}

define void @vst3_v8f16(<8 x half> *%src, <24 x half> *%dst) {
; CHECK-LABEL: vst3_v8f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vldrw.u32 q2, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r0, #16]
; CHECK-NEXT:    vldrw.u32 q5, [r0, #32]
; CHECK-NEXT:    vmov r3, s8
; CHECK-NEXT:    vmovx.f16 s12, s4
; CHECK-NEXT:    vmov r2, s4
; CHECK-NEXT:    vmov.16 q0[0], r3
; CHECK-NEXT:    vmov.16 q0[1], r2
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    vmov r0, s20
; CHECK-NEXT:    vmov.16 q0[4], r2
; CHECK-NEXT:    vdup.32 q4, r0
; CHECK-NEXT:    vmov r2, s9
; CHECK-NEXT:    vmov.16 q0[6], r2
; CHECK-NEXT:    vmov r2, s5
; CHECK-NEXT:    vmovx.f16 s12, s8
; CHECK-NEXT:    vmov r0, s17
; CHECK-NEXT:    vmov.16 q0[7], r2
; CHECK-NEXT:    vmov r2, s12
; CHECK-NEXT:    vmov.16 q3[2], r0
; CHECK-NEXT:    vmov.f32 s1, s8
; CHECK-NEXT:    vmov.16 q3[3], r2
; CHECK-NEXT:    vmov r0, s2
; CHECK-NEXT:    vmovx.f16 s16, s18
; CHECK-NEXT:    vmov.16 q3[4], r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmovx.f16 s16, s22
; CHECK-NEXT:    vmov.16 q3[5], r0
; CHECK-NEXT:    vmov r0, s16
; CHECK-NEXT:    vmovx.f16 s16, s6
; CHECK-NEXT:    vmovx.f16 s24, s7
; CHECK-NEXT:    vmov r2, s16
; CHECK-NEXT:    vstrw.32 q1, [sp] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q4[0], r2
; CHECK-NEXT:    vmov r2, s11
; CHECK-NEXT:    vmov.16 q4[1], r0
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov.16 q4[3], r0
; CHECK-NEXT:    vmov r0, s24
; CHECK-NEXT:    vmovx.f16 s24, s23
; CHECK-NEXT:    vmov.16 q4[6], r0
; CHECK-NEXT:    vmov r0, s24
; CHECK-NEXT:    vdup.32 q7, r2
; CHECK-NEXT:    vmov.16 q4[7], r0
; CHECK-NEXT:    vmov r2, s29
; CHECK-NEXT:    vmov.f32 s18, s23
; CHECK-NEXT:    vmovx.f16 s24, s17
; CHECK-NEXT:    vmov r0, s24
; CHECK-NEXT:    vmov.16 q6[2], r2
; CHECK-NEXT:    vmov.16 q6[3], r0
; CHECK-NEXT:    vmovx.f16 s28, s30
; CHECK-NEXT:    vmovx.f16 s4, s10
; CHECK-NEXT:    vmov.f32 s1, s13
; CHECK-NEXT:    vmov.f32 s2, s14
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vmov r0, s18
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vmov r0, s28
; CHECK-NEXT:    vmov.16 q6[5], r0
; CHECK-NEXT:    vmovx.f16 s28, s9
; CHECK-NEXT:    vmov r0, s21
; CHECK-NEXT:    vmov r2, s28
; CHECK-NEXT:    vmov.16 q7[0], r0
; CHECK-NEXT:    vmov.16 q7[1], r2
; CHECK-NEXT:    vmov r0, s22
; CHECK-NEXT:    vmov.16 q7[6], r0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.16 q7[7], r0
; CHECK-NEXT:    vmov.f32 s17, s25
; CHECK-NEXT:    vmov.f32 s29, s21
; CHECK-NEXT:    vmov.f32 s30, s10
; CHECK-NEXT:    vmovx.f16 s4, s29
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vldrw.u32 q1, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s26
; CHECK-NEXT:    vrev32.16 q2, q1
; CHECK-NEXT:    vstrw.32 q4, [r1, #32]
; CHECK-NEXT:    vmov r2, s9
; CHECK-NEXT:    vmovx.f16 s8, s10
; CHECK-NEXT:    vmov.16 q1[2], r2
; CHECK-NEXT:    vmov.16 q1[3], r0
; CHECK-NEXT:    vmov r0, s30
; CHECK-NEXT:    vmov.16 q1[4], r0
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[5], r0
; CHECK-NEXT:    vmov.f32 s29, s5
; CHECK-NEXT:    vmov.f32 s30, s6
; CHECK-NEXT:    vstrw.32 q7, [r1, #16]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <8 x half>, <8 x half>* %src, i32 0
  %l1 = load <8 x half>, <8 x half>* %s1, align 4
  %s2 = getelementptr <8 x half>, <8 x half>* %src, i32 1
  %l2 = load <8 x half>, <8 x half>* %s2, align 4
  %s3 = getelementptr <8 x half>, <8 x half>* %src, i32 2
  %l3 = load <8 x half>, <8 x half>* %s3, align 4
  %t1 = shufflevector <8 x half> %l1, <8 x half> %l2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %t2 = shufflevector <8 x half> %l3, <8 x half> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <16 x half> %t1, <16 x half> %t2, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x half> %s, <24 x half> *%dst
  ret void
}

define void @vst3_v16f16(<16 x half> *%src, <48 x half> *%dst) {
; CHECK-LABEL: vst3_v16f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #144
; CHECK-NEXT:    sub sp, #144
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #32]
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov q3, q0
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    vmov.16 q1[0], r3
; CHECK-NEXT:    vmovx.f16 s0, s8
; CHECK-NEXT:    vmov.16 q1[1], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s12
; CHECK-NEXT:    vmov.16 q1[4], r2
; CHECK-NEXT:    vmov r2, s13
; CHECK-NEXT:    vmov.16 q1[6], r2
; CHECK-NEXT:    vmov r2, s9
; CHECK-NEXT:    vmov.16 q1[7], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vldrw.u32 q0, [r0, #64]
; CHECK-NEXT:    vmov.f32 s5, s12
; CHECK-NEXT:    vmov q5, q3
; CHECK-NEXT:    vstrw.32 q3, [sp, #32] @ 16-byte Spill
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vdup.32 q0, r3
; CHECK-NEXT:    vstrw.32 q1, [sp, #128] @ 16-byte Spill
; CHECK-NEXT:    vmov r3, s1
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.16 q3[2], r3
; CHECK-NEXT:    vstrw.32 q2, [sp, #80] @ 16-byte Spill
; CHECK-NEXT:    vmov.16 q3[3], r2
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.16 q3[4], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s18
; CHECK-NEXT:    vmov.16 q3[5], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s10
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmovx.f16 s0, s11
; CHECK-NEXT:    vmov.16 q1[0], r3
; CHECK-NEXT:    vmov r3, s23
; CHECK-NEXT:    vmov.16 q1[1], r2
; CHECK-NEXT:    vmov r2, s11
; CHECK-NEXT:    vmov.16 q1[3], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s19
; CHECK-NEXT:    vmov.16 q1[6], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vldrw.u32 q5, [r0, #16]
; CHECK-NEXT:    vmov.16 q1[7], r2
; CHECK-NEXT:    vstrw.32 q3, [sp, #112] @ 16-byte Spill
; CHECK-NEXT:    vmov.f32 s6, s19
; CHECK-NEXT:    vmovx.f16 s0, s5
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vdup.32 q0, r3
; CHECK-NEXT:    vmov r3, s1
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.16 q2[2], r3
; CHECK-NEXT:    vmov r3, s20
; CHECK-NEXT:    vmov.16 q2[3], r2
; CHECK-NEXT:    vmov.16 q7[0], r3
; CHECK-NEXT:    vldrw.u32 q3, [r0, #80]
; CHECK-NEXT:    vstrw.32 q1, [sp, #96] @ 16-byte Spill
; CHECK-NEXT:    vstrw.32 q4, [sp, #48] @ 16-byte Spill
; CHECK-NEXT:    vmov r2, s6
; CHECK-NEXT:    vmov.16 q2[4], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmov.16 q2[5], r2
; CHECK-NEXT:    vstrw.32 q2, [sp, #64] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q2, [r0, #48]
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vmov r2, s8
; CHECK-NEXT:    vmovx.f16 s0, s8
; CHECK-NEXT:    vmov.16 q7[1], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmov.16 q7[4], r2
; CHECK-NEXT:    vmov r2, s21
; CHECK-NEXT:    vmov.16 q7[6], r2
; CHECK-NEXT:    vmov r2, s9
; CHECK-NEXT:    vmovx.f16 s0, s20
; CHECK-NEXT:    vmov.16 q7[7], r2
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vdup.32 q0, r0
; CHECK-NEXT:    vmov r0, s1
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.16 q1[2], r0
; CHECK-NEXT:    vmov.f32 s29, s20
; CHECK-NEXT:    vmov.16 q1[3], r2
; CHECK-NEXT:    vmov r0, s30
; CHECK-NEXT:    vmov.16 q1[4], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q1[5], r0
; CHECK-NEXT:    vmovx.f16 s0, s14
; CHECK-NEXT:    vstrw.32 q1, [sp, #16] @ 16-byte Spill
; CHECK-NEXT:    vmov q1, q2
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmovx.f16 s0, s6
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s7
; CHECK-NEXT:    vmov.16 q2[0], r2
; CHECK-NEXT:    vmov r2, s23
; CHECK-NEXT:    vmov.16 q2[1], r0
; CHECK-NEXT:    vmov r0, s7
; CHECK-NEXT:    vmov.16 q2[3], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmovx.f16 s0, s15
; CHECK-NEXT:    vmov.16 q2[6], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q2[7], r0
; CHECK-NEXT:    vmov.f32 s10, s15
; CHECK-NEXT:    vmovx.f16 s0, s9
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vdup.32 q0, r2
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.16 q6[2], r2
; CHECK-NEXT:    vmov.16 q6[3], r0
; CHECK-NEXT:    vmov r0, s10
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[5], r0
; CHECK-NEXT:    vmov r0, s13
; CHECK-NEXT:    vmovx.f16 s0, s21
; CHECK-NEXT:    vmov.16 q4[0], r0
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s22
; CHECK-NEXT:    vmov.16 q4[1], r2
; CHECK-NEXT:    vmov r0, s14
; CHECK-NEXT:    vmov.16 q4[6], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q4[7], r0
; CHECK-NEXT:    vmov.f32 s9, s25
; CHECK-NEXT:    vmov.f32 s17, s13
; CHECK-NEXT:    vldrw.u32 q3, [sp, #32] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s18, s22
; CHECK-NEXT:    vmovx.f16 s0, s17
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vrev32.16 q0, q1
; CHECK-NEXT:    vmov r2, s1
; CHECK-NEXT:    vmovx.f16 s0, s2
; CHECK-NEXT:    vmov.16 q1[2], r2
; CHECK-NEXT:    vmov.f32 s10, s26
; CHECK-NEXT:    vmov.16 q1[3], r0
; CHECK-NEXT:    vldrw.u32 q6, [sp, #112] @ 16-byte Reload
; CHECK-NEXT:    vstrw.32 q2, [r1, #80]
; CHECK-NEXT:    vmov r0, s18
; CHECK-NEXT:    vmov.16 q1[4], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q1[5], r0
; CHECK-NEXT:    vmovx.f16 s0, s13
; CHECK-NEXT:    vstrw.32 q1, [sp] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q1, [sp, #48] @ 16-byte Reload
; CHECK-NEXT:    vmov r2, s0
; CHECK-NEXT:    vmovx.f16 s0, s14
; CHECK-NEXT:    vmov r0, s5
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov.16 q5[1], r2
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vldrw.u32 q1, [sp, #64] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s22, s14
; CHECK-NEXT:    vmovx.f16 s0, s21
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vldrw.u32 q0, [sp, #80] @ 16-byte Reload
; CHECK-NEXT:    vrev32.16 q3, q0
; CHECK-NEXT:    vmov r2, s13
; CHECK-NEXT:    vmovx.f16 s12, s14
; CHECK-NEXT:    vmov.16 q0[2], r2
; CHECK-NEXT:    vmov.16 q0[3], r0
; CHECK-NEXT:    vmov r0, s22
; CHECK-NEXT:    vmov.16 q0[4], r0
; CHECK-NEXT:    vmov r0, s12
; CHECK-NEXT:    vldrw.u32 q3, [sp, #128] @ 16-byte Reload
; CHECK-NEXT:    vmov.16 q0[5], r0
; CHECK-NEXT:    vmov.f32 s13, s25
; CHECK-NEXT:    vmov.f32 s14, s26
; CHECK-NEXT:    vldrw.u32 q6, [sp, #96] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s25, s5
; CHECK-NEXT:    vstrw.32 q3, [r1]
; CHECK-NEXT:    vmov.f32 s21, s1
; CHECK-NEXT:    vmov.f32 s26, s6
; CHECK-NEXT:    vldrw.u32 q1, [sp, #16] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s22, s2
; CHECK-NEXT:    vldrw.u32 q0, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f32 s29, s5
; CHECK-NEXT:    vstrw.32 q6, [r1, #32]
; CHECK-NEXT:    vmov.f32 s17, s1
; CHECK-NEXT:    vstrw.32 q5, [r1, #16]
; CHECK-NEXT:    vmov.f32 s30, s6
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vstrw.32 q7, [r1, #48]
; CHECK-NEXT:    vstrw.32 q4, [r1, #64]
; CHECK-NEXT:    add sp, #144
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <16 x half>, <16 x half>* %src, i32 0
  %l1 = load <16 x half>, <16 x half>* %s1, align 4
  %s2 = getelementptr <16 x half>, <16 x half>* %src, i32 1
  %l2 = load <16 x half>, <16 x half>* %s2, align 4
  %s3 = getelementptr <16 x half>, <16 x half>* %src, i32 2
  %l3 = load <16 x half>, <16 x half>* %s3, align 4
  %t1 = shufflevector <16 x half> %l1, <16 x half> %l2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %t2 = shufflevector <16 x half> %l3, <16 x half> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <32 x half> %t1, <32 x half> %t2, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x half> %s, <48 x half> *%dst
  ret void
}

; f64

define void @vst3_v2f64(<2 x double> *%src, <6 x double> *%dst) {
; CHECK-LABEL: vst3_v2f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldrw.u32 q1, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov.f64 d6, d2
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d1, d4
; CHECK-NEXT:    vstrw.32 q3, [r1, #16]
; CHECK-NEXT:    vmov.f64 d2, d5
; CHECK-NEXT:    vstrw.32 q0, [r1]
; CHECK-NEXT:    vstrw.32 q1, [r1, #32]
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <2 x double>, <2 x double>* %src, i32 0
  %l1 = load <2 x double>, <2 x double>* %s1, align 4
  %s2 = getelementptr <2 x double>, <2 x double>* %src, i32 1
  %l2 = load <2 x double>, <2 x double>* %s2, align 4
  %s3 = getelementptr <2 x double>, <2 x double>* %src, i32 2
  %l3 = load <2 x double>, <2 x double>* %s3, align 4
  %t1 = shufflevector <2 x double> %l1, <2 x double> %l2, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %t2 = shufflevector <2 x double> %l3, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %s = shufflevector <4 x double> %t1, <4 x double> %t2, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x double> %s, <6 x double> *%dst
  ret void
}

define void @vst3_v4f64(<4 x double> *%src, <12 x double> *%dst) {
; CHECK-LABEL: vst3_v4f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vldrw.u32 q7, [r0, #48]
; CHECK-NEXT:    vldrw.u32 q6, [r0, #32]
; CHECK-NEXT:    vldrw.u32 q1, [r0]
; CHECK-NEXT:    vldrw.u32 q0, [r0, #80]
; CHECK-NEXT:    vldrw.u32 q2, [r0, #16]
; CHECK-NEXT:    vmov.f64 d6, d15
; CHECK-NEXT:    vstrw.32 q6, [sp] @ 16-byte Spill
; CHECK-NEXT:    vldrw.u32 q4, [r0, #64]
; CHECK-NEXT:    vmov.f64 d10, d2
; CHECK-NEXT:    vmov.f64 d7, d1
; CHECK-NEXT:    vmov.f64 d11, d12
; CHECK-NEXT:    vstrw.32 q3, [r1, #80]
; CHECK-NEXT:    vmov.f64 d12, d4
; CHECK-NEXT:    vstrw.32 q5, [r1]
; CHECK-NEXT:    vmov.f64 d1, d5
; CHECK-NEXT:    vldrw.u32 q2, [sp] @ 16-byte Reload
; CHECK-NEXT:    vmov.f64 d2, d8
; CHECK-NEXT:    vstrw.32 q0, [r1, #64]
; CHECK-NEXT:    vmov.f64 d13, d14
; CHECK-NEXT:    vstrw.32 q1, [r1, #16]
; CHECK-NEXT:    vmov.f64 d8, d5
; CHECK-NEXT:    vstrw.32 q6, [r1, #48]
; CHECK-NEXT:    vstrw.32 q4, [r1, #32]
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13, d14, d15}
; CHECK-NEXT:    bx lr
entry:
  %s1 = getelementptr <4 x double>, <4 x double>* %src, i32 0
  %l1 = load <4 x double>, <4 x double>* %s1, align 4
  %s2 = getelementptr <4 x double>, <4 x double>* %src, i32 1
  %l2 = load <4 x double>, <4 x double>* %s2, align 4
  %s3 = getelementptr <4 x double>, <4 x double>* %src, i32 2
  %l3 = load <4 x double>, <4 x double>* %s3, align 4
  %t1 = shufflevector <4 x double> %l1, <4 x double> %l2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %t2 = shufflevector <4 x double> %l3, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %s = shufflevector <8 x double> %t1, <8 x double> %t2, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x double> %s, <12 x double> *%dst
  ret void
}
