; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=s390x-linux-gnu | FileCheck %s

;; TODO: fold (sext (not x)) -> (add (zext x) -1)
define i32 @sext_of_not(i1 %x) {
; CHECK-LABEL: sext_of_not:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xilf %r2, 4294967295
; CHECK-NEXT:    nilf %r2, 1
; CHECK-NEXT:    lcr %r2, %r2
; CHECK-NEXT:    br %r14
  %xor = xor i1 %x, 1
  %sext = sext i1 %xor to i32
  ret i32 %sext
}

;; TODO: fold (sext (not (setcc a, b, cc))) -> (sext (setcc a, b, !cc))
define i32 @sext_of_not_cmp(i32 %x) {
; CHECK-LABEL: sext_of_not_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    chi %r2, 7
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    afi %r2, 1879048192
; CHECK-NEXT:    sra %r2, 31
; CHECK-NEXT:    br %r14
  %cmp = icmp eq i32 %x, 7
  %xor = xor i1 %cmp, 1
  %sext = sext i1 %xor to i32
  ret i32 %sext
}

;; TODO: fold (add (zext (setcc a, b, cc)), -1) -> (sext (setcc a, b, !cc))
define i32 @dec_of_zexted_cmp(i32 %x) {
; CHECK-LABEL: dec_of_zexted_cmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    chi %r2, 7
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    afi %r2, -268435456
; CHECK-NEXT:    srl %r2, 31
; CHECK-NEXT:    ahi %r2, -1
; CHECK-NEXT:    br %r14
  %cmp = icmp eq i32 %x, 7
  %zext = zext i1 %cmp to i32
  %dec = sub i32 %zext, 1
  ret i32 %dec
}
