; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-b -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IB
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbp -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IBP

define i32 @gorc1_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.p a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.p a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc1_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.p a0, a0
; RV32IB-NEXT:    orc.p a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.p a0, a0
; RV32IBP-NEXT:    orc.p a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc2_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc2_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    orc2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    orc2.n a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc4_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc4.b a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc4_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc4.b a0, a0
; RV32IB-NEXT:    orc4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc4.b a0, a0
; RV32IBP-NEXT:    orc4.b a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc8_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc8.h a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc8_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 8
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc8.h a0, a0
; RV32IB-NEXT:    orc8.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc8.h a0, a0
; RV32IBP-NEXT:    orc8.h a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc16_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc16_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 16
; RV32I-NEXT:    slli a3, a0, 16
; RV32I-NEXT:    srli a4, a0, 16
; RV32I-NEXT:    srli a5, a1, 16
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    orc16 a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    orc16 a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @grev1_i32(i32 %a) nounwind {
; RV32I-LABEL: grev1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev1_i64(i64 %a) nounwind {
; RV32I-LABEL: grev1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev.p a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev.p a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev2_i32(i32 %a) nounwind {
; RV32I-LABEL: grev2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev2_i64(i64 %a) nounwind {
; RV32I-LABEL: grev2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shl, %shr
  ret i64 %or
}

; FIXME: we should generate grevi 3 here
define i32 @grev3_i32(i32 %a) nounwind {
; RV32I-LABEL: grev3_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

; FIXME: we should generate grevi 3 here
define i64 @grev3_i64(i64 %a) nounwind {
; RV32I-LABEL: grev3_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a1, a1
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a1, a1
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev4_i32(i32 %a) nounwind {
; RV32I-LABEL: grev4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev4_i64(i64 %a) nounwind {
; RV32I-LABEL: grev4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    rev4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    rev4.b a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shl, %shr
  ret i64 %or
}

; FIXME: we should generate grevi 5 here
define i32 @grev5_i32(i32 %a) nounwind {
; RV32I-LABEL: grev5_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev5_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev5_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

; FIXME: we should generate grevi 5 here
define i64 @grev5_i64(i64 %a) nounwind {
; RV32I-LABEL: grev5_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev5_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a1, a1
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    rev4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev5_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a1, a1
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    rev4.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1

  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

; FIXME: we should generate grevi 6 here
define i32 @grev6_i32(i32 %a) nounwind {
; RV32I-LABEL: grev6_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev6_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev6_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

; FIXME: we should generate grevi 6 here
define i64 @grev6_i64(i64 %a) nounwind {
; RV32I-LABEL: grev6_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev6_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    rev4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev6_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    rev4.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

; FIXME: we should generate grevi 7 here
define i32 @grev7_i32(i32 %a) nounwind {
; RV32I-LABEL: grev7_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev7_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev7_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 4
  %shl3 = and i32 %and3, -252645136
  %and3b = lshr i32 %or2, 4
  %shr3 = and i32 %and3b, 252645135
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

; FIXME: we should generate grevi 7 here
define i64 @grev7_i64(i64 %a) nounwind {
; RV32I-LABEL: grev7_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev7_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev.p a1, a1
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    rev4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev7_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev.p a1, a1
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    rev4.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 4
  %shl3 = and i64 %and3, -1085102592571150096
  %and3b = lshr i64 %or2, 4
  %shr3 = and i64 %and3b, 1085102592571150095
  %or3 = or i64 %shl3, %shr3
  ret i64 %or3
}

define i32 @grev8_i32(i32 %a) nounwind {
; RV32I-LABEL: grev8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev8_i64(i64 %a) nounwind {
; RV32I-LABEL: grev8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    lui a4, 4080
; RV32I-NEXT:    addi a4, a4, 255
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    rev8.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    rev8.h a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev16_i32(i32 %a) nounwind {
; RV32I-LABEL: grev16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shl, %shr
  ret i32 %or
}

declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)

define signext i32 @grev16_i32_fshl(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshl:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32_fshl:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32_fshl:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %or = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define signext i32 @grev16_i32_fshr(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32_fshr:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32_fshr:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %or = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define i64 @grev16_i64(i64 %a) nounwind {
; RV32I-LABEL: grev16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 16
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    srli a1, a1, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    rori a1, a1, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    rori a1, a1, 16
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shl, %shr
  ret i64 %or
}

declare i32 @llvm.bswap.i32(i32)

define i32 @bswap_i32(i32 %a) nounwind {
; RV32I-LABEL: bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8 a0, a0
; RV32IBP-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV32I-LABEL: bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a5, 4080
; RV32I-NEXT:    and a4, a4, a5
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a2, a1, a2
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8 a2, a1
; RV32IB-NEXT:    rev8 a1, a0
; RV32IB-NEXT:    mv a0, a2
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8 a2, a1
; RV32IBP-NEXT:    rev8 a1, a0
; RV32IBP-NEXT:    mv a0, a2
; RV32IBP-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}

declare i32 @llvm.bitreverse.i32(i32)

define i32 @bitreverse_i32(i32 %a) nounwind {
; RV32I-LABEL: bitreverse_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 349525
; RV32I-NEXT:    addi a1, a1, 1365
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a0, a0
; RV32IBP-NEXT:    ret
  %1 = tail call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bitreverse.i64(i64)

define i64 @bitreverse_i64(i64 %a) nounwind {
; RV32I-LABEL: bitreverse_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi t0, a3, -256
; RV32I-NEXT:    and a2, a2, t0
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi t1, a2, -241
; RV32I-NEXT:    and a2, a1, t1
; RV32I-NEXT:    slli a2, a2, 4
; RV32I-NEXT:    lui a5, 986895
; RV32I-NEXT:    addi t2, a5, 240
; RV32I-NEXT:    and a1, a1, t2
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi t3, a2, 819
; RV32I-NEXT:    and a3, a1, t3
; RV32I-NEXT:    slli a3, a3, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a1, a3
; RV32I-NEXT:    slli a5, a5, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a7, a1, a5
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, t0
; RV32I-NEXT:    srli a5, a0, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    slli a5, a0, 8
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, t1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    and a0, a0, t2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, t3
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, a3
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    mv a0, a7
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a2, a1
; RV32IB-NEXT:    rev a1, a0
; RV32IB-NEXT:    mv a0, a2
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a2, a1
; RV32IBP-NEXT:    rev a1, a0
; RV32IBP-NEXT:    mv a0, a2
; RV32IBP-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %1
}

define i32 @shfl1_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 629146
; RV32I-NEXT:    addi a1, a1, -1639
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    lui a3, 279620
; RV32I-NEXT:    addi a3, a3, 1092
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 139810
; RV32I-NEXT:    addi a2, a2, 546
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip.n a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -1717986919
  %shl = shl i32 %a, 1
  %and1 = and i32 %shl, 1145324612
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 1
  %and2 = and i32 %shr, 572662306
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl1_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 629146
; RV32I-NEXT:    addi a2, a2, -1639
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 1
; RV32I-NEXT:    slli a5, a0, 1
; RV32I-NEXT:    lui a3, 279620
; RV32I-NEXT:    addi a3, a3, 1092
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a2, a3, a2
; RV32I-NEXT:    or a3, a5, a6
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 139810
; RV32I-NEXT:    addi a4, a4, 546
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip.n a0, a0
; RV32IB-NEXT:    zip.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip.n a0, a0
; RV32IBP-NEXT:    zip.n a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -7378697629483820647
  %shl = shl i64 %a, 1
  %and1 = and i64 %shl, 4919131752989213764
  %or = or i64 %and1, %and
  %shr = lshr i64 %a, 1
  %and2 = and i64 %shr, 2459565876494606882
  %or3 = or i64 %or, %and2
  ret i64 %or3
}

define i32 @shfl2_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 801852
; RV32I-NEXT:    addi a1, a1, 963
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    lui a3, 197379
; RV32I-NEXT:    addi a3, a3, 48
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 49345
; RV32I-NEXT:    addi a2, a2, -1012
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip2.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip2.b a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -1010580541
  %shl = shl i32 %a, 2
  %and1 = and i32 %shl, 808464432
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 2
  %and2 = and i32 %shr, 202116108
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl2_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 801852
; RV32I-NEXT:    addi a2, a2, 963
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 2
; RV32I-NEXT:    slli a5, a0, 2
; RV32I-NEXT:    lui a3, 197379
; RV32I-NEXT:    addi a3, a3, 48
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a2, a3, a2
; RV32I-NEXT:    or a3, a5, a6
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 49345
; RV32I-NEXT:    addi a4, a4, -1012
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip2.b a0, a0
; RV32IB-NEXT:    zip2.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip2.b a0, a0
; RV32IBP-NEXT:    zip2.b a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -4340410370284600381
  %shl = shl i64 %a, 2
  %and1 = and i64 %shl, 3472328296227680304
  %or = or i64 %and1, %and
  %shr = lshr i64 %a, 2
  %and2 = and i64 %shr, 868082074056920076
  %or3 = or i64 %or, %and2
  ret i64 %or3
}

define i32 @shfl4_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 983295
; RV32I-NEXT:    addi a1, a1, 15
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    lui a3, 61441
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 3840
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip4.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip4.h a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -267390961
  %shl = shl i32 %a, 4
  %and1 = and i32 %shl, 251662080
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 4
  %and2 = and i32 %shr, 15728880
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl4_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 983295
; RV32I-NEXT:    addi a2, a2, 15
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 4
; RV32I-NEXT:    slli a5, a0, 4
; RV32I-NEXT:    lui a3, 61441
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a2, a3, a2
; RV32I-NEXT:    or a3, a5, a6
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 3840
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip4.h a0, a0
; RV32IB-NEXT:    zip4.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip4.h a0, a0
; RV32IBP-NEXT:    zip4.h a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -1148435428713435121
  %shl = shl i64 %a, 4
  %and1 = and i64 %shl, 1080880403494997760
  %or = or i64 %and1, %and
  %shr = lshr i64 %a, 4
  %and2 = and i64 %shr, 67555025218437360
  %or3 = or i64 %or, %and2
  ret i64 %or3
}

define i32 @shfl8_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1044480
; RV32I-NEXT:    addi a1, a1, 255
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip8 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip8 a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -16776961
  %shl = shl i32 %a, 8
  %and1 = and i32 %shl, 16711680
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 8
  %and2 = and i32 %shr, 65280
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl8_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 1044480
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a3, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    slli a5, a0, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    or a2, a4, a2
; RV32I-NEXT:    or a3, a5, a3
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    lui a4, 16
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip8 a0, a0
; RV32IB-NEXT:    zip8 a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip8 a0, a0
; RV32IBP-NEXT:    zip8 a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -72056494543077121
  %shl = shl i64 %a, 8
  %and1 = and i64 %shl, 71776119077928960
  %or = or i64 %and1, %and
  %shr = lshr i64 %a, 8
  %and2 = and i64 %shr, 280375465148160
  %or3 = or i64 %or, %and2
  ret i64 %or3
}
