; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s

; Test splitting flat instruction offsets into the low and high bits
; when the offset doesn't fit in the offset field.

define i8 @flat_inst_valu_offset_1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, v0, 1
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 1
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x7ff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 2047
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 4095
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8191
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfffff800, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -2048
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfffff000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -4096
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_neg_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xffffe000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -8192
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 4095
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8191
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x3000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x3fff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 16383
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfffff000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -4096
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xffffe000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -8192
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define i8 @flat_inst_valu_offset_2x_neg_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffc000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_2x_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xffffc000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, -1, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -16384
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits (1ull << 33) | 2047
define i8 @flat_inst_valu_offset_64bit_11bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_11bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x7ff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589936639
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits (1ull << 33) | 2048
define i8 @flat_inst_valu_offset_64bit_11bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2048
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_11bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x800, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589936640
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits (1ull << 33) | 4095
define i8 @flat_inst_valu_offset_64bit_12bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_12bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589938687
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits (1ull << 33) | 4096
define i8 @flat_inst_valu_offset_64bit_12bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_12bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589938688
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits (1ull << 33) | 8191
define i8 @flat_inst_valu_offset_64bit_13bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_13bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589942783
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits (1ull << 33) | 8192
define i8 @flat_inst_valu_offset_64bit_13bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_13bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x2000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 2, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 8589942784
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2047
define i8 @flat_inst_valu_offset_64bit_11bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7ff, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x7ff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854773761
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2048
define i8 @flat_inst_valu_offset_64bit_11bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x800, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_11bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x800, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854773760
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4095
define i8 @flat_inst_valu_offset_64bit_12bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfff, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0xfff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854771713
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4096
define i8 @flat_inst_valu_offset_64bit_12bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_12bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854771712
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8191
define i8 @flat_inst_valu_offset_64bit_13bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x1fff, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854767617
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8192
define i8 @flat_inst_valu_offset_64bit_13bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-NEXT:    v_bfrev_b32_e32 v2, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: flat_inst_valu_offset_64bit_13bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v0, vcc_lo, 0x2000, v0
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    v_add_co_ci_u32_e32 v1, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr i8, i8* %p, i64 -9223372036854767616
  %load = load i8, i8* %gep, align 4
  ret i8 %load
}

define amdgpu_kernel void @flat_inst_salu_offset_1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:1
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 1
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 1
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 2047
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 4095
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8191
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff800, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff800
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -2048
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -4096
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_neg_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -8192
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 4095
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8191
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x3000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x3fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 16383
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_11bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfffff000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_11bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfffff000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -4096
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_12bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffe000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_12bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffe000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -8192
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

define amdgpu_kernel void @flat_inst_salu_offset_2x_neg_13bit_max(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xffffc000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, -1, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_2x_neg_13bit_max:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xffffc000
; GFX10-NEXT:    s_addc_u32 s1, s1, -1
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -16384
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 11-bit low-bits (1ull << 33) | 2047
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2047
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589936639
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 11-bit low-bits (1ull << 33) | 2048
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:2048
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x800
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589936640
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 12-bit low-bits (1ull << 33) | 4095
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e64 v0, vcc, 0, s0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589938687
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 12-bit low-bits (1ull << 33) | 4096
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589938688
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 13-bit low-bits (1ull << 33) | 8191
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1] offset:4095
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589942783
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 13-bit low-bits (1ull << 33) | 8192
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 2, v1, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX10-NEXT:    s_addc_u32 s1, s1, 2
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 8589942784
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2047
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x7ff, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x7ff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854773761
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 11-bit low-bits, negative high bits (1ull << 63) | 2048
define amdgpu_kernel void @flat_inst_salu_offset_64bit_11bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x800, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_11bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x800
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854773760
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4095
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0xfff, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0xfff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854771713
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 12-bit low-bits, negative high bits (1ull << 63) | 4096
define amdgpu_kernel void @flat_inst_salu_offset_64bit_12bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_12bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1000
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854771712
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8191
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_neg_high_split0(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x1fff, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split0:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x1fff
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854767617
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}

; Fill 13-bit low-bits, negative high bits (1ull << 63) | 8192
define amdgpu_kernel void @flat_inst_salu_offset_64bit_13bit_neg_high_split1(i8* %p) {
; GFX9-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0x2000, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, v1, v2, vcc
; GFX9-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    flat_store_byte v[0:1], v0
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: flat_inst_salu_offset_64bit_13bit_neg_high_split1:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; GFX10-NEXT:    ; implicit-def: $vcc_hi
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_add_u32 s0, s0, 0x2000
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_load_ubyte v0, v[0:1]
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_byte v[0:1], v0
; GFX10-NEXT:    s_endpgm
  %gep = getelementptr i8, i8* %p, i64 -9223372036854767616
  %load = load volatile i8, i8* %gep, align 1
  store i8 %load, i8* undef
  ret void
}
