// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -ffixed-point -triple x86_64-unknown-linux-gnu -S -emit-llvm %s -o - | FileCheck %s --check-prefixes=CHECK,SIGNED
// RUN: %clang_cc1 -ffixed-point -triple x86_64-unknown-linux-gnu -S -emit-llvm %s -o - -fpadding-on-unsigned-fixed-point | FileCheck %s --check-prefixes=CHECK,UNSIGNED

short _Accum sa;
_Accum a, a2;
long _Accum la;

unsigned short _Accum usa;
unsigned _Accum ua;
unsigned long _Accum ula;

short _Fract sf;
_Fract f;
long _Fract lf;
unsigned _Fract uf;

_Sat short _Accum sat_sa;
_Sat _Accum sat_a;
_Sat long _Accum sat_la;

_Sat unsigned short _Accum sat_usa;
_Sat unsigned _Accum sat_ua;
_Sat unsigned long _Accum sat_ula;

_Sat short _Fract sat_sf;
_Sat _Fract sat_f;
_Sat long _Fract sat_lf;

short s;
int i;
unsigned int ui;

// CHECK-LABEL: @fix_same1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    store i32 [[TMP0]], i32* @a2, align 4
// CHECK-NEXT:    ret void
//
void fix_same1() {
  a2 = a;
}

// CHECK-LABEL: @fix_same2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    store i32 [[TMP0]], i32* @a2, align 4
// CHECK-NEXT:    ret void
//
void fix_same2() {
  a2 = (_Accum)a;
}


// CHECK-LABEL: @fix_castdown1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, i64* @la, align 8
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i64 [[TMP0]], 16
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i64 [[DOWNSCALE]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castdown1() {
  a = la;
}

// CHECK-LABEL: @fix_castdown2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, i64* @la, align 8
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i64 [[TMP0]], 16
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i64 [[DOWNSCALE]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castdown2() {
  a = (_Accum)la;
}

// CHECK-LABEL: @fix_castdown3(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[DOWNSCALE]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @sa, align 2
// CHECK-NEXT:    ret void
//
void fix_castdown3() {
  sa = a;
}

// CHECK-LABEL: @fix_castdown4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[DOWNSCALE]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @sa, align 2
// CHECK-NEXT:    ret void
//
void fix_castdown4() {
  sa = a;
}


// CHECK-LABEL: @fix_castup1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @sa, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i32 [[RESIZE]], 8
// CHECK-NEXT:    store i32 [[UPSCALE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castup1() {
  a = sa;
}

// CHECK-LABEL: @fix_castup2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @sa, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i32 [[RESIZE]], 8
// CHECK-NEXT:    store i32 [[UPSCALE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castup2() {
  a = (_Accum)sa;
}

// CHECK-LABEL: @fix_castup3(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, i64* @la, align 8
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i64 [[TMP0]], 16
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i64 [[DOWNSCALE]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castup3() {
  a = la;
}

// CHECK-LABEL: @fix_castup4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, i64* @la, align 8
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i64 [[TMP0]], 16
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i64 [[DOWNSCALE]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_castup4() {
  a = (long _Accum)la;
}


// SIGNED-LABEL: @fix_sign1(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i32 [[TMP0]], 1
// SIGNED-NEXT:    store i32 [[UPSCALE]], i32* @ua, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sign1(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// UNSIGNED-NEXT:    store i32 [[TMP0]], i32* @ua, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sign1() {
  ua = a;
}

// SIGNED-LABEL: @fix_sign2(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ua, align 4
// SIGNED-NEXT:    [[DOWNSCALE:%.*]] = lshr i32 [[TMP0]], 1
// SIGNED-NEXT:    store i32 [[DOWNSCALE]], i32* @a, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sign2(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ua, align 4
// UNSIGNED-NEXT:    store i32 [[TMP0]], i32* @a, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sign2() {
  a = ua;
}

// SIGNED-LABEL: @fix_sign3(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i32 [[TMP0]], 1
// SIGNED-NEXT:    store i32 [[UPSCALE]], i32* @ua, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sign3(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// UNSIGNED-NEXT:    store i32 [[TMP0]], i32* @ua, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sign3() {
  ua = (unsigned _Accum)a;
}

// SIGNED-LABEL: @fix_sign4(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ua, align 4
// SIGNED-NEXT:    [[DOWNSCALE:%.*]] = lshr i32 [[TMP0]], 1
// SIGNED-NEXT:    store i32 [[DOWNSCALE]], i32* @a, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sign4(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ua, align 4
// UNSIGNED-NEXT:    store i32 [[TMP0]], i32* @a, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sign4() {
  a = (_Accum)ua;
}

// SIGNED-LABEL: @fix_sign5(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i64
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i64 [[RESIZE]], 17
// SIGNED-NEXT:    store i64 [[UPSCALE]], i64* @ula, align 8
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sign5(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i64
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i64 [[RESIZE]], 16
// UNSIGNED-NEXT:    store i64 [[UPSCALE]], i64* @ula, align 8
// UNSIGNED-NEXT:    ret void
//
void fix_sign5() {
  ula = a;
}


// CHECK-LABEL: @fix_sat1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[DOWNSCALE]], 32767
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i32 32767, i32 [[DOWNSCALE]]
// CHECK-NEXT:    [[TMP2:%.*]] = icmp slt i32 [[SATMAX]], -32768
// CHECK-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i32 -32768, i32 [[SATMAX]]
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[SATMIN]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @sat_sa, align 2
// CHECK-NEXT:    ret void
//
void fix_sat1() {
  // Casting down between types
  sat_sa = sat_a;
}

// CHECK-LABEL: @fix_sat2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[DOWNSCALE]], 127
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i32 127, i32 [[DOWNSCALE]]
// CHECK-NEXT:    [[TMP2:%.*]] = icmp slt i32 [[SATMAX]], -128
// CHECK-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i32 -128, i32 [[SATMAX]]
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[SATMIN]] to i8
// CHECK-NEXT:    store i8 [[RESIZE]], i8* @sat_sf, align 1
// CHECK-NEXT:    ret void
//
void fix_sat2() {
  // Accum to Fract, decreasing scale
  sat_sf = sat_a;
}

// CHECK-LABEL: @fix_sat3(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[TMP0]], 32767
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i32 32767, i32 [[TMP0]]
// CHECK-NEXT:    [[TMP2:%.*]] = icmp slt i32 [[SATMAX]], -32768
// CHECK-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i32 -32768, i32 [[SATMAX]]
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[SATMIN]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @sat_f, align 2
// CHECK-NEXT:    ret void
//
void fix_sat3() {
  // Accum to Fract, same scale
  sat_f = a;
}

// CHECK-LABEL: @fix_sat4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i48
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i48 [[RESIZE]], 16
// CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i48 [[UPSCALE]], 2147483647
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i48 2147483647, i48 [[UPSCALE]]
// CHECK-NEXT:    [[TMP2:%.*]] = icmp slt i48 [[SATMAX]], -2147483648
// CHECK-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i48 -2147483648, i48 [[SATMAX]]
// CHECK-NEXT:    [[RESIZE1:%.*]] = trunc i48 [[SATMIN]] to i32
// CHECK-NEXT:    store i32 [[RESIZE1]], i32* @sat_lf, align 4
// CHECK-NEXT:    ret void
//
void fix_sat4() {
  // Accum to Fract, increasing scale
  sat_lf = sat_a;
}

// SIGNED-LABEL: @fix_sat5(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// SIGNED-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 7
// SIGNED-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[DOWNSCALE]], 65535
// SIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i32 65535, i32 [[DOWNSCALE]]
// SIGNED-NEXT:    [[TMP2:%.*]] = icmp slt i32 [[SATMAX]], 0
// SIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i32 0, i32 [[SATMAX]]
// SIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[SATMIN]] to i16
// SIGNED-NEXT:    store i16 [[RESIZE]], i16* @sat_usa, align 2
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sat5(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// UNSIGNED-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// UNSIGNED-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[DOWNSCALE]], 32767
// UNSIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i32 32767, i32 [[DOWNSCALE]]
// UNSIGNED-NEXT:    [[TMP2:%.*]] = icmp slt i32 [[SATMAX]], 0
// UNSIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i32 0, i32 [[SATMAX]]
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[SATMIN]] to i16
// UNSIGNED-NEXT:    store i16 [[RESIZE]], i16* @sat_usa, align 2
// UNSIGNED-NEXT:    ret void
//
void fix_sat5() {
  // Signed to unsigned, decreasing scale
  sat_usa = sat_a;
}

// SIGNED-LABEL: @fix_sat6(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i33
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i33 [[RESIZE]], 1
// SIGNED-NEXT:    [[TMP1:%.*]] = icmp slt i33 [[UPSCALE]], 0
// SIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP1]], i33 0, i33 [[UPSCALE]]
// SIGNED-NEXT:    [[RESIZE1:%.*]] = trunc i33 [[SATMIN]] to i32
// SIGNED-NEXT:    store i32 [[RESIZE1]], i32* @sat_ua, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sat6(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// UNSIGNED-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[TMP0]], 0
// UNSIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP1]], i32 0, i32 [[TMP0]]
// UNSIGNED-NEXT:    store i32 [[SATMIN]], i32* @sat_ua, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sat6() {
  // Signed to unsigned, increasing scale
  sat_ua = sat_a;
}

// CHECK-LABEL: @fix_sat7(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    store i32 [[TMP0]], i32* @sat_a, align 4
// CHECK-NEXT:    ret void
//
void fix_sat7() {
  // Nothing when saturating to the same type and size
  sat_a = a;
}

// CHECK-LABEL: @fix_sat8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @sat_a, align 4
// CHECK-NEXT:    store i32 [[TMP0]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_sat8() {
  // Nothing when assigning back
  a = sat_a;
}

// CHECK-LABEL: @fix_sat9(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @sat_f, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @sat_a, align 4
// CHECK-NEXT:    ret void
//
void fix_sat9() {
  // No overflow when casting from fract to signed accum
  sat_a = sat_f;
}

// SIGNED-LABEL: @fix_sat10(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i8, i8* @sat_sf, align 1
// SIGNED-NEXT:    [[RESIZE:%.*]] = sext i8 [[TMP0]] to i32
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i32 [[RESIZE]], 9
// SIGNED-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[UPSCALE]], 0
// SIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP1]], i32 0, i32 [[UPSCALE]]
// SIGNED-NEXT:    store i32 [[SATMIN]], i32* @sat_ua, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_sat10(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i8, i8* @sat_sf, align 1
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = sext i8 [[TMP0]] to i32
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i32 [[RESIZE]], 8
// UNSIGNED-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[UPSCALE]], 0
// UNSIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP1]], i32 0, i32 [[UPSCALE]]
// UNSIGNED-NEXT:    store i32 [[SATMIN]], i32* @sat_ua, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_sat10() {
  // Only get overflow checking if signed fract to unsigned accum
  sat_ua = sat_sf;
}


// CHECK-LABEL: @fix_fract1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i32 [[TMP0]], 8
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[DOWNSCALE]] to i8
// CHECK-NEXT:    store i8 [[RESIZE]], i8* @sf, align 1
// CHECK-NEXT:    ret void
//
void fix_fract1() {
  // To lower scale
  sf = a;
}

// CHECK-LABEL: @fix_fract2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i8, i8* @sf, align 1
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i8 [[TMP0]] to i32
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i32 [[RESIZE]], 8
// CHECK-NEXT:    store i32 [[UPSCALE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_fract2() {
  // To higher scale
  a = sf;
}

// CHECK-LABEL: @fix_fract3(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @a, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @f, align 2
// CHECK-NEXT:    ret void
//
void fix_fract3() {
  // To same scale
  f = a;
}

// CHECK-LABEL: @fix_fract4(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @f, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[TMP0]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @a, align 4
// CHECK-NEXT:    ret void
//
void fix_fract4() {
  a = f;
}

// CHECK-LABEL: @fix_fract5(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @uf, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = zext i16 [[TMP0]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @ua, align 4
// CHECK-NEXT:    ret void
//
void fix_fract5() {
  // To unsigned
  ua = uf;
}

// CHECK-LABEL: @fix_fract6(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @ua, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// CHECK-NEXT:    store i16 [[RESIZE]], i16* @uf, align 2
// CHECK-NEXT:    ret void
//
void fix_fract6() {
  uf = ua;
}


// CHECK-LABEL: @fix_int1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @sa, align 2
// CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i16 [[TMP0]], 0
// CHECK-NEXT:    [[TMP2:%.*]] = add i16 [[TMP0]], 127
// CHECK-NEXT:    [[TMP3:%.*]] = select i1 [[TMP1]], i16 [[TMP2]], i16 [[TMP0]]
// CHECK-NEXT:    [[DOWNSCALE:%.*]] = ashr i16 [[TMP3]], 7
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[DOWNSCALE]] to i32
// CHECK-NEXT:    store i32 [[RESIZE]], i32* @i, align 4
// CHECK-NEXT:    ret void
//
void fix_int1() {
  // Will need to check for negative values
  i = sa;
}

// SIGNED-LABEL: @fix_int2(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i16, i16* @usa, align 2
// SIGNED-NEXT:    [[DOWNSCALE:%.*]] = lshr i16 [[TMP0]], 8
// SIGNED-NEXT:    [[RESIZE:%.*]] = zext i16 [[DOWNSCALE]] to i32
// SIGNED-NEXT:    store i32 [[RESIZE]], i32* @i, align 4
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @fix_int2(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i16, i16* @usa, align 2
// UNSIGNED-NEXT:    [[DOWNSCALE:%.*]] = lshr i16 [[TMP0]], 7
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = zext i16 [[DOWNSCALE]] to i32
// UNSIGNED-NEXT:    store i32 [[RESIZE]], i32* @i, align 4
// UNSIGNED-NEXT:    ret void
//
void fix_int2() {
  // No check needed for unsigned fixed points. Can just right shift.
  i = usa;
}


// CHECK-LABEL: @int_fix1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 7
// CHECK-NEXT:    store i16 [[UPSCALE]], i16* @sa, align 2
// CHECK-NEXT:    ret void
//
void int_fix1() {
  sa = i;
}

// CHECK-LABEL: @int_fix2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 7
// CHECK-NEXT:    store i16 [[UPSCALE]], i16* @sa, align 2
// CHECK-NEXT:    ret void
//
void int_fix2() {
  sa = ui;
}

// SIGNED-LABEL: @int_fix3(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 8
// SIGNED-NEXT:    store i16 [[UPSCALE]], i16* @usa, align 2
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @int_fix3(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 7
// UNSIGNED-NEXT:    store i16 [[UPSCALE]], i16* @usa, align 2
// UNSIGNED-NEXT:    ret void
//
void int_fix3() {
  usa = i;
}

// SIGNED-LABEL: @int_fix4(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 8
// SIGNED-NEXT:    store i16 [[UPSCALE]], i16* @usa, align 2
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @int_fix4(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = trunc i32 [[TMP0]] to i16
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i16 [[RESIZE]], 7
// UNSIGNED-NEXT:    store i16 [[UPSCALE]], i16* @usa, align 2
// UNSIGNED-NEXT:    ret void
//
void int_fix4() {
  usa = ui;
}

// CHECK-LABEL: @int_fix5(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i16, i16* @s, align 2
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i16 [[TMP0]] to i64
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i64 [[RESIZE]], 31
// CHECK-NEXT:    store i64 [[UPSCALE]], i64* @la, align 8
// CHECK-NEXT:    ret void
//
void int_fix5() {
  la = s;
}


// CHECK-LABEL: @int_sat1(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i39
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i39 [[RESIZE]], 7
// CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i39 [[UPSCALE]], 32767
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i39 32767, i39 [[UPSCALE]]
// CHECK-NEXT:    [[TMP2:%.*]] = icmp slt i39 [[SATMAX]], -32768
// CHECK-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i39 -32768, i39 [[SATMAX]]
// CHECK-NEXT:    [[RESIZE1:%.*]] = trunc i39 [[SATMIN]] to i16
// CHECK-NEXT:    store i16 [[RESIZE1]], i16* @sat_sa, align 2
// CHECK-NEXT:    ret void
//
void int_sat1() {
  sat_sa = i;
}

// CHECK-LABEL: @int_sat2(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// CHECK-NEXT:    [[RESIZE:%.*]] = zext i32 [[TMP0]] to i39
// CHECK-NEXT:    [[UPSCALE:%.*]] = shl i39 [[RESIZE]], 7
// CHECK-NEXT:    [[TMP1:%.*]] = icmp ugt i39 [[UPSCALE]], 32767
// CHECK-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i39 32767, i39 [[UPSCALE]]
// CHECK-NEXT:    [[RESIZE1:%.*]] = trunc i39 [[SATMAX]] to i16
// CHECK-NEXT:    store i16 [[RESIZE1]], i16* @sat_sa, align 2
// CHECK-NEXT:    ret void
//
void int_sat2() {
  sat_sa = ui;
}

// SIGNED-LABEL: @int_sat3(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i40
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i40 [[RESIZE]], 8
// SIGNED-NEXT:    [[TMP1:%.*]] = icmp sgt i40 [[UPSCALE]], 65535
// SIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i40 65535, i40 [[UPSCALE]]
// SIGNED-NEXT:    [[TMP2:%.*]] = icmp slt i40 [[SATMAX]], 0
// SIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i40 0, i40 [[SATMAX]]
// SIGNED-NEXT:    [[RESIZE1:%.*]] = trunc i40 [[SATMIN]] to i16
// SIGNED-NEXT:    store i16 [[RESIZE1]], i16* @sat_usa, align 2
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @int_sat3(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @i, align 4
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = sext i32 [[TMP0]] to i39
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i39 [[RESIZE]], 7
// UNSIGNED-NEXT:    [[TMP1:%.*]] = icmp sgt i39 [[UPSCALE]], 32767
// UNSIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i39 32767, i39 [[UPSCALE]]
// UNSIGNED-NEXT:    [[TMP2:%.*]] = icmp slt i39 [[SATMAX]], 0
// UNSIGNED-NEXT:    [[SATMIN:%.*]] = select i1 [[TMP2]], i39 0, i39 [[SATMAX]]
// UNSIGNED-NEXT:    [[RESIZE1:%.*]] = trunc i39 [[SATMIN]] to i16
// UNSIGNED-NEXT:    store i16 [[RESIZE1]], i16* @sat_usa, align 2
// UNSIGNED-NEXT:    ret void
//
void int_sat3() {
  sat_usa = i;
}

// SIGNED-LABEL: @int_sat4(
// SIGNED-NEXT:  entry:
// SIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// SIGNED-NEXT:    [[RESIZE:%.*]] = zext i32 [[TMP0]] to i40
// SIGNED-NEXT:    [[UPSCALE:%.*]] = shl i40 [[RESIZE]], 8
// SIGNED-NEXT:    [[TMP1:%.*]] = icmp ugt i40 [[UPSCALE]], 65535
// SIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i40 65535, i40 [[UPSCALE]]
// SIGNED-NEXT:    [[RESIZE1:%.*]] = trunc i40 [[SATMAX]] to i16
// SIGNED-NEXT:    store i16 [[RESIZE1]], i16* @sat_usa, align 2
// SIGNED-NEXT:    ret void
//
// UNSIGNED-LABEL: @int_sat4(
// UNSIGNED-NEXT:  entry:
// UNSIGNED-NEXT:    [[TMP0:%.*]] = load i32, i32* @ui, align 4
// UNSIGNED-NEXT:    [[RESIZE:%.*]] = zext i32 [[TMP0]] to i39
// UNSIGNED-NEXT:    [[UPSCALE:%.*]] = shl i39 [[RESIZE]], 7
// UNSIGNED-NEXT:    [[TMP1:%.*]] = icmp ugt i39 [[UPSCALE]], 32767
// UNSIGNED-NEXT:    [[SATMAX:%.*]] = select i1 [[TMP1]], i39 32767, i39 [[UPSCALE]]
// UNSIGNED-NEXT:    [[RESIZE1:%.*]] = trunc i39 [[SATMAX]] to i16
// UNSIGNED-NEXT:    store i16 [[RESIZE1]], i16* @sat_usa, align 2
// UNSIGNED-NEXT:    ret void
//
void int_sat4() {
  sat_usa = ui;
}
