; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+experimental-zfh,+experimental-v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

; FIXME: The scalar/vector operations ('fv' tests) should swap operands and
; condition codes accordingly in order to generate a 'vf' instruction.

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v10
; CHECK-NEXT:    vmflt.vv v26, v10, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v10, v10
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfeq.vf v25, v26, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfeq.vf v25, v26, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v10, v10
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfeq.vf v25, v26, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v10
; CHECK-NEXT:    vmflt.vv v26, v10, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v8, v10
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v10
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v10, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v10, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v10, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v10
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f16(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v10, v10
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfne.vf v25, v26, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f16(<vscale x 8 x half> %va, half %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfne.vf v25, v26, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f16_nonans(<vscale x 8 x half> %va, <vscale x 8 x half> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v10, v10
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x half> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f16_nonans(<vscale x 8 x half> %va, half %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vfmv.v.f v26, fa0
; CHECK-NEXT:    vmfne.vf v25, v26, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x half> undef, half %b, i32 0
  %splat = shufflevector <vscale x 8 x half> %head, <vscale x 8 x half> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x half> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v12
; CHECK-NEXT:    vmflt.vv v26, v12, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v12, v12
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfeq.vf v25, v28, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfeq.vf v25, v28, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v12, v12
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfeq.vf v25, v28, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v12
; CHECK-NEXT:    vmflt.vv v26, v12, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v8, v12
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v12
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v12, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v12, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v12, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v12
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f32(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v12, v12
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfne.vf v25, v28, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f32(<vscale x 8 x float> %va, float %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfne.vf v25, v28, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f32_nonans(<vscale x 8 x float> %va, <vscale x 8 x float> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v12, v12
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x float> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f32_nonans(<vscale x 8 x float> %va, float %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vfmv.v.f v28, fa0
; CHECK-NEXT:    vmfne.vf v25, v28, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x float> undef, float %b, i32 0
  %splat = shufflevector <vscale x 8 x float> %head, <vscale x 8 x float> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x float> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oeq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_oeq_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp oeq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oeq_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_oeq_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oeq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ogt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ogt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ogt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ogt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ogt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ogt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_oge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_oge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_oge_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp oge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_oge_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_oge_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp oge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_olt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_olt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_olt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_olt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp olt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_olt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_olt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp olt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ole_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ole_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ole_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ole_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ole <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ole_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ole_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ole <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_one_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v16
; CHECK-NEXT:    vmflt.vv v26, v16, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_one_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_one_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_one_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp one <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_one_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_one_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp one <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ord_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v16, v16
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ord_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v25, v16, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ord_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v25, v16, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ord_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vv v25, v16, v16
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ord <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ord_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ord_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfeq.vf v25, v16, fa0
; CHECK-NEXT:    vmfeq.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmand.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ord <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v16
; CHECK-NEXT:    vmflt.vv v26, v16, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vmfgt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ueq_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vmflt.vf v26, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ueq_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ueq <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ueq_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ueq_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfeq.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ueq <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ugt_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ugt_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp ugt <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ugt_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ugt_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ugt <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_uge_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uge_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uge_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_uge_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v16, v8
; CHECK-NEXT:    ret
  %vc = fcmp uge <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uge_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_uge_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uge <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ult_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v25, v16, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ult_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfge.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ult_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ult_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ult <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ult_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ult_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ult <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_ule_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vv v25, v16, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ule_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfgt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_ule_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmflt.vf v25, v8, fa0
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmnand.mm v0, v25, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_ule_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp ule <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_ule_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_ule_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfle.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp ule <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_une_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_une_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_une_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_une_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vv v0, v8, v16
; CHECK-NEXT:    ret
  %vc = fcmp une <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_une_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_une_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vf v0, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp une <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f64(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) {
; CHECK-LABEL: fcmp_uno_vv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v16, v16
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uno_vf_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v25, v16, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_fv_nxv8f64(<vscale x 8 x double> %va, double %b) {
; CHECK-LABEL: fcmp_uno_fv_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v25, v16, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v25, v26
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %splat, %va
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vv_nxv8f64_nonans(<vscale x 8 x double> %va, <vscale x 8 x double> %vb) #0 {
; CHECK-LABEL: fcmp_uno_vv_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vmfne.vv v25, v16, v16
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %vc = fcmp uno <vscale x 8 x double> %va, %vb
  ret <vscale x 8 x i1> %vc
}

define <vscale x 8 x i1> @fcmp_uno_vf_nxv8f64_nonans(<vscale x 8 x double> %va, double %b) #0 {
; CHECK-LABEL: fcmp_uno_vf_nxv8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vfmv.v.f v16, fa0
; CHECK-NEXT:    vmfne.vf v25, v16, fa0
; CHECK-NEXT:    vmfne.vv v26, v8, v8
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmor.mm v0, v26, v25
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x double> undef, double %b, i32 0
  %splat = shufflevector <vscale x 8 x double> %head, <vscale x 8 x double> undef, <vscale x 8 x i32> zeroinitializer
  %vc = fcmp uno <vscale x 8 x double> %va, %splat
  ret <vscale x 8 x i1> %vc
}

attributes #0 = { "no-nans-fp-math"="true" }
