; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1-RV64

define void @add_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: add_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = add <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @add_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: add_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = add <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @add_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: add_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = add <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @add_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: add_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = add <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @sub_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: sub_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = sub <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @sub_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: sub_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = sub <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @sub_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: sub_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = sub <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @sub_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: sub_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = sub <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @mul_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: mul_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = mul <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @mul_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: mul_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = mul <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @mul_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: mul_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = mul <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @mul_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: mul_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = mul <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @and_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: and_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = and <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @and_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: and_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = and <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @and_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: and_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = and <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @and_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: and_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = and <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @or_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: or_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = or <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @or_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: or_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = or <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @or_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: or_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = or <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @or_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: or_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = or <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @xor_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = xor <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @xor_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = xor <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @xor_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = xor <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @xor_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: xor_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = xor <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @lshr_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: lshr_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = lshr <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @lshr_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: lshr_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = lshr <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @lshr_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: lshr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = lshr <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @lshr_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: lshr_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = lshr <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @ashr_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: ashr_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = ashr <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @ashr_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: ashr_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = ashr <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @ashr_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: ashr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = ashr <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @ashr_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: ashr_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = ashr <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @shl_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: shl_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = shl <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @shl_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: shl_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = shl <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @shl_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: shl_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = shl <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @shl_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: shl_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = shl <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @sdiv_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: sdiv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = sdiv <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @sdiv_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: sdiv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = sdiv <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @sdiv_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: sdiv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = sdiv <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @sdiv_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: sdiv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = sdiv <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @srem_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: srem_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = srem <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @srem_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: srem_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = srem <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @srem_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: srem_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = srem <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @srem_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: srem_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = srem <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @udiv_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: udiv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = udiv <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @udiv_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: udiv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = udiv <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @udiv_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: udiv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = udiv <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @udiv_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: udiv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = udiv <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @urem_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: urem_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = urem <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @urem_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: urem_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = urem <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @urem_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: urem_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = urem <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @urem_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: urem_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = urem <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @mulhu_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhu_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI52_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI52_0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI52_1)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI52_1)
; CHECK-NEXT:    vle8.v v27, (a1)
; CHECK-NEXT:    vsrl.vv v26, v25, v26
; CHECK-NEXT:    vmulhu.vv v26, v26, v27
; CHECK-NEXT:    lui a1, %hi(.LCPI52_2)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI52_2)
; CHECK-NEXT:    vle8.v v27, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI52_3)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI52_3)
; CHECK-NEXT:    vle8.v v28, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vmulhu.vv v25, v25, v27
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vsrl.vv v25, v25, v28
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhu_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: mulhu_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI53_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI53_0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI53_1)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI53_1)
; CHECK-NEXT:    vle16.v v27, (a1)
; CHECK-NEXT:    vsrl.vv v26, v25, v26
; CHECK-NEXT:    vmulhu.vv v26, v26, v27
; CHECK-NEXT:    lui a1, %hi(.LCPI53_2)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI53_2)
; CHECK-NEXT:    vle16.v v27, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI53_3)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI53_3)
; CHECK-NEXT:    vle16.v v28, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vmulhu.vv v25, v25, v27
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vsrl.vv v25, v25, v28
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = udiv <8 x i16> %a, <i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhu_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: mulhu_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI54_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI54_0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmulhu.vv v26, v25, v26
; CHECK-NEXT:    lui a1, %hi(.LCPI54_1)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI54_1)
; CHECK-NEXT:    vle32.v v27, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI54_2)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI54_2)
; CHECK-NEXT:    vle32.v v28, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vmulhu.vv v25, v25, v27
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vsrl.vv v25, v25, v28
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = udiv <4 x i32> %a, <i32 5, i32 6, i32 7, i32 9>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhu_v2i64(<2 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhu_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI55_0)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI55_0)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmulhu.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI55_1)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI55_1)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI55_0)
; LMULMAX1-RV64-NEXT:    addi a1, a1, %lo(.LCPI55_0)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI55_1)
; LMULMAX1-RV64-NEXT:    addi a1, a1, %lo(.LCPI55_1)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a1)
; LMULMAX1-RV64-NEXT:    vmulhu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = udiv <2 x i64> %a, <i64 3, i64 5>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @mulhs_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhs_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI56_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI56_0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    lui a1, %hi(.LCPI56_1)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI56_1)
; CHECK-NEXT:    vle8.v v27, (a1)
; CHECK-NEXT:    vmulhu.vv v25, v25, v26
; CHECK-NEXT:    vsrl.vv v25, v25, v27
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhs_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: mulhs_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    lui a1, %hi(.LCPI57_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI57_0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmulh.vv v25, v25, v26
; CHECK-NEXT:    vsra.vi v25, v25, 1
; CHECK-NEXT:    vsrl.vi v26, v25, 15
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = sdiv <8 x i16> %a, <i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhs_v4i32(<4 x i32>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI58_0)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI58_0)
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vmulh.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI58_0)
; LMULMAX1-RV64-NEXT:    addi a1, a1, %lo(.LCPI58_0)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vmulh.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 31
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = sdiv <4 x i32> %a, <i32 -5, i32 5, i32 -5, i32 5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhs_v2i64(<2 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI59_0)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI59_0)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI59_1)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI59_1)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmulh.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI59_2)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI59_2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI59_3)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI59_3)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI59_0)
; LMULMAX1-RV64-NEXT:    addi a1, a1, %lo(.LCPI59_0)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI59_1)
; LMULMAX1-RV64-NEXT:    addi a1, a1, %lo(.LCPI59_1)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v25, v26
; LMULMAX1-RV64-NEXT:    vmulh.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    addi a1, zero, 63
; LMULMAX1-RV64-NEXT:    vsrl.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vid.v v27
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = sdiv <2 x i64> %a, <i64 3, i64 -3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @smin_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: smin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp slt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @smin_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: smin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp slt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @smin_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: smin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp slt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @smin_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: smin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp slt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @smax_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: smax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp sgt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @smax_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: smax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp sgt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @smax_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: smax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp sgt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @smax_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: smax_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp sgt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @umin_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: umin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp ult <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @umin_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: umin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp ult <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @umin_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: umin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp ult <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @umin_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: umin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp ult <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @umax_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: umax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp ugt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @umax_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: umax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp ugt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @umax_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: umax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp ugt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @umax_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: umax_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp ugt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @add_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: add_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = add <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @add_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: add_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = add <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @add_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: add_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = add <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @add_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: add_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = add <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @sub_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: sub_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = sub <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @sub_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: sub_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = sub <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @sub_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: sub_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = sub <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @sub_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: sub_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = sub <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @mul_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: mul_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = mul <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @mul_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: mul_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = mul <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @mul_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: mul_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = mul <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @mul_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: mul_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = mul <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @and_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: and_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = and <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @and_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: and_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = and <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @and_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: and_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = and <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @and_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: and_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = and <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @or_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: or_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = or <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @or_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: or_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = or <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @or_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: or_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = or <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @or_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: or_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = or <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @xor_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: xor_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = xor <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @xor_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: xor_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = xor <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @xor_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: xor_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = xor <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @xor_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: xor_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = xor <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @lshr_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: lshr_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = lshr <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @lshr_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: lshr_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = lshr <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @lshr_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: lshr_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = lshr <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @lshr_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: lshr_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = lshr <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @ashr_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: ashr_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = ashr <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @ashr_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: ashr_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = ashr <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @ashr_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: ashr_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = ashr <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @ashr_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: ashr_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = ashr <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @shl_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: shl_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = shl <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @shl_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: shl_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = shl <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @shl_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: shl_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = shl <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @shl_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: shl_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = shl <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @sdiv_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: sdiv_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = sdiv <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @sdiv_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: sdiv_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = sdiv <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @sdiv_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: sdiv_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = sdiv <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @sdiv_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: sdiv_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = sdiv <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @srem_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: srem_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = srem <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @srem_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: srem_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = srem <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @srem_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: srem_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = srem <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @srem_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: srem_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = srem <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @udiv_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: udiv_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = udiv <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @udiv_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: udiv_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = udiv <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @udiv_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: udiv_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = udiv <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @udiv_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: udiv_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = udiv <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @urem_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: urem_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = urem <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @urem_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: urem_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = urem <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @urem_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: urem_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = urem <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @urem_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: urem_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = urem <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @extract_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: extract_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: extract_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: extract_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  br label %"compute"
"compute":
  %c = add <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @mulhu_v32i8(<32 x i8>* %x) {
; LMULMAX2-LABEL: mulhu_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a1, zero, 32
; LMULMAX2-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI129_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI129_0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI129_1)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI129_1)
; LMULMAX2-NEXT:    vle8.v v30, (a1)
; LMULMAX2-NEXT:    vsrl.vv v28, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v28, v28, v30
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI129_2)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI129_2)
; LMULMAX2-NEXT:    vle8.v v30, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI129_3)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI129_3)
; LMULMAX2-NEXT:    vle8.v v8, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v8
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhu_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI129_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI129_0)
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI129_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI129_0)
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = udiv <32 x i8> %a, <i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25>
  store <32 x i8> %b, <32 x i8>* %x
  ret void
}

define void @mulhu_v16i16(<16 x i16>* %x) {
; LMULMAX2-LABEL: mulhu_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI130_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI130_0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI130_1)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI130_1)
; LMULMAX2-NEXT:    vle16.v v30, (a1)
; LMULMAX2-NEXT:    vsrl.vv v28, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v28, v28, v30
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI130_2)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI130_2)
; LMULMAX2-NEXT:    vle16.v v30, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI130_3)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI130_3)
; LMULMAX2-NEXT:    vle16.v v8, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v8
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhu_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI130_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI130_0)
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI130_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI130_0)
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = udiv <16 x i16> %a, <i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  store <16 x i16> %b, <16 x i16>* %x
  ret void
}

define void @mulhu_v8i32(<8 x i32>* %x) {
; LMULMAX2-LABEL: mulhu_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI131_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI131_0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmulhu.vv v28, v26, v28
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI131_1)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI131_1)
; LMULMAX2-NEXT:    vle32.v v30, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI131_2)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI131_2)
; LMULMAX2-NEXT:    vle32.v v8, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v8
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhu_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI131_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI131_0)
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vmulhu.vv v28, v25, v26
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI131_1)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI131_1)
; LMULMAX1-RV32-NEXT:    vle32.v v29, (a2)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI131_2)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI131_2)
; LMULMAX1-RV32-NEXT:    vle32.v v30, (a2)
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vmulhu.vv v25, v25, v29
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v30
; LMULMAX1-RV32-NEXT:    vmulhu.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vsub.vv v27, v27, v26
; LMULMAX1-RV32-NEXT:    vmulhu.vv v27, v27, v29
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v30
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI131_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI131_0)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = udiv <8 x i32> %a, <i32 5, i32 6, i32 7, i32 9, i32 5, i32 6, i32 7, i32 9>
  store <8 x i32> %b, <8 x i32>* %x
  ret void
}

define void @mulhu_v4i64(<4 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhu_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI132_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI132_0)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI132_1)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI132_1)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI132_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI132_0)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI132_1)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI132_1)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a0)
; LMULMAX1-RV64-NEXT:    vmulhu.vv v26, v25, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vmulhu.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI132_2)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI132_2)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI132_3)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI132_3)
; LMULMAX1-RV64-NEXT:    vle64.v v29, (a2)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI132_4)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI132_4)
; LMULMAX1-RV64-NEXT:    vle64.v v30, (a2)
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vmulhu.vv v26, v28, v29
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v26, v30
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = udiv <4 x i64> %a, <i64 3, i64 5, i64 7, i64 9>
  store <4 x i64> %b, <4 x i64>* %x
  ret void
}

define void @mulhs_v32i8(<32 x i8>* %x) {
; LMULMAX2-LABEL: mulhs_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a1, zero, 32
; LMULMAX2-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI133_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI133_0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI133_1)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI133_1)
; LMULMAX2-NEXT:    vle8.v v30, (a1)
; LMULMAX2-NEXT:    vmulhu.vv v26, v26, v28
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v30
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhs_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI133_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI133_0)
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI133_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI133_0)
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = udiv <32 x i8> %a, <i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9>
  store <32 x i8> %b, <32 x i8>* %x
  ret void
}

define void @mulhs_v16i16(<16 x i16>* %x) {
; LMULMAX2-LABEL: mulhs_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI134_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI134_0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmulh.vv v26, v26, v28
; LMULMAX2-NEXT:    vsra.vi v26, v26, 1
; LMULMAX2-NEXT:    vsrl.vi v28, v26, 15
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhs_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI134_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI134_0)
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI134_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI134_0)
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = sdiv <16 x i16> %a, <i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7, i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7>
  store <16 x i16> %b, <16 x i16>* %x
  ret void
}

define void @mulhs_v8i32(<8 x i32>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI135_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI135_0)
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a0)
; LMULMAX1-RV32-NEXT:    vmulh.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v25, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vmulh.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI135_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI135_0)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = sdiv <8 x i32> %a, <i32 -5, i32 5, i32 -5, i32 5, i32 -5, i32 5, i32 -5, i32 5>
  store <8 x i32> %b, <8 x i32>* %x
  ret void
}

define void @mulhs_v4i64(<4 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI136_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI136_0)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI136_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI136_0)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI136_1)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI136_1)
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a0)
; LMULMAX1-RV64-NEXT:    vmul.vv v29, v25, v26
; LMULMAX1-RV64-NEXT:    vmulh.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v29
; LMULMAX1-RV64-NEXT:    addi a2, zero, 63
; LMULMAX1-RV64-NEXT:    vsrl.vx v29, v25, a2
; LMULMAX1-RV64-NEXT:    vid.v v30
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v30
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v29
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v28, v26
; LMULMAX1-RV64-NEXT:    vmulh.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vx v27, v26, a2
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v26, v30
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = sdiv <4 x i64> %a, <i64 3, i64 -3, i64 3, i64 -3>
  store <4 x i64> %b, <4 x i64>* %x
  ret void
}

define void @smin_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: smin_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp slt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @smin_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: smin_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp slt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @smin_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: smin_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp slt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @smin_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: smin_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp slt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @smax_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: smax_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp sgt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @smax_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: smax_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp sgt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @smax_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: smax_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp sgt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @smax_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: smax_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp sgt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @umin_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: umin_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp ult <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @umin_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: umin_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp ult <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @umin_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: umin_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp ult <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @umin_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: umin_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp ult <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @umax_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: umax_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp ugt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @umax_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: umax_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp ugt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @umax_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: umax_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp ugt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @umax_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: umax_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp ugt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @add_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: add_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: add_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: add_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: add_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: add_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: add_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: add_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: add_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: add_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: add_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: add_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: add_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: sub_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: sub_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: sub_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: sub_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: sub_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: sub_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sub_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sub_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sub_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sub_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sub_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sub_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mul_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: mul_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = mul <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @mul_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: mul_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = mul <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @mul_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: mul_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = mul <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mul_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: mul_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = mul <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @mul_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: mul_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = mul <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @mul_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: mul_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = mul <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: and_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -2, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: and_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -2, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: and_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -2, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: and_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: and_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: and_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: and_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: and_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: and_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: and_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: and_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: and_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: or_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -2, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: or_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -2, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: or_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -2, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: or_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: or_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: or_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: or_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: or_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: or_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: or_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: or_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: or_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: xor_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: xor_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: xor_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: xor_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: xor_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: xor_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: xor_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: xor_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: xor_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: xor_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: xor_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: xor_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @lshr_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: lshr_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = lshr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @lshr_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: lshr_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = lshr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @lshr_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: lshr_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = lshr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @lshr_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: lshr_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = lshr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @lshr_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: lshr_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = lshr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @lshr_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: lshr_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = lshr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @ashr_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: ashr_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = ashr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @ashr_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: ashr_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = ashr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @ashr_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: ashr_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = ashr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @ashr_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: ashr_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = ashr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @ashr_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: ashr_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = ashr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @ashr_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: ashr_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = ashr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @shl_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: shl_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = shl <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @shl_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: shl_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = shl <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @shl_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: shl_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = shl <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @shl_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: shl_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = shl <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @shl_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: shl_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = shl <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @shl_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: shl_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = shl <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sdiv_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sdiv_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sdiv <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sdiv_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sdiv_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sdiv <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sdiv_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sdiv_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sdiv <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @srem_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: srem_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = srem <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @srem_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: srem_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = srem <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @srem_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: srem_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = srem <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @udiv_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: udiv_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = udiv <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @udiv_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: udiv_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = udiv <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @udiv_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: udiv_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = udiv <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @urem_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: urem_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = urem <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @urem_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: urem_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = urem <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @urem_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: urem_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = urem <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mulhu_vx_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhu_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, 57
; CHECK-NEXT:    vmulhu.vx v25, v25, a1
; CHECK-NEXT:    vsrl.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhu_vx_v8i16(<8 x i16>* %x) {
; LMULMAX1-RV32-LABEL: mulhu_vx_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, 2
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1171
; LMULMAX1-RV32-NEXT:    vmulhu.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_vx_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 2
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1171
; LMULMAX1-RV64-NEXT:    vmulhu.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = udiv <8 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhu_vx_v4i32(<4 x i32>* %x) {
; LMULMAX1-RV32-LABEL: mulhu_vx_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, 838861
; LMULMAX1-RV32-NEXT:    addi a1, a1, -819
; LMULMAX1-RV32-NEXT:    vmulhu.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_vx_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 838861
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX1-RV64-NEXT:    vmulhu.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = udiv <4 x i32> %a, <i32 5, i32 5, i32 5, i32 5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhu_vx_v2i64(<2 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhu_vx_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI252_0)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI252_0)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmulhu.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI252_1)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI252_1)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_vx_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 1026731
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    vmulhu.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = udiv <2 x i64> %a, <i64 3, i64 3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @mulhs_vx_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhs_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -123
; CHECK-NEXT:    vmulhu.vx v25, v25, a1
; CHECK-NEXT:    vsrl.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhs_vx_v8i16(<8 x i16>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_vx_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, -1755
; LMULMAX1-RV32-NEXT:    vmulh.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 15
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_vx_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1755
; LMULMAX1-RV64-NEXT:    vmulh.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 15
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = sdiv <8 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhs_vx_v4i32(<4 x i32>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_vx_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, 629146
; LMULMAX1-RV32-NEXT:    addi a1, a1, -1639
; LMULMAX1-RV32-NEXT:    vmulh.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_vx_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 629146
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1639
; LMULMAX1-RV64-NEXT:    vmulh.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 31
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = sdiv <4 x i32> %a, <i32 -5, i32 -5, i32 -5, i32 -5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhs_vx_v2i64(<2 x i64>* %x) {
; LMULMAX1-RV32-LABEL: mulhs_vx_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI256_0)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI256_0)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmulh.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, %hi(.LCPI256_1)
; LMULMAX1-RV32-NEXT:    addi a1, a1, %lo(.LCPI256_1)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_vx_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    lui a1, 21845
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1366
; LMULMAX1-RV64-NEXT:    vmulh.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    addi a1, zero, 63
; LMULMAX1-RV64-NEXT:    vsrl.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = sdiv <2 x i64> %a, <i64 3, i64 3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}
