; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,CHECK-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,CHECK-BE

; This file does not contain many test cases involving comparisons and logical
; comparisons (cmplwi, cmpldi). This is because alternative code is generated
; when there is a compare (logical or not), followed by a sign or zero extend.
; This codegen will be re-evaluated at a later time on whether or not it should
; be emitted on P10.

@globalVal = common dso_local local_unnamed_addr global i8 0, align 1
@globalVal2 = common dso_local local_unnamed_addr global i32 0, align 4
@globalVal3 = common dso_local local_unnamed_addr global i64 0, align 8
@globalVal4 = common dso_local local_unnamed_addr global i16 0, align 2

define dso_local signext i32 @setbc1(i8 %a) {
; CHECK-LABEL: setbc1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i8 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc2(i32 %a) {
; CHECK-LABEL: setbc2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i32 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc3(i64 %a) {
; CHECK-LABEL: setbc3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i64 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc4(i16 %a) {
; CHECK-LABEL: setbc4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i16 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setbc5(i8 %a) {
; CHECK-LABEL: setbc5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i8 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc6(i32 %a) {
; CHECK-LABEL: setbc6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i32 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc7(i64 %a) {
; CHECK-LABEL: setbc7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i64 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc8(i16 %a) {
; CHECK-LABEL: setbc8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, lt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp slt i16 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setbc9(i8 %a) {
; CHECK-LE-LABEL: setbc9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, lt
; CHECK-LE-NEXT:    pstb r3, globalVal@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    addis r4, r2, globalVal@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, lt
; CHECK-BE-NEXT:    stb r3, globalVal@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp slt i8 %a, 1
  %conv1 = zext i1 %cmp to i8
  store i8 %conv1, i8* @globalVal, align 1
  ret void
}

define dso_local void @setbc10(i32 %a) {
; CHECK-LE-LABEL: setbc10:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, lt
; CHECK-LE-NEXT:    pstw r3, globalVal2@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc10:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal2@toc@ha
; CHECK-BE-NEXT:    setbc r3, lt
; CHECK-BE-NEXT:    stw r3, globalVal2@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp slt i32 %a, 1
  %conv1 = zext i1 %cmp to i32
  store i32 %conv1, i32* @globalVal2, align 4
  ret void
}

define dso_local void @setbc11(i64 %a) {
; CHECK-LE-LABEL: setbc11:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpdi r3, 1
; CHECK-LE-NEXT:    setbc r3, lt
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc11:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpdi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setbc r3, lt
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp slt i64 %a, 1
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @globalVal3, align 8
  ret void
}

define dso_local void @setbc12(i16 %a) {
; CHECK-LE-LABEL: setbc12:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, lt
; CHECK-LE-NEXT:    psth r3, globalVal4@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc12:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    extsh r3, r3
; CHECK-BE-NEXT:    addis r4, r2, globalVal4@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, lt
; CHECK-BE-NEXT:    sth r3, globalVal4@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp slt i16 %a, 1
  %conv1 = zext i1 %cmp to i16
  store i16 %conv1, i16* @globalVal4, align 2
  ret void
}

define dso_local signext i32 @setbc13(i8 %a) {
; CHECK-LABEL: setbc13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i8 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc14(i32 %a) {
; CHECK-LABEL: setbc14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc15(i64 %a) {
; CHECK-LABEL: setbc15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc16(i16 %a) {
; CHECK-LABEL: setbc16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i16 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setbc17(i8 %a) {
; CHECK-LABEL: setbc17:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsb r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i8 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc18(i32 %a) {
; CHECK-LABEL: setbc18:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc19(i64 %a) {
; CHECK-LABEL: setbc19:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc20(i16 %a) {
; CHECK-LABEL: setbc20:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    extsh r3, r3
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp sgt i16 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setbc21(i8 %a) {
; CHECK-LE-LABEL: setbc21:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    extsb r3, r3
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, gt
; CHECK-LE-NEXT:    pstb r3, globalVal@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc21:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    extsb r3, r3
; CHECK-BE-NEXT:    addis r4, r2, globalVal@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, gt
; CHECK-BE-NEXT:    stb r3, globalVal@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp sgt i8 %a, 1
  %conv1 = zext i1 %cmp to i8
  store i8 %conv1, i8* @globalVal, align 1
  ret void
}

define dso_local void @setbc22(i32 %a) {
; CHECK-LE-LABEL: setbc22:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, gt
; CHECK-LE-NEXT:    pstw r3, globalVal2@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc22:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal2@toc@ha
; CHECK-BE-NEXT:    setbc r3, gt
; CHECK-BE-NEXT:    stw r3, globalVal2@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 1
  %conv1 = zext i1 %cmp to i32
  store i32 %conv1, i32* @globalVal2, align 4
  ret void
}

define dso_local void @setbc23(i64 %a) {
; CHECK-LE-LABEL: setbc23:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpdi r3, 1
; CHECK-LE-NEXT:    setbc r3, gt
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc23:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpdi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setbc r3, gt
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 1
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @globalVal3, align 8
  ret void
}

define dso_local void @setbc24(i16 %a) {
; CHECK-LE-LABEL: setbc24:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    extsh r3, r3
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, gt
; CHECK-LE-NEXT:    psth r3, globalVal4@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc24:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    extsh r3, r3
; CHECK-BE-NEXT:    addis r4, r2, globalVal4@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, gt
; CHECK-BE-NEXT:    sth r3, globalVal4@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp sgt i16 %a, 1
  %conv1 = zext i1 %cmp to i16
  store i16 %conv1, i16* @globalVal4, align 2
  ret void
}

define dso_local signext i32 @setbc25(i8 %a) {
; CHECK-LABEL: setbc25:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 24
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i8 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc26(i32 %a) {
; CHECK-LABEL: setbc26:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc27(i64 %a) {
; CHECK-LABEL: setbc27:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i64 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setbc28(i16 %a) {
; CHECK-LABEL: setbc28:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 16
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i16 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setbc29(i8 %a) {
; CHECK-LABEL: setbc29:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 24
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i8 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc30(i32 %a) {
; CHECK-LABEL: setbc30:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc31(i64 %a) {
; CHECK-LABEL: setbc31:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i64 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setbc32(i16 %a) {
; CHECK-LABEL: setbc32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 16
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setbc r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp eq i16 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setbc33(i8 %a) {
; CHECK-LE-LABEL: setbc33:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrlwi r3, r3, 24
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, eq
; CHECK-LE-NEXT:    pstb r3, globalVal@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc33:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrlwi r3, r3, 24
; CHECK-BE-NEXT:    addis r4, r2, globalVal@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, eq
; CHECK-BE-NEXT:    stb r3, globalVal@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp eq i8 %a, 1
  %conv1 = zext i1 %cmp to i8
  store i8 %conv1, i8* @globalVal, align 1
  ret void
}

define dso_local void @setbc34(i32 %a) {
; CHECK-LE-LABEL: setbc34:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, eq
; CHECK-LE-NEXT:    pstw r3, globalVal2@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc34:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal2@toc@ha
; CHECK-BE-NEXT:    setbc r3, eq
; CHECK-BE-NEXT:    stw r3, globalVal2@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp eq i32 %a, 1
  %conv1 = zext i1 %cmp to i32
  store i32 %conv1, i32* @globalVal2, align 4
  ret void
}

define dso_local void @setbc35(i64 %a) {
; CHECK-LE-LABEL: setbc35:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpdi r3, 1
; CHECK-LE-NEXT:    setbc r3, eq
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc35:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpdi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setbc r3, eq
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp eq i64 %a, 1
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @globalVal3, align 8
  ret void
}

define dso_local void @setbc36(i16 %a) {
; CHECK-LE-LABEL: setbc36:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrlwi r3, r3, 16
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setbc r3, eq
; CHECK-LE-NEXT:    psth r3, globalVal4@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc36:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrlwi r3, r3, 16
; CHECK-BE-NEXT:    addis r4, r2, globalVal4@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setbc r3, eq
; CHECK-BE-NEXT:    sth r3, globalVal4@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp eq i16 %a, 1
  %conv1 = zext i1 %cmp to i16
  store i16 %conv1, i16* @globalVal4, align 2
  ret void
}

define dso_local signext i32 @setbc37(i64 %a) {
; CHECK-LABEL: setbc37:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpldi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ugt i64 %a, 1
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setbc38(i64 %a) {
; CHECK-LABEL: setbc38:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpldi r3, 1
; CHECK-NEXT:    setbc r3, gt
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ugt i64 %a, 1
  %conv = zext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setbc39(i64 %a) {
; CHECK-LE-LABEL: setbc39:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpldi r3, 1
; CHECK-LE-NEXT:    setbc r3, gt
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setbc39:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpldi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setbc r3, gt
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp ugt i64 %a, 1
  %conv1 = zext i1 %cmp to i64
  store i64 %conv1, i64* @globalVal3, align 8
  ret void
}
