; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=tahiti -o - %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=fiji -o - %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx900 -o - %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -o - %s | FileCheck -check-prefix=GFX10 %s

define i7 @v_saddsat_i7(i7 %lhs, i7 %rhs) {
; GFX6-LABEL: v_saddsat_i7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 25, v0
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 25, v1
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, 0x80000000, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x7fffffff, v2
; GFX6-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 25, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 9, v0
; GFX8-NEXT:    v_min_i16_e32 v3, 0, v0
; GFX8-NEXT:    v_max_i16_e32 v2, 0, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 9, v1
; GFX8-NEXT:    v_sub_u16_e32 v3, 0x8000, v3
; GFX8-NEXT:    v_sub_u16_e32 v2, 0x7fff, v2
; GFX8-NEXT:    v_max_i16_e32 v1, v3, v1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v2
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    v_ashrrev_i16_e32 v0, 9, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 9, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 9, v1
; GFX9-NEXT:    v_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, 9, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b16_e64 v0, 9, v0
; GFX10-NEXT:    v_lshlrev_b16_e64 v1, 9, v1
; GFX10-NEXT:    v_add_nc_i16 v0, v0, v1 clamp
; GFX10-NEXT:    v_ashrrev_i16_e64 v0, 9, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i7 @llvm.sadd.sat.i7(i7 %lhs, i7 %rhs)
  ret i7 %result
}

define amdgpu_ps i7 @s_saddsat_i7(i7 inreg %lhs, i7 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i7:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 25
; GFX6-NEXT:    s_min_i32 s3, s0, 0
; GFX6-NEXT:    s_max_i32 s2, s0, 0
; GFX6-NEXT:    s_lshl_b32 s1, s1, 25
; GFX6-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX6-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX6-NEXT:    s_max_i32 s1, s3, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_ashr_i32 s0, s0, 25
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i7:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    s_sext_i32_i16 s3, s0
; GFX8-NEXT:    s_sext_i32_i16 s4, 0
; GFX8-NEXT:    s_max_i32 s5, s3, s4
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, s2
; GFX8-NEXT:    s_sub_i32 s3, 0xffff8000, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s3, s1
; GFX8-NEXT:    s_sub_i32 s5, 0x7fff, s5
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s3, s5
; GFX8-NEXT:    s_min_i32 s1, s1, s3
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    s_sext_i32_i16 s0, s0
; GFX8-NEXT:    s_ashr_i32 s0, s0, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, 9, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i7:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_bfe_u32 s2, 9, 0x100000
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    v_add_nc_i16 v0, s0, s1 clamp
; GFX10-NEXT:    v_ashrrev_i16_e64 v0, 9, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i7 @llvm.sadd.sat.i7(i7 %lhs, i7 %rhs)
  ret i7 %result
}

define i8 @v_saddsat_i8(i8 %lhs, i8 %rhs) {
; GFX6-LABEL: v_saddsat_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, 0x80000000, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x7fffffff, v2
; GFX6-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    v_min_i16_e32 v3, 0, v0
; GFX8-NEXT:    v_max_i16_e32 v2, 0, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_sub_u16_e32 v3, 0x8000, v3
; GFX8-NEXT:    v_sub_u16_e32 v2, 0x7fff, v2
; GFX8-NEXT:    v_max_i16_e32 v1, v3, v1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v2
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    v_ashrrev_i16_e32 v0, 8, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX9-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX9-NEXT:    v_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b16_e64 v0, 8, v0
; GFX10-NEXT:    v_lshlrev_b16_e64 v1, 8, v1
; GFX10-NEXT:    v_add_nc_i16 v0, v0, v1 clamp
; GFX10-NEXT:    v_ashrrev_i16_e64 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i8 @llvm.sadd.sat.i8(i8 %lhs, i8 %rhs)
  ret i8 %result
}

define amdgpu_ps i8 @s_saddsat_i8(i8 inreg %lhs, i8 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_min_i32 s3, s0, 0
; GFX6-NEXT:    s_max_i32 s2, s0, 0
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX6-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX6-NEXT:    s_max_i32 s1, s3, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_ashr_i32 s0, s0, 24
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX8-NEXT:    s_lshl_b32 s0, s0, s2
; GFX8-NEXT:    s_sext_i32_i16 s3, s0
; GFX8-NEXT:    s_sext_i32_i16 s4, 0
; GFX8-NEXT:    s_max_i32 s5, s3, s4
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, s2
; GFX8-NEXT:    s_sub_i32 s3, 0xffff8000, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s3, s1
; GFX8-NEXT:    s_sub_i32 s5, 0x7fff, s5
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s3, s5
; GFX8-NEXT:    s_min_i32 s1, s1, s3
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    s_sext_i32_i16 s0, s0
; GFX8-NEXT:    s_ashr_i32 s0, s0, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_ashrrev_i16_e32 v0, 8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_bfe_u32 s2, 8, 0x100000
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    v_add_nc_i16 v0, s0, s1 clamp
; GFX10-NEXT:    v_ashrrev_i16_e64 v0, 8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i8 @llvm.sadd.sat.i8(i8 %lhs, i8 %rhs)
  ret i8 %result
}

define i16 @v_saddsat_v2i8(i16 %lhs.arg, i16 %rhs.arg) {
; GFX6-LABEL: v_saddsat_v2i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v5, 0, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 8, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s5, v5
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s4, v4
; GFX6-NEXT:    v_max_i32_e32 v1, v5, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v4
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX6-NEXT:    v_min_i32_e32 v4, 0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX6-NEXT:    v_max_i32_e32 v3, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s5, v4
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s4, v3
; GFX6-NEXT:    v_max_i32_e32 v2, v4, v2
; GFX6-NEXT:    v_min_i32_e32 v2, v2, v3
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 24, v1
; GFX6-NEXT:    v_mov_b32_e32 v2, 0xff
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX6-NEXT:    v_and_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v2i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v2, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v5, 0, v0
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v2, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_sub_u16_e32 v5, s5, v5
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v4, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v4, s4, v4
; GFX8-NEXT:    v_max_i16_e32 v1, v5, v1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v4
; GFX8-NEXT:    v_min_i16_e32 v4, 0, v3
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    v_max_i16_e32 v1, 0, v3
; GFX8-NEXT:    v_sub_u16_e32 v4, s5, v4
; GFX8-NEXT:    v_sub_u16_e32 v1, s4, v1
; GFX8-NEXT:    v_max_i16_e32 v2, v4, v2
; GFX8-NEXT:    v_min_i16_e32 v1, v2, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, 0xff
; GFX8-NEXT:    v_add_u16_e32 v1, v3, v1
; GFX8-NEXT:    v_and_b32_sdwa v0, sext(v0), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v1, sext(v1), v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v2i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_sdwa v3, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NEXT:    v_and_or_b32 v0, v0, v4, v2
; GFX9-NEXT:    v_and_or_b32 v1, v1, v4, v3
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_and_b32_sdwa v1, v0, s4 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v2i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_mov_b32_e32 v2, 0xffff
; GFX10-NEXT:    v_lshrrev_b32_sdwa v3, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_lshrrev_b32_sdwa v4, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    s_movk_i32 s4, 0xff
; GFX10-NEXT:    v_and_or_b32 v0, v0, v2, v3
; GFX10-NEXT:    v_and_or_b32 v1, v1, v2, v4
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX10-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_b32_sdwa v1, v0, s4 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %lhs = bitcast i16 %lhs.arg to <2 x i8>
  %rhs = bitcast i16 %rhs.arg to <2 x i8>
  %result = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %lhs, <2 x i8> %rhs)
  %cast.result = bitcast <2 x i8> %result to i16
  ret i16 %cast.result
}

define amdgpu_ps i16 @s_saddsat_v2i8(i16 inreg %lhs.arg, i16 inreg %rhs.arg) {
; GFX6-LABEL: s_saddsat_v2i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s2, s0, 8
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    s_min_i32 s7, s0, 0
; GFX6-NEXT:    s_lshr_b32 s3, s1, 8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_sub_i32 s7, s5, s7
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    s_max_i32 s6, s0, 0
; GFX6-NEXT:    s_sub_i32 s6, s4, s6
; GFX6-NEXT:    s_max_i32 s1, s7, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s6
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 24
; GFX6-NEXT:    s_lshl_b32 s2, s3, 24
; GFX6-NEXT:    s_max_i32 s3, s1, 0
; GFX6-NEXT:    s_sub_i32 s3, s4, s3
; GFX6-NEXT:    s_min_i32 s4, s1, 0
; GFX6-NEXT:    s_sub_i32 s4, s5, s4
; GFX6-NEXT:    s_max_i32 s2, s4, s2
; GFX6-NEXT:    s_min_i32 s2, s2, s3
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_ashr_i32 s1, s1, 24
; GFX6-NEXT:    s_movk_i32 s2, 0xff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 24
; GFX6-NEXT:    s_and_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s0, s0, s2
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v2i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s4, 8, 0x100000
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_lshl_b32 s0, s0, s4
; GFX8-NEXT:    s_sext_i32_i16 s7, s0
; GFX8-NEXT:    s_sext_i32_i16 s8, 0
; GFX8-NEXT:    s_max_i32 s9, s7, s8
; GFX8-NEXT:    s_movk_i32 s6, 0x8000
; GFX8-NEXT:    s_min_i32 s7, s7, s8
; GFX8-NEXT:    s_sub_i32 s7, s6, s7
; GFX8-NEXT:    s_lshr_b32 s3, s1, 8
; GFX8-NEXT:    s_lshl_b32 s1, s1, s4
; GFX8-NEXT:    s_movk_i32 s5, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s7, s7
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s7, s1
; GFX8-NEXT:    s_sub_i32 s9, s5, s9
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s7, s9
; GFX8-NEXT:    s_min_i32 s1, s1, s7
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s4
; GFX8-NEXT:    s_lshl_b32 s2, s3, s4
; GFX8-NEXT:    s_sext_i32_i16 s3, s1
; GFX8-NEXT:    s_max_i32 s7, s3, s8
; GFX8-NEXT:    s_min_i32 s3, s3, s8
; GFX8-NEXT:    s_sub_i32 s3, s6, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_max_i32 s2, s3, s2
; GFX8-NEXT:    s_sub_i32 s5, s5, s7
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s3, s5
; GFX8-NEXT:    s_min_i32 s2, s2, s3
; GFX8-NEXT:    s_add_i32 s1, s1, s2
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s0, s0
; GFX8-NEXT:    s_ashr_i32 s1, s1, s4
; GFX8-NEXT:    s_movk_i32 s2, 0xff
; GFX8-NEXT:    s_ashr_i32 s0, s0, s4
; GFX8-NEXT:    s_and_b32 s1, s1, s2
; GFX8-NEXT:    s_and_b32 s0, s0, s2
; GFX8-NEXT:    s_lshl_b32 s1, s1, s4
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v2i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_lshr_b32 s3, s1, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s3
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_mov_b32 s2, 0x80008
; GFX9-NEXT:    s_lshl_b32 s0, s0, s2
; GFX9-NEXT:    s_lshl_b32 s3, s3, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s3
; GFX9-NEXT:    s_lshr_b32 s3, s1, 16
; GFX9-NEXT:    s_lshl_b32 s1, s1, s2
; GFX9-NEXT:    s_lshl_b32 s2, s3, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s2
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_and_b32_sdwa v1, v0, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v2i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshr_b32 s2, s0, 8
; GFX10-NEXT:    s_lshr_b32 s3, s1, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s3
; GFX10-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-NEXT:    s_mov_b32 s2, 0x80008
; GFX10-NEXT:    s_lshr_b32 s4, s1, 16
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s3, s3, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    s_lshl_b32 s2, s4, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s3
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s2
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s1 clamp
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_b32_sdwa v1, v0, s0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %lhs = bitcast i16 %lhs.arg to <2 x i8>
  %rhs = bitcast i16 %rhs.arg to <2 x i8>
  %result = call <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8> %lhs, <2 x i8> %rhs)
  %cast.result = bitcast <2 x i8> %result to i16
  ret i16 %cast.result
}

define i32 @v_saddsat_v4i8(i32 %lhs.arg, i32 %rhs.arg) {
; GFX6-LABEL: v_saddsat_v4i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 8, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 24, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX6-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, s5, v10
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v8, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s4, v8
; GFX6-NEXT:    v_max_i32_e32 v1, v10, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v8
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v2
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v5
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s5, v8
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s4, v5
; GFX6-NEXT:    v_max_i32_e32 v2, v8, v2
; GFX6-NEXT:    v_min_i32_e32 v2, v2, v5
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 24, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 24, v6
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, s5, v6
; GFX6-NEXT:    v_bfrev_b32_e32 v9, -2
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v9, v5
; GFX6-NEXT:    v_max_i32_e32 v3, v6, v3
; GFX6-NEXT:    v_min_i32_e32 v3, v3, v5
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 24, v4
; GFX6-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v3
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v3
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 24, v1
; GFX6-NEXT:    s_movk_i32 s4, 0xff
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 24, v7
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, v11, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v9, v5
; GFX6-NEXT:    v_max_i32_e32 v4, v6, v4
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v5
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 24, v2
; GFX6-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 24, v3
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 24, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v4i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 8
; GFX8-NEXT:    v_lshrrev_b32_sdwa v3, v2, v0 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 24, v0
; GFX8-NEXT:    v_lshlrev_b16_e32 v0, 8, v0
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v10, 0, v0
; GFX8-NEXT:    v_lshrrev_b32_sdwa v2, v2, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v1, 8, v1
; GFX8-NEXT:    v_sub_u16_e32 v10, s5, v10
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v8, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v8, s4, v8
; GFX8-NEXT:    v_max_i16_e32 v1, v10, v1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v8
; GFX8-NEXT:    v_min_i16_e32 v8, 0, v3
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    v_max_i16_e32 v1, 0, v3
; GFX8-NEXT:    v_sub_u16_e32 v8, s5, v8
; GFX8-NEXT:    v_sub_u16_e32 v1, s4, v1
; GFX8-NEXT:    v_max_i16_e32 v2, v8, v2
; GFX8-NEXT:    v_min_i16_e32 v1, v2, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v2, 8, v4
; GFX8-NEXT:    v_add_u16_e32 v1, v3, v1
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v6
; GFX8-NEXT:    v_min_i16_e32 v6, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v6, s5, v6
; GFX8-NEXT:    v_mov_b32_e32 v9, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v4, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v4, v9, v4
; GFX8-NEXT:    v_max_i16_e32 v3, v6, v3
; GFX8-NEXT:    v_min_i16_e32 v3, v3, v4
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v3, 8, v5
; GFX8-NEXT:    v_min_i16_e32 v6, 0, v3
; GFX8-NEXT:    v_max_i16_e32 v5, 0, v3
; GFX8-NEXT:    v_lshlrev_b16_e32 v4, 8, v7
; GFX8-NEXT:    v_sub_u16_e32 v6, 0x8000, v6
; GFX8-NEXT:    v_sub_u16_e32 v5, v9, v5
; GFX8-NEXT:    v_max_i16_e32 v4, v6, v4
; GFX8-NEXT:    v_min_i16_e32 v4, v4, v5
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v4
; GFX8-NEXT:    v_mov_b32_e32 v4, 0xff
; GFX8-NEXT:    v_and_b32_sdwa v1, sext(v1), v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_and_b32_sdwa v0, sext(v0), v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, sext(v2), v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_and_b32_sdwa v1, sext(v3), v4 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v4i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 8
; GFX9-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_sdwa v5, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX9-NEXT:    v_mov_b32_e32 v8, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX9-NEXT:    v_and_or_b32 v0, v0, v8, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_and_or_b32 v1, v1, v8, v5
; GFX9-NEXT:    v_and_or_b32 v2, v3, v8, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX9-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_and_or_b32 v3, v6, v8, v3
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    v_pk_lshlrev_b16 v2, 8, v2 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_lshlrev_b16 v3, 8, v3 op_sel_hi:[0,1]
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s4, 0xff
; GFX9-NEXT:    v_pk_add_i16 v1, v2, v3 clamp
; GFX9-NEXT:    v_and_b32_sdwa v2, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX9-NEXT:    v_pk_ashrrev_i16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_and_or_b32 v0, v0, s4, v2
; GFX9-NEXT:    v_and_b32_e32 v2, s4, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s4 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v4i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_mov_b32 s4, 8
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 24, v0
; GFX10-NEXT:    v_lshrrev_b32_sdwa v2, s4, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_lshrrev_b32_sdwa v6, s4, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX10-NEXT:    v_mov_b32_e32 v5, 0xffff
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX10-NEXT:    v_and_or_b32 v0, v0, v5, v2
; GFX10-NEXT:    v_and_or_b32 v1, v1, v5, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; GFX10-NEXT:    s_movk_i32 s4, 0xff
; GFX10-NEXT:    v_and_or_b32 v3, v3, v5, v4
; GFX10-NEXT:    v_pk_lshlrev_b16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_lshlrev_b16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_and_or_b32 v2, v8, v5, v2
; GFX10-NEXT:    v_pk_lshlrev_b16 v3, 8, v3 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX10-NEXT:    v_pk_lshlrev_b16 v1, 8, v2 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_i16 v1, v3, v1 clamp
; GFX10-NEXT:    v_and_b32_sdwa v2, v0, s4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pk_ashrrev_i16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX10-NEXT:    v_and_b32_e32 v3, s4, v1
; GFX10-NEXT:    v_and_b32_sdwa v1, v1, s4 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_and_or_b32 v0, v0, s4, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %lhs = bitcast i32 %lhs.arg to <4 x i8>
  %rhs = bitcast i32 %rhs.arg to <4 x i8>
  %result = call <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8> %lhs, <4 x i8> %rhs)
  %cast.result = bitcast <4 x i8> %result to i32
  ret i32 %cast.result
}

define amdgpu_ps i32 @s_saddsat_v4i8(i32 inreg %lhs.arg, i32 inreg %rhs.arg) {
; GFX6-LABEL: s_saddsat_v4i8:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s2, s0, 8
; GFX6-NEXT:    s_lshr_b32 s3, s0, 16
; GFX6-NEXT:    s_lshr_b32 s4, s0, 24
; GFX6-NEXT:    s_lshl_b32 s0, s0, 24
; GFX6-NEXT:    s_brev_b32 s9, 1
; GFX6-NEXT:    s_min_i32 s11, s0, 0
; GFX6-NEXT:    s_lshr_b32 s5, s1, 8
; GFX6-NEXT:    s_lshr_b32 s6, s1, 16
; GFX6-NEXT:    s_lshr_b32 s7, s1, 24
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_sub_i32 s11, s9, s11
; GFX6-NEXT:    s_brev_b32 s8, -2
; GFX6-NEXT:    s_max_i32 s10, s0, 0
; GFX6-NEXT:    s_sub_i32 s10, s8, s10
; GFX6-NEXT:    s_max_i32 s1, s11, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s10
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 24
; GFX6-NEXT:    s_min_i32 s10, s1, 0
; GFX6-NEXT:    s_lshl_b32 s2, s5, 24
; GFX6-NEXT:    s_max_i32 s5, s1, 0
; GFX6-NEXT:    s_sub_i32 s10, s9, s10
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s2, s10, s2
; GFX6-NEXT:    s_min_i32 s2, s2, s5
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_lshl_b32 s2, s3, 24
; GFX6-NEXT:    s_lshl_b32 s3, s6, 24
; GFX6-NEXT:    s_min_i32 s6, s2, 0
; GFX6-NEXT:    s_max_i32 s5, s2, 0
; GFX6-NEXT:    s_sub_i32 s6, s9, s6
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s3, s6, s3
; GFX6-NEXT:    s_min_i32 s3, s3, s5
; GFX6-NEXT:    s_add_i32 s2, s2, s3
; GFX6-NEXT:    s_lshl_b32 s3, s4, 24
; GFX6-NEXT:    s_min_i32 s6, s3, 0
; GFX6-NEXT:    s_max_i32 s5, s3, 0
; GFX6-NEXT:    s_lshl_b32 s4, s7, 24
; GFX6-NEXT:    s_sub_i32 s6, s9, s6
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s4, s6, s4
; GFX6-NEXT:    s_min_i32 s4, s4, s5
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    s_ashr_i32 s1, s1, 24
; GFX6-NEXT:    s_movk_i32 s4, 0xff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 24
; GFX6-NEXT:    s_and_b32 s1, s1, s4
; GFX6-NEXT:    s_ashr_i32 s2, s2, 24
; GFX6-NEXT:    s_and_b32 s0, s0, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_ashr_i32 s3, s3, 24
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s3, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 24
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v4i8:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_bfe_u32 s8, 8, 0x100000
; GFX8-NEXT:    s_lshr_b32 s2, s0, 8
; GFX8-NEXT:    s_lshr_b32 s3, s0, 16
; GFX8-NEXT:    s_lshr_b32 s4, s0, 24
; GFX8-NEXT:    s_lshl_b32 s0, s0, s8
; GFX8-NEXT:    s_sext_i32_i16 s11, s0
; GFX8-NEXT:    s_sext_i32_i16 s12, 0
; GFX8-NEXT:    s_max_i32 s13, s11, s12
; GFX8-NEXT:    s_movk_i32 s10, 0x8000
; GFX8-NEXT:    s_min_i32 s11, s11, s12
; GFX8-NEXT:    s_sub_i32 s11, s10, s11
; GFX8-NEXT:    s_lshr_b32 s5, s1, 8
; GFX8-NEXT:    s_lshr_b32 s6, s1, 16
; GFX8-NEXT:    s_lshr_b32 s7, s1, 24
; GFX8-NEXT:    s_lshl_b32 s1, s1, s8
; GFX8-NEXT:    s_movk_i32 s9, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s11, s11
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s11, s1
; GFX8-NEXT:    s_sub_i32 s13, s9, s13
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s11, s13
; GFX8-NEXT:    s_min_i32 s1, s1, s11
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    s_lshl_b32 s1, s2, s8
; GFX8-NEXT:    s_lshl_b32 s2, s5, s8
; GFX8-NEXT:    s_sext_i32_i16 s5, s1
; GFX8-NEXT:    s_max_i32 s11, s5, s12
; GFX8-NEXT:    s_min_i32 s5, s5, s12
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_max_i32 s2, s5, s2
; GFX8-NEXT:    s_sub_i32 s11, s9, s11
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s5, s11
; GFX8-NEXT:    s_min_i32 s2, s2, s5
; GFX8-NEXT:    s_add_i32 s1, s1, s2
; GFX8-NEXT:    s_lshl_b32 s2, s3, s8
; GFX8-NEXT:    s_sext_i32_i16 s5, s2
; GFX8-NEXT:    s_lshl_b32 s3, s6, s8
; GFX8-NEXT:    s_max_i32 s6, s5, s12
; GFX8-NEXT:    s_min_i32 s5, s5, s12
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_max_i32 s3, s5, s3
; GFX8-NEXT:    s_sub_i32 s6, s9, s6
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s5, s6
; GFX8-NEXT:    s_min_i32 s3, s3, s5
; GFX8-NEXT:    s_add_i32 s2, s2, s3
; GFX8-NEXT:    s_lshl_b32 s3, s4, s8
; GFX8-NEXT:    s_sext_i32_i16 s5, s3
; GFX8-NEXT:    s_max_i32 s6, s5, s12
; GFX8-NEXT:    s_min_i32 s5, s5, s12
; GFX8-NEXT:    s_lshl_b32 s4, s7, s8
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_max_i32 s4, s5, s4
; GFX8-NEXT:    s_sub_i32 s6, s9, s6
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s6
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s3, s3, s4
; GFX8-NEXT:    s_sext_i32_i16 s0, s0
; GFX8-NEXT:    s_ashr_i32 s1, s1, s8
; GFX8-NEXT:    s_movk_i32 s4, 0xff
; GFX8-NEXT:    s_ashr_i32 s0, s0, s8
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_and_b32 s1, s1, s4
; GFX8-NEXT:    s_ashr_i32 s2, s2, s8
; GFX8-NEXT:    s_and_b32 s0, s0, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 8
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s2, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_ashr_i32 s3, s3, s8
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    s_and_b32 s1, s3, s4
; GFX8-NEXT:    s_lshl_b32 s1, s1, 24
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v4i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshr_b32 s2, s0, 8
; GFX9-NEXT:    s_lshr_b32 s3, s0, 16
; GFX9-NEXT:    s_lshr_b32 s4, s0, 24
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s3, s4
; GFX9-NEXT:    s_lshr_b32 s4, s0, 16
; GFX9-NEXT:    s_mov_b32 s3, 0x80008
; GFX9-NEXT:    s_lshr_b32 s5, s1, 8
; GFX9-NEXT:    s_lshl_b32 s0, s0, s3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s0, s0, s4
; GFX9-NEXT:    s_lshr_b32 s4, s2, 16
; GFX9-NEXT:    s_lshr_b32 s6, s1, 16
; GFX9-NEXT:    s_lshr_b32 s7, s1, 24
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX9-NEXT:    s_lshr_b32 s5, s1, 16
; GFX9-NEXT:    s_lshl_b32 s2, s2, s3
; GFX9-NEXT:    s_lshl_b32 s4, s4, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s2, s4
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s6, s7
; GFX9-NEXT:    s_lshl_b32 s1, s1, s3
; GFX9-NEXT:    s_lshl_b32 s5, s5, 8
; GFX9-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX9-NEXT:    s_lshr_b32 s5, s4, 16
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    s_lshl_b32 s3, s4, s3
; GFX9-NEXT:    s_lshl_b32 s4, s5, 8
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s3, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX9-NEXT:    s_movk_i32 s0, 0xff
; GFX9-NEXT:    v_pk_add_i16 v1, s2, v1 clamp
; GFX9-NEXT:    v_and_b32_sdwa v2, v0, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX9-NEXT:    v_pk_ashrrev_i16 v1, 8, v1 op_sel_hi:[0,1]
; GFX9-NEXT:    v_and_or_b32 v0, v0, s0, v2
; GFX9-NEXT:    v_and_b32_e32 v2, s0, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX9-NEXT:    v_and_b32_sdwa v1, v1, s0 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v4i8:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshr_b32 s2, s0, 8
; GFX10-NEXT:    s_lshr_b32 s5, s1, 8
; GFX10-NEXT:    s_lshr_b32 s3, s0, 16
; GFX10-NEXT:    s_lshr_b32 s4, s0, 24
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s2
; GFX10-NEXT:    s_lshr_b32 s6, s1, 16
; GFX10-NEXT:    s_lshr_b32 s7, s1, 24
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX10-NEXT:    s_lshr_b32 s8, s0, 16
; GFX10-NEXT:    s_lshr_b32 s5, s1, 16
; GFX10-NEXT:    s_mov_b32 s2, 0x80008
; GFX10-NEXT:    s_lshl_b32 s8, s8, 8
; GFX10-NEXT:    s_lshl_b32 s0, s0, s2
; GFX10-NEXT:    s_lshl_b32 s1, s1, s2
; GFX10-NEXT:    s_lshl_b32 s5, s5, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s3, s3, s4
; GFX10-NEXT:    s_pack_ll_b32_b16 s6, s6, s7
; GFX10-NEXT:    s_pack_ll_b32_b16 s1, s1, s5
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s8
; GFX10-NEXT:    s_lshr_b32 s4, s3, 16
; GFX10-NEXT:    s_lshr_b32 s5, s6, 16
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s1 clamp
; GFX10-NEXT:    s_lshl_b32 s3, s3, s2
; GFX10-NEXT:    s_lshl_b32 s4, s4, 8
; GFX10-NEXT:    s_lshl_b32 s0, s6, s2
; GFX10-NEXT:    s_lshl_b32 s1, s5, 8
; GFX10-NEXT:    s_pack_ll_b32_b16 s2, s3, s4
; GFX10-NEXT:    s_pack_ll_b32_b16 s0, s0, s1
; GFX10-NEXT:    v_pk_ashrrev_i16 v0, 8, v0 op_sel_hi:[0,1]
; GFX10-NEXT:    v_pk_add_i16 v1, s2, s0 clamp
; GFX10-NEXT:    s_movk_i32 s0, 0xff
; GFX10-NEXT:    v_and_b32_sdwa v2, v0, s0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_pk_ashrrev_i16 v1, 8, v1 op_sel_hi:[0,1]
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; GFX10-NEXT:    v_and_b32_e32 v3, s0, v1
; GFX10-NEXT:    v_and_b32_sdwa v1, v1, s0 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_and_or_b32 v0, v0, s0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX10-NEXT:    v_or3_b32 v0, v0, v2, v1
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %lhs = bitcast i32 %lhs.arg to <4 x i8>
  %rhs = bitcast i32 %rhs.arg to <4 x i8>
  %result = call <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8> %lhs, <4 x i8> %rhs)
  %cast.result = bitcast <4 x i8> %result to i32
  ret i32 %cast.result
}

define i24 @v_saddsat_i24(i24 %lhs, i24 %rhs) {
; GFX6-LABEL: v_saddsat_i24:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, 0x80000000, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x7fffffff, v2
; GFX6-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 8, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i24:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v0, v1
; GFX8-NEXT:    v_bfe_i32 v3, v2, 0, 24
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 24
; GFX8-NEXT:    v_cmp_lt_i32_e64 s[4:5], v3, v0
; GFX8-NEXT:    v_bfe_i32 v0, v1, 0, 24
; GFX8-NEXT:    v_cmp_gt_i32_e64 s[6:7], 0, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 23, v3
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0xff800000, v0
; GFX8-NEXT:    s_xor_b64 vcc, s[6:7], s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX9-NEXT:    v_add_i32 v0, v0, v1 clamp
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 8, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 8, v1
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v1 clamp
; GFX10-NEXT:    v_ashrrev_i32_e32 v0, 8, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i24 @llvm.sadd.sat.i24(i24 %lhs, i24 %rhs)
  ret i24 %result
}

define amdgpu_ps i24 @s_saddsat_i24(i24 inreg %lhs, i24 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i24:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 8
; GFX6-NEXT:    s_min_i32 s3, s0, 0
; GFX6-NEXT:    s_max_i32 s2, s0, 0
; GFX6-NEXT:    s_lshl_b32 s1, s1, 8
; GFX6-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX6-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX6-NEXT:    s_max_i32 s1, s3, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_ashr_i32 s0, s0, 8
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i24:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_i32 s2, s0, s1
; GFX8-NEXT:    s_bfe_i32 s3, s2, 0x180000
; GFX8-NEXT:    s_bfe_i32 s0, s0, 0x180000
; GFX8-NEXT:    s_cmp_lt_i32 s3, s0
; GFX8-NEXT:    s_cselect_b32 s0, 1, 0
; GFX8-NEXT:    s_bfe_i32 s1, s1, 0x180000
; GFX8-NEXT:    s_cmp_lt_i32 s1, 0
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_xor_b32 s0, s1, s0
; GFX8-NEXT:    s_ashr_i32 s1, s3, 23
; GFX8-NEXT:    s_add_i32 s1, s1, 0xff800000
; GFX8-NEXT:    s_and_b32 s0, s0, 1
; GFX8-NEXT:    s_cmp_lg_u32 s0, 0
; GFX8-NEXT:    s_cselect_b32 s0, s1, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i24:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_lshl_b32 s1, s1, 8
; GFX9-NEXT:    s_lshl_b32 s0, s0, 8
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 8, v0
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i24:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_lshl_b32 s0, s0, 8
; GFX10-NEXT:    s_lshl_b32 s1, s1, 8
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s1 clamp
; GFX10-NEXT:    v_ashrrev_i32_e32 v0, 8, v0
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i24 @llvm.sadd.sat.i24(i24 %lhs, i24 %rhs)
  ret i24 %result
}

define i32 @v_saddsat_i32(i32 %lhs, i32 %rhs) {
; GFX6-LABEL: v_saddsat_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, 0x80000000, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x7fffffff, v2
; GFX6-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX8-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v3, vcc, 0x80000000, v3
; GFX8-NEXT:    v_sub_u32_e32 v2, vcc, 0x7fffffff, v2
; GFX8-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX8-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i32 @llvm.sadd.sat.i32(i32 %lhs, i32 %rhs)
  ret i32 %result
}

define amdgpu_ps i32 @s_saddsat_i32(i32 inreg %lhs, i32 inreg %rhs) {
; GCN-LABEL: s_saddsat_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_cmp_gt_i32 s0, 0
; GCN-NEXT:    s_cselect_b32 s2, s0, 0
; GCN-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GCN-NEXT:    s_cmp_lt_i32 s0, 0
; GCN-NEXT:    s_cselect_b32 s3, s0, 0
; GCN-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GCN-NEXT:    s_cmp_gt_i32 s3, s1
; GCN-NEXT:    s_cselect_b32 s1, s3, s1
; GCN-NEXT:    s_cmp_lt_i32 s1, s2
; GCN-NEXT:    s_cselect_b32 s1, s1, s2
; GCN-NEXT:    s_add_i32 s0, s0, s1
; GCN-NEXT:    ; return to shader part epilog
; GFX6-LABEL: s_saddsat_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_min_i32 s3, s0, 0
; GFX6-NEXT:    s_max_i32 s2, s0, 0
; GFX6-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX6-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX6-NEXT:    s_max_i32 s1, s3, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_min_i32 s3, s0, 0
; GFX8-NEXT:    s_max_i32 s2, s0, 0
; GFX8-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX8-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX8-NEXT:    s_max_i32 s1, s3, s1
; GFX8-NEXT:    s_min_i32 s1, s1, s2
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.sadd.sat.i32(i32 %lhs, i32 %rhs)
  ret i32 %result
}

define amdgpu_ps float @saddsat_i32_sv(i32 inreg %lhs, i32 %rhs) {
; GFX6-LABEL: saddsat_i32_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_min_i32 s2, s0, 0
; GFX6-NEXT:    s_max_i32 s1, s0, 0
; GFX6-NEXT:    s_sub_i32 s2, 0x80000000, s2
; GFX6-NEXT:    s_sub_i32 s1, 0x7fffffff, s1
; GFX6-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX6-NEXT:    v_min_i32_e32 v0, s1, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i32_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_min_i32 s2, s0, 0
; GFX8-NEXT:    s_max_i32 s1, s0, 0
; GFX8-NEXT:    s_sub_i32 s2, 0x80000000, s2
; GFX8-NEXT:    s_sub_i32 s1, 0x7fffffff, s1
; GFX8-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX8-NEXT:    v_min_i32_e32 v0, s1, v0
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i32_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i32_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.sadd.sat.i32(i32 %lhs, i32 %rhs)
  %cast = bitcast i32 %result to float
  ret float %cast
}

define amdgpu_ps float @saddsat_i32_vs(i32 %lhs, i32 inreg %rhs) {
; GFX6-LABEL: saddsat_i32_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_min_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v1, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x80000000, v2
; GFX6-NEXT:    v_sub_i32_e32 v1, vcc, 0x7fffffff, v1
; GFX6-NEXT:    v_max_i32_e32 v2, s0, v2
; GFX6-NEXT:    v_min_i32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i32_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_min_i32_e32 v2, 0, v0
; GFX8-NEXT:    v_max_i32_e32 v1, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v2, vcc, 0x80000000, v2
; GFX8-NEXT:    v_sub_u32_e32 v1, vcc, 0x7fffffff, v1
; GFX8-NEXT:    v_max_i32_e32 v2, s0, v2
; GFX8-NEXT:    v_min_i32_e32 v1, v2, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i32_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_i32 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i32_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i32 @llvm.sadd.sat.i32(i32 %lhs, i32 %rhs)
  %cast = bitcast i32 %result to float
  ret float %cast
}

define <2 x i32> @v_saddsat_v2i32(<2 x i32> %lhs, <2 x i32> %rhs) {
; GFX6-LABEL: v_saddsat_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v5, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s5, v5
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s4, v4
; GFX6-NEXT:    v_max_i32_e32 v2, v5, v2
; GFX6-NEXT:    v_min_i32_e32 v2, v2, v4
; GFX6-NEXT:    v_min_i32_e32 v4, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s5, v4
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, s4, v2
; GFX6-NEXT:    v_max_i32_e32 v3, v4, v3
; GFX6-NEXT:    v_min_i32_e32 v2, v3, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    v_min_i32_e32 v5, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, s5, v5
; GFX8-NEXT:    s_brev_b32 s4, -2
; GFX8-NEXT:    v_max_i32_e32 v4, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, s4, v4
; GFX8-NEXT:    v_max_i32_e32 v2, v5, v2
; GFX8-NEXT:    v_min_i32_e32 v2, v2, v4
; GFX8-NEXT:    v_min_i32_e32 v4, 0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v2
; GFX8-NEXT:    v_max_i32_e32 v2, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, s5, v4
; GFX8-NEXT:    v_sub_u32_e32 v2, vcc, s4, v2
; GFX8-NEXT:    v_max_i32_e32 v3, v4, v3
; GFX8-NEXT:    v_min_i32_e32 v2, v3, v2
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v2 clamp
; GFX9-NEXT:    v_add_i32 v1, v1, v3 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v2 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, v1, v3 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32> %lhs, <2 x i32> %rhs)
  ret <2 x i32> %result
}

define amdgpu_ps <2 x i32> @s_saddsat_v2i32(<2 x i32> inreg %lhs, <2 x i32> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    s_min_i32 s7, s0, 0
; GFX6-NEXT:    s_sub_i32 s7, s5, s7
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    s_max_i32 s6, s0, 0
; GFX6-NEXT:    s_sub_i32 s6, s4, s6
; GFX6-NEXT:    s_max_i32 s2, s7, s2
; GFX6-NEXT:    s_min_i32 s2, s2, s6
; GFX6-NEXT:    s_add_i32 s0, s0, s2
; GFX6-NEXT:    s_max_i32 s2, s1, 0
; GFX6-NEXT:    s_sub_i32 s2, s4, s2
; GFX6-NEXT:    s_min_i32 s4, s1, 0
; GFX6-NEXT:    s_sub_i32 s4, s5, s4
; GFX6-NEXT:    s_max_i32 s3, s4, s3
; GFX6-NEXT:    s_min_i32 s2, s3, s2
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    s_min_i32 s7, s0, 0
; GFX8-NEXT:    s_sub_i32 s7, s5, s7
; GFX8-NEXT:    s_brev_b32 s4, -2
; GFX8-NEXT:    s_max_i32 s6, s0, 0
; GFX8-NEXT:    s_sub_i32 s6, s4, s6
; GFX8-NEXT:    s_max_i32 s2, s7, s2
; GFX8-NEXT:    s_min_i32 s2, s2, s6
; GFX8-NEXT:    s_add_i32 s0, s0, s2
; GFX8-NEXT:    s_max_i32 s2, s1, 0
; GFX8-NEXT:    s_sub_i32 s2, s4, s2
; GFX8-NEXT:    s_min_i32 s4, s1, 0
; GFX8-NEXT:    s_sub_i32 s4, s5, s4
; GFX8-NEXT:    s_max_i32 s3, s4, s3
; GFX8-NEXT:    s_min_i32 s2, s3, s2
; GFX8-NEXT:    s_add_i32 s1, s1, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_i32 v1, s1, v1 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v2i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s2 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, s1, s3 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32> %lhs, <2 x i32> %rhs)
  ret <2 x i32> %result
}

define <3 x i32> @v_saddsat_v3i32(<3 x i32> %lhs, <3 x i32> %rhs) {
; GFX6-LABEL: v_saddsat_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v7, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, s5, v7
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v6, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, s4, v6
; GFX6-NEXT:    v_max_i32_e32 v3, v7, v3
; GFX6-NEXT:    v_min_i32_e32 v3, v3, v6
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v3
; GFX6-NEXT:    v_max_i32_e32 v3, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, s5, v6
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s4, v3
; GFX6-NEXT:    v_max_i32_e32 v4, v6, v4
; GFX6-NEXT:    v_min_i32_e32 v3, v4, v3
; GFX6-NEXT:    v_min_i32_e32 v4, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s5, v4
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v3
; GFX6-NEXT:    v_max_i32_e32 v3, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s4, v3
; GFX6-NEXT:    v_max_i32_e32 v4, v4, v5
; GFX6-NEXT:    v_min_i32_e32 v3, v4, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    v_min_i32_e32 v7, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v7, vcc, s5, v7
; GFX8-NEXT:    s_brev_b32 s4, -2
; GFX8-NEXT:    v_max_i32_e32 v6, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v6, vcc, s4, v6
; GFX8-NEXT:    v_max_i32_e32 v3, v7, v3
; GFX8-NEXT:    v_min_i32_e32 v3, v3, v6
; GFX8-NEXT:    v_min_i32_e32 v6, 0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v3
; GFX8-NEXT:    v_max_i32_e32 v3, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v6, vcc, s5, v6
; GFX8-NEXT:    v_sub_u32_e32 v3, vcc, s4, v3
; GFX8-NEXT:    v_max_i32_e32 v4, v6, v4
; GFX8-NEXT:    v_min_i32_e32 v3, v4, v3
; GFX8-NEXT:    v_min_i32_e32 v4, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, s5, v4
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v3
; GFX8-NEXT:    v_max_i32_e32 v3, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v3, vcc, s4, v3
; GFX8-NEXT:    v_max_i32_e32 v4, v4, v5
; GFX8-NEXT:    v_min_i32_e32 v3, v4, v3
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v3 clamp
; GFX9-NEXT:    v_add_i32 v1, v1, v4 clamp
; GFX9-NEXT:    v_add_i32 v2, v2, v5 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v3 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, v1, v4 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, v2, v5 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x i32> @llvm.sadd.sat.v3i32(<3 x i32> %lhs, <3 x i32> %rhs)
  ret <3 x i32> %result
}

define amdgpu_ps <3 x i32> @s_saddsat_v3i32(<3 x i32> inreg %lhs, <3 x i32> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_brev_b32 s7, 1
; GFX6-NEXT:    s_min_i32 s9, s0, 0
; GFX6-NEXT:    s_sub_i32 s9, s7, s9
; GFX6-NEXT:    s_brev_b32 s6, -2
; GFX6-NEXT:    s_max_i32 s8, s0, 0
; GFX6-NEXT:    s_sub_i32 s8, s6, s8
; GFX6-NEXT:    s_max_i32 s3, s9, s3
; GFX6-NEXT:    s_min_i32 s3, s3, s8
; GFX6-NEXT:    s_min_i32 s8, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s3
; GFX6-NEXT:    s_max_i32 s3, s1, 0
; GFX6-NEXT:    s_sub_i32 s8, s7, s8
; GFX6-NEXT:    s_sub_i32 s3, s6, s3
; GFX6-NEXT:    s_max_i32 s4, s8, s4
; GFX6-NEXT:    s_min_i32 s3, s4, s3
; GFX6-NEXT:    s_min_i32 s4, s2, 0
; GFX6-NEXT:    s_sub_i32 s4, s7, s4
; GFX6-NEXT:    s_add_i32 s1, s1, s3
; GFX6-NEXT:    s_max_i32 s3, s2, 0
; GFX6-NEXT:    s_sub_i32 s3, s6, s3
; GFX6-NEXT:    s_max_i32 s4, s4, s5
; GFX6-NEXT:    s_min_i32 s3, s4, s3
; GFX6-NEXT:    s_add_i32 s2, s2, s3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_brev_b32 s7, 1
; GFX8-NEXT:    s_min_i32 s9, s0, 0
; GFX8-NEXT:    s_sub_i32 s9, s7, s9
; GFX8-NEXT:    s_brev_b32 s6, -2
; GFX8-NEXT:    s_max_i32 s8, s0, 0
; GFX8-NEXT:    s_sub_i32 s8, s6, s8
; GFX8-NEXT:    s_max_i32 s3, s9, s3
; GFX8-NEXT:    s_min_i32 s3, s3, s8
; GFX8-NEXT:    s_min_i32 s8, s1, 0
; GFX8-NEXT:    s_add_i32 s0, s0, s3
; GFX8-NEXT:    s_max_i32 s3, s1, 0
; GFX8-NEXT:    s_sub_i32 s8, s7, s8
; GFX8-NEXT:    s_sub_i32 s3, s6, s3
; GFX8-NEXT:    s_max_i32 s4, s8, s4
; GFX8-NEXT:    s_min_i32 s3, s4, s3
; GFX8-NEXT:    s_min_i32 s4, s2, 0
; GFX8-NEXT:    s_sub_i32 s4, s7, s4
; GFX8-NEXT:    s_add_i32 s1, s1, s3
; GFX8-NEXT:    s_max_i32 s3, s2, 0
; GFX8-NEXT:    s_sub_i32 s3, s6, s3
; GFX8-NEXT:    s_max_i32 s4, s4, s5
; GFX8-NEXT:    s_min_i32 s3, s4, s3
; GFX8-NEXT:    s_add_i32 s2, s2, s3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_i32 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_i32 v2, s2, v2 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v3i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s3 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, s1, s4 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, s2, s5 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <3 x i32> @llvm.sadd.sat.v3i32(<3 x i32> %lhs, <3 x i32> %rhs)
  ret <3 x i32> %result
}

define <4 x i32> @v_saddsat_v4i32(<4 x i32> %lhs, <4 x i32> %rhs) {
; GFX6-LABEL: v_saddsat_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v9, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, s5, v9
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v8, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s4, v8
; GFX6-NEXT:    v_max_i32_e32 v4, v9, v4
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v8
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s5, v8
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s4, v4
; GFX6-NEXT:    v_max_i32_e32 v5, v8, v5
; GFX6-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX6-NEXT:    v_min_i32_e32 v5, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s5, v5
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s4, v4
; GFX6-NEXT:    v_max_i32_e32 v5, v5, v6
; GFX6-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX6-NEXT:    v_min_i32_e32 v5, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, 0x80000000, v5
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, 0x7fffffff, v4
; GFX6-NEXT:    v_max_i32_e32 v5, v5, v7
; GFX6-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    v_min_i32_e32 v9, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v9, vcc, s5, v9
; GFX8-NEXT:    s_brev_b32 s4, -2
; GFX8-NEXT:    v_max_i32_e32 v8, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v8, vcc, s4, v8
; GFX8-NEXT:    v_max_i32_e32 v4, v9, v4
; GFX8-NEXT:    v_min_i32_e32 v4, v4, v8
; GFX8-NEXT:    v_min_i32_e32 v8, 0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v4
; GFX8-NEXT:    v_max_i32_e32 v4, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v8, vcc, s5, v8
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, s4, v4
; GFX8-NEXT:    v_max_i32_e32 v5, v8, v5
; GFX8-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX8-NEXT:    v_min_i32_e32 v5, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, s5, v5
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v4
; GFX8-NEXT:    v_max_i32_e32 v4, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, s4, v4
; GFX8-NEXT:    v_max_i32_e32 v5, v5, v6
; GFX8-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX8-NEXT:    v_min_i32_e32 v5, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, 0x80000000, v5
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v4
; GFX8-NEXT:    v_max_i32_e32 v4, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v4, vcc, 0x7fffffff, v4
; GFX8-NEXT:    v_max_i32_e32 v5, v5, v7
; GFX8-NEXT:    v_min_i32_e32 v4, v5, v4
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v4 clamp
; GFX9-NEXT:    v_add_i32 v1, v1, v5 clamp
; GFX9-NEXT:    v_add_i32 v2, v2, v6 clamp
; GFX9-NEXT:    v_add_i32 v3, v3, v7 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v4 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, v1, v5 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, v2, v6 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, v3, v7 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %lhs, <4 x i32> %rhs)
  ret <4 x i32> %result
}

define amdgpu_ps <4 x i32> @s_saddsat_v4i32(<4 x i32> inreg %lhs, <4 x i32> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_brev_b32 s9, 1
; GFX6-NEXT:    s_min_i32 s11, s0, 0
; GFX6-NEXT:    s_sub_i32 s11, s9, s11
; GFX6-NEXT:    s_brev_b32 s8, -2
; GFX6-NEXT:    s_max_i32 s10, s0, 0
; GFX6-NEXT:    s_sub_i32 s10, s8, s10
; GFX6-NEXT:    s_max_i32 s4, s11, s4
; GFX6-NEXT:    s_min_i32 s4, s4, s10
; GFX6-NEXT:    s_min_i32 s10, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s4
; GFX6-NEXT:    s_max_i32 s4, s1, 0
; GFX6-NEXT:    s_sub_i32 s10, s9, s10
; GFX6-NEXT:    s_sub_i32 s4, s8, s4
; GFX6-NEXT:    s_max_i32 s5, s10, s5
; GFX6-NEXT:    s_min_i32 s4, s5, s4
; GFX6-NEXT:    s_min_i32 s5, s2, 0
; GFX6-NEXT:    s_sub_i32 s5, s9, s5
; GFX6-NEXT:    s_add_i32 s1, s1, s4
; GFX6-NEXT:    s_max_i32 s4, s2, 0
; GFX6-NEXT:    s_sub_i32 s4, s8, s4
; GFX6-NEXT:    s_max_i32 s5, s5, s6
; GFX6-NEXT:    s_min_i32 s4, s5, s4
; GFX6-NEXT:    s_min_i32 s5, s3, 0
; GFX6-NEXT:    s_sub_i32 s5, s9, s5
; GFX6-NEXT:    s_add_i32 s2, s2, s4
; GFX6-NEXT:    s_max_i32 s4, s3, 0
; GFX6-NEXT:    s_sub_i32 s4, s8, s4
; GFX6-NEXT:    s_max_i32 s5, s5, s7
; GFX6-NEXT:    s_min_i32 s4, s5, s4
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_brev_b32 s9, 1
; GFX8-NEXT:    s_min_i32 s11, s0, 0
; GFX8-NEXT:    s_sub_i32 s11, s9, s11
; GFX8-NEXT:    s_brev_b32 s8, -2
; GFX8-NEXT:    s_max_i32 s10, s0, 0
; GFX8-NEXT:    s_sub_i32 s10, s8, s10
; GFX8-NEXT:    s_max_i32 s4, s11, s4
; GFX8-NEXT:    s_min_i32 s4, s4, s10
; GFX8-NEXT:    s_min_i32 s10, s1, 0
; GFX8-NEXT:    s_add_i32 s0, s0, s4
; GFX8-NEXT:    s_max_i32 s4, s1, 0
; GFX8-NEXT:    s_sub_i32 s10, s9, s10
; GFX8-NEXT:    s_sub_i32 s4, s8, s4
; GFX8-NEXT:    s_max_i32 s5, s10, s5
; GFX8-NEXT:    s_min_i32 s4, s5, s4
; GFX8-NEXT:    s_min_i32 s5, s2, 0
; GFX8-NEXT:    s_sub_i32 s5, s9, s5
; GFX8-NEXT:    s_add_i32 s1, s1, s4
; GFX8-NEXT:    s_max_i32 s4, s2, 0
; GFX8-NEXT:    s_sub_i32 s4, s8, s4
; GFX8-NEXT:    s_max_i32 s5, s5, s6
; GFX8-NEXT:    s_min_i32 s4, s5, s4
; GFX8-NEXT:    s_min_i32 s5, s3, 0
; GFX8-NEXT:    s_sub_i32 s5, s9, s5
; GFX8-NEXT:    s_add_i32 s2, s2, s4
; GFX8-NEXT:    s_max_i32 s4, s3, 0
; GFX8-NEXT:    s_sub_i32 s4, s8, s4
; GFX8-NEXT:    s_max_i32 s5, s5, s7
; GFX8-NEXT:    s_min_i32 s4, s5, s4
; GFX8-NEXT:    s_add_i32 s3, s3, s4
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_i32 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_i32 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_i32 v3, s3, v3 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v4i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s4 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, s1, s5 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, s2, s6 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, s3, s7 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %lhs, <4 x i32> %rhs)
  ret <4 x i32> %result
}

define <5 x i32> @v_saddsat_v5i32(<5 x i32> %lhs, <5 x i32> %rhs) {
; GFX6-LABEL: v_saddsat_v5i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v12, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v12, vcc, s5, v12
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v10, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, s4, v10
; GFX6-NEXT:    v_max_i32_e32 v5, v12, v5
; GFX6-NEXT:    v_min_i32_e32 v5, v5, v10
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v5
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, s5, v10
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s4, v5
; GFX6-NEXT:    v_max_i32_e32 v6, v10, v6
; GFX6-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, s5, v6
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v5
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s4, v5
; GFX6-NEXT:    v_max_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX6-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, v13, v6
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v5
; GFX6-NEXT:    v_bfrev_b32_e32 v11, -2
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v11, v5
; GFX6-NEXT:    v_max_i32_e32 v6, v6, v8
; GFX6-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v4
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, v13, v6
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v5
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v4
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v11, v5
; GFX6-NEXT:    v_max_i32_e32 v6, v6, v9
; GFX6-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v5i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    v_min_i32_e32 v12, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v12, vcc, s5, v12
; GFX8-NEXT:    s_brev_b32 s4, -2
; GFX8-NEXT:    v_max_i32_e32 v10, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v10, vcc, s4, v10
; GFX8-NEXT:    v_max_i32_e32 v5, v12, v5
; GFX8-NEXT:    v_min_i32_e32 v5, v5, v10
; GFX8-NEXT:    v_min_i32_e32 v10, 0, v1
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v5
; GFX8-NEXT:    v_max_i32_e32 v5, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v10, vcc, s5, v10
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, s4, v5
; GFX8-NEXT:    v_max_i32_e32 v6, v10, v6
; GFX8-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX8-NEXT:    v_min_i32_e32 v6, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v6, vcc, s5, v6
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v5
; GFX8-NEXT:    v_max_i32_e32 v5, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, s4, v5
; GFX8-NEXT:    v_max_i32_e32 v6, v6, v7
; GFX8-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX8-NEXT:    v_bfrev_b32_e32 v13, 1
; GFX8-NEXT:    v_min_i32_e32 v6, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v6, vcc, v13, v6
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v5
; GFX8-NEXT:    v_bfrev_b32_e32 v11, -2
; GFX8-NEXT:    v_max_i32_e32 v5, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, v11, v5
; GFX8-NEXT:    v_max_i32_e32 v6, v6, v8
; GFX8-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX8-NEXT:    v_min_i32_e32 v6, 0, v4
; GFX8-NEXT:    v_sub_u32_e32 v6, vcc, v13, v6
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v5
; GFX8-NEXT:    v_max_i32_e32 v5, 0, v4
; GFX8-NEXT:    v_sub_u32_e32 v5, vcc, v11, v5
; GFX8-NEXT:    v_max_i32_e32 v6, v6, v9
; GFX8-NEXT:    v_min_i32_e32 v5, v6, v5
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v5i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v5 clamp
; GFX9-NEXT:    v_add_i32 v1, v1, v6 clamp
; GFX9-NEXT:    v_add_i32 v2, v2, v7 clamp
; GFX9-NEXT:    v_add_i32 v3, v3, v8 clamp
; GFX9-NEXT:    v_add_i32 v4, v4, v9 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v5i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v5 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, v1, v6 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, v2, v7 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, v3, v8 clamp
; GFX10-NEXT:    v_add_nc_i32 v4, v4, v9 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <5 x i32> @llvm.sadd.sat.v5i32(<5 x i32> %lhs, <5 x i32> %rhs)
  ret <5 x i32> %result
}

define amdgpu_ps <5 x i32> @s_saddsat_v5i32(<5 x i32> inreg %lhs, <5 x i32> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v5i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_brev_b32 s11, 1
; GFX6-NEXT:    s_min_i32 s13, s0, 0
; GFX6-NEXT:    s_sub_i32 s13, s11, s13
; GFX6-NEXT:    s_brev_b32 s10, -2
; GFX6-NEXT:    s_max_i32 s12, s0, 0
; GFX6-NEXT:    s_sub_i32 s12, s10, s12
; GFX6-NEXT:    s_max_i32 s5, s13, s5
; GFX6-NEXT:    s_min_i32 s5, s5, s12
; GFX6-NEXT:    s_min_i32 s12, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s5
; GFX6-NEXT:    s_max_i32 s5, s1, 0
; GFX6-NEXT:    s_sub_i32 s12, s11, s12
; GFX6-NEXT:    s_sub_i32 s5, s10, s5
; GFX6-NEXT:    s_max_i32 s6, s12, s6
; GFX6-NEXT:    s_min_i32 s5, s6, s5
; GFX6-NEXT:    s_min_i32 s6, s2, 0
; GFX6-NEXT:    s_sub_i32 s6, s11, s6
; GFX6-NEXT:    s_add_i32 s1, s1, s5
; GFX6-NEXT:    s_max_i32 s5, s2, 0
; GFX6-NEXT:    s_sub_i32 s5, s10, s5
; GFX6-NEXT:    s_max_i32 s6, s6, s7
; GFX6-NEXT:    s_min_i32 s5, s6, s5
; GFX6-NEXT:    s_min_i32 s6, s3, 0
; GFX6-NEXT:    s_sub_i32 s6, s11, s6
; GFX6-NEXT:    s_add_i32 s2, s2, s5
; GFX6-NEXT:    s_max_i32 s5, s3, 0
; GFX6-NEXT:    s_sub_i32 s5, s10, s5
; GFX6-NEXT:    s_max_i32 s6, s6, s8
; GFX6-NEXT:    s_min_i32 s5, s6, s5
; GFX6-NEXT:    s_min_i32 s6, s4, 0
; GFX6-NEXT:    s_sub_i32 s6, s11, s6
; GFX6-NEXT:    s_add_i32 s3, s3, s5
; GFX6-NEXT:    s_max_i32 s5, s4, 0
; GFX6-NEXT:    s_sub_i32 s5, s10, s5
; GFX6-NEXT:    s_max_i32 s6, s6, s9
; GFX6-NEXT:    s_min_i32 s5, s6, s5
; GFX6-NEXT:    s_add_i32 s4, s4, s5
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v5i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_brev_b32 s11, 1
; GFX8-NEXT:    s_min_i32 s13, s0, 0
; GFX8-NEXT:    s_sub_i32 s13, s11, s13
; GFX8-NEXT:    s_brev_b32 s10, -2
; GFX8-NEXT:    s_max_i32 s12, s0, 0
; GFX8-NEXT:    s_sub_i32 s12, s10, s12
; GFX8-NEXT:    s_max_i32 s5, s13, s5
; GFX8-NEXT:    s_min_i32 s5, s5, s12
; GFX8-NEXT:    s_min_i32 s12, s1, 0
; GFX8-NEXT:    s_add_i32 s0, s0, s5
; GFX8-NEXT:    s_max_i32 s5, s1, 0
; GFX8-NEXT:    s_sub_i32 s12, s11, s12
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_max_i32 s6, s12, s6
; GFX8-NEXT:    s_min_i32 s5, s6, s5
; GFX8-NEXT:    s_min_i32 s6, s2, 0
; GFX8-NEXT:    s_sub_i32 s6, s11, s6
; GFX8-NEXT:    s_add_i32 s1, s1, s5
; GFX8-NEXT:    s_max_i32 s5, s2, 0
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_max_i32 s6, s6, s7
; GFX8-NEXT:    s_min_i32 s5, s6, s5
; GFX8-NEXT:    s_min_i32 s6, s3, 0
; GFX8-NEXT:    s_sub_i32 s6, s11, s6
; GFX8-NEXT:    s_add_i32 s2, s2, s5
; GFX8-NEXT:    s_max_i32 s5, s3, 0
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_max_i32 s6, s6, s8
; GFX8-NEXT:    s_min_i32 s5, s6, s5
; GFX8-NEXT:    s_min_i32 s6, s4, 0
; GFX8-NEXT:    s_sub_i32 s6, s11, s6
; GFX8-NEXT:    s_add_i32 s3, s3, s5
; GFX8-NEXT:    s_max_i32 s5, s4, 0
; GFX8-NEXT:    s_sub_i32 s5, s10, s5
; GFX8-NEXT:    s_max_i32 s6, s6, s9
; GFX8-NEXT:    s_min_i32 s5, s6, s5
; GFX8-NEXT:    s_add_i32 s4, s4, s5
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v5i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_i32 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_i32 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_i32 v3, s3, v3 clamp
; GFX9-NEXT:    v_add_i32 v4, s4, v4 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v5i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s5 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, s1, s6 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, s2, s7 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, s3, s8 clamp
; GFX10-NEXT:    v_add_nc_i32 v4, s4, s9 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <5 x i32> @llvm.sadd.sat.v5i32(<5 x i32> %lhs, <5 x i32> %rhs)
  ret <5 x i32> %result
}

define <16 x i32> @v_saddsat_v16i32(<16 x i32> %lhs, <16 x i32> %rhs) {
; GFX6-LABEL: v_saddsat_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    s_brev_b32 s4, 1
; GFX6-NEXT:    v_min_i32_e32 v32, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v32, vcc, s4, v32
; GFX6-NEXT:    v_max_i32_e32 v16, v32, v16
; GFX6-NEXT:    s_brev_b32 s5, -2
; GFX6-NEXT:    v_max_i32_e32 v32, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v32, vcc, s5, v32
; GFX6-NEXT:    v_min_i32_e32 v16, v16, v32
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v16
; GFX6-NEXT:    v_min_i32_e32 v16, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v16, vcc, s4, v16
; GFX6-NEXT:    v_max_i32_e32 v16, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v17, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, s5, v17
; GFX6-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v16
; GFX6-NEXT:    v_min_i32_e32 v16, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v16, vcc, s4, v16
; GFX6-NEXT:    v_max_i32_e32 v17, 0, v2
; GFX6-NEXT:    v_max_i32_e32 v16, v16, v18
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, s5, v17
; GFX6-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v16
; GFX6-NEXT:    v_bfrev_b32_e32 v16, 1
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_bfrev_b32_e32 v18, -2
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v3
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v4
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v4
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v20
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v5
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v5
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v21
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v6
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v6
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v22
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v6, vcc, v6, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v7
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v7
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v23
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v7, vcc, v7, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v8
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v8
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v24
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v8, vcc, v8, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v9
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v9
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v25
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v9, vcc, v9, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v10
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v10
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v26
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v10, vcc, v10, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v11
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v11
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v27
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v11, vcc, v11, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v12
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v12
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v28
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v12, vcc, v12, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v13
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v13
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v29
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v13, vcc, v13, v17
; GFX6-NEXT:    v_min_i32_e32 v17, 0, v14
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v16, v17
; GFX6-NEXT:    v_max_i32_e32 v19, 0, v14
; GFX6-NEXT:    v_max_i32_e32 v17, v17, v30
; GFX6-NEXT:    v_sub_i32_e32 v19, vcc, v18, v19
; GFX6-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX6-NEXT:    v_add_i32_e32 v14, vcc, v14, v17
; GFX6-NEXT:    v_max_i32_e32 v17, 0, v15
; GFX6-NEXT:    v_sub_i32_e32 v17, vcc, v18, v17
; GFX6-NEXT:    v_min_i32_e32 v18, 0, v15
; GFX6-NEXT:    v_sub_i32_e32 v16, vcc, v16, v18
; GFX6-NEXT:    v_max_i32_e32 v16, v16, v31
; GFX6-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX6-NEXT:    v_add_i32_e32 v15, vcc, v15, v16
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_brev_b32 s4, 1
; GFX8-NEXT:    v_min_i32_e32 v32, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v32, vcc, s4, v32
; GFX8-NEXT:    v_max_i32_e32 v16, v32, v16
; GFX8-NEXT:    s_brev_b32 s5, -2
; GFX8-NEXT:    v_max_i32_e32 v32, 0, v0
; GFX8-NEXT:    v_sub_u32_e32 v32, vcc, s5, v32
; GFX8-NEXT:    v_min_i32_e32 v16, v16, v32
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, v0, v16
; GFX8-NEXT:    v_min_i32_e32 v16, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v16, vcc, s4, v16
; GFX8-NEXT:    v_max_i32_e32 v16, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v17, 0, v1
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, s5, v17
; GFX8-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX8-NEXT:    v_add_u32_e32 v1, vcc, v1, v16
; GFX8-NEXT:    v_min_i32_e32 v16, 0, v2
; GFX8-NEXT:    v_sub_u32_e32 v16, vcc, s4, v16
; GFX8-NEXT:    v_max_i32_e32 v17, 0, v2
; GFX8-NEXT:    v_max_i32_e32 v16, v16, v18
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, s5, v17
; GFX8-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, v2, v16
; GFX8-NEXT:    v_bfrev_b32_e32 v16, 1
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_bfrev_b32_e32 v18, -2
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v3
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v3, vcc, v3, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v4
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v4
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v20
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v4, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v5
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v5
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v21
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v5, vcc, v5, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v6
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v6
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v22
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v6, vcc, v6, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v7
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v7
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v23
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v7, vcc, v7, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v8
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v8
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v24
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v8, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v9
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v9
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v25
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v9, vcc, v9, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v10
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v10
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v26
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v10, vcc, v10, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v11
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v11
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v27
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v11, vcc, v11, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v12
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v12
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v28
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v12, vcc, v12, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v13
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v13
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v29
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v13, vcc, v13, v17
; GFX8-NEXT:    v_min_i32_e32 v17, 0, v14
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v16, v17
; GFX8-NEXT:    v_max_i32_e32 v19, 0, v14
; GFX8-NEXT:    v_max_i32_e32 v17, v17, v30
; GFX8-NEXT:    v_sub_u32_e32 v19, vcc, v18, v19
; GFX8-NEXT:    v_min_i32_e32 v17, v17, v19
; GFX8-NEXT:    v_add_u32_e32 v14, vcc, v14, v17
; GFX8-NEXT:    v_max_i32_e32 v17, 0, v15
; GFX8-NEXT:    v_sub_u32_e32 v17, vcc, v18, v17
; GFX8-NEXT:    v_min_i32_e32 v18, 0, v15
; GFX8-NEXT:    v_sub_u32_e32 v16, vcc, v16, v18
; GFX8-NEXT:    v_max_i32_e32 v16, v16, v31
; GFX8-NEXT:    v_min_i32_e32 v16, v16, v17
; GFX8-NEXT:    v_add_u32_e32 v15, vcc, v15, v16
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i32 v0, v0, v16 clamp
; GFX9-NEXT:    v_add_i32 v1, v1, v17 clamp
; GFX9-NEXT:    v_add_i32 v2, v2, v18 clamp
; GFX9-NEXT:    v_add_i32 v3, v3, v19 clamp
; GFX9-NEXT:    v_add_i32 v4, v4, v20 clamp
; GFX9-NEXT:    v_add_i32 v5, v5, v21 clamp
; GFX9-NEXT:    v_add_i32 v6, v6, v22 clamp
; GFX9-NEXT:    v_add_i32 v7, v7, v23 clamp
; GFX9-NEXT:    v_add_i32 v8, v8, v24 clamp
; GFX9-NEXT:    v_add_i32 v9, v9, v25 clamp
; GFX9-NEXT:    v_add_i32 v10, v10, v26 clamp
; GFX9-NEXT:    v_add_i32 v11, v11, v27 clamp
; GFX9-NEXT:    v_add_i32 v12, v12, v28 clamp
; GFX9-NEXT:    v_add_i32 v13, v13, v29 clamp
; GFX9-NEXT:    v_add_i32 v14, v14, v30 clamp
; GFX9-NEXT:    v_add_i32 v15, v15, v31 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i32 v0, v0, v16 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, v1, v17 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, v2, v18 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, v3, v19 clamp
; GFX10-NEXT:    v_add_nc_i32 v4, v4, v20 clamp
; GFX10-NEXT:    v_add_nc_i32 v5, v5, v21 clamp
; GFX10-NEXT:    v_add_nc_i32 v6, v6, v22 clamp
; GFX10-NEXT:    v_add_nc_i32 v7, v7, v23 clamp
; GFX10-NEXT:    v_add_nc_i32 v8, v8, v24 clamp
; GFX10-NEXT:    v_add_nc_i32 v9, v9, v25 clamp
; GFX10-NEXT:    v_add_nc_i32 v10, v10, v26 clamp
; GFX10-NEXT:    v_add_nc_i32 v11, v11, v27 clamp
; GFX10-NEXT:    v_add_nc_i32 v12, v12, v28 clamp
; GFX10-NEXT:    v_add_nc_i32 v13, v13, v29 clamp
; GFX10-NEXT:    v_add_nc_i32 v14, v14, v30 clamp
; GFX10-NEXT:    v_add_nc_i32 v15, v15, v31 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> %lhs, <16 x i32> %rhs)
  ret <16 x i32> %result
}

define amdgpu_ps <16 x i32> @s_saddsat_v16i32(<16 x i32> inreg %lhs, <16 x i32> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v16i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_brev_b32 s33, 1
; GFX6-NEXT:    s_min_i32 s35, s0, 0
; GFX6-NEXT:    s_sub_i32 s35, s33, s35
; GFX6-NEXT:    s_brev_b32 s32, -2
; GFX6-NEXT:    s_max_i32 s34, s0, 0
; GFX6-NEXT:    s_sub_i32 s34, s32, s34
; GFX6-NEXT:    s_max_i32 s16, s35, s16
; GFX6-NEXT:    s_min_i32 s16, s16, s34
; GFX6-NEXT:    s_min_i32 s34, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s16
; GFX6-NEXT:    s_max_i32 s16, s1, 0
; GFX6-NEXT:    s_sub_i32 s34, s33, s34
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s34, s17
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s2, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s1, s1, s16
; GFX6-NEXT:    s_max_i32 s16, s2, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s18
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s3, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s2, s2, s16
; GFX6-NEXT:    s_max_i32 s16, s3, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s19
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s4, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s3, s3, s16
; GFX6-NEXT:    s_max_i32 s16, s4, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s20
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s5, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s4, s4, s16
; GFX6-NEXT:    s_max_i32 s16, s5, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s21
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s6, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s5, s5, s16
; GFX6-NEXT:    s_max_i32 s16, s6, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s22
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s7, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s6, s6, s16
; GFX6-NEXT:    s_max_i32 s16, s7, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s23
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s8, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s7, s7, s16
; GFX6-NEXT:    s_max_i32 s16, s8, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s24
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s9, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s8, s8, s16
; GFX6-NEXT:    s_max_i32 s16, s9, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s25
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s10, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s9, s9, s16
; GFX6-NEXT:    s_max_i32 s16, s10, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s26
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s11, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s10, s10, s16
; GFX6-NEXT:    s_max_i32 s16, s11, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s27
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s12, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s11, s11, s16
; GFX6-NEXT:    s_max_i32 s16, s12, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s28
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s13, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s12, s12, s16
; GFX6-NEXT:    s_max_i32 s16, s13, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s29
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s14, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s13, s13, s16
; GFX6-NEXT:    s_max_i32 s16, s14, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s30
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_min_i32 s17, s15, 0
; GFX6-NEXT:    s_sub_i32 s17, s33, s17
; GFX6-NEXT:    s_add_i32 s14, s14, s16
; GFX6-NEXT:    s_max_i32 s16, s15, 0
; GFX6-NEXT:    s_sub_i32 s16, s32, s16
; GFX6-NEXT:    s_max_i32 s17, s17, s31
; GFX6-NEXT:    s_min_i32 s16, s17, s16
; GFX6-NEXT:    s_add_i32 s15, s15, s16
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v16i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_brev_b32 s33, 1
; GFX8-NEXT:    s_min_i32 s35, s0, 0
; GFX8-NEXT:    s_sub_i32 s35, s33, s35
; GFX8-NEXT:    s_brev_b32 s32, -2
; GFX8-NEXT:    s_max_i32 s34, s0, 0
; GFX8-NEXT:    s_sub_i32 s34, s32, s34
; GFX8-NEXT:    s_max_i32 s16, s35, s16
; GFX8-NEXT:    s_min_i32 s16, s16, s34
; GFX8-NEXT:    s_min_i32 s34, s1, 0
; GFX8-NEXT:    s_add_i32 s0, s0, s16
; GFX8-NEXT:    s_max_i32 s16, s1, 0
; GFX8-NEXT:    s_sub_i32 s34, s33, s34
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s34, s17
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s2, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s1, s1, s16
; GFX8-NEXT:    s_max_i32 s16, s2, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s18
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s3, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s2, s2, s16
; GFX8-NEXT:    s_max_i32 s16, s3, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s19
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s4, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s3, s3, s16
; GFX8-NEXT:    s_max_i32 s16, s4, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s20
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s5, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s4, s4, s16
; GFX8-NEXT:    s_max_i32 s16, s5, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s21
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s6, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s5, s5, s16
; GFX8-NEXT:    s_max_i32 s16, s6, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s22
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s7, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s6, s6, s16
; GFX8-NEXT:    s_max_i32 s16, s7, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s23
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s8, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s7, s7, s16
; GFX8-NEXT:    s_max_i32 s16, s8, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s24
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s9, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s8, s8, s16
; GFX8-NEXT:    s_max_i32 s16, s9, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s25
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s10, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s9, s9, s16
; GFX8-NEXT:    s_max_i32 s16, s10, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s26
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s11, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s10, s10, s16
; GFX8-NEXT:    s_max_i32 s16, s11, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s27
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s12, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s11, s11, s16
; GFX8-NEXT:    s_max_i32 s16, s12, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s28
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s13, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s12, s12, s16
; GFX8-NEXT:    s_max_i32 s16, s13, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s29
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s14, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s13, s13, s16
; GFX8-NEXT:    s_max_i32 s16, s14, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s30
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_min_i32 s17, s15, 0
; GFX8-NEXT:    s_sub_i32 s17, s33, s17
; GFX8-NEXT:    s_add_i32 s14, s14, s16
; GFX8-NEXT:    s_max_i32 s16, s15, 0
; GFX8-NEXT:    s_sub_i32 s16, s32, s16
; GFX8-NEXT:    s_max_i32 s17, s17, s31
; GFX8-NEXT:    s_min_i32 s16, s17, s16
; GFX8-NEXT:    s_add_i32 s15, s15, s16
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v16i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    v_mov_b32_e32 v14, s30
; GFX9-NEXT:    v_mov_b32_e32 v15, s31
; GFX9-NEXT:    v_add_i32 v0, s0, v0 clamp
; GFX9-NEXT:    v_add_i32 v1, s1, v1 clamp
; GFX9-NEXT:    v_add_i32 v2, s2, v2 clamp
; GFX9-NEXT:    v_add_i32 v3, s3, v3 clamp
; GFX9-NEXT:    v_add_i32 v4, s4, v4 clamp
; GFX9-NEXT:    v_add_i32 v5, s5, v5 clamp
; GFX9-NEXT:    v_add_i32 v6, s6, v6 clamp
; GFX9-NEXT:    v_add_i32 v7, s7, v7 clamp
; GFX9-NEXT:    v_add_i32 v8, s8, v8 clamp
; GFX9-NEXT:    v_add_i32 v9, s9, v9 clamp
; GFX9-NEXT:    v_add_i32 v10, s10, v10 clamp
; GFX9-NEXT:    v_add_i32 v11, s11, v11 clamp
; GFX9-NEXT:    v_add_i32 v12, s12, v12 clamp
; GFX9-NEXT:    v_add_i32 v13, s13, v13 clamp
; GFX9-NEXT:    v_add_i32 v14, s14, v14 clamp
; GFX9-NEXT:    v_add_i32 v15, s15, v15 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    v_readfirstlane_b32 s4, v4
; GFX9-NEXT:    v_readfirstlane_b32 s5, v5
; GFX9-NEXT:    v_readfirstlane_b32 s6, v6
; GFX9-NEXT:    v_readfirstlane_b32 s7, v7
; GFX9-NEXT:    v_readfirstlane_b32 s8, v8
; GFX9-NEXT:    v_readfirstlane_b32 s9, v9
; GFX9-NEXT:    v_readfirstlane_b32 s10, v10
; GFX9-NEXT:    v_readfirstlane_b32 s11, v11
; GFX9-NEXT:    v_readfirstlane_b32 s12, v12
; GFX9-NEXT:    v_readfirstlane_b32 s13, v13
; GFX9-NEXT:    v_readfirstlane_b32 s14, v14
; GFX9-NEXT:    v_readfirstlane_b32 s15, v15
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v16i32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i32 v0, s0, s16 clamp
; GFX10-NEXT:    v_add_nc_i32 v1, s1, s17 clamp
; GFX10-NEXT:    v_add_nc_i32 v2, s2, s18 clamp
; GFX10-NEXT:    v_add_nc_i32 v3, s3, s19 clamp
; GFX10-NEXT:    v_add_nc_i32 v4, s4, s20 clamp
; GFX10-NEXT:    v_add_nc_i32 v5, s5, s21 clamp
; GFX10-NEXT:    v_add_nc_i32 v6, s6, s22 clamp
; GFX10-NEXT:    v_add_nc_i32 v7, s7, s23 clamp
; GFX10-NEXT:    v_add_nc_i32 v8, s8, s24 clamp
; GFX10-NEXT:    v_add_nc_i32 v9, s9, s25 clamp
; GFX10-NEXT:    v_add_nc_i32 v10, s10, s26 clamp
; GFX10-NEXT:    v_add_nc_i32 v11, s11, s27 clamp
; GFX10-NEXT:    v_add_nc_i32 v12, s12, s28 clamp
; GFX10-NEXT:    v_add_nc_i32 v13, s13, s29 clamp
; GFX10-NEXT:    v_add_nc_i32 v14, s14, s30 clamp
; GFX10-NEXT:    v_add_nc_i32 v15, s15, s31 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-NEXT:    v_readfirstlane_b32 s5, v5
; GFX10-NEXT:    v_readfirstlane_b32 s6, v6
; GFX10-NEXT:    v_readfirstlane_b32 s7, v7
; GFX10-NEXT:    v_readfirstlane_b32 s8, v8
; GFX10-NEXT:    v_readfirstlane_b32 s9, v9
; GFX10-NEXT:    v_readfirstlane_b32 s10, v10
; GFX10-NEXT:    v_readfirstlane_b32 s11, v11
; GFX10-NEXT:    v_readfirstlane_b32 s12, v12
; GFX10-NEXT:    v_readfirstlane_b32 s13, v13
; GFX10-NEXT:    v_readfirstlane_b32 s14, v14
; GFX10-NEXT:    v_readfirstlane_b32 s15, v15
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32> %lhs, <16 x i32> %rhs)
  ret <16 x i32> %result
}

define i16 @v_saddsat_i16(i16 %lhs, i16 %rhs) {
; GFX6-LABEL: v_saddsat_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, 0x80000000, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x7fffffff, v2
; GFX6-NEXT:    v_max_i32_e32 v1, v3, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v2
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_min_i16_e32 v3, 0, v0
; GFX8-NEXT:    v_max_i16_e32 v2, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v3, 0x8000, v3
; GFX8-NEXT:    v_sub_u16_e32 v2, 0x7fff, v2
; GFX8-NEXT:    v_max_i16_e32 v1, v3, v1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v2
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_nc_i16 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i16 @llvm.sadd.sat.i16(i16 %lhs, i16 %rhs)
  ret i16 %result
}

define amdgpu_ps i16 @s_saddsat_i16(i16 inreg %lhs, i16 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_min_i32 s3, s0, 0
; GFX6-NEXT:    s_max_i32 s2, s0, 0
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_sub_i32 s3, 0x80000000, s3
; GFX6-NEXT:    s_sub_i32 s2, 0x7fffffff, s2
; GFX6-NEXT:    s_max_i32 s1, s3, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s2
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_ashr_i32 s0, s0, 16
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s2, s0
; GFX8-NEXT:    s_sext_i32_i16 s3, 0
; GFX8-NEXT:    s_max_i32 s4, s2, s3
; GFX8-NEXT:    s_min_i32 s2, s2, s3
; GFX8-NEXT:    s_sub_i32 s2, 0xffff8000, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s2, s1
; GFX8-NEXT:    s_sub_i32 s4, 0x7fff, s4
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s2, s4
; GFX8-NEXT:    s_min_i32 s1, s1, s2
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i16 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.sadd.sat.i16(i16 %lhs, i16 %rhs)
  ret i16 %result
}

define amdgpu_ps half @saddsat_i16_sv(i16 inreg %lhs, i16 %rhs) {
; GFX6-LABEL: saddsat_i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_min_i32 s2, s0, 0
; GFX6-NEXT:    s_max_i32 s1, s0, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_sub_i32 s2, 0x80000000, s2
; GFX6-NEXT:    s_sub_i32 s1, 0x7fffffff, s1
; GFX6-NEXT:    v_max_i32_e32 v0, s2, v0
; GFX6-NEXT:    v_min_i32_e32 v0, s1, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s1, s0
; GFX8-NEXT:    s_sext_i32_i16 s2, 0
; GFX8-NEXT:    s_max_i32 s3, s1, s2
; GFX8-NEXT:    s_min_i32 s1, s1, s2
; GFX8-NEXT:    s_sub_i32 s1, 0xffff8000, s1
; GFX8-NEXT:    s_sub_i32 s3, 0x7fff, s3
; GFX8-NEXT:    v_max_i16_e32 v0, s1, v0
; GFX8-NEXT:    v_min_i16_e32 v0, s3, v0
; GFX8-NEXT:    v_add_u16_e32 v0, s0, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i16_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i16 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.sadd.sat.i16(i16 %lhs, i16 %rhs)
  %cast = bitcast i16 %result to half
  ret half %cast
}

define amdgpu_ps half @saddsat_i16_vs(i16 %lhs, i16 inreg %rhs) {
; GFX6-LABEL: saddsat_i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_min_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v1, 0, v0
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, 0x80000000, v2
; GFX6-NEXT:    v_sub_i32_e32 v1, vcc, 0x7fffffff, v1
; GFX6-NEXT:    v_max_i32_e32 v2, s0, v2
; GFX6-NEXT:    v_min_i32_e32 v1, v2, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_min_i16_e32 v2, 0, v0
; GFX8-NEXT:    v_max_i16_e32 v1, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v2, 0x8000, v2
; GFX8-NEXT:    v_sub_u16_e32 v1, 0x7fff, v1
; GFX8-NEXT:    v_max_i16_e32 v2, s0, v2
; GFX8-NEXT:    v_min_i16_e32 v1, v2, v1
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_add_i16 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i16_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_nc_i16 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i16 @llvm.sadd.sat.i16(i16 %lhs, i16 %rhs)
  %cast = bitcast i16 %result to half
  ret half %cast
}

define <2 x i16> @v_saddsat_v2i16(<2 x i16> %lhs, <2 x i16> %rhs) {
; GFX6-LABEL: v_saddsat_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v5, 0, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s5, v5
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v4, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s4, v4
; GFX6-NEXT:    v_max_i32_e32 v1, v5, v1
; GFX6-NEXT:    v_min_i32_e32 v1, v1, v4
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX6-NEXT:    v_min_i32_e32 v4, 0, v1
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX6-NEXT:    v_max_i32_e32 v3, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v4, vcc, s5, v4
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s4, v3
; GFX6-NEXT:    v_max_i32_e32 v2, v4, v2
; GFX6-NEXT:    v_min_i32_e32 v2, v2, v3
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s4, 0xffff
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX6-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v4, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v4, s5, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v3, 0, v0
; GFX8-NEXT:    v_min_i16_e32 v5, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v3, s4, v3
; GFX8-NEXT:    v_max_i16_e32 v4, v4, v1
; GFX8-NEXT:    v_min_i16_e32 v3, v4, v3
; GFX8-NEXT:    v_max_i16_e32 v4, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v5, s5, v5
; GFX8-NEXT:    v_sub_u16_e32 v4, s4, v4
; GFX8-NEXT:    v_max_i16_sdwa v1, v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v1, v1, v4
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v3
; GFX8-NEXT:    v_add_u16_sdwa v1, v2, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v2i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v1 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  ret <2 x i16> %result
}

define amdgpu_ps i32 @s_saddsat_v2i16(<2 x i16> inreg %lhs, <2 x i16> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v2i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s2, s0, 16
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    s_min_i32 s7, s0, 0
; GFX6-NEXT:    s_lshr_b32 s3, s1, 16
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_sub_i32 s7, s5, s7
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    s_max_i32 s6, s0, 0
; GFX6-NEXT:    s_sub_i32 s6, s4, s6
; GFX6-NEXT:    s_max_i32 s1, s7, s1
; GFX6-NEXT:    s_min_i32 s1, s1, s6
; GFX6-NEXT:    s_add_i32 s0, s0, s1
; GFX6-NEXT:    s_lshl_b32 s1, s2, 16
; GFX6-NEXT:    s_lshl_b32 s2, s3, 16
; GFX6-NEXT:    s_max_i32 s3, s1, 0
; GFX6-NEXT:    s_sub_i32 s3, s4, s3
; GFX6-NEXT:    s_min_i32 s4, s1, 0
; GFX6-NEXT:    s_sub_i32 s4, s5, s4
; GFX6-NEXT:    s_max_i32 s2, s4, s2
; GFX6-NEXT:    s_min_i32 s2, s2, s3
; GFX6-NEXT:    s_add_i32 s1, s1, s2
; GFX6-NEXT:    s_ashr_i32 s1, s1, 16
; GFX6-NEXT:    s_mov_b32 s2, 0xffff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 16
; GFX6-NEXT:    s_and_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s0, s0, s2
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v2i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s6, s0
; GFX8-NEXT:    s_sext_i32_i16 s7, 0
; GFX8-NEXT:    s_max_i32 s8, s6, s7
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    s_min_i32 s6, s6, s7
; GFX8-NEXT:    s_sub_i32 s6, s5, s6
; GFX8-NEXT:    s_lshr_b32 s3, s1, 16
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s6, s6
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_max_i32 s1, s6, s1
; GFX8-NEXT:    s_sub_i32 s8, s4, s8
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s6, s8
; GFX8-NEXT:    s_lshr_b32 s2, s0, 16
; GFX8-NEXT:    s_min_i32 s1, s1, s6
; GFX8-NEXT:    s_add_i32 s0, s0, s1
; GFX8-NEXT:    s_sext_i32_i16 s1, s2
; GFX8-NEXT:    s_max_i32 s6, s1, s7
; GFX8-NEXT:    s_min_i32 s1, s1, s7
; GFX8-NEXT:    s_sub_i32 s1, s5, s1
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_max_i32 s1, s1, s3
; GFX8-NEXT:    s_sub_i32 s4, s4, s6
; GFX8-NEXT:    s_sext_i32_i16 s1, s1
; GFX8-NEXT:    s_sext_i32_i16 s3, s4
; GFX8-NEXT:    s_min_i32 s1, s1, s3
; GFX8-NEXT:    s_add_i32 s2, s2, s1
; GFX8-NEXT:    s_bfe_u32 s1, s2, 0x100000
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX8-NEXT:    s_lshl_b32 s1, s1, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v2i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s1 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to i32
  ret i32 %cast
}

define amdgpu_ps float @saddsat_v2i16_sv(<2 x i16> inreg %lhs, <2 x i16> %rhs) {
; GFX6-LABEL: saddsat_v2i16_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshr_b32 s1, s0, 16
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_brev_b32 s3, 1
; GFX6-NEXT:    s_min_i32 s5, s0, 0
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_sub_i32 s5, s3, s5
; GFX6-NEXT:    s_brev_b32 s2, -2
; GFX6-NEXT:    s_max_i32 s4, s0, 0
; GFX6-NEXT:    s_sub_i32 s4, s2, s4
; GFX6-NEXT:    v_max_i32_e32 v0, s5, v0
; GFX6-NEXT:    v_min_i32_e32 v0, s4, v0
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, s0, v0
; GFX6-NEXT:    s_lshl_b32 s0, s1, 16
; GFX6-NEXT:    s_max_i32 s1, s0, 0
; GFX6-NEXT:    s_sub_i32 s1, s2, s1
; GFX6-NEXT:    s_min_i32 s2, s0, 0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    s_sub_i32 s2, s3, s2
; GFX6-NEXT:    v_max_i32_e32 v1, s2, v1
; GFX6-NEXT:    v_min_i32_e32 v1, s1, v1
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, s0, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s0, 0xffff
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX6-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_v2i16_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s4, s0
; GFX8-NEXT:    s_sext_i32_i16 s5, 0
; GFX8-NEXT:    s_max_i32 s6, s4, s5
; GFX8-NEXT:    s_movk_i32 s3, 0x8000
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_movk_i32 s2, 0x7fff
; GFX8-NEXT:    s_sub_i32 s4, s3, s4
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_max_i16_e32 v1, s4, v0
; GFX8-NEXT:    s_sub_i32 s6, s2, s6
; GFX8-NEXT:    s_sext_i32_i16 s4, s1
; GFX8-NEXT:    v_min_i16_e32 v1, s6, v1
; GFX8-NEXT:    s_max_i32 s6, s4, s5
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_sub_i32 s3, s3, s4
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_max_i16_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_sub_i32 s2, s2, s6
; GFX8-NEXT:    v_min_i16_e32 v0, s2, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_add_u16_e32 v1, s0, v1
; GFX8-NEXT:    v_add_u16_sdwa v0, v2, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_v2i16_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_v2i16_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

define amdgpu_ps float @saddsat_v2i16_vs(<2 x i16> %lhs, <2 x i16> inreg %rhs) {
; GFX6-LABEL: saddsat_v2i16_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_brev_b32 s3, 1
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v0
; GFX6-NEXT:    s_lshr_b32 s1, s0, 16
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s3, v3
; GFX6-NEXT:    s_brev_b32 s2, -2
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v0
; GFX6-NEXT:    v_max_i32_e32 v3, s0, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, s2, v2
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_i32_e32 v2, v3, v2
; GFX6-NEXT:    v_min_i32_e32 v3, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v2
; GFX6-NEXT:    v_max_i32_e32 v2, 0, v1
; GFX6-NEXT:    s_lshl_b32 s0, s1, 16
; GFX6-NEXT:    v_sub_i32_e32 v3, vcc, s3, v3
; GFX6-NEXT:    v_max_i32_e32 v3, s0, v3
; GFX6-NEXT:    v_sub_i32_e32 v2, vcc, s2, v2
; GFX6-NEXT:    v_min_i32_e32 v2, v3, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s0, 0xffff
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s0, v1
; GFX6-NEXT:    v_and_b32_e32 v0, s0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_v2i16_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_movk_i32 s3, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v3, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v3, s3, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; GFX8-NEXT:    s_movk_i32 s2, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v2, 0, v0
; GFX8-NEXT:    v_min_i16_e32 v4, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v2, s2, v2
; GFX8-NEXT:    v_max_i16_e32 v3, s0, v3
; GFX8-NEXT:    v_min_i16_e32 v2, v3, v2
; GFX8-NEXT:    v_max_i16_e32 v3, 0, v1
; GFX8-NEXT:    s_lshr_b32 s1, s0, 16
; GFX8-NEXT:    v_sub_u16_e32 v4, s3, v4
; GFX8-NEXT:    v_sub_u16_e32 v3, s2, v3
; GFX8-NEXT:    v_max_i16_e32 v4, s1, v4
; GFX8-NEXT:    v_min_i16_e32 v3, v4, v3
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v2
; GFX8-NEXT:    v_add_u16_sdwa v1, v1, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_v2i16_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_pk_add_i16 v0, v0, s0 clamp
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_v2i16_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, v0, s0 clamp
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16> %lhs, <2 x i16> %rhs)
  %cast = bitcast <2 x i16> %result to float
  ret float %cast
}

; FIXME: v3i16 insert/extract
; define <3 x i16> @v_saddsat_v3i16(<3 x i16> %lhs, <3 x i16> %rhs) {
;   %result = call <3 x i16> @llvm.sadd.sat.v3i16(<3 x i16> %lhs, <3 x i16> %rhs)
;   ret <3 x i16> %result
; }

; define amdgpu_ps <3 x i16> @s_saddsat_v3i16(<3 x i16> inreg %lhs, <3 x i16> inreg %rhs) {
;   %result = call <3 x i16> @llvm.sadd.sat.v3i16(<3 x i16> %lhs, <3 x i16> %rhs)
;   ret <3 x i16> %result
; }

define <2 x float> @v_saddsat_v4i16(<4 x i16> %lhs, <4 x i16> %rhs) {
; GFX6-LABEL: v_saddsat_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, s5, v10
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v8, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s4, v8
; GFX6-NEXT:    v_max_i32_e32 v4, v10, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v8
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s5, v8
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, s4, v5
; GFX6-NEXT:    v_max_i32_e32 v4, v8, v4
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, s5, v6
; GFX6-NEXT:    v_bfrev_b32_e32 v9, -2
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v9, v5
; GFX6-NEXT:    v_max_i32_e32 v4, v6, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v5
; GFX6-NEXT:    v_bfrev_b32_e32 v11, 1
; GFX6-NEXT:    v_min_i32_e32 v6, 0, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v4
; GFX6-NEXT:    v_max_i32_e32 v5, 0, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX6-NEXT:    v_sub_i32_e32 v6, vcc, v11, v6
; GFX6-NEXT:    v_sub_i32_e32 v5, vcc, v9, v5
; GFX6-NEXT:    v_max_i32_e32 v4, v6, v4
; GFX6-NEXT:    v_min_i32_e32 v4, v4, v5
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s4, 0xffff
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v4
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX6-NEXT:    v_and_b32_e32 v2, s4, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v7, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v7, s5, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v6, 0, v0
; GFX8-NEXT:    v_min_i16_e32 v8, 0, v4
; GFX8-NEXT:    v_sub_u16_e32 v6, s4, v6
; GFX8-NEXT:    v_max_i16_e32 v7, v7, v2
; GFX8-NEXT:    v_min_i16_e32 v6, v7, v6
; GFX8-NEXT:    v_max_i16_e32 v7, 0, v4
; GFX8-NEXT:    v_sub_u16_e32 v8, s5, v8
; GFX8-NEXT:    v_max_i16_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v8, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v7, s4, v7
; GFX8-NEXT:    v_min_i16_e32 v2, v2, v7
; GFX8-NEXT:    v_max_i16_e32 v7, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v8, s5, v8
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_min_i16_e32 v9, 0, v5
; GFX8-NEXT:    v_sub_u16_e32 v7, s4, v7
; GFX8-NEXT:    v_max_i16_e32 v8, v8, v3
; GFX8-NEXT:    v_min_i16_e32 v7, v8, v7
; GFX8-NEXT:    v_max_i16_e32 v8, 0, v5
; GFX8-NEXT:    v_sub_u16_e32 v9, s5, v9
; GFX8-NEXT:    v_sub_u16_e32 v8, s4, v8
; GFX8-NEXT:    v_max_i16_sdwa v3, v9, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v3, v3, v8
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v6
; GFX8-NEXT:    v_add_u16_sdwa v2, v4, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v7
; GFX8-NEXT:    v_add_u16_sdwa v2, v5, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v2 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, v1, v3 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v4i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v2 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, v1, v3 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16> %lhs, <4 x i16> %rhs)
  %cast = bitcast <4 x i16> %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x i32> @s_saddsat_v4i16(<4 x i16> inreg %lhs, <4 x i16> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v4i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_brev_b32 s9, 1
; GFX6-NEXT:    s_min_i32 s11, s0, 0
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_sub_i32 s11, s9, s11
; GFX6-NEXT:    s_brev_b32 s8, -2
; GFX6-NEXT:    s_max_i32 s10, s0, 0
; GFX6-NEXT:    s_sub_i32 s10, s8, s10
; GFX6-NEXT:    s_max_i32 s4, s11, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_min_i32 s4, s4, s10
; GFX6-NEXT:    s_min_i32 s10, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s4
; GFX6-NEXT:    s_lshl_b32 s4, s5, 16
; GFX6-NEXT:    s_max_i32 s5, s1, 0
; GFX6-NEXT:    s_sub_i32 s10, s9, s10
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s4, s10, s4
; GFX6-NEXT:    s_min_i32 s4, s4, s5
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s4
; GFX6-NEXT:    s_lshl_b32 s4, s6, 16
; GFX6-NEXT:    s_min_i32 s6, s2, 0
; GFX6-NEXT:    s_max_i32 s5, s2, 0
; GFX6-NEXT:    s_sub_i32 s6, s9, s6
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s4, s6, s4
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_min_i32 s4, s4, s5
; GFX6-NEXT:    s_min_i32 s6, s3, 0
; GFX6-NEXT:    s_add_i32 s2, s2, s4
; GFX6-NEXT:    s_max_i32 s5, s3, 0
; GFX6-NEXT:    s_lshl_b32 s4, s7, 16
; GFX6-NEXT:    s_sub_i32 s6, s9, s6
; GFX6-NEXT:    s_sub_i32 s5, s8, s5
; GFX6-NEXT:    s_max_i32 s4, s6, s4
; GFX6-NEXT:    s_min_i32 s4, s4, s5
; GFX6-NEXT:    s_add_i32 s3, s3, s4
; GFX6-NEXT:    s_ashr_i32 s1, s1, 16
; GFX6-NEXT:    s_mov_b32 s4, 0xffff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 16
; GFX6-NEXT:    s_and_b32 s1, s1, s4
; GFX6-NEXT:    s_ashr_i32 s2, s2, 16
; GFX6-NEXT:    s_ashr_i32 s3, s3, 16
; GFX6-NEXT:    s_and_b32 s0, s0, s4
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, s4
; GFX6-NEXT:    s_and_b32 s2, s3, s4
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v4i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s10, s0
; GFX8-NEXT:    s_sext_i32_i16 s11, 0
; GFX8-NEXT:    s_max_i32 s12, s10, s11
; GFX8-NEXT:    s_movk_i32 s9, 0x8000
; GFX8-NEXT:    s_min_i32 s10, s10, s11
; GFX8-NEXT:    s_sub_i32 s10, s9, s10
; GFX8-NEXT:    s_lshr_b32 s6, s2, 16
; GFX8-NEXT:    s_movk_i32 s8, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s10, s10
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_max_i32 s2, s10, s2
; GFX8-NEXT:    s_sub_i32 s12, s8, s12
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s10, s12
; GFX8-NEXT:    s_lshr_b32 s4, s0, 16
; GFX8-NEXT:    s_min_i32 s2, s2, s10
; GFX8-NEXT:    s_add_i32 s0, s0, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s4
; GFX8-NEXT:    s_max_i32 s10, s2, s11
; GFX8-NEXT:    s_min_i32 s2, s2, s11
; GFX8-NEXT:    s_sub_i32 s2, s9, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s6, s6
; GFX8-NEXT:    s_max_i32 s2, s2, s6
; GFX8-NEXT:    s_sub_i32 s10, s8, s10
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s6, s10
; GFX8-NEXT:    s_min_i32 s2, s2, s6
; GFX8-NEXT:    s_add_i32 s4, s4, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s1
; GFX8-NEXT:    s_max_i32 s6, s2, s11
; GFX8-NEXT:    s_min_i32 s2, s2, s11
; GFX8-NEXT:    s_sub_i32 s2, s9, s2
; GFX8-NEXT:    s_lshr_b32 s7, s3, 16
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_max_i32 s2, s2, s3
; GFX8-NEXT:    s_sub_i32 s6, s8, s6
; GFX8-NEXT:    s_sext_i32_i16 s3, s6
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_lshr_b32 s5, s1, 16
; GFX8-NEXT:    s_min_i32 s2, s2, s3
; GFX8-NEXT:    s_add_i32 s1, s1, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s5
; GFX8-NEXT:    s_max_i32 s3, s2, s11
; GFX8-NEXT:    s_min_i32 s2, s2, s11
; GFX8-NEXT:    s_sub_i32 s2, s9, s2
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s6, s7
; GFX8-NEXT:    s_sub_i32 s3, s8, s3
; GFX8-NEXT:    s_max_i32 s2, s2, s6
; GFX8-NEXT:    s_sext_i32_i16 s2, s2
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_min_i32 s2, s2, s3
; GFX8-NEXT:    s_add_i32 s5, s5, s2
; GFX8-NEXT:    s_bfe_u32 s2, s4, 0x100000
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s2
; GFX8-NEXT:    s_bfe_u32 s2, s5, 0x100000
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x100000
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s2
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v4i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, s1, v1 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v4i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s2 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, s1, s3 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16> %lhs, <4 x i16> %rhs)
  %cast = bitcast <4 x i16> %result to <2 x i32>
  ret <2 x i32> %cast
}

; FIXME
; define <5 x i16> @v_saddsat_v5i16(<5 x i16> %lhs, <5 x i16> %rhs) {
;   %result = call <5 x i16> @llvm.sadd.sat.v5i16(<5 x i16> %lhs, <5 x i16> %rhs)
;   ret <5 x i16> %result
; }

; define amdgpu_ps <5 x i16> @s_saddsat_v5i16(<5 x i16> inreg %lhs, <5 x i16> inreg %rhs) {
;   %result = call <5 x i16> @llvm.sadd.sat.v5i16(<5 x i16> %lhs, <5 x i16> %rhs)
;   ret <5 x i16> %result
; }

define <3 x float> @v_saddsat_v6i16(<6 x i16> %lhs, <6 x i16> %rhs) {
; GFX6-LABEL: v_saddsat_v6i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v14, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX6-NEXT:    v_sub_i32_e32 v14, vcc, s5, v14
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v12, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v12, vcc, s4, v12
; GFX6-NEXT:    v_max_i32_e32 v6, v14, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v12
; GFX6-NEXT:    v_min_i32_e32 v12, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX6-NEXT:    v_max_i32_e32 v7, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v12, vcc, s5, v12
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, s4, v7
; GFX6-NEXT:    v_max_i32_e32 v6, v12, v6
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v8
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, s5, v8
; GFX6-NEXT:    v_bfrev_b32_e32 v13, -2
; GFX6-NEXT:    v_max_i32_e32 v7, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, v13, v7
; GFX6-NEXT:    v_max_i32_e32 v6, v8, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_bfrev_b32_e32 v15, 1
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v6
; GFX6-NEXT:    v_max_i32_e32 v7, 0, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v9
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, v15, v8
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, v13, v7
; GFX6-NEXT:    v_max_i32_e32 v6, v8, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v4
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v6
; GFX6-NEXT:    v_max_i32_e32 v7, 0, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v10
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, v15, v8
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, v13, v7
; GFX6-NEXT:    v_max_i32_e32 v6, v8, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_min_i32_e32 v8, 0, v5
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v6
; GFX6-NEXT:    v_max_i32_e32 v7, 0, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; GFX6-NEXT:    v_sub_i32_e32 v8, vcc, v15, v8
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s4, 0xffff
; GFX6-NEXT:    v_sub_i32_e32 v7, vcc, v13, v7
; GFX6-NEXT:    v_max_i32_e32 v6, v8, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX6-NEXT:    v_min_i32_e32 v6, v6, v7
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v6
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX6-NEXT:    v_and_b32_e32 v2, s4, v3
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 16, v5
; GFX6-NEXT:    v_and_b32_e32 v3, s4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v2, s4, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v6i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v11, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v11, s5, v11
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v9, 0, v0
; GFX8-NEXT:    v_min_i16_e32 v13, 0, v6
; GFX8-NEXT:    v_sub_u16_e32 v9, s4, v9
; GFX8-NEXT:    v_max_i16_e32 v11, v11, v3
; GFX8-NEXT:    v_min_i16_e32 v9, v11, v9
; GFX8-NEXT:    v_max_i16_e32 v11, 0, v6
; GFX8-NEXT:    v_sub_u16_e32 v13, s5, v13
; GFX8-NEXT:    v_max_i16_sdwa v3, v13, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v13, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v11, s4, v11
; GFX8-NEXT:    v_min_i16_e32 v3, v3, v11
; GFX8-NEXT:    v_max_i16_e32 v11, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v13, s5, v13
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX8-NEXT:    v_min_i16_e32 v14, 0, v7
; GFX8-NEXT:    v_sub_u16_e32 v11, s4, v11
; GFX8-NEXT:    v_max_i16_e32 v13, v13, v4
; GFX8-NEXT:    v_min_i16_e32 v11, v13, v11
; GFX8-NEXT:    v_max_i16_e32 v13, 0, v7
; GFX8-NEXT:    v_sub_u16_e32 v14, s5, v14
; GFX8-NEXT:    v_max_i16_sdwa v4, v14, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_sub_u16_e32 v13, s4, v13
; GFX8-NEXT:    v_mov_b32_e32 v12, 0xffff8000
; GFX8-NEXT:    v_min_i16_e32 v14, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v14, v12, v14
; GFX8-NEXT:    v_min_i16_e32 v4, v4, v13
; GFX8-NEXT:    v_mov_b32_e32 v10, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v13, 0, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX8-NEXT:    v_sub_u16_e32 v13, v10, v13
; GFX8-NEXT:    v_max_i16_e32 v14, v14, v5
; GFX8-NEXT:    v_min_i16_e32 v13, v14, v13
; GFX8-NEXT:    v_max_i16_e32 v14, 0, v8
; GFX8-NEXT:    v_sub_u16_e32 v10, v10, v14
; GFX8-NEXT:    v_min_i16_e32 v14, 0, v8
; GFX8-NEXT:    v_sub_u16_e32 v12, v12, v14
; GFX8-NEXT:    v_max_i16_sdwa v5, v12, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v9
; GFX8-NEXT:    v_add_u16_sdwa v3, v6, v3 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX8-NEXT:    v_min_i16_e32 v5, v5, v10
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v11
; GFX8-NEXT:    v_add_u16_sdwa v3, v7, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v3
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v13
; GFX8-NEXT:    v_add_u16_sdwa v3, v8, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v3 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, v1, v4 clamp
; GFX9-NEXT:    v_pk_add_i16 v2, v2, v5 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v6i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v3 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, v1, v4 clamp
; GFX10-NEXT:    v_pk_add_i16 v2, v2, v5 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <6 x i16> @llvm.sadd.sat.v6i16(<6 x i16> %lhs, <6 x i16> %rhs)
  %cast = bitcast <6 x i16> %result to <3 x float>
  ret <3 x float> %cast
}

define amdgpu_ps <3 x i32> @s_saddsat_v6i16(<6 x i16> inreg %lhs, <6 x i16> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v6i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_brev_b32 s13, 1
; GFX6-NEXT:    s_min_i32 s15, s0, 0
; GFX6-NEXT:    s_lshl_b32 s6, s6, 16
; GFX6-NEXT:    s_sub_i32 s15, s13, s15
; GFX6-NEXT:    s_brev_b32 s12, -2
; GFX6-NEXT:    s_max_i32 s14, s0, 0
; GFX6-NEXT:    s_sub_i32 s14, s12, s14
; GFX6-NEXT:    s_max_i32 s6, s15, s6
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_min_i32 s6, s6, s14
; GFX6-NEXT:    s_min_i32 s14, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s6
; GFX6-NEXT:    s_lshl_b32 s6, s7, 16
; GFX6-NEXT:    s_max_i32 s7, s1, 0
; GFX6-NEXT:    s_sub_i32 s14, s13, s14
; GFX6-NEXT:    s_sub_i32 s7, s12, s7
; GFX6-NEXT:    s_max_i32 s6, s14, s6
; GFX6-NEXT:    s_min_i32 s6, s6, s7
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s6
; GFX6-NEXT:    s_lshl_b32 s6, s8, 16
; GFX6-NEXT:    s_min_i32 s8, s2, 0
; GFX6-NEXT:    s_max_i32 s7, s2, 0
; GFX6-NEXT:    s_sub_i32 s8, s13, s8
; GFX6-NEXT:    s_sub_i32 s7, s12, s7
; GFX6-NEXT:    s_max_i32 s6, s8, s6
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_min_i32 s6, s6, s7
; GFX6-NEXT:    s_min_i32 s8, s3, 0
; GFX6-NEXT:    s_add_i32 s2, s2, s6
; GFX6-NEXT:    s_max_i32 s7, s3, 0
; GFX6-NEXT:    s_lshl_b32 s6, s9, 16
; GFX6-NEXT:    s_sub_i32 s8, s13, s8
; GFX6-NEXT:    s_sub_i32 s7, s12, s7
; GFX6-NEXT:    s_max_i32 s6, s8, s6
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_min_i32 s6, s6, s7
; GFX6-NEXT:    s_min_i32 s8, s4, 0
; GFX6-NEXT:    s_add_i32 s3, s3, s6
; GFX6-NEXT:    s_max_i32 s7, s4, 0
; GFX6-NEXT:    s_lshl_b32 s6, s10, 16
; GFX6-NEXT:    s_sub_i32 s8, s13, s8
; GFX6-NEXT:    s_sub_i32 s7, s12, s7
; GFX6-NEXT:    s_max_i32 s6, s8, s6
; GFX6-NEXT:    s_lshl_b32 s5, s5, 16
; GFX6-NEXT:    s_min_i32 s6, s6, s7
; GFX6-NEXT:    s_min_i32 s8, s5, 0
; GFX6-NEXT:    s_add_i32 s4, s4, s6
; GFX6-NEXT:    s_max_i32 s7, s5, 0
; GFX6-NEXT:    s_lshl_b32 s6, s11, 16
; GFX6-NEXT:    s_sub_i32 s8, s13, s8
; GFX6-NEXT:    s_sub_i32 s7, s12, s7
; GFX6-NEXT:    s_max_i32 s6, s8, s6
; GFX6-NEXT:    s_min_i32 s6, s6, s7
; GFX6-NEXT:    s_add_i32 s5, s5, s6
; GFX6-NEXT:    s_ashr_i32 s1, s1, 16
; GFX6-NEXT:    s_mov_b32 s6, 0xffff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 16
; GFX6-NEXT:    s_and_b32 s1, s1, s6
; GFX6-NEXT:    s_ashr_i32 s2, s2, 16
; GFX6-NEXT:    s_ashr_i32 s3, s3, 16
; GFX6-NEXT:    s_and_b32 s0, s0, s6
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, s6
; GFX6-NEXT:    s_and_b32 s2, s3, s6
; GFX6-NEXT:    s_ashr_i32 s5, s5, 16
; GFX6-NEXT:    s_and_b32 s3, s5, s6
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_ashr_i32 s4, s4, 16
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s2, s4, s6
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_or_b32 s2, s2, s3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v6i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s14, s0
; GFX8-NEXT:    s_sext_i32_i16 s15, 0
; GFX8-NEXT:    s_max_i32 s16, s14, s15
; GFX8-NEXT:    s_movk_i32 s13, 0x8000
; GFX8-NEXT:    s_min_i32 s14, s14, s15
; GFX8-NEXT:    s_sub_i32 s14, s13, s14
; GFX8-NEXT:    s_lshr_b32 s9, s3, 16
; GFX8-NEXT:    s_movk_i32 s12, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s14, s14
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_max_i32 s3, s14, s3
; GFX8-NEXT:    s_sub_i32 s16, s12, s16
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s14, s16
; GFX8-NEXT:    s_lshr_b32 s6, s0, 16
; GFX8-NEXT:    s_min_i32 s3, s3, s14
; GFX8-NEXT:    s_add_i32 s0, s0, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s6
; GFX8-NEXT:    s_max_i32 s14, s3, s15
; GFX8-NEXT:    s_min_i32 s3, s3, s15
; GFX8-NEXT:    s_sub_i32 s3, s13, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s9, s9
; GFX8-NEXT:    s_max_i32 s3, s3, s9
; GFX8-NEXT:    s_sub_i32 s14, s12, s14
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s9, s14
; GFX8-NEXT:    s_min_i32 s3, s3, s9
; GFX8-NEXT:    s_add_i32 s6, s6, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s1
; GFX8-NEXT:    s_max_i32 s9, s3, s15
; GFX8-NEXT:    s_min_i32 s3, s3, s15
; GFX8-NEXT:    s_sub_i32 s3, s13, s3
; GFX8-NEXT:    s_lshr_b32 s10, s4, 16
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_max_i32 s3, s3, s4
; GFX8-NEXT:    s_sub_i32 s9, s12, s9
; GFX8-NEXT:    s_sext_i32_i16 s4, s9
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_lshr_b32 s7, s1, 16
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_add_i32 s1, s1, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s7
; GFX8-NEXT:    s_max_i32 s4, s3, s15
; GFX8-NEXT:    s_min_i32 s3, s3, s15
; GFX8-NEXT:    s_sub_i32 s3, s13, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s9, s10
; GFX8-NEXT:    s_sub_i32 s4, s12, s4
; GFX8-NEXT:    s_max_i32 s3, s3, s9
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_add_i32 s7, s7, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s2
; GFX8-NEXT:    s_max_i32 s4, s3, s15
; GFX8-NEXT:    s_min_i32 s3, s3, s15
; GFX8-NEXT:    s_sub_i32 s3, s13, s3
; GFX8-NEXT:    s_lshr_b32 s11, s5, 16
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_max_i32 s3, s3, s5
; GFX8-NEXT:    s_sub_i32 s4, s12, s4
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_lshr_b32 s8, s2, 16
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_add_i32 s2, s2, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s8
; GFX8-NEXT:    s_max_i32 s4, s3, s15
; GFX8-NEXT:    s_min_i32 s3, s3, s15
; GFX8-NEXT:    s_sub_i32 s3, s13, s3
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s5, s11
; GFX8-NEXT:    s_sub_i32 s4, s12, s4
; GFX8-NEXT:    s_max_i32 s3, s3, s5
; GFX8-NEXT:    s_sext_i32_i16 s3, s3
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_min_i32 s3, s3, s4
; GFX8-NEXT:    s_add_i32 s8, s8, s3
; GFX8-NEXT:    s_bfe_u32 s3, s6, 0x100000
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s3
; GFX8-NEXT:    s_bfe_u32 s3, s7, 0x100000
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x100000
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s3
; GFX8-NEXT:    s_bfe_u32 s3, s8, 0x100000
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x100000
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_or_b32 s2, s2, s3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v6i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    v_mov_b32_e32 v2, s5
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, s1, v1 clamp
; GFX9-NEXT:    v_pk_add_i16 v2, s2, v2 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v6i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s3 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, s1, s4 clamp
; GFX10-NEXT:    v_pk_add_i16 v2, s2, s5 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <6 x i16> @llvm.sadd.sat.v6i16(<6 x i16> %lhs, <6 x i16> %rhs)
  %cast = bitcast <6 x i16> %result to <3 x i32>
  ret <3 x i32> %cast
}

define <4 x float> @v_saddsat_v8i16(<8 x i16> %lhs, <8 x i16> %rhs) {
; GFX6-LABEL: v_saddsat_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    v_min_i32_e32 v18, 0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX6-NEXT:    v_sub_i32_e32 v18, vcc, s5, v18
; GFX6-NEXT:    s_brev_b32 s4, -2
; GFX6-NEXT:    v_max_i32_e32 v16, 0, v0
; GFX6-NEXT:    v_sub_i32_e32 v16, vcc, s4, v16
; GFX6-NEXT:    v_max_i32_e32 v8, v18, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v16
; GFX6-NEXT:    v_min_i32_e32 v16, 0, v1
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, v0, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v1
; GFX6-NEXT:    v_sub_i32_e32 v16, vcc, s5, v16
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, s4, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v16, v8
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_add_i32_e32 v1, vcc, v1, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, s5, v10
; GFX6-NEXT:    v_bfrev_b32_e32 v17, -2
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v2
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_bfrev_b32_e32 v19, 1
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v3
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, v2, v8
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v3
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v11
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, v19, v10
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v4
; GFX6-NEXT:    v_add_i32_e32 v3, vcc, v3, v8
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v12
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, v19, v10
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v5
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v4, v8
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v13
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, v19, v10
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v6
; GFX6-NEXT:    v_add_i32_e32 v5, vcc, v5, v8
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v14
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, v19, v10
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_min_i32_e32 v10, 0, v7
; GFX6-NEXT:    v_add_i32_e32 v6, vcc, v6, v8
; GFX6-NEXT:    v_max_i32_e32 v9, 0, v7
; GFX6-NEXT:    v_ashrrev_i32_e32 v1, 16, v1
; GFX6-NEXT:    s_mov_b32 s4, 0xffff
; GFX6-NEXT:    v_lshlrev_b32_e32 v8, 16, v15
; GFX6-NEXT:    v_sub_i32_e32 v10, vcc, v19, v10
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 16, v0
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX6-NEXT:    v_sub_i32_e32 v9, vcc, v17, v9
; GFX6-NEXT:    v_max_i32_e32 v8, v10, v8
; GFX6-NEXT:    v_min_i32_e32 v8, v8, v9
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 16, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_add_i32_e32 v7, vcc, v7, v8
; GFX6-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX6-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX6-NEXT:    v_and_b32_e32 v2, s4, v3
; GFX6-NEXT:    v_ashrrev_i32_e32 v5, 16, v5
; GFX6-NEXT:    v_and_b32_e32 v3, s4, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_ashrrev_i32_e32 v4, 16, v4
; GFX6-NEXT:    v_ashrrev_i32_e32 v7, 16, v7
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_and_b32_e32 v2, s4, v4
; GFX6-NEXT:    v_and_b32_e32 v4, s4, v7
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_ashrrev_i32_e32 v6, 16, v6
; GFX6-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX6-NEXT:    v_and_b32_e32 v3, s4, v6
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX6-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_movk_i32 s5, 0x8000
; GFX8-NEXT:    v_min_i16_e32 v14, 0, v0
; GFX8-NEXT:    v_sub_u16_e32 v14, s5, v14
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX8-NEXT:    s_movk_i32 s4, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v12, 0, v0
; GFX8-NEXT:    v_min_i16_e32 v16, 0, v8
; GFX8-NEXT:    v_sub_u16_e32 v12, s4, v12
; GFX8-NEXT:    v_max_i16_e32 v14, v14, v4
; GFX8-NEXT:    v_min_i16_e32 v12, v14, v12
; GFX8-NEXT:    v_max_i16_e32 v14, 0, v8
; GFX8-NEXT:    v_sub_u16_e32 v16, s5, v16
; GFX8-NEXT:    v_max_i16_sdwa v4, v16, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v16, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v14, s4, v14
; GFX8-NEXT:    v_min_i16_e32 v4, v4, v14
; GFX8-NEXT:    v_max_i16_e32 v14, 0, v1
; GFX8-NEXT:    v_sub_u16_e32 v16, s5, v16
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX8-NEXT:    v_min_i16_e32 v17, 0, v9
; GFX8-NEXT:    v_sub_u16_e32 v14, s4, v14
; GFX8-NEXT:    v_max_i16_e32 v16, v16, v5
; GFX8-NEXT:    v_min_i16_e32 v14, v16, v14
; GFX8-NEXT:    v_max_i16_e32 v16, 0, v9
; GFX8-NEXT:    v_sub_u16_e32 v17, s5, v17
; GFX8-NEXT:    v_max_i16_sdwa v5, v17, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_sub_u16_e32 v16, s4, v16
; GFX8-NEXT:    v_mov_b32_e32 v15, 0xffff8000
; GFX8-NEXT:    v_min_i16_e32 v17, 0, v2
; GFX8-NEXT:    v_sub_u16_e32 v17, v15, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; GFX8-NEXT:    v_min_i16_e32 v5, v5, v16
; GFX8-NEXT:    v_mov_b32_e32 v13, 0x7fff
; GFX8-NEXT:    v_max_i16_e32 v16, 0, v2
; GFX8-NEXT:    v_min_i16_e32 v18, 0, v10
; GFX8-NEXT:    v_sub_u16_e32 v16, v13, v16
; GFX8-NEXT:    v_max_i16_e32 v17, v17, v6
; GFX8-NEXT:    v_min_i16_e32 v16, v17, v16
; GFX8-NEXT:    v_max_i16_e32 v17, 0, v10
; GFX8-NEXT:    v_sub_u16_e32 v18, v15, v18
; GFX8-NEXT:    v_max_i16_sdwa v6, v18, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_min_i16_e32 v18, 0, v3
; GFX8-NEXT:    v_sub_u16_e32 v17, v13, v17
; GFX8-NEXT:    v_sub_u16_e32 v18, v15, v18
; GFX8-NEXT:    v_min_i16_e32 v6, v6, v17
; GFX8-NEXT:    v_max_i16_e32 v17, 0, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 16, v3
; GFX8-NEXT:    v_sub_u16_e32 v17, v13, v17
; GFX8-NEXT:    v_max_i16_e32 v18, v18, v7
; GFX8-NEXT:    v_min_i16_e32 v17, v18, v17
; GFX8-NEXT:    v_max_i16_e32 v18, 0, v11
; GFX8-NEXT:    v_sub_u16_e32 v13, v13, v18
; GFX8-NEXT:    v_min_i16_e32 v18, 0, v11
; GFX8-NEXT:    v_sub_u16_e32 v15, v15, v18
; GFX8-NEXT:    v_add_u16_e32 v0, v0, v12
; GFX8-NEXT:    v_add_u16_sdwa v4, v8, v4 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_max_i16_sdwa v7, v15, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v4
; GFX8-NEXT:    v_add_u16_e32 v1, v1, v14
; GFX8-NEXT:    v_add_u16_sdwa v4, v9, v5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX8-NEXT:    v_min_i16_e32 v7, v7, v13
; GFX8-NEXT:    v_add_u16_e32 v2, v2, v16
; GFX8-NEXT:    v_add_u16_sdwa v4, v10, v6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX8-NEXT:    v_add_u16_e32 v3, v3, v17
; GFX8-NEXT:    v_add_u16_sdwa v4, v11, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_pk_add_i16 v0, v0, v4 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, v1, v5 clamp
; GFX9-NEXT:    v_pk_add_i16 v2, v2, v6 clamp
; GFX9-NEXT:    v_pk_add_i16 v3, v3, v7 clamp
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v8i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_pk_add_i16 v0, v0, v4 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, v1, v5 clamp
; GFX10-NEXT:    v_pk_add_i16 v2, v2, v6 clamp
; GFX10-NEXT:    v_pk_add_i16 v3, v3, v7 clamp
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %lhs, <8 x i16> %rhs)
  %cast = bitcast <8 x i16> %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x i32> @s_saddsat_v8i16(<8 x i16> inreg %lhs, <8 x i16> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v8i16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_lshl_b32 s0, s0, 16
; GFX6-NEXT:    s_brev_b32 s17, 1
; GFX6-NEXT:    s_min_i32 s19, s0, 0
; GFX6-NEXT:    s_lshl_b32 s8, s8, 16
; GFX6-NEXT:    s_sub_i32 s19, s17, s19
; GFX6-NEXT:    s_brev_b32 s16, -2
; GFX6-NEXT:    s_max_i32 s18, s0, 0
; GFX6-NEXT:    s_sub_i32 s18, s16, s18
; GFX6-NEXT:    s_max_i32 s8, s19, s8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s18
; GFX6-NEXT:    s_min_i32 s18, s1, 0
; GFX6-NEXT:    s_add_i32 s0, s0, s8
; GFX6-NEXT:    s_lshl_b32 s8, s9, 16
; GFX6-NEXT:    s_max_i32 s9, s1, 0
; GFX6-NEXT:    s_sub_i32 s18, s17, s18
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s18, s8
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_add_i32 s1, s1, s8
; GFX6-NEXT:    s_lshl_b32 s8, s10, 16
; GFX6-NEXT:    s_min_i32 s10, s2, 0
; GFX6-NEXT:    s_max_i32 s9, s2, 0
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_min_i32 s10, s3, 0
; GFX6-NEXT:    s_add_i32 s2, s2, s8
; GFX6-NEXT:    s_max_i32 s9, s3, 0
; GFX6-NEXT:    s_lshl_b32 s8, s11, 16
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_min_i32 s10, s4, 0
; GFX6-NEXT:    s_add_i32 s3, s3, s8
; GFX6-NEXT:    s_max_i32 s9, s4, 0
; GFX6-NEXT:    s_lshl_b32 s8, s12, 16
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_lshl_b32 s5, s5, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_min_i32 s10, s5, 0
; GFX6-NEXT:    s_add_i32 s4, s4, s8
; GFX6-NEXT:    s_max_i32 s9, s5, 0
; GFX6-NEXT:    s_lshl_b32 s8, s13, 16
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_lshl_b32 s6, s6, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_min_i32 s10, s6, 0
; GFX6-NEXT:    s_add_i32 s5, s5, s8
; GFX6-NEXT:    s_max_i32 s9, s6, 0
; GFX6-NEXT:    s_lshl_b32 s8, s14, 16
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_lshl_b32 s7, s7, 16
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_min_i32 s10, s7, 0
; GFX6-NEXT:    s_add_i32 s6, s6, s8
; GFX6-NEXT:    s_max_i32 s9, s7, 0
; GFX6-NEXT:    s_lshl_b32 s8, s15, 16
; GFX6-NEXT:    s_sub_i32 s10, s17, s10
; GFX6-NEXT:    s_sub_i32 s9, s16, s9
; GFX6-NEXT:    s_max_i32 s8, s10, s8
; GFX6-NEXT:    s_min_i32 s8, s8, s9
; GFX6-NEXT:    s_add_i32 s7, s7, s8
; GFX6-NEXT:    s_ashr_i32 s1, s1, 16
; GFX6-NEXT:    s_mov_b32 s8, 0xffff
; GFX6-NEXT:    s_ashr_i32 s0, s0, 16
; GFX6-NEXT:    s_and_b32 s1, s1, s8
; GFX6-NEXT:    s_ashr_i32 s2, s2, 16
; GFX6-NEXT:    s_ashr_i32 s3, s3, 16
; GFX6-NEXT:    s_and_b32 s0, s0, s8
; GFX6-NEXT:    s_lshl_b32 s1, s1, 16
; GFX6-NEXT:    s_or_b32 s0, s0, s1
; GFX6-NEXT:    s_and_b32 s1, s2, s8
; GFX6-NEXT:    s_and_b32 s2, s3, s8
; GFX6-NEXT:    s_ashr_i32 s5, s5, 16
; GFX6-NEXT:    s_and_b32 s3, s5, s8
; GFX6-NEXT:    s_lshl_b32 s2, s2, 16
; GFX6-NEXT:    s_ashr_i32 s4, s4, 16
; GFX6-NEXT:    s_ashr_i32 s7, s7, 16
; GFX6-NEXT:    s_or_b32 s1, s1, s2
; GFX6-NEXT:    s_and_b32 s2, s4, s8
; GFX6-NEXT:    s_and_b32 s4, s7, s8
; GFX6-NEXT:    s_lshl_b32 s3, s3, 16
; GFX6-NEXT:    s_ashr_i32 s6, s6, 16
; GFX6-NEXT:    s_or_b32 s2, s2, s3
; GFX6-NEXT:    s_and_b32 s3, s6, s8
; GFX6-NEXT:    s_lshl_b32 s4, s4, 16
; GFX6-NEXT:    s_or_b32 s3, s3, s4
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v8i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_sext_i32_i16 s18, s0
; GFX8-NEXT:    s_sext_i32_i16 s19, 0
; GFX8-NEXT:    s_max_i32 s20, s18, s19
; GFX8-NEXT:    s_movk_i32 s17, 0x8000
; GFX8-NEXT:    s_min_i32 s18, s18, s19
; GFX8-NEXT:    s_sub_i32 s18, s17, s18
; GFX8-NEXT:    s_lshr_b32 s12, s4, 16
; GFX8-NEXT:    s_movk_i32 s16, 0x7fff
; GFX8-NEXT:    s_sext_i32_i16 s18, s18
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_max_i32 s4, s18, s4
; GFX8-NEXT:    s_sub_i32 s20, s16, s20
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s18, s20
; GFX8-NEXT:    s_lshr_b32 s8, s0, 16
; GFX8-NEXT:    s_min_i32 s4, s4, s18
; GFX8-NEXT:    s_add_i32 s0, s0, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s8
; GFX8-NEXT:    s_max_i32 s18, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s12, s12
; GFX8-NEXT:    s_max_i32 s4, s4, s12
; GFX8-NEXT:    s_sub_i32 s18, s16, s18
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s12, s18
; GFX8-NEXT:    s_min_i32 s4, s4, s12
; GFX8-NEXT:    s_add_i32 s8, s8, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s1
; GFX8-NEXT:    s_max_i32 s12, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_lshr_b32 s13, s5, 16
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_max_i32 s4, s4, s5
; GFX8-NEXT:    s_sub_i32 s12, s16, s12
; GFX8-NEXT:    s_sext_i32_i16 s5, s12
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_lshr_b32 s9, s1, 16
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s1, s1, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s9
; GFX8-NEXT:    s_max_i32 s5, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s12, s13
; GFX8-NEXT:    s_sub_i32 s5, s16, s5
; GFX8-NEXT:    s_max_i32 s4, s4, s12
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s9, s9, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s2
; GFX8-NEXT:    s_max_i32 s5, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_lshr_b32 s14, s6, 16
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s6, s6
; GFX8-NEXT:    s_max_i32 s4, s4, s6
; GFX8-NEXT:    s_sub_i32 s5, s16, s5
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_lshr_b32 s10, s2, 16
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s2, s2, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s10
; GFX8-NEXT:    s_max_i32 s5, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s6, s14
; GFX8-NEXT:    s_max_i32 s4, s4, s6
; GFX8-NEXT:    s_sub_i32 s5, s16, s5
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s10, s10, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s3
; GFX8-NEXT:    s_max_i32 s5, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s6, s7
; GFX8-NEXT:    s_sub_i32 s5, s16, s5
; GFX8-NEXT:    s_max_i32 s4, s4, s6
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_lshr_b32 s11, s3, 16
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s3, s3, s4
; GFX8-NEXT:    s_sext_i32_i16 s4, s11
; GFX8-NEXT:    s_max_i32 s5, s4, s19
; GFX8-NEXT:    s_min_i32 s4, s4, s19
; GFX8-NEXT:    s_sub_i32 s4, s17, s4
; GFX8-NEXT:    s_lshr_b32 s15, s7, 16
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s6, s15
; GFX8-NEXT:    s_sub_i32 s5, s16, s5
; GFX8-NEXT:    s_max_i32 s4, s4, s6
; GFX8-NEXT:    s_sext_i32_i16 s4, s4
; GFX8-NEXT:    s_sext_i32_i16 s5, s5
; GFX8-NEXT:    s_min_i32 s4, s4, s5
; GFX8-NEXT:    s_add_i32 s11, s11, s4
; GFX8-NEXT:    s_bfe_u32 s4, s8, 0x100000
; GFX8-NEXT:    s_bfe_u32 s0, s0, 0x100000
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s0, s0, s4
; GFX8-NEXT:    s_bfe_u32 s4, s9, 0x100000
; GFX8-NEXT:    s_bfe_u32 s1, s1, 0x100000
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s1, s1, s4
; GFX8-NEXT:    s_bfe_u32 s4, s10, 0x100000
; GFX8-NEXT:    s_bfe_u32 s2, s2, 0x100000
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s2, s2, s4
; GFX8-NEXT:    s_bfe_u32 s4, s11, 0x100000
; GFX8-NEXT:    s_bfe_u32 s3, s3, 0x100000
; GFX8-NEXT:    s_lshl_b32 s4, s4, 16
; GFX8-NEXT:    s_or_b32 s3, s3, s4
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v8i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s7
; GFX9-NEXT:    v_pk_add_i16 v0, s0, v0 clamp
; GFX9-NEXT:    v_pk_add_i16 v1, s1, v1 clamp
; GFX9-NEXT:    v_pk_add_i16 v2, s2, v2 clamp
; GFX9-NEXT:    v_pk_add_i16 v3, s3, v3 clamp
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v8i16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_pk_add_i16 v0, s0, s4 clamp
; GFX10-NEXT:    v_pk_add_i16 v1, s1, s5 clamp
; GFX10-NEXT:    v_pk_add_i16 v2, s2, s6 clamp
; GFX10-NEXT:    v_pk_add_i16 v3, s3, s7 clamp
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16> %lhs, <8 x i16> %rhs)
  %cast = bitcast <8 x i16> %result to <4 x i32>
  ret <4 x i32> %cast
}

; FIXME: i48 broken because i48 add broken
; define i48 @v_saddsat_i48(i48 %lhs, i48 %rhs) {
;   %result = call i48 @llvm.sadd.sat.i48(i48 %lhs, i48 %rhs)
;   ret i48 %result
; }

; define amdgpu_ps i48 @s_saddsat_i48(i48 inreg %lhs, i48 inreg %rhs) {
;   %result = call i48 @llvm.sadd.sat.i48(i48 %lhs, i48 %rhs)
;   ret i48 %result
; }

; define amdgpu_ps <2 x float> @saddsat_i48_sv(i48 inreg %lhs, i48 %rhs) {
;   %result = call i48 @llvm.sadd.sat.i48(i48 %lhs, i48 %rhs)
;   %ext.result = zext i48 %result to i64
;   %cast = bitcast i64 %ext.result to <2 x float>
;   ret <2 x float> %cast
; }

; define amdgpu_ps <2 x float> @saddsat_i48_vs(i48 %lhs, i48 inreg %rhs) {
;   %result = call i48 @llvm.sadd.sat.i48(i48 %lhs, i48 %rhs)
;   %ext.result = zext i48 %result to i64
;   %cast = bitcast i64 %ext.result to <2 x float>
;   ret <2 x float> %cast
; }

define i64 @v_saddsat_i64(i64 %lhs, i64 %rhs) {
; GFX6-LABEL: v_saddsat_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v0, v2
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v1, v3, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[0:1]
; GFX6-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[2:3]
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 31, v5
; GFX6-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX6-NEXT:    v_add_i32_e64 v2, s[6:7], 0, v0
; GFX6-NEXT:    v_addc_u32_e64 v1, s[6:7], v0, v1, s[6:7]
; GFX6-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v0, v2
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v1, v3, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[0:1]
; GFX8-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[2:3]
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 31, v5
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    v_add_u32_e64 v2, s[6:7], 0, v0
; GFX8-NEXT:    v_addc_u32_e64 v1, s[6:7], v0, v1, s[6:7]
; GFX8-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v0, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v1, v3, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[0:1]
; GFX9-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[2:3]
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 31, v5
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    v_add_co_u32_e64 v2, s[6:7], 0, v0
; GFX9-NEXT:    v_addc_co_u32_e64 v1, s[6:7], v0, v1, s[6:7]
; GFX9-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_add_co_u32_e64 v10, vcc_lo, v0, v2
; GFX10-NEXT:    v_add_co_ci_u32_e32 v11, vcc_lo, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, 0, v[2:3]
; GFX10-NEXT:    v_ashrrev_i32_e32 v6, 31, v11
; GFX10-NEXT:    v_cmp_lt_i64_e64 s4, v[10:11], v[0:1]
; GFX10-NEXT:    v_add_co_u32_e64 v0, s5, v6, 0
; GFX10-NEXT:    v_add_co_ci_u32_e64 v1, s5, 0x80000000, v6, s5
; GFX10-NEXT:    s_xor_b32 vcc_lo, vcc_lo, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v10, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v11, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call i64 @llvm.sadd.sat.i64(i64 %lhs, i64 %rhs)
  ret i64 %result
}

define amdgpu_ps i64 @s_saddsat_i64(i64 inreg %lhs, i64 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s4, s0, s2
; GFX6-NEXT:    s_cselect_b32 s5, 1, 0
; GFX6-NEXT:    s_and_b32 s5, s5, 1
; GFX6-NEXT:    s_cmp_lg_u32 s5, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    s_addc_u32 s5, s1, s3
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX6-NEXT:    s_ashr_i32 s2, s5, 31
; GFX6-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX6-NEXT:    s_add_u32 s0, s2, 0
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    s_addc_u32 s1, s2, 0x80000000
; GFX6-NEXT:    v_mov_b32_e32 v0, s4
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    v_readfirstlane_b32 s1, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s4, s0, s2
; GFX8-NEXT:    s_cselect_b32 s5, 1, 0
; GFX8-NEXT:    s_and_b32 s5, s5, 1
; GFX8-NEXT:    s_cmp_lg_u32 s5, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_addc_u32 s5, s1, s3
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX8-NEXT:    s_ashr_i32 s2, s5, 31
; GFX8-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX8-NEXT:    s_add_u32 s0, s2, 0
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    s_addc_u32 s1, s2, 0x80000000
; GFX8-NEXT:    v_mov_b32_e32 v0, s4
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s4, s0, s2
; GFX9-NEXT:    s_cselect_b32 s5, 1, 0
; GFX9-NEXT:    s_and_b32 s5, s5, 1
; GFX9-NEXT:    s_cmp_lg_u32 s5, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_addc_u32 s5, s1, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[4:5], v[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX9-NEXT:    s_ashr_i32 s2, s5, 31
; GFX9-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX9-NEXT:    s_add_u32 s0, s2, 0
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    s_addc_u32 s1, s2, 0x80000000
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s4, s0, s2
; GFX10-NEXT:    s_cselect_b32 s5, 1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-NEXT:    s_and_b32 s5, s5, 1
; GFX10-NEXT:    s_cmp_lg_u32 s5, 0
; GFX10-NEXT:    s_addc_u32 s5, s1, s3
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[4:5], s[0:1]
; GFX10-NEXT:    v_cmp_lt_i64_e64 s1, s[2:3], 0
; GFX10-NEXT:    s_ashr_i32 s2, s5, 31
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    s_xor_b32 s3, s1, s0
; GFX10-NEXT:    s_add_u32 s0, s2, 0
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s3
; GFX10-NEXT:    s_and_b32 s1, s1, 1
; GFX10-NEXT:    s_cmp_lg_u32 s1, 0
; GFX10-NEXT:    s_addc_u32 s1, s2, 0x80000000
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s1, s3
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.sadd.sat.i64(i64 %lhs, i64 %rhs)
  ret i64 %result
}

define amdgpu_ps <2 x float> @saddsat_i64_sv(i64 inreg %lhs, i64 %rhs) {
; GFX6-LABEL: saddsat_i64_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v1, vcc
; GFX6-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[2:3]
; GFX6-NEXT:    v_cmp_gt_i64_e64 s[0:1], 0, v[0:1]
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX6-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX6-NEXT:    v_add_i32_e64 v4, s[2:3], 0, v0
; GFX6-NEXT:    v_addc_u32_e64 v1, s[2:3], v0, v1, s[2:3]
; GFX6-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i64_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v1, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[2:3]
; GFX8-NEXT:    v_cmp_gt_i64_e64 s[0:1], 0, v[0:1]
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    v_add_u32_e64 v4, s[2:3], 0, v0
; GFX8-NEXT:    v_addc_u32_e64 v1, s[2:3], v0, v1, s[2:3]
; GFX8-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i64_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v1, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, s[0:1], v[2:3]
; GFX9-NEXT:    v_cmp_gt_i64_e64 s[0:1], 0, v[0:1]
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    v_add_co_u32_e64 v4, s[2:3], 0, v0
; GFX9-NEXT:    v_addc_co_u32_e64 v1, s[2:3], v0, v1, s[2:3]
; GFX9-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i64_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32_e64 v2, vcc_lo, s0, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX10-NEXT:    v_cmp_gt_i64_e64 s0, s[0:1], v[2:3]
; GFX10-NEXT:    v_add_co_u32_e64 v0, s1, v4, 0
; GFX10-NEXT:    v_add_co_ci_u32_e64 v1, s1, 0x80000000, v4, s1
; GFX10-NEXT:    s_xor_b32 vcc_lo, vcc_lo, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.sadd.sat.i64(i64 %lhs, i64 %rhs)
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define amdgpu_ps <2 x float> @saddsat_i64_vs(i64 %lhs, i64 inreg %rhs) {
; GFX6-LABEL: saddsat_i64_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    v_add_i32_e32 v2, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v1, v3, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[2:3], v[0:1]
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[0:1], 0
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX6-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX6-NEXT:    v_add_i32_e64 v4, s[0:1], 0, v0
; GFX6-NEXT:    v_addc_u32_e64 v1, s[0:1], v0, v1, s[0:1]
; GFX6-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i64_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_add_u32_e32 v2, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v1, v3, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[2:3], v[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[0:1], 0
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX8-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX8-NEXT:    v_add_u32_e64 v4, s[0:1], 0, v0
; GFX8-NEXT:    v_addc_u32_e64 v1, s[0:1], v0, v1, s[0:1]
; GFX8-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i64_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v1, v3, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[2:3], v[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[0:1], 0
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 31, v3
; GFX9-NEXT:    v_bfrev_b32_e32 v1, 1
; GFX9-NEXT:    v_add_co_u32_e64 v4, s[0:1], 0, v0
; GFX9-NEXT:    v_addc_co_u32_e64 v1, s[0:1], v0, v1, s[0:1]
; GFX9-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i64_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32_e64 v2, vcc_lo, v0, s0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_i64_e64 s1, s[0:1], 0
; GFX10-NEXT:    v_ashrrev_i32_e32 v4, 31, v3
; GFX10-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[2:3], v[0:1]
; GFX10-NEXT:    v_add_co_u32_e64 v0, s0, v4, 0
; GFX10-NEXT:    v_add_co_ci_u32_e64 v1, s0, 0x80000000, v4, s0
; GFX10-NEXT:    s_xor_b32 vcc_lo, s1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i64 @llvm.sadd.sat.i64(i64 %lhs, i64 %rhs)
  %cast = bitcast i64 %result to <2 x float>
  ret <2 x float> %cast
}

define <2 x i64> @v_saddsat_v2i64(<2 x i64> %lhs, <2 x i64> %rhs) {
; GFX6-LABEL: v_saddsat_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v8, vcc, v0, v4
; GFX6-NEXT:    v_addc_u32_e32 v9, vcc, v1, v5, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[8:9], v[0:1]
; GFX6-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[4:5]
; GFX6-NEXT:    v_ashrrev_i32_e32 v0, 31, v9
; GFX6-NEXT:    v_bfrev_b32_e32 v10, 1
; GFX6-NEXT:    v_add_i32_e64 v1, s[6:7], 0, v0
; GFX6-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX6-NEXT:    v_addc_u32_e64 v4, s[6:7], v0, v10, s[6:7]
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v8, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, v2, v6
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v3, v7, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[2:3]
; GFX6-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[6:7]
; GFX6-NEXT:    v_ashrrev_i32_e32 v2, 31, v5
; GFX6-NEXT:    v_add_i32_e64 v3, s[6:7], 0, v2
; GFX6-NEXT:    v_addc_u32_e64 v6, s[6:7], v2, v10, s[6:7]
; GFX6-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v4, v3, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v0, v4
; GFX8-NEXT:    v_addc_u32_e32 v9, vcc, v1, v5, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[8:9], v[0:1]
; GFX8-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[4:5]
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 31, v9
; GFX8-NEXT:    v_bfrev_b32_e32 v10, 1
; GFX8-NEXT:    v_add_u32_e64 v1, s[6:7], 0, v0
; GFX8-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX8-NEXT:    v_addc_u32_e64 v4, s[6:7], v0, v10, s[6:7]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v8, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, v2, v6
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v3, v7, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[2:3]
; GFX8-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[6:7]
; GFX8-NEXT:    v_ashrrev_i32_e32 v2, 31, v5
; GFX8-NEXT:    v_add_u32_e64 v3, s[6:7], 0, v2
; GFX8-NEXT:    v_addc_u32_e64 v6, s[6:7], v2, v10, s[6:7]
; GFX8-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v3, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, v0, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, v1, v5, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[8:9], v[0:1]
; GFX9-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[4:5]
; GFX9-NEXT:    v_ashrrev_i32_e32 v0, 31, v9
; GFX9-NEXT:    v_bfrev_b32_e32 v10, 1
; GFX9-NEXT:    v_add_co_u32_e64 v1, s[6:7], 0, v0
; GFX9-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX9-NEXT:    v_addc_co_u32_e64 v4, s[6:7], v0, v10, s[6:7]
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v8, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, v2, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v3, v7, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[4:5], v[2:3]
; GFX9-NEXT:    v_cmp_gt_i64_e64 s[4:5], 0, v[6:7]
; GFX9-NEXT:    v_ashrrev_i32_e32 v2, 31, v5
; GFX9-NEXT:    v_add_co_u32_e64 v3, s[6:7], 0, v2
; GFX9-NEXT:    v_addc_co_u32_e64 v6, s[6:7], v2, v10, s[6:7]
; GFX9-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v3, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v5, v6, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v2i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v14, v0
; GFX10-NEXT:    v_mov_b32_e32 v15, v1
; GFX10-NEXT:    v_mov_b32_e32 v17, v2
; GFX10-NEXT:    v_mov_b32_e32 v18, v3
; GFX10-NEXT:    v_cmp_gt_i64_e64 s4, 0, v[4:5]
; GFX10-NEXT:    v_add_co_u32_e64 v8, vcc_lo, v14, v4
; GFX10-NEXT:    v_cmp_gt_i64_e64 s6, 0, v[6:7]
; GFX10-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v15, v5, vcc_lo
; GFX10-NEXT:    v_add_co_u32_e64 v19, vcc_lo, v17, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v20, vcc_lo, v18, v7, vcc_lo
; GFX10-NEXT:    v_ashrrev_i32_e32 v12, 31, v9
; GFX10-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[8:9], v[14:15]
; GFX10-NEXT:    v_ashrrev_i32_e32 v0, 31, v20
; GFX10-NEXT:    v_add_co_u32_e64 v1, s5, v12, 0
; GFX10-NEXT:    v_add_co_ci_u32_e64 v4, s5, 0x80000000, v12, s5
; GFX10-NEXT:    v_cmp_lt_i64_e64 s5, v[19:20], v[17:18]
; GFX10-NEXT:    v_add_co_u32_e64 v2, s7, v0, 0
; GFX10-NEXT:    s_xor_b32 vcc_lo, s4, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e64 v3, s7, 0x80000000, v0, s7
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v8, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v9, v4, vcc_lo
; GFX10-NEXT:    s_xor_b32 vcc_lo, s6, s5
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %lhs, <2 x i64> %rhs)
  ret <2 x i64> %result
}

define amdgpu_ps <2 x i64> @s_saddsat_v2i64(<2 x i64> inreg %lhs, <2 x i64> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v2i64:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s8, s0, s4
; GFX6-NEXT:    s_cselect_b32 s9, 1, 0
; GFX6-NEXT:    s_and_b32 s9, s9, 1
; GFX6-NEXT:    s_cmp_lg_u32 s9, 0
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    s_addc_u32 s9, s1, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[4:5], 0
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[0:1]
; GFX6-NEXT:    s_ashr_i32 s4, s9, 31
; GFX6-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX6-NEXT:    s_add_u32 s0, s4, 0
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    s_brev_b32 s5, 1
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    s_addc_u32 s1, s4, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    s_add_u32 s0, s2, s6
; GFX6-NEXT:    v_mov_b32_e32 v2, s1
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    v_mov_b32_e32 v0, s8
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    s_addc_u32 s1, s3, s7
; GFX6-NEXT:    v_mov_b32_e32 v3, s9
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[0:1]
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[6:7], 0
; GFX6-NEXT:    s_ashr_i32 s4, s1, 31
; GFX6-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    s_add_u32 s0, s4, 0
; GFX6-NEXT:    s_cselect_b32 s2, 1, 0
; GFX6-NEXT:    s_and_b32 s2, s2, 1
; GFX6-NEXT:    s_cmp_lg_u32 s2, 0
; GFX6-NEXT:    s_addc_u32 s3, s4, s5
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_mov_b32_e32 v3, s3
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v4
; GFX6-NEXT:    v_readfirstlane_b32 s1, v2
; GFX6-NEXT:    v_readfirstlane_b32 s2, v0
; GFX6-NEXT:    v_readfirstlane_b32 s3, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v2i64:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s8, s0, s4
; GFX8-NEXT:    s_cselect_b32 s9, 1, 0
; GFX8-NEXT:    s_and_b32 s9, s9, 1
; GFX8-NEXT:    s_cmp_lg_u32 s9, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_addc_u32 s9, s1, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[4:5], 0
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[0:1]
; GFX8-NEXT:    s_ashr_i32 s4, s9, 31
; GFX8-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX8-NEXT:    s_add_u32 s0, s4, 0
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    s_brev_b32 s5, 1
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    s_addc_u32 s1, s4, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    s_add_u32 s0, s2, s6
; GFX8-NEXT:    v_mov_b32_e32 v2, s1
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    v_mov_b32_e32 v0, s8
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    s_addc_u32 s1, s3, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s9
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[6:7], 0
; GFX8-NEXT:    s_ashr_i32 s4, s1, 31
; GFX8-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    s_add_u32 s0, s4, 0
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_and_b32 s2, s2, 1
; GFX8-NEXT:    s_cmp_lg_u32 s2, 0
; GFX8-NEXT:    s_addc_u32 s3, s4, s5
; GFX8-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v3, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v4
; GFX8-NEXT:    v_readfirstlane_b32 s1, v2
; GFX8-NEXT:    v_readfirstlane_b32 s2, v0
; GFX8-NEXT:    v_readfirstlane_b32 s3, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v2i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s8, s0, s4
; GFX9-NEXT:    s_cselect_b32 s9, 1, 0
; GFX9-NEXT:    s_and_b32 s9, s9, 1
; GFX9-NEXT:    s_cmp_lg_u32 s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_addc_u32 s9, s1, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[4:5], 0
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[8:9], v[0:1]
; GFX9-NEXT:    s_ashr_i32 s4, s9, 31
; GFX9-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; GFX9-NEXT:    s_add_u32 s0, s4, 0
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    s_brev_b32 s5, 1
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    s_addc_u32 s1, s4, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    s_add_u32 s0, s2, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    v_mov_b32_e32 v0, s8
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v0, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    s_addc_u32 s1, s3, s7
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[0:1], v[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[6:7], 0
; GFX9-NEXT:    s_ashr_i32 s4, s1, 31
; GFX9-NEXT:    s_xor_b64 vcc, s[2:3], vcc
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    s_add_u32 s0, s4, 0
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    s_and_b32 s2, s2, 1
; GFX9-NEXT:    s_cmp_lg_u32 s2, 0
; GFX9-NEXT:    s_addc_u32 s3, s4, s5
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-NEXT:    v_mov_b32_e32 v3, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v4
; GFX9-NEXT:    v_readfirstlane_b32 s1, v2
; GFX9-NEXT:    v_readfirstlane_b32 s2, v0
; GFX9-NEXT:    v_readfirstlane_b32 s3, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v2i64:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s8, s0, s4
; GFX10-NEXT:    s_cselect_b32 s9, 1, 0
; GFX10-NEXT:    v_cmp_lt_i64_e64 s4, s[4:5], 0
; GFX10-NEXT:    s_and_b32 s9, s9, 1
; GFX10-NEXT:    v_mov_b32_e32 v0, s8
; GFX10-NEXT:    s_cmp_lg_u32 s9, 0
; GFX10-NEXT:    s_brev_b32 s10, 1
; GFX10-NEXT:    s_addc_u32 s9, s1, s5
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[8:9], s[0:1]
; GFX10-NEXT:    s_ashr_i32 s1, s9, 31
; GFX10-NEXT:    v_mov_b32_e32 v1, s9
; GFX10-NEXT:    s_xor_b32 s8, s4, s0
; GFX10-NEXT:    s_add_u32 s0, s1, 0
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s8
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s10
; GFX10-NEXT:    s_add_u32 s4, s2, s6
; GFX10-NEXT:    s_cselect_b32 s5, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v1, s1, s8
; GFX10-NEXT:    s_and_b32 s5, s5, 1
; GFX10-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-NEXT:    s_cmp_lg_u32 s5, 0
; GFX10-NEXT:    s_addc_u32 s5, s3, s7
; GFX10-NEXT:    v_cmp_lt_i64_e64 s2, s[4:5], s[2:3]
; GFX10-NEXT:    v_cmp_lt_i64_e64 s3, s[6:7], 0
; GFX10-NEXT:    s_ashr_i32 s1, s5, 31
; GFX10-NEXT:    v_mov_b32_e32 v3, s5
; GFX10-NEXT:    s_xor_b32 s2, s3, s2
; GFX10-NEXT:    s_add_u32 s0, s1, 0
; GFX10-NEXT:    s_cselect_b32 s3, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s0, s2
; GFX10-NEXT:    s_and_b32 s3, s3, 1
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    s_cmp_lg_u32 s3, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s10
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, s1, s2
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64> %lhs, <2 x i64> %rhs)
  ret <2 x i64> %result
}

define amdgpu_ps i128 @s_saddsat_i128(i128 inreg %lhs, i128 inreg %rhs) {
; GFX6-LABEL: s_saddsat_i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s8, s0, s4
; GFX6-NEXT:    s_cselect_b32 s9, 1, 0
; GFX6-NEXT:    s_and_b32 s9, s9, 1
; GFX6-NEXT:    s_cmp_lg_u32 s9, 0
; GFX6-NEXT:    s_addc_u32 s9, s1, s5
; GFX6-NEXT:    s_cselect_b32 s10, 1, 0
; GFX6-NEXT:    s_and_b32 s10, s10, 1
; GFX6-NEXT:    s_cmp_lg_u32 s10, 0
; GFX6-NEXT:    s_addc_u32 s10, s2, s6
; GFX6-NEXT:    s_cselect_b32 s11, 1, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    s_and_b32 s11, s11, 1
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    s_cmp_lg_u32 s11, 0
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    s_addc_u32 s11, s3, s7
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[10:11], v[0:1]
; GFX6-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[4:5], 0
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[10:11], v[0:1]
; GFX6-NEXT:    s_movk_i32 s2, 0x7f
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[6:7], 0
; GFX6-NEXT:    v_cmp_eq_u64_e64 vcc, s[6:7], 0
; GFX6-NEXT:    s_sub_i32 s6, s2, 64
; GFX6-NEXT:    s_sub_i32 s4, 64, s2
; GFX6-NEXT:    s_cmp_lt_u32 s2, 64
; GFX6-NEXT:    s_cselect_b32 s12, 1, 0
; GFX6-NEXT:    s_cmp_eq_u32 s2, 0
; GFX6-NEXT:    s_cselect_b32 s13, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX6-NEXT:    s_ashr_i64 s[0:1], s[10:11], s2
; GFX6-NEXT:    s_lshr_b64 s[2:3], s[8:9], s2
; GFX6-NEXT:    s_lshl_b64 s[4:5], s[10:11], s4
; GFX6-NEXT:    s_or_b64 s[2:3], s[2:3], s[4:5]
; GFX6-NEXT:    s_ashr_i32 s4, s11, 31
; GFX6-NEXT:    s_ashr_i64 s[6:7], s[10:11], s6
; GFX6-NEXT:    s_cmp_lg_u32 s12, 0
; GFX6-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[6:7]
; GFX6-NEXT:    s_cmp_lg_u32 s13, 0
; GFX6-NEXT:    s_cselect_b64 s[2:3], s[8:9], s[2:3]
; GFX6-NEXT:    s_mov_b32 s5, s4
; GFX6-NEXT:    s_cmp_lg_u32 s12, 0
; GFX6-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[4:5]
; GFX6-NEXT:    s_add_u32 s2, s2, 0
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    s_and_b32 s4, s4, 1
; GFX6-NEXT:    s_cmp_lg_u32 s4, 0
; GFX6-NEXT:    s_addc_u32 s3, s3, 0
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    s_and_b32 s4, s4, 1
; GFX6-NEXT:    s_cmp_lg_u32 s4, 0
; GFX6-NEXT:    s_addc_u32 s0, s0, 0
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX6-NEXT:    s_and_b32 s4, s4, 1
; GFX6-NEXT:    s_cmp_lg_u32 s4, 0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NEXT:    v_mov_b32_e32 v3, s8
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_mov_b32_e32 v4, s9
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    v_mov_b32_e32 v4, s10
; GFX6-NEXT:    v_mov_b32_e32 v5, s11
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v0
; GFX6-NEXT:    v_readfirstlane_b32 s1, v1
; GFX6-NEXT:    v_readfirstlane_b32 s2, v2
; GFX6-NEXT:    v_readfirstlane_b32 s3, v3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s8, s0, s4
; GFX8-NEXT:    s_cselect_b32 s9, 1, 0
; GFX8-NEXT:    s_and_b32 s9, s9, 1
; GFX8-NEXT:    s_cmp_lg_u32 s9, 0
; GFX8-NEXT:    s_addc_u32 s9, s1, s5
; GFX8-NEXT:    s_cselect_b32 s10, 1, 0
; GFX8-NEXT:    s_and_b32 s10, s10, 1
; GFX8-NEXT:    s_cmp_lg_u32 s10, 0
; GFX8-NEXT:    s_addc_u32 s10, s2, s6
; GFX8-NEXT:    s_cselect_b32 s11, 1, 0
; GFX8-NEXT:    s_and_b32 s11, s11, 1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    s_cmp_lg_u32 s11, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_addc_u32 s11, s3, s7
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_cmp_eq_u64 s[10:11], s[2:3]
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[10:11], v[0:1]
; GFX8-NEXT:    s_and_b32 s0, 1, s2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[4:5], 0
; GFX8-NEXT:    s_cmp_eq_u64 s[6:7], 0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[6:7], 0
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX8-NEXT:    s_and_b32 s0, 1, s2
; GFX8-NEXT:    s_movk_i32 s2, 0x7f
; GFX8-NEXT:    s_sub_i32 s6, s2, 64
; GFX8-NEXT:    s_sub_i32 s4, 64, s2
; GFX8-NEXT:    s_cmp_lt_u32 s2, 64
; GFX8-NEXT:    s_cselect_b32 s12, 1, 0
; GFX8-NEXT:    s_cmp_eq_u32 s2, 0
; GFX8-NEXT:    s_cselect_b32 s13, 1, 0
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_ashr_i64 s[0:1], s[10:11], s2
; GFX8-NEXT:    s_lshr_b64 s[2:3], s[8:9], s2
; GFX8-NEXT:    s_lshl_b64 s[4:5], s[10:11], s4
; GFX8-NEXT:    s_or_b64 s[2:3], s[2:3], s[4:5]
; GFX8-NEXT:    s_ashr_i32 s4, s11, 31
; GFX8-NEXT:    s_ashr_i64 s[6:7], s[10:11], s6
; GFX8-NEXT:    s_cmp_lg_u32 s12, 0
; GFX8-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[6:7]
; GFX8-NEXT:    s_cmp_lg_u32 s13, 0
; GFX8-NEXT:    s_cselect_b64 s[2:3], s[8:9], s[2:3]
; GFX8-NEXT:    s_mov_b32 s5, s4
; GFX8-NEXT:    s_cmp_lg_u32 s12, 0
; GFX8-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[4:5]
; GFX8-NEXT:    s_add_u32 s2, s2, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_cmp_lg_u32 s4, 0
; GFX8-NEXT:    s_addc_u32 s3, s3, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_cmp_lg_u32 s4, 0
; GFX8-NEXT:    s_addc_u32 s0, s0, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX8-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_and_b32 s4, s4, 1
; GFX8-NEXT:    s_cmp_lg_u32 s4, 0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_mov_b32_e32 v3, s8
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v4, s9
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v4, s10
; GFX8-NEXT:    v_mov_b32_e32 v5, s11
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v0
; GFX8-NEXT:    v_readfirstlane_b32 s1, v1
; GFX8-NEXT:    v_readfirstlane_b32 s2, v2
; GFX8-NEXT:    v_readfirstlane_b32 s3, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s8, s0, s4
; GFX9-NEXT:    s_cselect_b32 s9, 1, 0
; GFX9-NEXT:    s_and_b32 s9, s9, 1
; GFX9-NEXT:    s_cmp_lg_u32 s9, 0
; GFX9-NEXT:    s_addc_u32 s9, s1, s5
; GFX9-NEXT:    s_cselect_b32 s10, 1, 0
; GFX9-NEXT:    s_and_b32 s10, s10, 1
; GFX9-NEXT:    s_cmp_lg_u32 s10, 0
; GFX9-NEXT:    s_addc_u32 s10, s2, s6
; GFX9-NEXT:    s_cselect_b32 s11, 1, 0
; GFX9-NEXT:    s_and_b32 s11, s11, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    s_cmp_lg_u32 s11, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    s_addc_u32 s11, s3, s7
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[8:9], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_cmp_eq_u64 s[10:11], s[2:3]
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[10:11], v[0:1]
; GFX9-NEXT:    s_and_b32 s0, 1, s2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[4:5], 0
; GFX9-NEXT:    s_cmp_eq_u64 s[6:7], 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[6:7], 0
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX9-NEXT:    s_and_b32 s0, 1, s2
; GFX9-NEXT:    s_movk_i32 s2, 0x7f
; GFX9-NEXT:    s_sub_i32 s6, s2, 64
; GFX9-NEXT:    s_sub_i32 s4, 64, s2
; GFX9-NEXT:    s_cmp_lt_u32 s2, 64
; GFX9-NEXT:    s_cselect_b32 s12, 1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s2, 0
; GFX9-NEXT:    s_cselect_b32 s13, 1, 0
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_ashr_i64 s[0:1], s[10:11], s2
; GFX9-NEXT:    s_lshr_b64 s[2:3], s[8:9], s2
; GFX9-NEXT:    s_lshl_b64 s[4:5], s[10:11], s4
; GFX9-NEXT:    s_or_b64 s[2:3], s[2:3], s[4:5]
; GFX9-NEXT:    s_ashr_i32 s4, s11, 31
; GFX9-NEXT:    s_ashr_i64 s[6:7], s[10:11], s6
; GFX9-NEXT:    s_cmp_lg_u32 s12, 0
; GFX9-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[6:7]
; GFX9-NEXT:    s_cmp_lg_u32 s13, 0
; GFX9-NEXT:    s_cselect_b64 s[2:3], s[8:9], s[2:3]
; GFX9-NEXT:    s_mov_b32 s5, s4
; GFX9-NEXT:    s_cmp_lg_u32 s12, 0
; GFX9-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[4:5]
; GFX9-NEXT:    s_add_u32 s2, s2, 0
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-NEXT:    s_addc_u32 s3, s3, 0
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-NEXT:    s_addc_u32 s0, s0, 0
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX9-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_and_b32 s4, s4, 1
; GFX9-NEXT:    s_cmp_lg_u32 s4, 0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s8
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v4, s9
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v0
; GFX9-NEXT:    v_readfirstlane_b32 s1, v1
; GFX9-NEXT:    v_readfirstlane_b32 s2, v2
; GFX9-NEXT:    v_readfirstlane_b32 s3, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s8, s0, s4
; GFX10-NEXT:    s_cselect_b32 s9, 1, 0
; GFX10-NEXT:    s_movk_i32 s12, 0x7f
; GFX10-NEXT:    s_and_b32 s9, s9, 1
; GFX10-NEXT:    s_cmp_lg_u32 s9, 0
; GFX10-NEXT:    s_addc_u32 s9, s1, s5
; GFX10-NEXT:    s_cselect_b32 s10, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s0, s[8:9], s[0:1]
; GFX10-NEXT:    s_and_b32 s10, s10, 1
; GFX10-NEXT:    s_cmp_lg_u32 s10, 0
; GFX10-NEXT:    s_addc_u32 s10, s2, s6
; GFX10-NEXT:    s_cselect_b32 s11, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX10-NEXT:    s_and_b32 s11, s11, 1
; GFX10-NEXT:    v_mov_b32_e32 v3, s10
; GFX10-NEXT:    s_cmp_lg_u32 s11, 0
; GFX10-NEXT:    s_addc_u32 s11, s3, s7
; GFX10-NEXT:    s_cmp_eq_u64 s[10:11], s[2:3]
; GFX10-NEXT:    v_cmp_lt_i64_e64 s1, s[10:11], s[2:3]
; GFX10-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10-NEXT:    v_mov_b32_e32 v4, s11
; GFX10-NEXT:    s_and_b32 s0, 1, s0
; GFX10-NEXT:    s_cmp_eq_u64 s[6:7], 0
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s0, s[4:5], 0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s1
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    s_sub_i32 s13, s12, 64
; GFX10-NEXT:    s_and_b32 s14, 1, s1
; GFX10-NEXT:    s_sub_i32 s15, 64, s12
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    s_cmp_lt_u32 s12, 64
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s0
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[6:7], 0
; GFX10-NEXT:    s_cselect_b32 s16, 1, 0
; GFX10-NEXT:    s_cmp_eq_u32 s12, 0
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s14
; GFX10-NEXT:    s_cselect_b32 s17, 1, 0
; GFX10-NEXT:    s_lshr_b64 s[2:3], s[8:9], s12
; GFX10-NEXT:    s_lshl_b64 s[4:5], s[10:11], s15
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GFX10-NEXT:    s_ashr_i32 s6, s11, 31
; GFX10-NEXT:    s_or_b64 s[2:3], s[2:3], s[4:5]
; GFX10-NEXT:    s_ashr_i64 s[0:1], s[10:11], s12
; GFX10-NEXT:    s_ashr_i64 s[4:5], s[10:11], s13
; GFX10-NEXT:    s_cmp_lg_u32 s16, 0
; GFX10-NEXT:    s_mov_b32 s7, s6
; GFX10-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[4:5]
; GFX10-NEXT:    s_cmp_lg_u32 s17, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc_lo
; GFX10-NEXT:    s_cselect_b64 s[2:3], s[8:9], s[2:3]
; GFX10-NEXT:    s_cmp_lg_u32 s16, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, s9
; GFX10-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[6:7]
; GFX10-NEXT:    s_add_u32 s2, s2, 0
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    v_mov_b32_e32 v1, s8
; GFX10-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10-NEXT:    s_addc_u32 s0, s0, 0
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    s_and_b32 s4, s4, 1
; GFX10-NEXT:    s_cmp_lg_u32 s4, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, 0x80000000
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v1, s2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v2, s3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v3, s0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v4, s1, vcc_lo
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.sadd.sat.i128(i128 %lhs, i128 %rhs)
  ret i128 %result
}

define amdgpu_ps <4 x float> @saddsat_i128_sv(i128 inreg %lhs, i128 %rhs) {
; GFX6-LABEL: saddsat_i128_sv:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v5, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v6, s2
; GFX6-NEXT:    v_mov_b32_e32 v7, s3
; GFX6-NEXT:    v_addc_u32_e32 v6, vcc, v6, v2, vcc
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX6-NEXT:    s_movk_i32 s0, 0x7f
; GFX6-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX6-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[6:7]
; GFX6-NEXT:    s_sub_i32 s1, s0, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[6:7]
; GFX6-NEXT:    s_sub_i32 s2, 64, s0
; GFX6-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[0:1]
; GFX6-NEXT:    s_cmp_lt_u32 s0, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX6-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[2:3]
; GFX6-NEXT:    s_cselect_b32 s3, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GFX6-NEXT:    v_lshl_b64 v[2:3], v[6:7], s2
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX6-NEXT:    v_xor_b32_e32 v10, v0, v8
; GFX6-NEXT:    v_lshr_b64 v[0:1], v[4:5], s0
; GFX6-NEXT:    s_cmp_eq_u32 s0, 0
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    v_ashr_i64 v[8:9], v[6:7], s0
; GFX6-NEXT:    s_and_b32 s0, 1, s3
; GFX6-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[6:7], s1
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    s_and_b32 s0, 1, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    s_and_b32 s0, 1, s3
; GFX6-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX6-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v8, vcc
; GFX6-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i128_sv:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v5, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, v6, v2, vcc
; GFX8-NEXT:    v_addc_u32_e32 v7, vcc, v7, v3, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX8-NEXT:    s_movk_i32 s0, 0x7f
; GFX8-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[6:7]
; GFX8-NEXT:    s_sub_i32 s1, s0, 64
; GFX8-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[6:7]
; GFX8-NEXT:    s_sub_i32 s2, 64, s0
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[0:1]
; GFX8-NEXT:    s_cmp_lt_u32 s0, 64
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[2:3]
; GFX8-NEXT:    s_cselect_b32 s3, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GFX8-NEXT:    v_lshlrev_b64 v[2:3], s2, v[6:7]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    v_xor_b32_e32 v10, v0, v8
; GFX8-NEXT:    v_lshrrev_b64 v[0:1], s0, v[4:5]
; GFX8-NEXT:    s_cmp_eq_u32 s0, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_ashrrev_i64 v[8:9], s0, v[6:7]
; GFX8-NEXT:    s_and_b32 s0, 1, s3
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], s1, v[6:7]
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_and_b32 s0, 1, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_and_b32 s0, 1, s3
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v8, vcc
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i128_sv:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v5, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, v6, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v3, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, s[0:1], v[4:5]
; GFX9-NEXT:    s_movk_i32 s0, 0x7f
; GFX9-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, s[2:3], v[6:7]
; GFX9-NEXT:    s_sub_i32 s1, s0, 64
; GFX9-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[6:7]
; GFX9-NEXT:    s_sub_i32 s2, 64, s0
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[0:1]
; GFX9-NEXT:    s_cmp_lt_u32 s0, 64
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[2:3]
; GFX9-NEXT:    s_cselect_b32 s3, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[2:3]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], s2, v[6:7]
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_xor_b32_e32 v10, v0, v8
; GFX9-NEXT:    v_lshrrev_b64 v[0:1], s0, v[4:5]
; GFX9-NEXT:    s_cmp_eq_u32 s0, 0
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_ashrrev_i64 v[8:9], s0, v[6:7]
; GFX9-NEXT:    s_and_b32 s0, 1, s3
; GFX9-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX9-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], s1, v[6:7]
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_and_b32 s0, 1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_and_b32 s0, 1, s3
; GFX9-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, 0, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v8, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i128_sv:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_add_co_u32_e64 v4, vcc_lo, s0, v0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, s1, v1, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v6, vcc_lo, s2, v2, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, s3, v3, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, s[0:1], v[4:5]
; GFX10-NEXT:    s_movk_i32 s0, 0x7f
; GFX10-NEXT:    s_sub_i32 s1, 64, s0
; GFX10-NEXT:    v_lshrrev_b64 v[15:16], s0, v[4:5]
; GFX10-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, s[2:3], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, s[2:3], v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, 0, v[0:1]
; GFX10-NEXT:    v_lshlrev_b64 v[8:9], s1, v[6:7]
; GFX10-NEXT:    s_sub_i32 s1, s0, 64
; GFX10-NEXT:    s_cmp_lt_u32 s0, 64
; GFX10-NEXT:    v_ashrrev_i64 v[0:1], s0, v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e64 v11, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, 0, v[2:3]
; GFX10-NEXT:    v_or_b32_e32 v8, v15, v8
; GFX10-NEXT:    v_or_b32_e32 v9, v16, v9
; GFX10-NEXT:    v_ashrrev_i32_e32 v15, 31, v7
; GFX10-NEXT:    v_cndmask_b32_e64 v12, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, 0, v[2:3]
; GFX10-NEXT:    v_ashrrev_i64 v[2:3], s1, v[6:7]
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v12, v11, vcc_lo
; GFX10-NEXT:    s_cselect_b32 vcc_lo, 1, 0
; GFX10-NEXT:    s_cmp_eq_u32 s0, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v9, vcc_lo
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v8, vcc_lo
; GFX10-NEXT:    s_and_b32 s0, 1, s1
; GFX10-NEXT:    s_and_b32 s1, 1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10-NEXT:    v_cmp_ne_u32_e64 s0, 0, s1
; GFX10-NEXT:    v_xor_b32_e32 v9, v11, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v15, v0, s0
; GFX10-NEXT:    v_and_b32_e32 v8, 1, v9
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v15, v1, s0
; GFX10-NEXT:    v_add_co_u32_e64 v2, vcc_lo, v2, 0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 s0, 0, v8
; GFX10-NEXT:    v_add_co_ci_u32_e32 v8, vcc_lo, 0, v0, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v4, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v5, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v6, v8, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v7, v9, s0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.sadd.sat.i128(i128 %lhs, i128 %rhs)
  %cast = bitcast i128 %result to <4 x float>
  ret <4 x float> %cast
}

define amdgpu_ps <4 x float> @saddsat_i128_vs(i128 %lhs, i128 inreg %rhs) {
; GFX6-LABEL: saddsat_i128_vs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v5, s1
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, s0, v0
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, v1, v5, vcc
; GFX6-NEXT:    v_mov_b32_e32 v6, s2
; GFX6-NEXT:    v_mov_b32_e32 v7, s3
; GFX6-NEXT:    v_addc_u32_e32 v6, vcc, v2, v6, vcc
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, v3, v7, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX6-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[0:1], 0
; GFX6-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[6:7], v[2:3]
; GFX6-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX6-NEXT:    v_cmp_eq_u64_e64 vcc, s[2:3], 0
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX6-NEXT:    s_movk_i32 s0, 0x7f
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    s_sub_i32 s2, 64, s0
; GFX6-NEXT:    s_sub_i32 s1, s0, 64
; GFX6-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX6-NEXT:    s_cmp_lt_u32 s0, 64
; GFX6-NEXT:    v_lshr_b64 v[0:1], v[4:5], s0
; GFX6-NEXT:    v_lshl_b64 v[2:3], v[6:7], s2
; GFX6-NEXT:    s_cselect_b32 s3, 1, 0
; GFX6-NEXT:    s_cmp_eq_u32 s0, 0
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    v_ashr_i64 v[8:9], v[6:7], s0
; GFX6-NEXT:    s_and_b32 s0, 1, s3
; GFX6-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[6:7], s1
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    s_and_b32 s0, 1, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    s_and_b32 s0, 1, s3
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX6-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v8, vcc
; GFX6-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: saddsat_i128_vs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, s0, v0
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, v1, v5, vcc
; GFX8-NEXT:    v_mov_b32_e32 v6, s2
; GFX8-NEXT:    v_mov_b32_e32 v7, s3
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, v2, v6, vcc
; GFX8-NEXT:    v_addc_u32_e32 v7, vcc, v3, v7, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX8-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[0:1], 0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[6:7], v[2:3]
; GFX8-NEXT:    s_cmp_eq_u64 s[2:3], 0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX8-NEXT:    s_and_b32 s0, 1, s4
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_movk_i32 s0, 0x7f
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX8-NEXT:    s_sub_i32 s2, 64, s0
; GFX8-NEXT:    s_sub_i32 s1, s0, 64
; GFX8-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX8-NEXT:    s_cmp_lt_u32 s0, 64
; GFX8-NEXT:    v_lshrrev_b64 v[0:1], s0, v[4:5]
; GFX8-NEXT:    v_lshlrev_b64 v[2:3], s2, v[6:7]
; GFX8-NEXT:    s_cselect_b32 s3, 1, 0
; GFX8-NEXT:    s_cmp_eq_u32 s0, 0
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_ashrrev_i64 v[8:9], s0, v[6:7]
; GFX8-NEXT:    s_and_b32 s0, 1, s3
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], s1, v[6:7]
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_and_b32 s0, 1, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_and_b32 s0, 1, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v8, vcc
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: saddsat_i128_vs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v5, s1
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, s0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, v1, v5, vcc
; GFX9-NEXT:    v_mov_b32_e32 v6, s2
; GFX9-NEXT:    v_mov_b32_e32 v7, s3
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, v2, v6, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, v3, v7, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[4:5], v[0:1]
; GFX9-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[0:1], 0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[6:7], v[2:3]
; GFX9-NEXT:    s_cmp_eq_u64 s[2:3], 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[6:7], v[2:3]
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[2:3], 0
; GFX9-NEXT:    v_ashrrev_i32_e32 v11, 31, v7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX9-NEXT:    s_and_b32 s0, 1, s4
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_movk_i32 s0, 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX9-NEXT:    s_sub_i32 s2, 64, s0
; GFX9-NEXT:    s_sub_i32 s1, s0, 64
; GFX9-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX9-NEXT:    s_cmp_lt_u32 s0, 64
; GFX9-NEXT:    v_lshrrev_b64 v[0:1], s0, v[4:5]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], s2, v[6:7]
; GFX9-NEXT:    s_cselect_b32 s3, 1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s0, 0
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_ashrrev_i64 v[8:9], s0, v[6:7]
; GFX9-NEXT:    s_and_b32 s0, 1, s3
; GFX9-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX9-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], s1, v[6:7]
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_and_b32 s0, 1, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_and_b32 s0, 1, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_bfrev_b32_e32 v8, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, 0, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v8, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v6, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v7, v3, vcc
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: saddsat_i128_vs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_mov_b32_e32 v5, v0
; GFX10-NEXT:    v_mov_b32_e32 v6, v1
; GFX10-NEXT:    v_mov_b32_e32 v9, v2
; GFX10-NEXT:    v_mov_b32_e32 v10, v3
; GFX10-NEXT:    s_cmp_eq_u64 s[2:3], 0
; GFX10-NEXT:    v_add_co_u32_e64 v15, vcc_lo, v5, s0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s0, s[0:1], 0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v16, vcc_lo, s1, v6, vcc_lo
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v19, vcc_lo, s2, v9, vcc_lo
; GFX10-NEXT:    s_and_b32 s1, 1, s4
; GFX10-NEXT:    v_add_co_ci_u32_e32 v20, vcc_lo, s3, v10, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[15:16], v[5:6]
; GFX10-NEXT:    v_cndmask_b32_e64 v8, 0, 1, s0
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[2:3], 0
; GFX10-NEXT:    v_ashrrev_i32_e32 v7, 31, v20
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[19:20], v[9:10]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[19:20], v[9:10]
; GFX10-NEXT:    v_cndmask_b32_e64 v9, 0, 1, s0
; GFX10-NEXT:    s_movk_i32 s0, 0x7f
; GFX10-NEXT:    s_sub_i32 s2, 64, s0
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s1
; GFX10-NEXT:    v_lshrrev_b64 v[0:1], s0, v[15:16]
; GFX10-NEXT:    v_lshlrev_b64 v[2:3], s2, v[19:20]
; GFX10-NEXT:    s_sub_i32 s1, s0, 64
; GFX10-NEXT:    s_cmp_lt_u32 s0, 64
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v9, v8, vcc_lo
; GFX10-NEXT:    s_cselect_b32 vcc_lo, 1, 0
; GFX10-NEXT:    v_ashrrev_i64 v[8:9], s1, v[19:20]
; GFX10-NEXT:    s_cmp_eq_u32 s0, 0
; GFX10-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX10-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    v_ashrrev_i64 v[0:1], s0, v[19:20]
; GFX10-NEXT:    s_and_b32 s0, 1, s1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc_lo
; GFX10-NEXT:    s_and_b32 s1, 1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10-NEXT:    v_cmp_ne_u32_e64 s0, 0, s1
; GFX10-NEXT:    v_xor_b32_e32 v9, v11, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v15, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v16, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v7, v0, s0
; GFX10-NEXT:    v_and_b32_e32 v8, 1, v9
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v7, v1, s0
; GFX10-NEXT:    v_add_co_u32_e64 v2, vcc_lo, v2, 0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 s0, 0, v8
; GFX10-NEXT:    v_add_co_ci_u32_e32 v8, vcc_lo, 0, v0, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v15, v2, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v16, v3, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v19, v8, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v20, v9, s0
; GFX10-NEXT:    ; return to shader part epilog
  %result = call i128 @llvm.sadd.sat.i128(i128 %lhs, i128 %rhs)
  %cast = bitcast i128 %result to <4 x float>
  ret <4 x float> %cast
}

define <2 x i128> @v_saddsat_v2i128(<2 x i128> %lhs, <2 x i128> %rhs) {
; GFX6-LABEL: v_saddsat_v2i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_add_i32_e32 v16, vcc, v0, v8
; GFX6-NEXT:    v_addc_u32_e32 v17, vcc, v1, v9, vcc
; GFX6-NEXT:    v_addc_u32_e32 v18, vcc, v2, v10, vcc
; GFX6-NEXT:    v_addc_u32_e32 v19, vcc, v3, v11, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[16:17], v[0:1]
; GFX6-NEXT:    s_movk_i32 s6, 0x7f
; GFX6-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[18:19], v[2:3]
; GFX6-NEXT:    s_sub_i32 s7, s6, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[18:19], v[2:3]
; GFX6-NEXT:    s_sub_i32 s8, 64, s6
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[8:9]
; GFX6-NEXT:    s_cmp_lt_u32 s6, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[10:11]
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GFX6-NEXT:    s_cmp_eq_u32 s6, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX6-NEXT:    v_lshr_b64 v[0:1], v[16:17], s6
; GFX6-NEXT:    v_lshl_b64 v[2:3], v[18:19], s8
; GFX6-NEXT:    s_cselect_b32 s5, 1, 0
; GFX6-NEXT:    s_and_b32 s4, 1, s4
; GFX6-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX6-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX6-NEXT:    v_ashr_i64 v[0:1], v[18:19], s7
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX6-NEXT:    s_and_b32 s4, 1, s5
; GFX6-NEXT:    v_ashr_i64 v[8:9], v[18:19], s6
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX6-NEXT:    v_ashrrev_i32_e32 v11, 31, v19
; GFX6-NEXT:    v_cndmask_b32_e64 v0, v0, v16, s[4:5]
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v1, v1, v17, s[4:5]
; GFX6-NEXT:    v_add_i32_e32 v0, vcc, 0, v0
; GFX6-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX6-NEXT:    v_bfrev_b32_e32 v20, 1
; GFX6-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX6-NEXT:    v_addc_u32_e32 v3, vcc, v3, v20, vcc
; GFX6-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX6-NEXT:    v_add_i32_e32 v8, vcc, v4, v12
; GFX6-NEXT:    v_addc_u32_e32 v9, vcc, v5, v13, vcc
; GFX6-NEXT:    v_addc_u32_e32 v10, vcc, v6, v14, vcc
; GFX6-NEXT:    v_addc_u32_e32 v11, vcc, v7, v15, vcc
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GFX6-NEXT:    s_cmp_lt_u32 s6, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, v[10:11], v[6:7]
; GFX6-NEXT:    s_cselect_b32 s4, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, v[10:11], v[6:7]
; GFX6-NEXT:    s_cmp_eq_u32 s6, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX6-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[12:13]
; GFX6-NEXT:    s_cselect_b32 s5, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX6-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[14:15]
; GFX6-NEXT:    v_ashr_i64 v[12:13], v[10:11], s6
; GFX6-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GFX6-NEXT:    s_and_b32 s5, 1, s5
; GFX6-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX6-NEXT:    v_xor_b32_e32 v14, v5, v4
; GFX6-NEXT:    v_lshr_b64 v[4:5], v[8:9], s6
; GFX6-NEXT:    v_lshl_b64 v[6:7], v[10:11], s8
; GFX6-NEXT:    s_and_b32 s6, 1, s4
; GFX6-NEXT:    v_or_b32_e32 v6, v4, v6
; GFX6-NEXT:    v_or_b32_e32 v7, v5, v7
; GFX6-NEXT:    v_ashr_i64 v[4:5], v[10:11], s7
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s6
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s5
; GFX6-NEXT:    s_and_b32 s4, 1, s4
; GFX6-NEXT:    v_ashrrev_i32_e32 v15, 31, v11
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc
; GFX6-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX6-NEXT:    v_cndmask_b32_e32 v6, v15, v12, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v7, v15, v13, vcc
; GFX6-NEXT:    v_add_i32_e32 v4, vcc, 0, v4
; GFX6-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; GFX6-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; GFX6-NEXT:    v_addc_u32_e32 v7, vcc, v7, v20, vcc
; GFX6-NEXT:    v_and_b32_e32 v12, 1, v14
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v8, v4, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v7, v11, v7, vcc
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_saddsat_v2i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_add_u32_e32 v16, vcc, v0, v8
; GFX8-NEXT:    v_addc_u32_e32 v17, vcc, v1, v9, vcc
; GFX8-NEXT:    v_addc_u32_e32 v18, vcc, v2, v10, vcc
; GFX8-NEXT:    v_addc_u32_e32 v19, vcc, v3, v11, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[16:17], v[0:1]
; GFX8-NEXT:    s_movk_i32 s6, 0x7f
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[18:19], v[2:3]
; GFX8-NEXT:    s_sub_i32 s7, s6, 64
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[18:19], v[2:3]
; GFX8-NEXT:    s_sub_i32 s8, 64, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[8:9]
; GFX8-NEXT:    s_cmp_lt_u32 s6, 64
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[10:11]
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX8-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX8-NEXT:    v_lshrrev_b64 v[0:1], s6, v[16:17]
; GFX8-NEXT:    v_lshlrev_b64 v[2:3], s8, v[18:19]
; GFX8-NEXT:    s_cselect_b32 s5, 1, 0
; GFX8-NEXT:    s_and_b32 s4, 1, s4
; GFX8-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX8-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX8-NEXT:    v_ashrrev_i64 v[0:1], s7, v[18:19]
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    s_and_b32 s4, 1, s5
; GFX8-NEXT:    v_ashrrev_i64 v[8:9], s6, v[18:19]
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_ashrrev_i32_e32 v11, 31, v19
; GFX8-NEXT:    v_cndmask_b32_e64 v0, v0, v16, s[4:5]
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v1, v1, v17, s[4:5]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, 0, v0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_bfrev_b32_e32 v20, 1
; GFX8-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; GFX8-NEXT:    v_addc_u32_e32 v3, vcc, v3, v20, vcc
; GFX8-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX8-NEXT:    v_add_u32_e32 v8, vcc, v4, v12
; GFX8-NEXT:    v_addc_u32_e32 v9, vcc, v5, v13, vcc
; GFX8-NEXT:    v_addc_u32_e32 v10, vcc, v6, v14, vcc
; GFX8-NEXT:    v_addc_u32_e32 v11, vcc, v7, v15, vcc
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GFX8-NEXT:    s_cmp_lt_u32 s6, 64
; GFX8-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, v[10:11], v[6:7]
; GFX8-NEXT:    s_cselect_b32 s4, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, v[10:11], v[6:7]
; GFX8-NEXT:    s_cmp_eq_u32 s6, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[12:13]
; GFX8-NEXT:    s_cselect_b32 s5, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX8-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[14:15]
; GFX8-NEXT:    v_ashrrev_i64 v[12:13], s6, v[10:11]
; GFX8-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GFX8-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GFX8-NEXT:    s_and_b32 s5, 1, s5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX8-NEXT:    v_xor_b32_e32 v14, v5, v4
; GFX8-NEXT:    v_lshrrev_b64 v[4:5], s6, v[8:9]
; GFX8-NEXT:    v_lshlrev_b64 v[6:7], s8, v[10:11]
; GFX8-NEXT:    s_and_b32 s6, 1, s4
; GFX8-NEXT:    v_or_b32_e32 v6, v4, v6
; GFX8-NEXT:    v_or_b32_e32 v7, v5, v7
; GFX8-NEXT:    v_ashrrev_i64 v[4:5], s7, v[10:11]
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s6
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s5
; GFX8-NEXT:    s_and_b32 s4, 1, s4
; GFX8-NEXT:    v_ashrrev_i32_e32 v15, 31, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v15, v12, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v15, v13, vcc
; GFX8-NEXT:    v_add_u32_e32 v4, vcc, 0, v4
; GFX8-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; GFX8-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; GFX8-NEXT:    v_addc_u32_e32 v7, vcc, v7, v20, vcc
; GFX8-NEXT:    v_and_b32_e32 v12, 1, v14
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v8, v4, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v11, v7, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_saddsat_v2i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, v0, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, v1, v9, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v18, vcc, v2, v10, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, v3, v11, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[16:17], v[0:1]
; GFX9-NEXT:    s_movk_i32 s6, 0x7f
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[18:19], v[2:3]
; GFX9-NEXT:    s_sub_i32 s7, s6, 64
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[18:19], v[2:3]
; GFX9-NEXT:    s_sub_i32 s8, 64, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[8:9]
; GFX9-NEXT:    s_cmp_lt_u32 s6, 64
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[10:11]
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[10:11]
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX9-NEXT:    v_xor_b32_e32 v10, v1, v0
; GFX9-NEXT:    v_lshrrev_b64 v[0:1], s6, v[16:17]
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], s8, v[18:19]
; GFX9-NEXT:    s_cselect_b32 s5, 1, 0
; GFX9-NEXT:    s_and_b32 s4, 1, s4
; GFX9-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX9-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX9-NEXT:    v_ashrrev_i64 v[0:1], s7, v[18:19]
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    s_and_b32 s4, 1, s5
; GFX9-NEXT:    v_ashrrev_i64 v[8:9], s6, v[18:19]
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX9-NEXT:    v_ashrrev_i32_e32 v11, 31, v19
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v0, v16, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v11, v8, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v11, v9, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, v17, s[4:5]
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 0, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_bfrev_b32_e32 v20, 1
; GFX9-NEXT:    v_addc_co_u32_e32 v2, vcc, 0, v2, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, v3, v20, vcc
; GFX9-NEXT:    v_and_b32_e32 v8, 1, v10
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v16, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v17, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v18, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v19, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, v4, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, v5, v13, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v10, vcc, v6, v14, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, v7, v15, vcc
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, v[8:9], v[4:5]
; GFX9-NEXT:    s_cmp_lt_u32 s6, 64
; GFX9-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, v[10:11], v[6:7]
; GFX9-NEXT:    s_cselect_b32 s4, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, v[10:11], v[6:7]
; GFX9-NEXT:    s_cmp_eq_u32 s6, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX9-NEXT:    v_cmp_gt_u64_e32 vcc, 0, v[12:13]
; GFX9-NEXT:    s_cselect_b32 s5, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX9-NEXT:    v_cmp_gt_i64_e32 vcc, 0, v[14:15]
; GFX9-NEXT:    v_ashrrev_i64 v[12:13], s6, v[10:11]
; GFX9-NEXT:    v_cndmask_b32_e64 v6, 0, 1, vcc
; GFX9-NEXT:    v_cmp_eq_u64_e32 vcc, 0, v[14:15]
; GFX9-NEXT:    s_and_b32 s5, 1, s5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX9-NEXT:    v_xor_b32_e32 v14, v5, v4
; GFX9-NEXT:    v_lshrrev_b64 v[4:5], s6, v[8:9]
; GFX9-NEXT:    v_lshlrev_b64 v[6:7], s8, v[10:11]
; GFX9-NEXT:    s_and_b32 s6, 1, s4
; GFX9-NEXT:    v_or_b32_e32 v6, v4, v6
; GFX9-NEXT:    v_or_b32_e32 v7, v5, v7
; GFX9-NEXT:    v_ashrrev_i64 v[4:5], s7, v[10:11]
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s6
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s5
; GFX9-NEXT:    s_and_b32 s4, 1, s4
; GFX9-NEXT:    v_ashrrev_i32_e32 v15, 31, v11
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v15, v12, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v15, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 0, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v6, vcc, 0, v6, vcc
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, v7, v20, vcc
; GFX9-NEXT:    v_and_b32_e32 v12, 1, v14
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v8, v4, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v11, v7, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_saddsat_v2i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    v_mov_b32_e32 v22, v0
; GFX10-NEXT:    v_mov_b32_e32 v23, v1
; GFX10-NEXT:    v_mov_b32_e32 v20, v2
; GFX10-NEXT:    v_mov_b32_e32 v21, v3
; GFX10-NEXT:    s_movk_i32 s5, 0x7f
; GFX10-NEXT:    v_add_co_u32_e64 v16, vcc_lo, v22, v8
; GFX10-NEXT:    s_sub_i32 s6, 64, s5
; GFX10-NEXT:    v_add_co_ci_u32_e32 v17, vcc_lo, v23, v9, vcc_lo
; GFX10-NEXT:    s_sub_i32 s7, s5, 64
; GFX10-NEXT:    v_add_co_ci_u32_e32 v18, vcc_lo, v20, v10, vcc_lo
; GFX10-NEXT:    s_cmp_lt_u32 s5, 64
; GFX10-NEXT:    v_add_co_ci_u32_e32 v19, vcc_lo, v21, v11, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[16:17], v[22:23]
; GFX10-NEXT:    v_mov_b32_e32 v26, v4
; GFX10-NEXT:    v_mov_b32_e32 v27, v5
; GFX10-NEXT:    v_mov_b32_e32 v24, v6
; GFX10-NEXT:    v_lshlrev_b64 v[2:3], s6, v[18:19]
; GFX10-NEXT:    v_mov_b32_e32 v25, v7
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_lt_i64_e32 vcc_lo, v[18:19], v[20:21]
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, v[18:19], v[20:21]
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_u64_e32 vcc_lo, 0, v[8:9]
; GFX10-NEXT:    v_lshrrev_b64 v[0:1], s5, v[16:17]
; GFX10-NEXT:    v_cndmask_b32_e64 v8, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_i64_e32 vcc_lo, 0, v[10:11]
; GFX10-NEXT:    v_or_b32_e32 v2, v0, v2
; GFX10-NEXT:    v_or_b32_e32 v3, v1, v3
; GFX10-NEXT:    v_ashrrev_i64 v[0:1], s5, v[18:19]
; GFX10-NEXT:    v_cndmask_b32_e64 v9, 0, 1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u64_e32 vcc_lo, 0, v[10:11]
; GFX10-NEXT:    v_ashrrev_i32_e32 v11, 31, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc_lo
; GFX10-NEXT:    s_cselect_b32 vcc_lo, 1, 0
; GFX10-NEXT:    v_ashrrev_i64 v[8:9], s7, v[18:19]
; GFX10-NEXT:    s_cmp_eq_u32 s5, 0
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    s_and_b32 s8, 1, vcc_lo
; GFX10-NEXT:    s_and_b32 s4, 1, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s4
; GFX10-NEXT:    v_cmp_ne_u32_e64 s4, 0, s8
; GFX10-NEXT:    v_xor_b32_e32 v9, v10, v20
; GFX10-NEXT:    s_cmp_lt_u32 s5, 64
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v16, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v17, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v11, v0, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v11, v1, s4
; GFX10-NEXT:    v_and_b32_e32 v8, 1, v9
; GFX10-NEXT:    v_add_co_u32_e64 v2, vcc_lo, v2, 0
; GFX10-NEXT:    v_add_co_ci_u32_e32 v3, vcc_lo, 0, v3, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v20, vcc_lo, 0, v0, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e32 v21, vcc_lo, 0x80000000, v1, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_add_co_u32_e64 v8, s4, v26, v12
; GFX10-NEXT:    v_add_co_ci_u32_e64 v9, s4, v27, v13, s4
; GFX10-NEXT:    v_add_co_ci_u32_e64 v10, s4, v24, v14, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v16, v2, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e64 v11, s4, v25, v15, s4
; GFX10-NEXT:    v_cmp_lt_u64_e64 s4, v[8:9], v[26:27]
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v17, v3, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v18, v20, vcc_lo
; GFX10-NEXT:    v_lshrrev_b64 v[3:4], s5, v[8:9]
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 1, s4
; GFX10-NEXT:    v_cmp_lt_i64_e64 s4, v[10:11], v[24:25]
; GFX10-NEXT:    v_cndmask_b32_e64 v16, 0, 1, s4
; GFX10-NEXT:    v_cmp_gt_u64_e64 s4, 0, v[12:13]
; GFX10-NEXT:    v_lshlrev_b64 v[12:13], s6, v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v17, 0, 1, s4
; GFX10-NEXT:    v_cmp_gt_i64_e64 s4, 0, v[14:15]
; GFX10-NEXT:    v_or_b32_e32 v12, v3, v12
; GFX10-NEXT:    v_or_b32_e32 v13, v4, v13
; GFX10-NEXT:    v_ashrrev_i64 v[3:4], s5, v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v18, 0, 1, s4
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, v[10:11], v[24:25]
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v16, v5, s4
; GFX10-NEXT:    v_cmp_eq_u64_e64 s4, 0, v[14:15]
; GFX10-NEXT:    v_ashrrev_i64 v[5:6], s7, v[10:11]
; GFX10-NEXT:    v_cndmask_b32_e64 v14, v18, v17, s4
; GFX10-NEXT:    s_cselect_b32 s4, 1, 0
; GFX10-NEXT:    s_cmp_eq_u32 s5, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, v12, s4
; GFX10-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, v13, s4
; GFX10-NEXT:    s_and_b32 s5, 1, s6
; GFX10-NEXT:    s_and_b32 s6, 1, s4
; GFX10-NEXT:    v_cmp_ne_u32_e64 s4, 0, s5
; GFX10-NEXT:    v_xor_b32_e32 v7, v14, v7
; GFX10-NEXT:    v_ashrrev_i32_e32 v18, 31, v11
; GFX10-NEXT:    v_cmp_ne_u32_e64 s5, 0, s6
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v5, v8, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v6, v9, s4
; GFX10-NEXT:    v_and_b32_e32 v7, 1, v7
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v18, v3, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v18, v4, s5
; GFX10-NEXT:    v_add_co_u32_e64 v5, s4, v5, 0
; GFX10-NEXT:    v_add_co_ci_u32_e64 v6, s4, 0, v6, s4
; GFX10-NEXT:    v_cmp_ne_u32_e64 s5, 0, v7
; GFX10-NEXT:    v_add_co_ci_u32_e64 v7, s4, 0, v3, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v19, v21, vcc_lo
; GFX10-NEXT:    v_add_co_ci_u32_e64 v12, s4, 0x80000000, v4, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v8, v5, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v9, v6, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v10, v7, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v11, v12, s5
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128> %lhs, <2 x i128> %rhs)
  ret <2 x i128> %result
}

define amdgpu_ps <2 x i128> @s_saddsat_v2i128(<2 x i128> inreg %lhs, <2 x i128> inreg %rhs) {
; GFX6-LABEL: s_saddsat_v2i128:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_add_u32 s16, s0, s8
; GFX6-NEXT:    s_cselect_b32 s17, 1, 0
; GFX6-NEXT:    s_and_b32 s17, s17, 1
; GFX6-NEXT:    s_cmp_lg_u32 s17, 0
; GFX6-NEXT:    s_addc_u32 s17, s1, s9
; GFX6-NEXT:    s_cselect_b32 s18, 1, 0
; GFX6-NEXT:    s_and_b32 s18, s18, 1
; GFX6-NEXT:    s_cmp_lg_u32 s18, 0
; GFX6-NEXT:    s_addc_u32 s18, s2, s10
; GFX6-NEXT:    s_cselect_b32 s19, 1, 0
; GFX6-NEXT:    v_mov_b32_e32 v3, s1
; GFX6-NEXT:    s_and_b32 s19, s19, 1
; GFX6-NEXT:    v_mov_b32_e32 v2, s0
; GFX6-NEXT:    s_cmp_lg_u32 s19, 0
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[16:17], v[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v0, s2
; GFX6-NEXT:    s_addc_u32 s19, s3, s11
; GFX6-NEXT:    s_movk_i32 s20, 0x7f
; GFX6-NEXT:    v_mov_b32_e32 v1, s3
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[18:19], v[0:1]
; GFX6-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[8:9], 0
; GFX6-NEXT:    s_sub_i32 s21, s20, 64
; GFX6-NEXT:    s_sub_i32 s22, 64, s20
; GFX6-NEXT:    s_cmp_lt_u32 s20, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[18:19], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX6-NEXT:    s_cselect_b32 s23, 1, 0
; GFX6-NEXT:    s_cmp_eq_u32 s20, 0
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[10:11], 0
; GFX6-NEXT:    s_cselect_b32 s24, 1, 0
; GFX6-NEXT:    s_lshr_b64 s[2:3], s[16:17], s20
; GFX6-NEXT:    s_lshl_b64 s[8:9], s[18:19], s22
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX6-NEXT:    v_cmp_eq_u64_e64 vcc, s[10:11], 0
; GFX6-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GFX6-NEXT:    s_ashr_i32 s8, s19, 31
; GFX6-NEXT:    s_ashr_i64 s[0:1], s[18:19], s20
; GFX6-NEXT:    s_ashr_i64 s[10:11], s[18:19], s21
; GFX6-NEXT:    s_cmp_lg_u32 s23, 0
; GFX6-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[10:11]
; GFX6-NEXT:    s_cmp_lg_u32 s24, 0
; GFX6-NEXT:    s_cselect_b64 s[2:3], s[16:17], s[2:3]
; GFX6-NEXT:    s_cmp_lg_u32 s23, 0
; GFX6-NEXT:    s_mov_b32 s9, s8
; GFX6-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[8:9]
; GFX6-NEXT:    s_add_u32 s2, s2, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    s_addc_u32 s3, s3, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    s_addc_u32 s0, s0, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX6-NEXT:    s_brev_b32 s23, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    s_addc_u32 s1, s1, s23
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_mov_b32_e32 v0, s0
; GFX6-NEXT:    v_mov_b32_e32 v1, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s16
; GFX6-NEXT:    s_add_u32 s0, s4, s12
; GFX6-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v1, s1
; GFX6-NEXT:    s_cselect_b32 s1, 1, 0
; GFX6-NEXT:    s_and_b32 s1, s1, 1
; GFX6-NEXT:    s_cmp_lg_u32 s1, 0
; GFX6-NEXT:    s_addc_u32 s1, s5, s13
; GFX6-NEXT:    s_cselect_b32 s2, 1, 0
; GFX6-NEXT:    s_and_b32 s2, s2, 1
; GFX6-NEXT:    s_cmp_lg_u32 s2, 0
; GFX6-NEXT:    v_mov_b32_e32 v2, s3
; GFX6-NEXT:    v_mov_b32_e32 v4, s17
; GFX6-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s18
; GFX6-NEXT:    v_mov_b32_e32 v3, s19
; GFX6-NEXT:    s_addc_u32 s2, s6, s14
; GFX6-NEXT:    s_cselect_b32 s3, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v7, v3, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    s_and_b32 s3, s3, 1
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    s_cmp_lg_u32 s3, 0
; GFX6-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX6-NEXT:    v_mov_b32_e32 v0, s6
; GFX6-NEXT:    s_addc_u32 s3, s7, s15
; GFX6-NEXT:    v_mov_b32_e32 v1, s7
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[12:13], 0
; GFX6-NEXT:    s_cmp_lt_u32 s20, 64
; GFX6-NEXT:    v_cndmask_b32_e64 v3, 0, 1, vcc
; GFX6-NEXT:    v_cmp_eq_u64_e32 vcc, s[2:3], v[0:1]
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX6-NEXT:    s_cselect_b32 s12, 1, 0
; GFX6-NEXT:    s_cmp_eq_u32 s20, 0
; GFX6-NEXT:    v_cmp_lt_i64_e64 s[4:5], s[14:15], 0
; GFX6-NEXT:    s_cselect_b32 s13, 1, 0
; GFX6-NEXT:    s_lshr_b64 s[6:7], s[0:1], s20
; GFX6-NEXT:    s_lshl_b64 s[8:9], s[2:3], s22
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[4:5]
; GFX6-NEXT:    s_or_b64 s[6:7], s[6:7], s[8:9]
; GFX6-NEXT:    s_ashr_i32 s8, s3, 31
; GFX6-NEXT:    s_ashr_i64 s[4:5], s[2:3], s20
; GFX6-NEXT:    s_ashr_i64 s[10:11], s[2:3], s21
; GFX6-NEXT:    s_cmp_lg_u32 s12, 0
; GFX6-NEXT:    s_cselect_b64 s[6:7], s[6:7], s[10:11]
; GFX6-NEXT:    s_cmp_lg_u32 s13, 0
; GFX6-NEXT:    s_cselect_b64 s[6:7], s[0:1], s[6:7]
; GFX6-NEXT:    s_mov_b32 s9, s8
; GFX6-NEXT:    s_cmp_lg_u32 s12, 0
; GFX6-NEXT:    s_cselect_b64 s[4:5], s[4:5], s[8:9]
; GFX6-NEXT:    s_add_u32 s6, s6, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    s_addc_u32 s7, s7, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    v_cmp_eq_u64_e64 vcc, s[14:15], 0
; GFX6-NEXT:    s_addc_u32 s4, s4, 0
; GFX6-NEXT:    s_cselect_b32 s8, 1, 0
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX6-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX6-NEXT:    s_and_b32 s8, s8, 1
; GFX6-NEXT:    s_cmp_lg_u32 s8, 0
; GFX6-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX6-NEXT:    v_mov_b32_e32 v3, s0
; GFX6-NEXT:    v_mov_b32_e32 v8, s1
; GFX6-NEXT:    s_addc_u32 s5, s5, s23
; GFX6-NEXT:    v_mov_b32_e32 v1, s6
; GFX6-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, s7
; GFX6-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v1, v8, v2, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, s4
; GFX6-NEXT:    v_mov_b32_e32 v8, s2
; GFX6-NEXT:    v_mov_b32_e32 v3, s5
; GFX6-NEXT:    v_mov_b32_e32 v9, s3
; GFX6-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc
; GFX6-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc
; GFX6-NEXT:    v_readfirstlane_b32 s0, v5
; GFX6-NEXT:    v_readfirstlane_b32 s1, v4
; GFX6-NEXT:    v_readfirstlane_b32 s2, v6
; GFX6-NEXT:    v_readfirstlane_b32 s3, v7
; GFX6-NEXT:    v_readfirstlane_b32 s4, v0
; GFX6-NEXT:    v_readfirstlane_b32 s5, v1
; GFX6-NEXT:    v_readfirstlane_b32 s6, v2
; GFX6-NEXT:    v_readfirstlane_b32 s7, v3
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: s_saddsat_v2i128:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s16, s0, s8
; GFX8-NEXT:    s_cselect_b32 s17, 1, 0
; GFX8-NEXT:    s_and_b32 s17, s17, 1
; GFX8-NEXT:    s_cmp_lg_u32 s17, 0
; GFX8-NEXT:    s_addc_u32 s17, s1, s9
; GFX8-NEXT:    s_cselect_b32 s18, 1, 0
; GFX8-NEXT:    s_and_b32 s18, s18, 1
; GFX8-NEXT:    s_cmp_lg_u32 s18, 0
; GFX8-NEXT:    s_addc_u32 s18, s2, s10
; GFX8-NEXT:    s_cselect_b32 s19, 1, 0
; GFX8-NEXT:    s_and_b32 s19, s19, 1
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    s_cmp_lg_u32 s19, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    s_addc_u32 s19, s3, s11
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[16:17], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    s_cmp_eq_u64 s[18:19], s[2:3]
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[18:19], v[0:1]
; GFX8-NEXT:    s_and_b32 s0, 1, s2
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[8:9], 0
; GFX8-NEXT:    s_cmp_eq_u64 s[10:11], 0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[10:11], 0
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_movk_i32 s20, 0x7f
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX8-NEXT:    s_and_b32 s0, 1, s2
; GFX8-NEXT:    s_sub_i32 s21, s20, 64
; GFX8-NEXT:    s_sub_i32 s22, 64, s20
; GFX8-NEXT:    s_cmp_lt_u32 s20, 64
; GFX8-NEXT:    s_cselect_b32 s23, 1, 0
; GFX8-NEXT:    s_cmp_eq_u32 s20, 0
; GFX8-NEXT:    s_cselect_b32 s24, 1, 0
; GFX8-NEXT:    s_lshr_b64 s[2:3], s[16:17], s20
; GFX8-NEXT:    s_lshl_b64 s[8:9], s[18:19], s22
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX8-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GFX8-NEXT:    s_ashr_i32 s8, s19, 31
; GFX8-NEXT:    s_ashr_i64 s[0:1], s[18:19], s20
; GFX8-NEXT:    s_ashr_i64 s[10:11], s[18:19], s21
; GFX8-NEXT:    s_cmp_lg_u32 s23, 0
; GFX8-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[10:11]
; GFX8-NEXT:    s_cmp_lg_u32 s24, 0
; GFX8-NEXT:    s_cselect_b64 s[2:3], s[16:17], s[2:3]
; GFX8-NEXT:    s_cmp_lg_u32 s23, 0
; GFX8-NEXT:    s_mov_b32 s9, s8
; GFX8-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[8:9]
; GFX8-NEXT:    s_add_u32 s2, s2, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s3, s3, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s0, s0, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_brev_b32 s23, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    s_addc_u32 s1, s1, s23
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s16
; GFX8-NEXT:    s_add_u32 s0, s4, s12
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    s_cselect_b32 s1, 1, 0
; GFX8-NEXT:    s_and_b32 s1, s1, 1
; GFX8-NEXT:    s_cmp_lg_u32 s1, 0
; GFX8-NEXT:    s_addc_u32 s1, s5, s13
; GFX8-NEXT:    s_cselect_b32 s2, 1, 0
; GFX8-NEXT:    s_and_b32 s2, s2, 1
; GFX8-NEXT:    s_cmp_lg_u32 s2, 0
; GFX8-NEXT:    v_mov_b32_e32 v2, s3
; GFX8-NEXT:    v_mov_b32_e32 v4, s17
; GFX8-NEXT:    s_addc_u32 s2, s6, s14
; GFX8-NEXT:    s_cselect_b32 s3, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s18
; GFX8-NEXT:    v_mov_b32_e32 v3, s19
; GFX8-NEXT:    s_and_b32 s3, s3, 1
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v3, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    s_cmp_lg_u32 s3, 0
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    s_addc_u32 s3, s7, s15
; GFX8-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX8-NEXT:    v_mov_b32_e32 v0, s6
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    s_cmp_eq_u64 s[2:3], s[6:7]
; GFX8-NEXT:    s_cselect_b32 s6, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX8-NEXT:    s_and_b32 s4, 1, s6
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[12:13], 0
; GFX8-NEXT:    s_cmp_eq_u64 s[14:15], 0
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX8-NEXT:    v_cmp_lt_i64_e64 s[4:5], s[14:15], 0
; GFX8-NEXT:    s_cselect_b32 s6, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[4:5]
; GFX8-NEXT:    s_and_b32 s4, 1, s6
; GFX8-NEXT:    s_cmp_lt_u32 s20, 64
; GFX8-NEXT:    s_cselect_b32 s12, 1, 0
; GFX8-NEXT:    s_cmp_eq_u32 s20, 0
; GFX8-NEXT:    s_cselect_b32 s13, 1, 0
; GFX8-NEXT:    s_lshr_b64 s[6:7], s[0:1], s20
; GFX8-NEXT:    s_lshl_b64 s[8:9], s[2:3], s22
; GFX8-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX8-NEXT:    s_or_b64 s[6:7], s[6:7], s[8:9]
; GFX8-NEXT:    s_ashr_i32 s8, s3, 31
; GFX8-NEXT:    s_ashr_i64 s[4:5], s[2:3], s20
; GFX8-NEXT:    s_ashr_i64 s[10:11], s[2:3], s21
; GFX8-NEXT:    s_cmp_lg_u32 s12, 0
; GFX8-NEXT:    s_cselect_b64 s[6:7], s[6:7], s[10:11]
; GFX8-NEXT:    s_cmp_lg_u32 s13, 0
; GFX8-NEXT:    s_cselect_b64 s[6:7], s[0:1], s[6:7]
; GFX8-NEXT:    s_mov_b32 s9, s8
; GFX8-NEXT:    s_cmp_lg_u32 s12, 0
; GFX8-NEXT:    s_cselect_b64 s[4:5], s[4:5], s[8:9]
; GFX8-NEXT:    s_add_u32 s6, s6, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s7, s7, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    s_addc_u32 s4, s4, 0
; GFX8-NEXT:    s_cselect_b32 s8, 1, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX8-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_and_b32 s8, s8, 1
; GFX8-NEXT:    s_cmp_lg_u32 s8, 0
; GFX8-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX8-NEXT:    v_mov_b32_e32 v3, s0
; GFX8-NEXT:    v_mov_b32_e32 v8, s1
; GFX8-NEXT:    s_addc_u32 s5, s5, s23
; GFX8-NEXT:    v_mov_b32_e32 v1, s6
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, s7
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v8, v2, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s4
; GFX8-NEXT:    v_mov_b32_e32 v8, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s5
; GFX8-NEXT:    v_mov_b32_e32 v9, s3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc
; GFX8-NEXT:    v_readfirstlane_b32 s0, v5
; GFX8-NEXT:    v_readfirstlane_b32 s1, v4
; GFX8-NEXT:    v_readfirstlane_b32 s2, v6
; GFX8-NEXT:    v_readfirstlane_b32 s3, v7
; GFX8-NEXT:    v_readfirstlane_b32 s4, v0
; GFX8-NEXT:    v_readfirstlane_b32 s5, v1
; GFX8-NEXT:    v_readfirstlane_b32 s6, v2
; GFX8-NEXT:    v_readfirstlane_b32 s7, v3
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: s_saddsat_v2i128:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s16, s0, s8
; GFX9-NEXT:    s_cselect_b32 s17, 1, 0
; GFX9-NEXT:    s_and_b32 s17, s17, 1
; GFX9-NEXT:    s_cmp_lg_u32 s17, 0
; GFX9-NEXT:    s_addc_u32 s17, s1, s9
; GFX9-NEXT:    s_cselect_b32 s18, 1, 0
; GFX9-NEXT:    s_and_b32 s18, s18, 1
; GFX9-NEXT:    s_cmp_lg_u32 s18, 0
; GFX9-NEXT:    s_addc_u32 s18, s2, s10
; GFX9-NEXT:    s_cselect_b32 s19, 1, 0
; GFX9-NEXT:    s_and_b32 s19, s19, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, s1
; GFX9-NEXT:    s_cmp_lg_u32 s19, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s0
; GFX9-NEXT:    s_addc_u32 s19, s3, s11
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[16:17], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_cmp_eq_u64 s[18:19], s[2:3]
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[18:19], v[0:1]
; GFX9-NEXT:    s_and_b32 s0, 1, s2
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    v_cmp_lt_u64_e64 s[0:1], s[8:9], 0
; GFX9-NEXT:    s_cmp_eq_u64 s[10:11], 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[0:1]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[0:1], s[10:11], 0
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    s_movk_i32 s20, 0x7f
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[0:1]
; GFX9-NEXT:    s_and_b32 s0, 1, s2
; GFX9-NEXT:    s_sub_i32 s21, s20, 64
; GFX9-NEXT:    s_sub_i32 s22, 64, s20
; GFX9-NEXT:    s_cmp_lt_u32 s20, 64
; GFX9-NEXT:    s_cselect_b32 s23, 1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s20, 0
; GFX9-NEXT:    s_cselect_b32 s24, 1, 0
; GFX9-NEXT:    s_lshr_b64 s[2:3], s[16:17], s20
; GFX9-NEXT:    s_lshl_b64 s[8:9], s[18:19], s22
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s0
; GFX9-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GFX9-NEXT:    s_ashr_i32 s8, s19, 31
; GFX9-NEXT:    s_ashr_i64 s[0:1], s[18:19], s20
; GFX9-NEXT:    s_ashr_i64 s[10:11], s[18:19], s21
; GFX9-NEXT:    s_cmp_lg_u32 s23, 0
; GFX9-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[10:11]
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cselect_b64 s[2:3], s[16:17], s[2:3]
; GFX9-NEXT:    s_cmp_lg_u32 s23, 0
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[8:9]
; GFX9-NEXT:    s_add_u32 s2, s2, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s3, s3, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s0, s0, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_brev_b32 s23, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    s_addc_u32 s1, s1, s23
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s16
; GFX9-NEXT:    s_add_u32 s0, s4, s12
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_cselect_b32 s1, 1, 0
; GFX9-NEXT:    s_and_b32 s1, s1, 1
; GFX9-NEXT:    s_cmp_lg_u32 s1, 0
; GFX9-NEXT:    s_addc_u32 s1, s5, s13
; GFX9-NEXT:    s_cselect_b32 s2, 1, 0
; GFX9-NEXT:    s_and_b32 s2, s2, 1
; GFX9-NEXT:    s_cmp_lg_u32 s2, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, s3
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    s_addc_u32 s2, s6, s14
; GFX9-NEXT:    s_cselect_b32 s3, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    s_and_b32 s3, s3, 1
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v3, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    s_cmp_lg_u32 s3, 0
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    s_addc_u32 s3, s7, s15
; GFX9-NEXT:    v_cmp_lt_u64_e32 vcc, s[0:1], v[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    s_cmp_eq_u64 s[2:3], s[6:7]
; GFX9-NEXT:    s_cselect_b32 s6, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_i64_e32 vcc, s[2:3], v[0:1]
; GFX9-NEXT:    s_and_b32 s4, 1, s6
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    v_cmp_lt_u64_e64 s[4:5], s[12:13], 0
; GFX9-NEXT:    s_cmp_eq_u64 s[14:15], 0
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[4:5], s[14:15], 0
; GFX9-NEXT:    s_cselect_b32 s6, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s[4:5]
; GFX9-NEXT:    s_and_b32 s4, 1, s6
; GFX9-NEXT:    s_cmp_lt_u32 s20, 64
; GFX9-NEXT:    s_cselect_b32 s12, 1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s20, 0
; GFX9-NEXT:    s_cselect_b32 s13, 1, 0
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[0:1], s20
; GFX9-NEXT:    s_lshl_b64 s[8:9], s[2:3], s22
; GFX9-NEXT:    v_cmp_ne_u32_e64 vcc, 0, s4
; GFX9-NEXT:    s_or_b64 s[6:7], s[6:7], s[8:9]
; GFX9-NEXT:    s_ashr_i32 s8, s3, 31
; GFX9-NEXT:    s_ashr_i64 s[4:5], s[2:3], s20
; GFX9-NEXT:    s_ashr_i64 s[10:11], s[2:3], s21
; GFX9-NEXT:    s_cmp_lg_u32 s12, 0
; GFX9-NEXT:    s_cselect_b64 s[6:7], s[6:7], s[10:11]
; GFX9-NEXT:    s_cmp_lg_u32 s13, 0
; GFX9-NEXT:    s_cselect_b64 s[6:7], s[0:1], s[6:7]
; GFX9-NEXT:    s_mov_b32 s9, s8
; GFX9-NEXT:    s_cmp_lg_u32 s12, 0
; GFX9-NEXT:    s_cselect_b64 s[4:5], s[4:5], s[8:9]
; GFX9-NEXT:    s_add_u32 s6, s6, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s7, s7, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    s_addc_u32 s4, s4, 0
; GFX9-NEXT:    s_cselect_b32 s8, 1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GFX9-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX9-NEXT:    s_and_b32 s8, s8, 1
; GFX9-NEXT:    s_cmp_lg_u32 s8, 0
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, s0
; GFX9-NEXT:    v_mov_b32_e32 v8, s1
; GFX9-NEXT:    s_addc_u32 s5, s5, s23
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v8, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, s4
; GFX9-NEXT:    v_mov_b32_e32 v8, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s5
; GFX9-NEXT:    v_mov_b32_e32 v9, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v8, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc
; GFX9-NEXT:    v_readfirstlane_b32 s0, v5
; GFX9-NEXT:    v_readfirstlane_b32 s1, v4
; GFX9-NEXT:    v_readfirstlane_b32 s2, v6
; GFX9-NEXT:    v_readfirstlane_b32 s3, v7
; GFX9-NEXT:    v_readfirstlane_b32 s4, v0
; GFX9-NEXT:    v_readfirstlane_b32 s5, v1
; GFX9-NEXT:    v_readfirstlane_b32 s6, v2
; GFX9-NEXT:    v_readfirstlane_b32 s7, v3
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: s_saddsat_v2i128:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s16, s0, s8
; GFX10-NEXT:    s_cselect_b32 s17, 1, 0
; GFX10-NEXT:    s_mov_b32 s46, s0
; GFX10-NEXT:    s_and_b32 s17, s17, 1
; GFX10-NEXT:    s_mov_b32 s47, s1
; GFX10-NEXT:    s_cmp_lg_u32 s17, 0
; GFX10-NEXT:    s_addc_u32 s17, s1, s9
; GFX10-NEXT:    s_cselect_b32 s18, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s0, s[16:17], s[46:47]
; GFX10-NEXT:    s_and_b32 s18, s18, 1
; GFX10-NEXT:    s_cmp_lg_u32 s18, 0
; GFX10-NEXT:    s_addc_u32 s30, s2, s10
; GFX10-NEXT:    s_cselect_b32 s19, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX10-NEXT:    s_and_b32 s19, s19, 1
; GFX10-NEXT:    s_cmp_lg_u32 s19, 0
; GFX10-NEXT:    s_addc_u32 s31, s3, s11
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[30:31], s[2:3]
; GFX10-NEXT:    s_cmp_eq_u64 s[30:31], s[2:3]
; GFX10-NEXT:    v_cmp_lt_u64_e64 s2, s[8:9], 0
; GFX10-NEXT:    s_cselect_b32 s20, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s0
; GFX10-NEXT:    s_and_b32 s0, 1, s20
; GFX10-NEXT:    s_cmp_eq_u64 s[10:11], 0
; GFX10-NEXT:    s_movk_i32 s20, 0x7f
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s2
; GFX10-NEXT:    v_cmp_lt_i64_e64 s2, s[10:11], 0
; GFX10-NEXT:    s_and_b32 s1, 1, s1
; GFX10-NEXT:    s_sub_i32 s21, s20, 64
; GFX10-NEXT:    s_sub_i32 s22, 64, s20
; GFX10-NEXT:    s_cmp_lt_u32 s20, 64
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10-NEXT:    s_cselect_b32 s23, 1, 0
; GFX10-NEXT:    s_cmp_eq_u32 s20, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, 0, 1, s2
; GFX10-NEXT:    s_cselect_b32 s24, 1, 0
; GFX10-NEXT:    s_lshr_b64 s[2:3], s[16:17], s20
; GFX10-NEXT:    s_lshl_b64 s[8:9], s[30:31], s22
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s1
; GFX10-NEXT:    s_ashr_i32 s10, s31, 31
; GFX10-NEXT:    s_or_b64 s[2:3], s[2:3], s[8:9]
; GFX10-NEXT:    s_ashr_i64 s[0:1], s[30:31], s20
; GFX10-NEXT:    s_ashr_i64 s[8:9], s[30:31], s21
; GFX10-NEXT:    s_cmp_lg_u32 s23, 0
; GFX10-NEXT:    s_mov_b32 s11, s10
; GFX10-NEXT:    s_cselect_b64 s[2:3], s[2:3], s[8:9]
; GFX10-NEXT:    s_cmp_lg_u32 s24, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc_lo
; GFX10-NEXT:    s_cselect_b64 s[2:3], s[16:17], s[2:3]
; GFX10-NEXT:    s_cmp_lg_u32 s23, 0
; GFX10-NEXT:    v_mov_b32_e32 v2, s17
; GFX10-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[10:11]
; GFX10-NEXT:    s_add_u32 s2, s2, 0
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_xor_b32_e32 v0, v1, v0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    v_mov_b32_e32 v1, s16
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_brev_b32 s23, 1
; GFX10-NEXT:    s_addc_u32 s3, s3, 0
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    v_mov_b32_e32 v3, s31
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s0, s0, 0
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s23
; GFX10-NEXT:    v_cndmask_b32_e64 v0, v1, s2, vcc_lo
; GFX10-NEXT:    s_add_u32 s2, s4, s12
; GFX10-NEXT:    v_cndmask_b32_e64 v1, v2, s3, vcc_lo
; GFX10-NEXT:    s_cselect_b32 s3, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v3, v3, s1, vcc_lo
; GFX10-NEXT:    s_and_b32 s3, s3, 1
; GFX10-NEXT:    v_mov_b32_e32 v2, s30
; GFX10-NEXT:    s_cmp_lg_u32 s3, 0
; GFX10-NEXT:    s_addc_u32 s3, s5, s13
; GFX10-NEXT:    s_cselect_b32 s8, 1, 0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s1, s[2:3], s[4:5]
; GFX10-NEXT:    s_and_b32 s8, s8, 1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, v2, s0, vcc_lo
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_addc_u32 s8, s6, s14
; GFX10-NEXT:    s_cselect_b32 s9, 1, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s1
; GFX10-NEXT:    s_and_b32 s9, s9, 1
; GFX10-NEXT:    v_mov_b32_e32 v7, s8
; GFX10-NEXT:    s_cmp_lg_u32 s9, 0
; GFX10-NEXT:    s_addc_u32 s9, s7, s15
; GFX10-NEXT:    s_cmp_eq_u64 s[8:9], s[6:7]
; GFX10-NEXT:    v_cmp_lt_i64_e64 s1, s[8:9], s[6:7]
; GFX10-NEXT:    s_cselect_b32 s0, 1, 0
; GFX10-NEXT:    v_mov_b32_e32 v8, s9
; GFX10-NEXT:    s_and_b32 s0, 1, s0
; GFX10-NEXT:    s_cmp_eq_u64 s[14:15], 0
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s0
; GFX10-NEXT:    v_cmp_lt_u64_e64 s0, s[12:13], 0
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 1, s1
; GFX10-NEXT:    s_cselect_b32 s1, 1, 0
; GFX10-NEXT:    s_and_b32 s16, 1, s1
; GFX10-NEXT:    s_cmp_lt_u32 s20, 64
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 1, s0
; GFX10-NEXT:    v_cmp_lt_i64_e64 s0, s[14:15], 0
; GFX10-NEXT:    s_cselect_b32 s17, 1, 0
; GFX10-NEXT:    s_cmp_eq_u32 s20, 0
; GFX10-NEXT:    v_cmp_ne_u32_e64 vcc_lo, 0, s16
; GFX10-NEXT:    s_cselect_b32 s12, 1, 0
; GFX10-NEXT:    s_lshr_b64 s[4:5], s[2:3], s20
; GFX10-NEXT:    s_lshl_b64 s[6:7], s[8:9], s22
; GFX10-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s0
; GFX10-NEXT:    s_ashr_i32 s10, s9, 31
; GFX10-NEXT:    s_or_b64 s[4:5], s[4:5], s[6:7]
; GFX10-NEXT:    s_ashr_i64 s[0:1], s[8:9], s20
; GFX10-NEXT:    s_ashr_i64 s[6:7], s[8:9], s21
; GFX10-NEXT:    s_cmp_lg_u32 s17, 0
; GFX10-NEXT:    s_mov_b32 s11, s10
; GFX10-NEXT:    s_cselect_b64 s[4:5], s[4:5], s[6:7]
; GFX10-NEXT:    s_cmp_lg_u32 s12, 0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc_lo
; GFX10-NEXT:    s_cselect_b64 s[4:5], s[2:3], s[4:5]
; GFX10-NEXT:    s_cmp_lg_u32 s17, 0
; GFX10-NEXT:    v_mov_b32_e32 v6, s3
; GFX10-NEXT:    s_cselect_b64 s[0:1], s[0:1], s[10:11]
; GFX10-NEXT:    s_add_u32 s4, s4, 0
; GFX10-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10-NEXT:    v_xor_b32_e32 v4, v5, v4
; GFX10-NEXT:    s_and_b32 s6, s6, 1
; GFX10-NEXT:    v_mov_b32_e32 v5, s2
; GFX10-NEXT:    s_cmp_lg_u32 s6, 0
; GFX10-NEXT:    v_readfirstlane_b32 s2, v2
; GFX10-NEXT:    s_addc_u32 s5, s5, 0
; GFX10-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10-NEXT:    v_and_b32_e32 v4, 1, v4
; GFX10-NEXT:    s_and_b32 s6, s6, 1
; GFX10-NEXT:    v_readfirstlane_b32 s3, v3
; GFX10-NEXT:    s_cmp_lg_u32 s6, 0
; GFX10-NEXT:    s_addc_u32 s0, s0, 0
; GFX10-NEXT:    s_cselect_b32 s6, 1, 0
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    s_and_b32 s6, s6, 1
; GFX10-NEXT:    s_cmp_lg_u32 s6, 0
; GFX10-NEXT:    s_addc_u32 s1, s1, s23
; GFX10-NEXT:    v_cndmask_b32_e64 v4, v5, s4, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v5, v6, s5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v6, v7, s0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v7, v8, s1, vcc_lo
; GFX10-NEXT:    v_readfirstlane_b32 s0, v0
; GFX10-NEXT:    v_readfirstlane_b32 s1, v1
; GFX10-NEXT:    v_readfirstlane_b32 s4, v4
; GFX10-NEXT:    v_readfirstlane_b32 s5, v5
; GFX10-NEXT:    v_readfirstlane_b32 s6, v6
; GFX10-NEXT:    v_readfirstlane_b32 s7, v7
; GFX10-NEXT:    ; return to shader part epilog
  %result = call <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128> %lhs, <2 x i128> %rhs)
  ret <2 x i128> %result
}

declare i7 @llvm.sadd.sat.i7(i7, i7) #0
declare i8 @llvm.sadd.sat.i8(i8, i8) #0
declare <2 x i8> @llvm.sadd.sat.v2i8(<2 x i8>, <2 x i8>) #0
declare <4 x i8> @llvm.sadd.sat.v4i8(<4 x i8>, <4 x i8>) #0

declare i16 @llvm.sadd.sat.i16(i16, i16) #0
declare <2 x i16> @llvm.sadd.sat.v2i16(<2 x i16>, <2 x i16>) #0
declare <3 x i16> @llvm.sadd.sat.v3i16(<3 x i16>, <3 x i16>) #0
declare <4 x i16> @llvm.sadd.sat.v4i16(<4 x i16>, <4 x i16>) #0
declare <5 x i16> @llvm.sadd.sat.v5i16(<5 x i16>, <5 x i16>) #0
declare <6 x i16> @llvm.sadd.sat.v6i16(<6 x i16>, <6 x i16>) #0
declare <8 x i16> @llvm.sadd.sat.v8i16(<8 x i16>, <8 x i16>) #0

declare i24 @llvm.sadd.sat.i24(i24, i24) #0

declare i32 @llvm.sadd.sat.i32(i32, i32) #0
declare <2 x i32> @llvm.sadd.sat.v2i32(<2 x i32>, <2 x i32>) #0
declare <3 x i32> @llvm.sadd.sat.v3i32(<3 x i32>, <3 x i32>) #0
declare <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32>, <4 x i32>) #0
declare <5 x i32> @llvm.sadd.sat.v5i32(<5 x i32>, <5 x i32>) #0
declare <16 x i32> @llvm.sadd.sat.v16i32(<16 x i32>, <16 x i32>) #0

declare i48 @llvm.sadd.sat.i48(i48, i48) #0

declare i64 @llvm.sadd.sat.i64(i64, i64) #0
declare <2 x i64> @llvm.sadd.sat.v2i64(<2 x i64>, <2 x i64>) #0

declare i128 @llvm.sadd.sat.i128(i128, i128) #0
declare <2 x i128> @llvm.sadd.sat.v2i128(<2 x i128>, <2 x i128>) #0

attributes #0 = { nounwind readnone speculatable willreturn }
