//RUN: %clang_cc1 %s -cl-std=clc++ -pedantic -verify -ast-dump  | FileCheck %s

template <typename T>
struct S {
  T a;        // expected-error{{field may not be qualified with an address space}}
  T f1();     // we ignore address space on a return types.
  void f2(T); // expected-error{{parameter may not be qualified with an address space}}
};

template <typename T>
T foo1(__global T *i) { // expected-note{{candidate template ignored: substitution failure [with T = __local int]: conflicting address space qualifiers are provided between types '__global T' and '__local int'}}
  return *i;
}

template <typename T>
T *foo2(T *i) {
  return i;
}

template <typename T>
void foo3() {
  __private T ii; // expected-error{{conflicting address space qualifiers are provided between types '__private T' and '__global int'}}
}

template <class _Tp> struct remove_reference         { typedef _Tp type; };
template <class _Tp> struct remove_reference<_Tp &>  { typedef _Tp type; };
template <class _Tp> struct as_pointer {
    typedef typename remove_reference<_Tp>::type* type;
};

// Check address space deduction in template parameter deduction.
struct rep {
  // When there is no address space on a reference use __generic.
  // CHECK: |-CXXConstructorDecl {{.*}} rep 'void (const __generic rep &__private) __generic'
  template<class U, class = typename as_pointer<U>::type>
  rep(U&& v) {}
};

struct rep_outer : private rep {
  rep_outer()
    : rep(0) {}
};


template<class T, class F>
void foo4(T t, F f){
  f(t);
}

void bar() {
  S<const __global int> sintgl; // expected-note{{in instantiation of template class 'S<const __global int>' requested here}}

  foo1<__local int>(1); // expected-error{{no matching function for call to 'foo1'}}
  foo2<__global int>(0);
  foo3<__global int>(); // expected-note{{in instantiation of function template specialization 'foo3<__global int>' requested here}}

  rep_outer r;
  int i;
  // Preserve the address space of the type in forwarding reference.
  // CHECK: CXXMethodDecl {{.*}} operator() 'void (__private int &__private) const __generic'
  foo4(i, [](auto&& x){;});
}
