// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +experimental-v \
// RUN:   -O2 -emit-llvm %s -o - | FileCheck --check-prefix=CHECK-RV64-O2 %s
// RUN: %clang_cc1 -triple riscv32 -target-feature +experimental-v \
// RUN:   -O2 -emit-llvm %s -o - | FileCheck --check-prefix=CHECK-RV32-O2 %s

#include <stddef.h>
#include <stdint.h>

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[ARG_0:%.*]], <vscale x 8 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> [[ARG_0:%.*]], <vscale x 8 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_int8m1_t test_vadd_vv_i8m1_vl(__rvv_int8m1_t arg_0, __rvv_int8m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], <vscale x 8 x i8> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], <vscale x 8 x i8> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_int8m1_t test_vadd_vv_i8m1_m_vl(__rvv_bool8_t arg_0, __rvv_int8m1_t arg_1, __rvv_int8m1_t arg_2, __rvv_int8m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[ARG_0:%.*]], <vscale x 4 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> [[ARG_0:%.*]], <vscale x 4 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_int16m1_t test_vadd_vv_i16m1_vl(__rvv_int16m1_t arg_0, __rvv_int16m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], <vscale x 4 x i16> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], <vscale x 4 x i16> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_int16m1_t test_vadd_vv_i16m1_m_vl(__rvv_bool16_t arg_0, __rvv_int16m1_t arg_1, __rvv_int16m1_t arg_2, __rvv_int16m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[ARG_0:%.*]], <vscale x 2 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> [[ARG_0:%.*]], <vscale x 2 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_int32m1_t test_vadd_vv_i32m1_vl(__rvv_int32m1_t arg_0, __rvv_int32m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i32m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], <vscale x 2 x i32> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], <vscale x 2 x i32> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_int32m1_t test_vadd_vv_i32m1_m_vl(__rvv_bool32_t arg_0, __rvv_int32m1_t arg_1, __rvv_int32m1_t arg_2, __rvv_int32m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i32m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[ARG_0:%.*]], <vscale x 1 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> [[ARG_0:%.*]], <vscale x 1 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_int64m1_t test_vadd_vv_i64m1_vl(__rvv_int64m1_t arg_0, __rvv_int64m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i64m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], <vscale x 1 x i64> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], <vscale x 1 x i64> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_int64m1_t test_vadd_vv_i64m1_m_vl(__rvv_bool64_t arg_0, __rvv_int64m1_t arg_1, __rvv_int64m1_t arg_2, __rvv_int64m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i64m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[ARG_0:%.*]], <vscale x 16 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> [[ARG_0:%.*]], <vscale x 16 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_int8m2_t test_vadd_vv_i8m2_vl(__rvv_int8m2_t arg_0, __rvv_int8m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], <vscale x 16 x i8> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], <vscale x 16 x i8> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_int8m2_t test_vadd_vv_i8m2_m_vl(__rvv_bool4_t arg_0, __rvv_int8m2_t arg_1, __rvv_int8m2_t arg_2, __rvv_int8m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[ARG_0:%.*]], <vscale x 8 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> [[ARG_0:%.*]], <vscale x 8 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_int16m2_t test_vadd_vv_i16m2_vl(__rvv_int16m2_t arg_0, __rvv_int16m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], <vscale x 8 x i16> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], <vscale x 8 x i16> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_int16m2_t test_vadd_vv_i16m2_m_vl(__rvv_bool8_t arg_0, __rvv_int16m2_t arg_1, __rvv_int16m2_t arg_2, __rvv_int16m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[ARG_0:%.*]], <vscale x 4 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> [[ARG_0:%.*]], <vscale x 4 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_int32m2_t test_vadd_vv_i32m2_vl(__rvv_int32m2_t arg_0, __rvv_int32m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i32m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], <vscale x 4 x i32> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], <vscale x 4 x i32> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_int32m2_t test_vadd_vv_i32m2_m_vl(__rvv_bool16_t arg_0, __rvv_int32m2_t arg_1, __rvv_int32m2_t arg_2, __rvv_int32m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i32m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[ARG_0:%.*]], <vscale x 2 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> [[ARG_0:%.*]], <vscale x 2 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_int64m2_t test_vadd_vv_i64m2_vl(__rvv_int64m2_t arg_0, __rvv_int64m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i64m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], <vscale x 2 x i64> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], <vscale x 2 x i64> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_int64m2_t test_vadd_vv_i64m2_m_vl(__rvv_bool32_t arg_0, __rvv_int64m2_t arg_1, __rvv_int64m2_t arg_2, __rvv_int64m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i64m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[ARG_0:%.*]], <vscale x 32 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> [[ARG_0:%.*]], <vscale x 32 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_int8m4_t test_vadd_vv_i8m4_vl(__rvv_int8m4_t arg_0, __rvv_int8m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], <vscale x 32 x i8> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], <vscale x 32 x i8> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_int8m4_t test_vadd_vv_i8m4_m_vl(__rvv_bool2_t arg_0, __rvv_int8m4_t arg_1, __rvv_int8m4_t arg_2, __rvv_int8m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[ARG_0:%.*]], <vscale x 16 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> [[ARG_0:%.*]], <vscale x 16 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_int16m4_t test_vadd_vv_i16m4_vl(__rvv_int16m4_t arg_0, __rvv_int16m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], <vscale x 16 x i16> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], <vscale x 16 x i16> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_int16m4_t test_vadd_vv_i16m4_m_vl(__rvv_bool4_t arg_0, __rvv_int16m4_t arg_1, __rvv_int16m4_t arg_2, __rvv_int16m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[ARG_0:%.*]], <vscale x 8 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> [[ARG_0:%.*]], <vscale x 8 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_int32m4_t test_vadd_vv_i32m4_vl(__rvv_int32m4_t arg_0, __rvv_int32m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i32m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], <vscale x 8 x i32> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], <vscale x 8 x i32> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_int32m4_t test_vadd_vv_i32m4_m_vl(__rvv_bool8_t arg_0, __rvv_int32m4_t arg_1, __rvv_int32m4_t arg_2, __rvv_int32m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i32m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[ARG_0:%.*]], <vscale x 4 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> [[ARG_0:%.*]], <vscale x 4 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_int64m4_t test_vadd_vv_i64m4_vl(__rvv_int64m4_t arg_0, __rvv_int64m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i64m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], <vscale x 4 x i64> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], <vscale x 4 x i64> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_int64m4_t test_vadd_vv_i64m4_m_vl(__rvv_bool16_t arg_0, __rvv_int64m4_t arg_1, __rvv_int64m4_t arg_2, __rvv_int64m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i64m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[ARG_0:%.*]], <vscale x 64 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> [[ARG_0:%.*]], <vscale x 64 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_int8m8_t test_vadd_vv_i8m8_vl(__rvv_int8m8_t arg_0, __rvv_int8m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], <vscale x 64 x i8> [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], <vscale x 64 x i8> [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_int8m8_t test_vadd_vv_i8m8_m_vl(__rvv_bool1_t arg_0, __rvv_int8m8_t arg_1, __rvv_int8m8_t arg_2, __rvv_int8m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[ARG_0:%.*]], <vscale x 32 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> [[ARG_0:%.*]], <vscale x 32 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_int16m8_t test_vadd_vv_i16m8_vl(__rvv_int16m8_t arg_0, __rvv_int16m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], <vscale x 32 x i16> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], <vscale x 32 x i16> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_int16m8_t test_vadd_vv_i16m8_m_vl(__rvv_bool2_t arg_0, __rvv_int16m8_t arg_1, __rvv_int16m8_t arg_2, __rvv_int16m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[ARG_0:%.*]], <vscale x 16 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> [[ARG_0:%.*]], <vscale x 16 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_int32m8_t test_vadd_vv_i32m8_vl(__rvv_int32m8_t arg_0, __rvv_int32m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i32m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], <vscale x 16 x i32> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], <vscale x 16 x i32> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_int32m8_t test_vadd_vv_i32m8_m_vl(__rvv_bool4_t arg_0, __rvv_int32m8_t arg_1, __rvv_int32m8_t arg_2, __rvv_int32m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i32m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[ARG_0:%.*]], <vscale x 8 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> [[ARG_0:%.*]], <vscale x 8 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_int64m8_t test_vadd_vv_i64m8_vl(__rvv_int64m8_t arg_0, __rvv_int64m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i64m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i64m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], <vscale x 8 x i64> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i64m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], <vscale x 8 x i64> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_int64m8_t test_vadd_vv_i64m8_m_vl(__rvv_bool8_t arg_0, __rvv_int64m8_t arg_1, __rvv_int64m8_t arg_2, __rvv_int64m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i64m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[ARG_0:%.*]], <vscale x 4 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> [[ARG_0:%.*]], <vscale x 4 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_int8mf2_t test_vadd_vv_i8mf2_vl(__rvv_int8mf2_t arg_0, __rvv_int8mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], <vscale x 4 x i8> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], <vscale x 4 x i8> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_int8mf2_t test_vadd_vv_i8mf2_m_vl(__rvv_bool16_t arg_0, __rvv_int8mf2_t arg_1, __rvv_int8mf2_t arg_2, __rvv_int8mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[ARG_0:%.*]], <vscale x 2 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> [[ARG_0:%.*]], <vscale x 2 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_int16mf2_t test_vadd_vv_i16mf2_vl(__rvv_int16mf2_t arg_0, __rvv_int16mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], <vscale x 2 x i16> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], <vscale x 2 x i16> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_int16mf2_t test_vadd_vv_i16mf2_m_vl(__rvv_bool32_t arg_0, __rvv_int16mf2_t arg_1, __rvv_int16mf2_t arg_2, __rvv_int16mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[ARG_0:%.*]], <vscale x 1 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> [[ARG_0:%.*]], <vscale x 1 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_int32mf2_t test_vadd_vv_i32mf2_vl(__rvv_int32mf2_t arg_0, __rvv_int32mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i32mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i32mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], <vscale x 1 x i32> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i32mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], <vscale x 1 x i32> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_int32mf2_t test_vadd_vv_i32mf2_m_vl(__rvv_bool64_t arg_0, __rvv_int32mf2_t arg_1, __rvv_int32mf2_t arg_2, __rvv_int32mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i32mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[ARG_0:%.*]], <vscale x 2 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> [[ARG_0:%.*]], <vscale x 2 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_int8mf4_t test_vadd_vv_i8mf4_vl(__rvv_int8mf4_t arg_0, __rvv_int8mf4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], <vscale x 2 x i8> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], <vscale x 2 x i8> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_int8mf4_t test_vadd_vv_i8mf4_m_vl(__rvv_bool32_t arg_0, __rvv_int8mf4_t arg_1, __rvv_int8mf4_t arg_2, __rvv_int8mf4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[ARG_0:%.*]], <vscale x 1 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> [[ARG_0:%.*]], <vscale x 1 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_int16mf4_t test_vadd_vv_i16mf4_vl(__rvv_int16mf4_t arg_0, __rvv_int16mf4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i16mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i16mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], <vscale x 1 x i16> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i16mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], <vscale x 1 x i16> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_int16mf4_t test_vadd_vv_i16mf4_m_vl(__rvv_bool64_t arg_0, __rvv_int16mf4_t arg_1, __rvv_int16mf4_t arg_2, __rvv_int16mf4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i16mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[ARG_0:%.*]], <vscale x 1 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> [[ARG_0:%.*]], <vscale x 1 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_int8mf8_t test_vadd_vv_i8mf8_vl(__rvv_int8mf8_t arg_0, __rvv_int8mf8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_i8mf8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_i8mf8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], <vscale x 1 x i8> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_i8mf8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], <vscale x 1 x i8> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_int8mf8_t test_vadd_vv_i8mf8_m_vl(__rvv_bool64_t arg_0, __rvv_int8mf8_t arg_1, __rvv_int8mf8_t arg_2, __rvv_int8mf8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_i8mf8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.i8.i64(<vscale x 8 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.i8.i32(<vscale x 8 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_int8m1_t test_vadd_vx_i8m1_vl(__rvv_int8m1_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.i8.i64(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.i8.i32(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_int8m1_t test_vadd_vx_i8m1_m_vl(__rvv_bool8_t arg_0, __rvv_int8m1_t arg_1, __rvv_int8m1_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.i16.i64(<vscale x 4 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.i16.i32(<vscale x 4 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_int16m1_t test_vadd_vx_i16m1_vl(__rvv_int16m1_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.i16.i64(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.i16.i32(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_int16m1_t test_vadd_vx_i16m1_m_vl(__rvv_bool16_t arg_0, __rvv_int16m1_t arg_1, __rvv_int16m1_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.i32.i64(<vscale x 2 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.i32.i32(<vscale x 2 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_int32m1_t test_vadd_vx_i32m1_vl(__rvv_int32m1_t arg_0, int32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i32m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.i32.i64(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.i32.i32(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_int32m1_t test_vadd_vx_i32m1_m_vl(__rvv_bool32_t arg_0, __rvv_int32m1_t arg_1, __rvv_int32m1_t arg_2, int32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i32m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.i64.i64(<vscale x 1 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.i64.i32(<vscale x 1 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_int64m1_t test_vadd_vx_i64m1_vl(__rvv_int64m1_t arg_0, int64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i64m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.i64.i64(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.i64.i32(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_int64m1_t test_vadd_vx_i64m1_m_vl(__rvv_bool64_t arg_0, __rvv_int64m1_t arg_1, __rvv_int64m1_t arg_2, int64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i64m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.i8.i64(<vscale x 16 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.i8.i32(<vscale x 16 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_int8m2_t test_vadd_vx_i8m2_vl(__rvv_int8m2_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.i8.i64(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.i8.i32(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_int8m2_t test_vadd_vx_i8m2_m_vl(__rvv_bool4_t arg_0, __rvv_int8m2_t arg_1, __rvv_int8m2_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.i16.i64(<vscale x 8 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.i16.i32(<vscale x 8 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_int16m2_t test_vadd_vx_i16m2_vl(__rvv_int16m2_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.i16.i64(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.i16.i32(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_int16m2_t test_vadd_vx_i16m2_m_vl(__rvv_bool8_t arg_0, __rvv_int16m2_t arg_1, __rvv_int16m2_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.i32.i64(<vscale x 4 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.i32.i32(<vscale x 4 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_int32m2_t test_vadd_vx_i32m2_vl(__rvv_int32m2_t arg_0, int32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i32m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.i32.i64(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.i32.i32(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_int32m2_t test_vadd_vx_i32m2_m_vl(__rvv_bool16_t arg_0, __rvv_int32m2_t arg_1, __rvv_int32m2_t arg_2, int32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i32m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.i64.i64(<vscale x 2 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.i64.i32(<vscale x 2 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_int64m2_t test_vadd_vx_i64m2_vl(__rvv_int64m2_t arg_0, int64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i64m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.i64.i64(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.i64.i32(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_int64m2_t test_vadd_vx_i64m2_m_vl(__rvv_bool32_t arg_0, __rvv_int64m2_t arg_1, __rvv_int64m2_t arg_2, int64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i64m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.i8.i64(<vscale x 32 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.i8.i32(<vscale x 32 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_int8m4_t test_vadd_vx_i8m4_vl(__rvv_int8m4_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.i8.i64(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.i8.i32(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_int8m4_t test_vadd_vx_i8m4_m_vl(__rvv_bool2_t arg_0, __rvv_int8m4_t arg_1, __rvv_int8m4_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.i16.i64(<vscale x 16 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.i16.i32(<vscale x 16 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_int16m4_t test_vadd_vx_i16m4_vl(__rvv_int16m4_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.i16.i64(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.i16.i32(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_int16m4_t test_vadd_vx_i16m4_m_vl(__rvv_bool4_t arg_0, __rvv_int16m4_t arg_1, __rvv_int16m4_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.i32.i64(<vscale x 8 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.i32.i32(<vscale x 8 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_int32m4_t test_vadd_vx_i32m4_vl(__rvv_int32m4_t arg_0, int32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i32m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.i32.i64(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.i32.i32(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_int32m4_t test_vadd_vx_i32m4_m_vl(__rvv_bool8_t arg_0, __rvv_int32m4_t arg_1, __rvv_int32m4_t arg_2, int32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i32m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.i64.i64(<vscale x 4 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.i64.i32(<vscale x 4 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_int64m4_t test_vadd_vx_i64m4_vl(__rvv_int64m4_t arg_0, int64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i64m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.i64.i64(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.i64.i32(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_int64m4_t test_vadd_vx_i64m4_m_vl(__rvv_bool16_t arg_0, __rvv_int64m4_t arg_1, __rvv_int64m4_t arg_2, int64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i64m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.i8.i64(<vscale x 64 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.i8.i32(<vscale x 64 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_int8m8_t test_vadd_vx_i8m8_vl(__rvv_int8m8_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.i8.i64(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.i8.i32(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_int8m8_t test_vadd_vx_i8m8_m_vl(__rvv_bool1_t arg_0, __rvv_int8m8_t arg_1, __rvv_int8m8_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.i16.i64(<vscale x 32 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.i16.i32(<vscale x 32 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_int16m8_t test_vadd_vx_i16m8_vl(__rvv_int16m8_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.i16.i64(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.i16.i32(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_int16m8_t test_vadd_vx_i16m8_m_vl(__rvv_bool2_t arg_0, __rvv_int16m8_t arg_1, __rvv_int16m8_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.i32.i64(<vscale x 16 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.i32.i32(<vscale x 16 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_int32m8_t test_vadd_vx_i32m8_vl(__rvv_int32m8_t arg_0, int32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i32m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.i32.i64(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.i32.i32(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_int32m8_t test_vadd_vx_i32m8_m_vl(__rvv_bool4_t arg_0, __rvv_int32m8_t arg_1, __rvv_int32m8_t arg_2, int32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i32m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.i64.i64(<vscale x 8 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.i64.i32(<vscale x 8 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_int64m8_t test_vadd_vx_i64m8_vl(__rvv_int64m8_t arg_0, int64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i64m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i64m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.i64.i64(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i64m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.i64.i32(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_int64m8_t test_vadd_vx_i64m8_m_vl(__rvv_bool8_t arg_0, __rvv_int64m8_t arg_1, __rvv_int64m8_t arg_2, int64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i64m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.i8.i64(<vscale x 4 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.i8.i32(<vscale x 4 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_int8mf2_t test_vadd_vx_i8mf2_vl(__rvv_int8mf2_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.i8.i64(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.i8.i32(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_int8mf2_t test_vadd_vx_i8mf2_m_vl(__rvv_bool16_t arg_0, __rvv_int8mf2_t arg_1, __rvv_int8mf2_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.i16.i64(<vscale x 2 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.i16.i32(<vscale x 2 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_int16mf2_t test_vadd_vx_i16mf2_vl(__rvv_int16mf2_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.i16.i64(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.i16.i32(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_int16mf2_t test_vadd_vx_i16mf2_m_vl(__rvv_bool32_t arg_0, __rvv_int16mf2_t arg_1, __rvv_int16mf2_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.i32.i64(<vscale x 1 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.i32.i32(<vscale x 1 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_int32mf2_t test_vadd_vx_i32mf2_vl(__rvv_int32mf2_t arg_0, int32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i32mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i32mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.i32.i64(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i32mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.i32.i32(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_int32mf2_t test_vadd_vx_i32mf2_m_vl(__rvv_bool64_t arg_0, __rvv_int32mf2_t arg_1, __rvv_int32mf2_t arg_2, int32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i32mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.i8.i64(<vscale x 2 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.i8.i32(<vscale x 2 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_int8mf4_t test_vadd_vx_i8mf4_vl(__rvv_int8mf4_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.i8.i64(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.i8.i32(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_int8mf4_t test_vadd_vx_i8mf4_m_vl(__rvv_bool32_t arg_0, __rvv_int8mf4_t arg_1, __rvv_int8mf4_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.i16.i64(<vscale x 1 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.i16.i32(<vscale x 1 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_int16mf4_t test_vadd_vx_i16mf4_vl(__rvv_int16mf4_t arg_0, int16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i16mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i16mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.i16.i64(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i16mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.i16.i32(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_int16mf4_t test_vadd_vx_i16mf4_m_vl(__rvv_bool64_t arg_0, __rvv_int16mf4_t arg_1, __rvv_int16mf4_t arg_2, int16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i16mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.i8.i64(<vscale x 1 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.i8.i32(<vscale x 1 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_int8mf8_t test_vadd_vx_i8mf8_vl(__rvv_int8mf8_t arg_0, int8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_i8mf8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_i8mf8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.i8.i64(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_i8mf8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.i8.i32(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_int8mf8_t test_vadd_vx_i8mf8_m_vl(__rvv_bool64_t arg_0, __rvv_int8mf8_t arg_1, __rvv_int8mf8_t arg_2, int8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_i8mf8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[ARG_0:%.*]], <vscale x 8 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> [[ARG_0:%.*]], <vscale x 8 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_uint8m1_t test_vadd_vv_u8m1_vl(__rvv_uint8m1_t arg_0, __rvv_uint8m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.nxv8i8.i64(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], <vscale x 8 x i8> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.nxv8i8.i32(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], <vscale x 8 x i8> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_uint8m1_t test_vadd_vv_u8m1_m_vl(__rvv_bool8_t arg_0, __rvv_uint8m1_t arg_1, __rvv_uint8m1_t arg_2, __rvv_uint8m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[ARG_0:%.*]], <vscale x 4 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> [[ARG_0:%.*]], <vscale x 4 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_uint16m1_t test_vadd_vv_u16m1_vl(__rvv_uint16m1_t arg_0, __rvv_uint16m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.nxv4i16.i64(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], <vscale x 4 x i16> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.nxv4i16.i32(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], <vscale x 4 x i16> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_uint16m1_t test_vadd_vv_u16m1_m_vl(__rvv_bool16_t arg_0, __rvv_uint16m1_t arg_1, __rvv_uint16m1_t arg_2, __rvv_uint16m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[ARG_0:%.*]], <vscale x 2 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> [[ARG_0:%.*]], <vscale x 2 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_uint32m1_t test_vadd_vv_u32m1_vl(__rvv_uint32m1_t arg_0, __rvv_uint32m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u32m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.nxv2i32.i64(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], <vscale x 2 x i32> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.nxv2i32.i32(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], <vscale x 2 x i32> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_uint32m1_t test_vadd_vv_u32m1_m_vl(__rvv_bool32_t arg_0, __rvv_uint32m1_t arg_1, __rvv_uint32m1_t arg_2, __rvv_uint32m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u32m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[ARG_0:%.*]], <vscale x 1 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> [[ARG_0:%.*]], <vscale x 1 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_uint64m1_t test_vadd_vv_u64m1_vl(__rvv_uint64m1_t arg_0, __rvv_uint64m1_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u64m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.nxv1i64.i64(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], <vscale x 1 x i64> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.nxv1i64.i32(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], <vscale x 1 x i64> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_uint64m1_t test_vadd_vv_u64m1_m_vl(__rvv_bool64_t arg_0, __rvv_uint64m1_t arg_1, __rvv_uint64m1_t arg_2, __rvv_uint64m1_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u64m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[ARG_0:%.*]], <vscale x 16 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> [[ARG_0:%.*]], <vscale x 16 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_uint8m2_t test_vadd_vv_u8m2_vl(__rvv_uint8m2_t arg_0, __rvv_uint8m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.nxv16i8.i64(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], <vscale x 16 x i8> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.nxv16i8.i32(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], <vscale x 16 x i8> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_uint8m2_t test_vadd_vv_u8m2_m_vl(__rvv_bool4_t arg_0, __rvv_uint8m2_t arg_1, __rvv_uint8m2_t arg_2, __rvv_uint8m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[ARG_0:%.*]], <vscale x 8 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> [[ARG_0:%.*]], <vscale x 8 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_uint16m2_t test_vadd_vv_u16m2_vl(__rvv_uint16m2_t arg_0, __rvv_uint16m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.nxv8i16.i64(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], <vscale x 8 x i16> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.nxv8i16.i32(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], <vscale x 8 x i16> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_uint16m2_t test_vadd_vv_u16m2_m_vl(__rvv_bool8_t arg_0, __rvv_uint16m2_t arg_1, __rvv_uint16m2_t arg_2, __rvv_uint16m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[ARG_0:%.*]], <vscale x 4 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> [[ARG_0:%.*]], <vscale x 4 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_uint32m2_t test_vadd_vv_u32m2_vl(__rvv_uint32m2_t arg_0, __rvv_uint32m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u32m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.nxv4i32.i64(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], <vscale x 4 x i32> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.nxv4i32.i32(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], <vscale x 4 x i32> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_uint32m2_t test_vadd_vv_u32m2_m_vl(__rvv_bool16_t arg_0, __rvv_uint32m2_t arg_1, __rvv_uint32m2_t arg_2, __rvv_uint32m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u32m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[ARG_0:%.*]], <vscale x 2 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> [[ARG_0:%.*]], <vscale x 2 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_uint64m2_t test_vadd_vv_u64m2_vl(__rvv_uint64m2_t arg_0, __rvv_uint64m2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u64m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.nxv2i64.i64(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], <vscale x 2 x i64> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.nxv2i64.i32(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], <vscale x 2 x i64> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_uint64m2_t test_vadd_vv_u64m2_m_vl(__rvv_bool32_t arg_0, __rvv_uint64m2_t arg_1, __rvv_uint64m2_t arg_2, __rvv_uint64m2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u64m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[ARG_0:%.*]], <vscale x 32 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> [[ARG_0:%.*]], <vscale x 32 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_uint8m4_t test_vadd_vv_u8m4_vl(__rvv_uint8m4_t arg_0, __rvv_uint8m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.nxv32i8.i64(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], <vscale x 32 x i8> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.nxv32i8.i32(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], <vscale x 32 x i8> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_uint8m4_t test_vadd_vv_u8m4_m_vl(__rvv_bool2_t arg_0, __rvv_uint8m4_t arg_1, __rvv_uint8m4_t arg_2, __rvv_uint8m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[ARG_0:%.*]], <vscale x 16 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> [[ARG_0:%.*]], <vscale x 16 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_uint16m4_t test_vadd_vv_u16m4_vl(__rvv_uint16m4_t arg_0, __rvv_uint16m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.nxv16i16.i64(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], <vscale x 16 x i16> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.nxv16i16.i32(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], <vscale x 16 x i16> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_uint16m4_t test_vadd_vv_u16m4_m_vl(__rvv_bool4_t arg_0, __rvv_uint16m4_t arg_1, __rvv_uint16m4_t arg_2, __rvv_uint16m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[ARG_0:%.*]], <vscale x 8 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> [[ARG_0:%.*]], <vscale x 8 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_uint32m4_t test_vadd_vv_u32m4_vl(__rvv_uint32m4_t arg_0, __rvv_uint32m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u32m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.nxv8i32.i64(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], <vscale x 8 x i32> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.nxv8i32.i32(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], <vscale x 8 x i32> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_uint32m4_t test_vadd_vv_u32m4_m_vl(__rvv_bool8_t arg_0, __rvv_uint32m4_t arg_1, __rvv_uint32m4_t arg_2, __rvv_uint32m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u32m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[ARG_0:%.*]], <vscale x 4 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> [[ARG_0:%.*]], <vscale x 4 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_uint64m4_t test_vadd_vv_u64m4_vl(__rvv_uint64m4_t arg_0, __rvv_uint64m4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u64m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.nxv4i64.i64(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], <vscale x 4 x i64> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], <vscale x 4 x i64> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_uint64m4_t test_vadd_vv_u64m4_m_vl(__rvv_bool16_t arg_0, __rvv_uint64m4_t arg_1, __rvv_uint64m4_t arg_2, __rvv_uint64m4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u64m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[ARG_0:%.*]], <vscale x 64 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> [[ARG_0:%.*]], <vscale x 64 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_uint8m8_t test_vadd_vv_u8m8_vl(__rvv_uint8m8_t arg_0, __rvv_uint8m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.nxv64i8.i64(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], <vscale x 64 x i8> [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.nxv64i8.i32(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], <vscale x 64 x i8> [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_uint8m8_t test_vadd_vv_u8m8_m_vl(__rvv_bool1_t arg_0, __rvv_uint8m8_t arg_1, __rvv_uint8m8_t arg_2, __rvv_uint8m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[ARG_0:%.*]], <vscale x 32 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> [[ARG_0:%.*]], <vscale x 32 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_uint16m8_t test_vadd_vv_u16m8_vl(__rvv_uint16m8_t arg_0, __rvv_uint16m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.nxv32i16.i64(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], <vscale x 32 x i16> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.nxv32i16.i32(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], <vscale x 32 x i16> [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_uint16m8_t test_vadd_vv_u16m8_m_vl(__rvv_bool2_t arg_0, __rvv_uint16m8_t arg_1, __rvv_uint16m8_t arg_2, __rvv_uint16m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[ARG_0:%.*]], <vscale x 16 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> [[ARG_0:%.*]], <vscale x 16 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_uint32m8_t test_vadd_vv_u32m8_vl(__rvv_uint32m8_t arg_0, __rvv_uint32m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u32m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.nxv16i32.i64(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], <vscale x 16 x i32> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.nxv16i32.i32(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], <vscale x 16 x i32> [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_uint32m8_t test_vadd_vv_u32m8_m_vl(__rvv_bool4_t arg_0, __rvv_uint32m8_t arg_1, __rvv_uint32m8_t arg_2, __rvv_uint32m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u32m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[ARG_0:%.*]], <vscale x 8 x i64> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> [[ARG_0:%.*]], <vscale x 8 x i64> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_uint64m8_t test_vadd_vv_u64m8_vl(__rvv_uint64m8_t arg_0, __rvv_uint64m8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u64m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u64m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.nxv8i64.i64(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], <vscale x 8 x i64> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u64m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.nxv8i64.i32(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], <vscale x 8 x i64> [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_uint64m8_t test_vadd_vv_u64m8_m_vl(__rvv_bool8_t arg_0, __rvv_uint64m8_t arg_1, __rvv_uint64m8_t arg_2, __rvv_uint64m8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u64m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[ARG_0:%.*]], <vscale x 4 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> [[ARG_0:%.*]], <vscale x 4 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_uint8mf2_t test_vadd_vv_u8mf2_vl(__rvv_uint8mf2_t arg_0, __rvv_uint8mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.nxv4i8.i64(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], <vscale x 4 x i8> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.nxv4i8.i32(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], <vscale x 4 x i8> [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_uint8mf2_t test_vadd_vv_u8mf2_m_vl(__rvv_bool16_t arg_0, __rvv_uint8mf2_t arg_1, __rvv_uint8mf2_t arg_2, __rvv_uint8mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[ARG_0:%.*]], <vscale x 2 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> [[ARG_0:%.*]], <vscale x 2 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_uint16mf2_t test_vadd_vv_u16mf2_vl(__rvv_uint16mf2_t arg_0, __rvv_uint16mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.nxv2i16.i64(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], <vscale x 2 x i16> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.nxv2i16.i32(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], <vscale x 2 x i16> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_uint16mf2_t test_vadd_vv_u16mf2_m_vl(__rvv_bool32_t arg_0, __rvv_uint16mf2_t arg_1, __rvv_uint16mf2_t arg_2, __rvv_uint16mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[ARG_0:%.*]], <vscale x 1 x i32> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> [[ARG_0:%.*]], <vscale x 1 x i32> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_uint32mf2_t test_vadd_vv_u32mf2_vl(__rvv_uint32mf2_t arg_0, __rvv_uint32mf2_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u32mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u32mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32.i64(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], <vscale x 1 x i32> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u32mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32.i32(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], <vscale x 1 x i32> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_uint32mf2_t test_vadd_vv_u32mf2_m_vl(__rvv_bool64_t arg_0, __rvv_uint32mf2_t arg_1, __rvv_uint32mf2_t arg_2, __rvv_uint32mf2_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u32mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[ARG_0:%.*]], <vscale x 2 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> [[ARG_0:%.*]], <vscale x 2 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_uint8mf4_t test_vadd_vv_u8mf4_vl(__rvv_uint8mf4_t arg_0, __rvv_uint8mf4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.nxv2i8.i64(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], <vscale x 2 x i8> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.nxv2i8.i32(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], <vscale x 2 x i8> [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_uint8mf4_t test_vadd_vv_u8mf4_m_vl(__rvv_bool32_t arg_0, __rvv_uint8mf4_t arg_1, __rvv_uint8mf4_t arg_2, __rvv_uint8mf4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[ARG_0:%.*]], <vscale x 1 x i16> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> [[ARG_0:%.*]], <vscale x 1 x i16> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_uint16mf4_t test_vadd_vv_u16mf4_vl(__rvv_uint16mf4_t arg_0, __rvv_uint16mf4_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u16mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u16mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.nxv1i16.i64(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], <vscale x 1 x i16> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u16mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.nxv1i16.i32(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], <vscale x 1 x i16> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_uint16mf4_t test_vadd_vv_u16mf4_m_vl(__rvv_bool64_t arg_0, __rvv_uint16mf4_t arg_1, __rvv_uint16mf4_t arg_2, __rvv_uint16mf4_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u16mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[ARG_0:%.*]], <vscale x 1 x i8> [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> [[ARG_0:%.*]], <vscale x 1 x i8> [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_uint8mf8_t test_vadd_vv_u8mf8_vl(__rvv_uint8mf8_t arg_0, __rvv_uint8mf8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vv_u8mf8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vv_u8mf8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.nxv1i8.i64(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], <vscale x 1 x i8> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vv_u8mf8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.nxv1i8.i32(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], <vscale x 1 x i8> [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_uint8mf8_t test_vadd_vv_u8mf8_m_vl(__rvv_bool64_t arg_0, __rvv_uint8mf8_t arg_1, __rvv_uint8mf8_t arg_2, __rvv_uint8mf8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vv_u8mf8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.i8.i64(<vscale x 8 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.nxv8i8.i8.i32(<vscale x 8 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_uint8m1_t test_vadd_vx_u8m1_vl(__rvv_uint8m1_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.i8.i64(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i8> @llvm.riscv.vadd.mask.nxv8i8.i8.i32(<vscale x 8 x i8> [[ARG_1:%.*]], <vscale x 8 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
__rvv_uint8m1_t test_vadd_vx_u8m1_m_vl(__rvv_bool8_t arg_0, __rvv_uint8m1_t arg_1, __rvv_uint8m1_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.i16.i64(<vscale x 4 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.i16.i32(<vscale x 4 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_uint16m1_t test_vadd_vx_u16m1_vl(__rvv_uint16m1_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.i16.i64(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i16> @llvm.riscv.vadd.mask.nxv4i16.i16.i32(<vscale x 4 x i16> [[ARG_1:%.*]], <vscale x 4 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
__rvv_uint16m1_t test_vadd_vx_u16m1_m_vl(__rvv_bool16_t arg_0, __rvv_uint16m1_t arg_1, __rvv_uint16m1_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.i32.i64(<vscale x 2 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.nxv2i32.i32.i32(<vscale x 2 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_uint32m1_t test_vadd_vx_u32m1_vl(__rvv_uint32m1_t arg_0, uint32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u32m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.i32.i64(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i32> @llvm.riscv.vadd.mask.nxv2i32.i32.i32(<vscale x 2 x i32> [[ARG_1:%.*]], <vscale x 2 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
__rvv_uint32m1_t test_vadd_vx_u32m1_m_vl(__rvv_bool32_t arg_0, __rvv_uint32m1_t arg_1, __rvv_uint32m1_t arg_2, uint32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u32m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m1_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.i64.i64(<vscale x 1 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m1_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.nxv1i64.i64.i32(<vscale x 1 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_uint64m1_t test_vadd_vx_u64m1_vl(__rvv_uint64m1_t arg_0, uint64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u64m1_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m1_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.i64.i64(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m1_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i64> @llvm.riscv.vadd.mask.nxv1i64.i64.i32(<vscale x 1 x i64> [[ARG_1:%.*]], <vscale x 1 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
__rvv_uint64m1_t test_vadd_vx_u64m1_m_vl(__rvv_bool64_t arg_0, __rvv_uint64m1_t arg_1, __rvv_uint64m1_t arg_2, uint64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u64m1_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.i8.i64(<vscale x 16 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.nxv16i8.i8.i32(<vscale x 16 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_uint8m2_t test_vadd_vx_u8m2_vl(__rvv_uint8m2_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.i8.i64(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i8> @llvm.riscv.vadd.mask.nxv16i8.i8.i32(<vscale x 16 x i8> [[ARG_1:%.*]], <vscale x 16 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
__rvv_uint8m2_t test_vadd_vx_u8m2_m_vl(__rvv_bool4_t arg_0, __rvv_uint8m2_t arg_1, __rvv_uint8m2_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.i16.i64(<vscale x 8 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.nxv8i16.i16.i32(<vscale x 8 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_uint16m2_t test_vadd_vx_u16m2_vl(__rvv_uint16m2_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.i16.i64(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i16> @llvm.riscv.vadd.mask.nxv8i16.i16.i32(<vscale x 8 x i16> [[ARG_1:%.*]], <vscale x 8 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
__rvv_uint16m2_t test_vadd_vx_u16m2_m_vl(__rvv_bool8_t arg_0, __rvv_uint16m2_t arg_1, __rvv_uint16m2_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.i32.i64(<vscale x 4 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.i32.i32(<vscale x 4 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_uint32m2_t test_vadd_vx_u32m2_vl(__rvv_uint32m2_t arg_0, uint32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u32m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.i32.i64(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i32> @llvm.riscv.vadd.mask.nxv4i32.i32.i32(<vscale x 4 x i32> [[ARG_1:%.*]], <vscale x 4 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
__rvv_uint32m2_t test_vadd_vx_u32m2_m_vl(__rvv_bool16_t arg_0, __rvv_uint32m2_t arg_1, __rvv_uint32m2_t arg_2, uint32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u32m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.i64.i64(<vscale x 2 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.nxv2i64.i64.i32(<vscale x 2 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_uint64m2_t test_vadd_vx_u64m2_vl(__rvv_uint64m2_t arg_0, uint64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u64m2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.i64.i64(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i64> @llvm.riscv.vadd.mask.nxv2i64.i64.i32(<vscale x 2 x i64> [[ARG_1:%.*]], <vscale x 2 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
__rvv_uint64m2_t test_vadd_vx_u64m2_m_vl(__rvv_bool32_t arg_0, __rvv_uint64m2_t arg_1, __rvv_uint64m2_t arg_2, uint64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u64m2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.i8.i64(<vscale x 32 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.nxv32i8.i8.i32(<vscale x 32 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_uint8m4_t test_vadd_vx_u8m4_vl(__rvv_uint8m4_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.i8.i64(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i8> @llvm.riscv.vadd.mask.nxv32i8.i8.i32(<vscale x 32 x i8> [[ARG_1:%.*]], <vscale x 32 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
__rvv_uint8m4_t test_vadd_vx_u8m4_m_vl(__rvv_bool2_t arg_0, __rvv_uint8m4_t arg_1, __rvv_uint8m4_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.i16.i64(<vscale x 16 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.nxv16i16.i16.i32(<vscale x 16 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_uint16m4_t test_vadd_vx_u16m4_vl(__rvv_uint16m4_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.i16.i64(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i16> @llvm.riscv.vadd.mask.nxv16i16.i16.i32(<vscale x 16 x i16> [[ARG_1:%.*]], <vscale x 16 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
__rvv_uint16m4_t test_vadd_vx_u16m4_m_vl(__rvv_bool4_t arg_0, __rvv_uint16m4_t arg_1, __rvv_uint16m4_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.i32.i64(<vscale x 8 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.nxv8i32.i32.i32(<vscale x 8 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_uint32m4_t test_vadd_vx_u32m4_vl(__rvv_uint32m4_t arg_0, uint32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u32m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.i32.i64(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i32> @llvm.riscv.vadd.mask.nxv8i32.i32.i32(<vscale x 8 x i32> [[ARG_1:%.*]], <vscale x 8 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
__rvv_uint32m4_t test_vadd_vx_u32m4_m_vl(__rvv_bool8_t arg_0, __rvv_uint32m4_t arg_1, __rvv_uint32m4_t arg_2, uint32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u32m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.i64.i64(<vscale x 4 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.i64.i32(<vscale x 4 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_uint64m4_t test_vadd_vx_u64m4_vl(__rvv_uint64m4_t arg_0, uint64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u64m4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.i64.i64(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i64> @llvm.riscv.vadd.mask.nxv4i64.i64.i32(<vscale x 4 x i64> [[ARG_1:%.*]], <vscale x 4 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
__rvv_uint64m4_t test_vadd_vx_u64m4_m_vl(__rvv_bool16_t arg_0, __rvv_uint64m4_t arg_1, __rvv_uint64m4_t arg_2, uint64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u64m4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.i8.i64(<vscale x 64 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.nxv64i8.i8.i32(<vscale x 64 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_uint8m8_t test_vadd_vx_u8m8_vl(__rvv_uint8m8_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.i8.i64(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 64 x i8> @llvm.riscv.vadd.mask.nxv64i8.i8.i32(<vscale x 64 x i8> [[ARG_1:%.*]], <vscale x 64 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 64 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
__rvv_uint8m8_t test_vadd_vx_u8m8_m_vl(__rvv_bool1_t arg_0, __rvv_uint8m8_t arg_1, __rvv_uint8m8_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.i16.i64(<vscale x 32 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.nxv32i16.i16.i32(<vscale x 32 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_uint16m8_t test_vadd_vx_u16m8_vl(__rvv_uint16m8_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.i16.i64(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 32 x i16> @llvm.riscv.vadd.mask.nxv32i16.i16.i32(<vscale x 32 x i16> [[ARG_1:%.*]], <vscale x 32 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 32 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
__rvv_uint16m8_t test_vadd_vx_u16m8_m_vl(__rvv_bool2_t arg_0, __rvv_uint16m8_t arg_1, __rvv_uint16m8_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.i32.i64(<vscale x 16 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.nxv16i32.i32.i32(<vscale x 16 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_uint32m8_t test_vadd_vx_u32m8_vl(__rvv_uint32m8_t arg_0, uint32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u32m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.i32.i64(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 16 x i32> @llvm.riscv.vadd.mask.nxv16i32.i32.i32(<vscale x 16 x i32> [[ARG_1:%.*]], <vscale x 16 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 16 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
__rvv_uint32m8_t test_vadd_vx_u32m8_m_vl(__rvv_bool4_t arg_0, __rvv_uint32m8_t arg_1, __rvv_uint32m8_t arg_2, uint32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u32m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.i64.i64(<vscale x 8 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.nxv8i64.i64.i32(<vscale x 8 x i64> [[ARG_0:%.*]], i64 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_uint64m8_t test_vadd_vx_u64m8_vl(__rvv_uint64m8_t arg_0, uint64_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u64m8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u64m8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.i64.i64(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u64m8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 8 x i64> @llvm.riscv.vadd.mask.nxv8i64.i64.i32(<vscale x 8 x i64> [[ARG_1:%.*]], <vscale x 8 x i64> [[ARG_2:%.*]], i64 [[ARG_3:%.*]], <vscale x 8 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
__rvv_uint64m8_t test_vadd_vx_u64m8_m_vl(__rvv_bool8_t arg_0, __rvv_uint64m8_t arg_1, __rvv_uint64m8_t arg_2, uint64_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u64m8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.i8.i64(<vscale x 4 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.nxv4i8.i8.i32(<vscale x 4 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_uint8mf2_t test_vadd_vx_u8mf2_vl(__rvv_uint8mf2_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.i8.i64(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 4 x i8> @llvm.riscv.vadd.mask.nxv4i8.i8.i32(<vscale x 4 x i8> [[ARG_1:%.*]], <vscale x 4 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 4 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
__rvv_uint8mf2_t test_vadd_vx_u8mf2_m_vl(__rvv_bool16_t arg_0, __rvv_uint8mf2_t arg_1, __rvv_uint8mf2_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.i16.i64(<vscale x 2 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.nxv2i16.i16.i32(<vscale x 2 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_uint16mf2_t test_vadd_vx_u16mf2_vl(__rvv_uint16mf2_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.i16.i64(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i16> @llvm.riscv.vadd.mask.nxv2i16.i16.i32(<vscale x 2 x i16> [[ARG_1:%.*]], <vscale x 2 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
__rvv_uint16mf2_t test_vadd_vx_u16mf2_m_vl(__rvv_bool32_t arg_0, __rvv_uint16mf2_t arg_1, __rvv_uint16mf2_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32mf2_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.i32.i64(<vscale x 1 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32mf2_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.nxv1i32.i32.i32(<vscale x 1 x i32> [[ARG_0:%.*]], i32 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_uint32mf2_t test_vadd_vx_u32mf2_vl(__rvv_uint32mf2_t arg_0, uint32_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u32mf2_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u32mf2_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.i32.i64(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u32mf2_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.i32.i32(<vscale x 1 x i32> [[ARG_1:%.*]], <vscale x 1 x i32> [[ARG_2:%.*]], i32 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
__rvv_uint32mf2_t test_vadd_vx_u32mf2_m_vl(__rvv_bool64_t arg_0, __rvv_uint32mf2_t arg_1, __rvv_uint32mf2_t arg_2, uint32_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u32mf2_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.i8.i64(<vscale x 2 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.nxv2i8.i8.i32(<vscale x 2 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_uint8mf4_t test_vadd_vx_u8mf4_vl(__rvv_uint8mf4_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.i8.i64(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 2 x i8> @llvm.riscv.vadd.mask.nxv2i8.i8.i32(<vscale x 2 x i8> [[ARG_1:%.*]], <vscale x 2 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 2 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
__rvv_uint8mf4_t test_vadd_vx_u8mf4_m_vl(__rvv_bool32_t arg_0, __rvv_uint8mf4_t arg_1, __rvv_uint8mf4_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16mf4_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.i16.i64(<vscale x 1 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16mf4_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.nxv1i16.i16.i32(<vscale x 1 x i16> [[ARG_0:%.*]], i16 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_uint16mf4_t test_vadd_vx_u16mf4_vl(__rvv_uint16mf4_t arg_0, uint16_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u16mf4_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u16mf4_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.i16.i64(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u16mf4_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i16> @llvm.riscv.vadd.mask.nxv1i16.i16.i32(<vscale x 1 x i16> [[ARG_1:%.*]], <vscale x 1 x i16> [[ARG_2:%.*]], i16 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
__rvv_uint16mf4_t test_vadd_vx_u16mf4_m_vl(__rvv_bool64_t arg_0, __rvv_uint16mf4_t arg_1, __rvv_uint16mf4_t arg_2, uint16_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u16mf4_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf8_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.i8.i64(<vscale x 1 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i64 [[ARG_2:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf8_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.nxv1i8.i8.i32(<vscale x 1 x i8> [[ARG_0:%.*]], i8 [[ARG_1:%.*]], i32 [[ARG_2:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_uint8mf8_t test_vadd_vx_u8mf8_vl(__rvv_uint8mf8_t arg_0, uint8_t arg_1, size_t arg_2)
{
    return __builtin_rvv_vadd_vx_u8mf8_vl(arg_0, arg_1, arg_2);
}

// CHECK-RV64-O2-LABEL: @test_vadd_vx_u8mf8_m_vl(
// CHECK-RV64-O2-NEXT:  entry:
// CHECK-RV64-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.i8.i64(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i64 [[ARG_4:%.*]])
// CHECK-RV64-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV32-O2-LABEL: @test_vadd_vx_u8mf8_m_vl(
// CHECK-RV32-O2-NEXT:  entry:
// CHECK-RV32-O2-NEXT:    [[TMP0:%.*]] = tail call <vscale x 1 x i8> @llvm.riscv.vadd.mask.nxv1i8.i8.i32(<vscale x 1 x i8> [[ARG_1:%.*]], <vscale x 1 x i8> [[ARG_2:%.*]], i8 [[ARG_3:%.*]], <vscale x 1 x i1> [[ARG_0:%.*]], i32 [[ARG_4:%.*]])
// CHECK-RV32-O2-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
__rvv_uint8mf8_t test_vadd_vx_u8mf8_m_vl(__rvv_bool64_t arg_0, __rvv_uint8mf8_t arg_1, __rvv_uint8mf8_t arg_2, uint8_t arg_3, size_t arg_4)
{
    return __builtin_rvv_vadd_vx_u8mf8_m_vl(arg_0, arg_1, arg_2, arg_3, arg_4);
}
