; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP32
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP64

define float @float_add(float %a, float %b) {
; MIPS32-LABEL: float_add:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    add.s $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = fadd float %a, %b
  ret float %add
}

define float @float_sub(float %a, float %b) {
; MIPS32-LABEL: float_sub:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sub.s $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %sub = fsub float %a, %b
  ret float %sub
}

define float @float_mul(float %a, float %b) {
; MIPS32-LABEL: float_mul:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    mul.s $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %mul = fmul float %a, %b
  ret float %mul
}

define float @float_div(float %a, float %b) {
; MIPS32-LABEL: float_div:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    div.s $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %div = fdiv float %a, %b
  ret float %div
}

define double @double_add(double %a, double %b) {
; MIPS32-LABEL: double_add:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    add.d $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %add = fadd double %a, %b
  ret double %add
}

define double @double_sub(double %a, double %b) {
; MIPS32-LABEL: double_sub:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sub.d $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %sub = fsub double %a, %b
  ret double %sub
}

define double @double_mul(double %a, double %b) {
; MIPS32-LABEL: double_mul:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    mul.d $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %mul = fmul double %a, %b
  ret double %mul
}

define double @double_div(double %a, double %b) {
; MIPS32-LABEL: double_div:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    div.d $f0, $f12, $f14
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %div = fdiv double %a, %b
  ret double %div
}
