#include "emu.h"
#include "cpu/m6809/m6809.h"

extern const char layout_pinball[];

class wpc_dcs_state : public driver_device
{
public:
	wpc_dcs_state(running_machine &machine, const driver_device_config_base &config)
		: driver_device(machine, config) { }
};


static ADDRESS_MAP_START( wpc_dcs_map, ADDRESS_SPACE_PROGRAM, 8 )
	ADDRESS_MAP_UNMAP_HIGH
ADDRESS_MAP_END

static INPUT_PORTS_START( wpc_dcs )
INPUT_PORTS_END

static MACHINE_RESET( wpc_dcs )
{
}

static DRIVER_INIT( wpc_dcs )
{
}

static MACHINE_CONFIG_START( wpc_dcs, wpc_dcs_state )
	/* basic machine hardware */
	MCFG_CPU_ADD("maincpu", M6809, 2000000)
	MCFG_CPU_PROGRAM_MAP(wpc_dcs_map)

	MCFG_MACHINE_RESET( wpc_dcs )

	/* video hardware */
	MCFG_DEFAULT_LAYOUT(layout_pinball)
MACHINE_CONFIG_END

/*-------------
/ Demolition Man
/--------------*/
ROM_START(dm_pa2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-pa2.rom", 0x00000, 0x80000, CRC(862be56a) SHA1(95e1f899963762cb1a9de4eb5d6d57183ed1da38))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dmsndp4.u2", 0x000000, 0x080000, CRC(8581116b) SHA1(ab24fa4aadf27761c9013adb84cfef9bfda27d44))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u3", 0x100000, 0x080000, CRC(fe79fc89) SHA1(4ef1ef0d66d43fa66af1ecb17c14141760859084))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u4", 0x200000, 0x080000, CRC(18407309) SHA1(499d62e4b434d48870fe532bb85106868df17c9b))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u5", 0x300000, 0x080000, CRC(f2006c93) SHA1(16656ae6ff18aad0965c5a14882138508925313a))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u6", 0x400000, 0x080000, CRC(bc17ba11) SHA1(a794599bc334762ddb79e1d0219ad20383139728))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u7", 0x500000, 0x080000, CRC(8760ed90) SHA1(cf8808f7cd347c47fa12e73a6bb5a54303fb7c49))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(dm_px5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_px5.rom", 0x00000, 0x80000, CRC(42673371) SHA1(77570902c1ca13956fa65214184bce79bcc67173))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dmsndp4.u2", 0x000000, 0x080000, CRC(8581116b) SHA1(ab24fa4aadf27761c9013adb84cfef9bfda27d44))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u3", 0x100000, 0x080000, CRC(fe79fc89) SHA1(4ef1ef0d66d43fa66af1ecb17c14141760859084))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u4", 0x200000, 0x080000, CRC(18407309) SHA1(499d62e4b434d48870fe532bb85106868df17c9b))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u5", 0x300000, 0x080000, CRC(f2006c93) SHA1(16656ae6ff18aad0965c5a14882138508925313a))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u6", 0x400000, 0x080000, CRC(bc17ba11) SHA1(a794599bc334762ddb79e1d0219ad20383139728))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dmsndp4.u7", 0x500000, 0x080000, CRC(8760ed90) SHA1(cf8808f7cd347c47fa12e73a6bb5a54303fb7c49))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(dm_la1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_la1.rom", 0x00000, 0x80000, CRC(be7c1965) SHA1(ed3b1016febc819b8c9f34953067bf0cdf3f33e6))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("dm_u2_s.l1", 0x000000, 0x080000, CRC(f72dc72e) SHA1(a1267c32f70b4bfe6058d7e28d82006541fe3d6c))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dm_u3_s.l2", 0x100000, 0x080000, CRC(2b65a66e) SHA1(7796082ecd7af29a240190aff654320375502a8b))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dm_u4_s.l2", 0x200000, 0x080000, CRC(9d6815fe) SHA1(fb4be63dee54a883884f1600565011cb9740a866))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dm_u5_s.l2", 0x300000, 0x080000, CRC(9f614c27) SHA1(f8f2f083b644517582a748bda0a3f69c14583f13))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dm_u6_s.l2", 0x400000, 0x080000, CRC(3efc2c0e) SHA1(bc4efdee44ff635771629a2bde79e230b7643f31))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dm_u7_s.l2", 0x500000, 0x080000, CRC(75066af1) SHA1(4d70bce8a96343afcf02c89240b11faf19e11f02))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(dm_lx3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_lx3.rom", 0x00000, 0x80000, CRC(5aa57674) SHA1(e02d91a705799866bd741b998d93413ec5bced25))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dm_u2_s.l2", 0x000000, 0x080000, CRC(85fb8bce) SHA1(f2e912113d08b230e32aeeb4143485f266574fa2))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dm_u3_s.l2", 0x100000, 0x080000, CRC(2b65a66e) SHA1(7796082ecd7af29a240190aff654320375502a8b))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dm_u4_s.l2", 0x200000, 0x080000, CRC(9d6815fe) SHA1(fb4be63dee54a883884f1600565011cb9740a866))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dm_u5_s.l2", 0x300000, 0x080000, CRC(9f614c27) SHA1(f8f2f083b644517582a748bda0a3f69c14583f13))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dm_u6_s.l2", 0x400000, 0x080000, CRC(3efc2c0e) SHA1(bc4efdee44ff635771629a2bde79e230b7643f31))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dm_u7_s.l2", 0x500000, 0x080000, CRC(75066af1) SHA1(4d70bce8a96343afcf02c89240b11faf19e11f02))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(dm_lx4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_lx4.rom", 0x00000, 0x80000, CRC(c2d0f493) SHA1(26ee970827dd96f3b3c56aa548cf7629ed6a16c1))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dm_u2_s.l2", 0x000000, 0x080000, CRC(85fb8bce) SHA1(f2e912113d08b230e32aeeb4143485f266574fa2))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dm_u3_s.l2", 0x100000, 0x080000, CRC(2b65a66e) SHA1(7796082ecd7af29a240190aff654320375502a8b))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dm_u4_s.l2", 0x200000, 0x080000, CRC(9d6815fe) SHA1(fb4be63dee54a883884f1600565011cb9740a866))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dm_u5_s.l2", 0x300000, 0x080000, CRC(9f614c27) SHA1(f8f2f083b644517582a748bda0a3f69c14583f13))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dm_u6_s.l2", 0x400000, 0x080000, CRC(3efc2c0e) SHA1(bc4efdee44ff635771629a2bde79e230b7643f31))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dm_u7_s.l2", 0x500000, 0x080000, CRC(75066af1) SHA1(4d70bce8a96343afcf02c89240b11faf19e11f02))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END
ROM_START(dm_h5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_h5.rom", 0x00000, 0x80000, CRC(bdcc62f7) SHA1(d6f3181970f3f71a876e9a2166156eb8fc405af0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dm.2", 0x000000, 0x080000, CRC(03dae358) SHA1(e6ab35a0c530eda90bd2d65af7bff82af08c39f3))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dm.3", 0x100000, 0x080000, CRC(3b924d3f) SHA1(5bd6126cc6a6c662de0bc311c047441bc29919b2))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dm.4", 0x200000, 0x080000, CRC(ff8985da) SHA1(b382c301744ce208f4710b3dd2342457d02f0ce9))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dm.5", 0x300000, 0x080000, CRC(76f09bd0) SHA1(1e4861ddc12069733f7e1d25192df97b0d9b09ee))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dm.6", 0x400000, 0x080000, CRC(2897aca8) SHA1(d910289e10422e22b4a3e1e296a4a167da1eaa5b))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dm.7", 0x500000, 0x080000, CRC(6b1b9137) SHA1(4064f4fc230ba17b68819ff889335d9b6d9bba3e))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("dm.8", 0x600000, 0x080000, CRC(5b333818) SHA1(007b8c117516b6023b376f95ff13831111f4dc20))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("dm.9", 0x700000, 0x080000, CRC(4c1a34e8) SHA1(3eacc3c63b2d9db57fc86447f1408635b987ef69))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(dm_h6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("dman_h6.rom", 0x00000, 0x80000, CRC(3a079b80) SHA1(94a7ee94819ec878ced5e07745bf52b6c65e06c9))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("dm.2", 0x000000, 0x080000, CRC(03dae358) SHA1(e6ab35a0c530eda90bd2d65af7bff82af08c39f3))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("dm.3", 0x100000, 0x080000, CRC(3b924d3f) SHA1(5bd6126cc6a6c662de0bc311c047441bc29919b2))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("dm.4", 0x200000, 0x080000, CRC(ff8985da) SHA1(b382c301744ce208f4710b3dd2342457d02f0ce9))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("dm.5", 0x300000, 0x080000, CRC(76f09bd0) SHA1(1e4861ddc12069733f7e1d25192df97b0d9b09ee))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("dm.6", 0x400000, 0x080000, CRC(2897aca8) SHA1(d910289e10422e22b4a3e1e296a4a167da1eaa5b))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("dm.7", 0x500000, 0x080000, CRC(6b1b9137) SHA1(4064f4fc230ba17b68819ff889335d9b6d9bba3e))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("dm.8", 0x600000, 0x080000, CRC(5b333818) SHA1(007b8c117516b6023b376f95ff13831111f4dc20))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("dm.9", 0x700000, 0x080000, CRC(4c1a34e8) SHA1(3eacc3c63b2d9db57fc86447f1408635b987ef69))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Indiana Jones
/------------------*/
ROM_START(ij_l7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ijone_l7.rom", 0x00000, 0x80000, CRC(4658c877) SHA1(b47ab064ff954bd182919f714ed8930cf0bed896))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l3.u2", 0x000000, 0x080000, CRC(fbd91a0d) SHA1(8d9a74f04f6088f18dfbb578893410abc21a0e42))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(ij_lg7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("u6-lg7.rom", 0x00000, 0x80000, CRC(c168a9f7) SHA1(732cc0863da06bce3d9793d57d67ba03c4c2f4d7))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l3.u2", 0x000000, 0x080000, CRC(fbd91a0d) SHA1(8d9a74f04f6088f18dfbb578893410abc21a0e42))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(ij_l6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ijone_l6.rom", 0x00000, 0x80000, CRC(8c44b880) SHA1(9bc2cd91ea4d98e6509d6c1e2e34622e83c5a4d7))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l3.u2", 0x000000, 0x080000, CRC(fbd91a0d) SHA1(8d9a74f04f6088f18dfbb578893410abc21a0e42))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(ij_l5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ijone_l5.rom", 0x00000, 0x80000, CRC(bf46ff92) SHA1(1afb1aadf115ae7d7f54bfea1fcca71a9de6ebb0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l2.u2", 0x000000, 0x080000, CRC(508d27c5) SHA1(da9787905c6f11d16e9a62047f15c5780017b551))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(ij_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ij_l4.u6", 0x00000, 0x80000, CRC(5f2c3130) SHA1(b748932a1c0ac622e00744314fafef857f59026d))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l2.u2", 0x000000, 0x080000, CRC(508d27c5) SHA1(da9787905c6f11d16e9a62047f15c5780017b551))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(ij_l3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ijone_l3.rom", 0x00000, 0x80000, CRC(0555c593) SHA1(1a73946fff9ae40e5499fcfa2d9f8330a25b8bae))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ijsnd_l1.u2", 0x000000, 0x080000, CRC(89061ade) SHA1(0bd5ec961c780c4d46296aee7f2cb63b72e990f5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u3", 0x100000, 0x080000, CRC(3f12a996) SHA1(5f5d2853e671d13fafdb2972f52a823e18f27643))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u4", 0x200000, 0x080000, CRC(05a92937) SHA1(e4e53e2899a7e7cbcd6ce7e3331bb8aa13321aa6))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u5", 0x300000, 0x080000, CRC(e6fe417c) SHA1(d990ed218fe296ad9a015d77519b8d954d252035))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u6", 0x400000, 0x080000, CRC(975f3e48) SHA1(16c56500b18e551bcd2e0c7e4c55ddab4791ac84))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u7", 0x500000, 0x080000, CRC(2d9cd098) SHA1(8d26c84cbd4ab2a5c9f4be3ea95a79fd125248e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ijsnd_l3.u8", 0x600000, 0x080000, CRC(45e35bd7) SHA1(782b406be341d55d22a96acb8c2459f3058940df))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END

/*-----------------
/  Judge Dredd
/------------------*/
ROM_START(jd_l7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jdrd_l7.rom", 0x00000, 0x80000, CRC(87b2a5c3) SHA1(e487e9ff78353ee96d5fb5f036b1a6cef586f5b4))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("jdsnd_u2.bin", 0x000000, 0x080000, CRC(d8f453c6) SHA1(5dd677fde46436dbf2d2e9058f06dd3048600234))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u3.bin", 0x100000, 0x080000, CRC(0a11f673) SHA1(ab556477a25e3493555b8a281ca86677caec8947))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u4.bin", 0x200000, 0x080000, CRC(93f6ebc1) SHA1(5cb306afa693e60887069745588dfd5b930c5951))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u5.bin", 0x300000, 0x080000, CRC(c9f28ba6) SHA1(8447372428e3b9fc86a98286c05f95a13abe26b0))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u6.bin", 0x400000, 0x080000, CRC(ef0bf094) SHA1(c0860cecd436d352fe2c2208533ff6dc71bfced1))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u7.bin", 0x500000, 0x080000, CRC(aebab88b) SHA1(d3f1be60a6840d9d085e22b43aafea1354771980))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u8.bin", 0x600000, 0x080000, CRC(77604893) SHA1(a9a4a66412096edd88ee7adfd960eef6f5d16476))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u9.bin", 0x700000, 0x080000, CRC(885b7c70) SHA1(be3bb42aeda3020a72c527f52c5330d0bafa9966))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(jd_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jd_l1.u6", 0x00000, 0x80000, CRC(09a4b1d8) SHA1(9f941bbeb6e58d918d374694c7ff2a67f1084cc0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("jdsnd_u2.bin", 0x000000, 0x080000, CRC(d8f453c6) SHA1(5dd677fde46436dbf2d2e9058f06dd3048600234))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u3.bin", 0x100000, 0x080000, CRC(0a11f673) SHA1(ab556477a25e3493555b8a281ca86677caec8947))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u4.bin", 0x200000, 0x080000, CRC(93f6ebc1) SHA1(5cb306afa693e60887069745588dfd5b930c5951))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u5.bin", 0x300000, 0x080000, CRC(c9f28ba6) SHA1(8447372428e3b9fc86a98286c05f95a13abe26b0))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u6.bin", 0x400000, 0x080000, CRC(ef0bf094) SHA1(c0860cecd436d352fe2c2208533ff6dc71bfced1))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u7.bin", 0x500000, 0x080000, CRC(aebab88b) SHA1(d3f1be60a6840d9d085e22b43aafea1354771980))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u8.bin", 0x600000, 0x080000, CRC(77604893) SHA1(a9a4a66412096edd88ee7adfd960eef6f5d16476))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u9.bin", 0x700000, 0x080000, CRC(885b7c70) SHA1(be3bb42aeda3020a72c527f52c5330d0bafa9966))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END
ROM_START(jd_l6)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jd_l6.u6", 0x00000, 0x80000, CRC(0a74cba4) SHA1(1872fd86bbfa772eac9cc2ef2634a90b72b3d5e2))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("jdsnd_u2.bin", 0x000000, 0x080000, CRC(d8f453c6) SHA1(5dd677fde46436dbf2d2e9058f06dd3048600234))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u3.bin", 0x100000, 0x080000, CRC(0a11f673) SHA1(ab556477a25e3493555b8a281ca86677caec8947))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u4.bin", 0x200000, 0x080000, CRC(93f6ebc1) SHA1(5cb306afa693e60887069745588dfd5b930c5951))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u5.bin", 0x300000, 0x080000, CRC(c9f28ba6) SHA1(8447372428e3b9fc86a98286c05f95a13abe26b0))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u6.bin", 0x400000, 0x080000, CRC(ef0bf094) SHA1(c0860cecd436d352fe2c2208533ff6dc71bfced1))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u7.bin", 0x500000, 0x080000, CRC(aebab88b) SHA1(d3f1be60a6840d9d085e22b43aafea1354771980))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u8.bin", 0x600000, 0x080000, CRC(77604893) SHA1(a9a4a66412096edd88ee7adfd960eef6f5d16476))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
	ROM_LOAD("jdsnd_u9.bin", 0x700000, 0x080000, CRC(885b7c70) SHA1(be3bb42aeda3020a72c527f52c5330d0bafa9966))
	ROM_RELOAD(0x700000+0x080000, 0x080000)
ROM_END

/*-----------------
/ Popeye Saves The Earth
/------------------*/
ROM_START(pop_lx5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("peye_lx5.rom", 0x00000, 0x80000, CRC(ee1f7a67) SHA1(f02518546de93256b00bc1f5b92452a10f9e56dd))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("popsndl2.u2", 0x000000, 0x080000, CRC(00590f2d) SHA1(540ad9825dbaace55bf36a6cee98bef06f240e15))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("popsndl2.u3", 0x100000, 0x080000, CRC(87032b27) SHA1(9488d177418b53ceb37686cf6f4f58800b306d85))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("popsndl2.u4", 0x200000, 0x080000, CRC(b0808aa8) SHA1(bebe6ec3c3e675e096084b6ed61065ad48dc5c3f))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("popsndl2.u5", 0x300000, 0x080000, CRC(3662206b) SHA1(c2714665db18e9ae540a8f922d7ebb3058638563))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("popsndl2.u6", 0x400000, 0x080000, CRC(84a5f317) SHA1(f1b9710d109e28fe3255e36dafa2be23656d0445))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("popsndl2.u7", 0x500000, 0x080000, CRC(b8fde2c7) SHA1(ee82a7b1ad32e1231356ce42c4ad3109150a9992))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
ROM_END

ROM_START(pop_pa3)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("peye_pa3.rom", 0x00000, 0x80000, CRC(1cee3ae7) SHA1(e5b05fcf8aac98993940a2cda2552ff93ee3a518))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("popsndp0.u2", 0x000000, 0x080000, CRC(1e3a98a4) SHA1(2f871f354df7684d0b4aa31e2d2bb4035072bb4a))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("popsndl2.u3", 0x100000, 0x080000, CRC(87032b27) SHA1(9488d177418b53ceb37686cf6f4f58800b306d85))
	ROM_RELOAD(0x100000 +0x080000, 0x080000)
	ROM_LOAD("popsndl2.u4", 0x200000, 0x080000, CRC(b0808aa8) SHA1(bebe6ec3c3e675e096084b6ed61065ad48dc5c3f))
	ROM_RELOAD(0x200000 +0x080000, 0x080000)
	ROM_LOAD("popsndl2.u5", 0x300000, 0x080000, CRC(3662206b) SHA1(c2714665db18e9ae540a8f922d7ebb3058638563))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
	ROM_LOAD("popsndl2.u6", 0x400000, 0x080000, CRC(84a5f317) SHA1(f1b9710d109e28fe3255e36dafa2be23656d0445))
	ROM_RELOAD(0x400000 +0x080000, 0x080000)
	ROM_LOAD("popsndl2.u7", 0x500000, 0x080000, CRC(b8fde2c7) SHA1(ee82a7b1ad32e1231356ce42c4ad3109150a9992))
	ROM_RELOAD(0x500000 +0x080000, 0x080000)
ROM_END
/*-----------------
/ Star Trek: The Next Generation
/------------------*/
ROM_START(sttng_l7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_lx7.rom", 0x00000, 0x80000, CRC(d439fdbb) SHA1(12d1c72cd6cc18db53e51ebb4c1e55ca9bcf9908))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ng_u2_s.l1", 0x000000, 0x080000, CRC(c3bd7bf5) SHA1(2476ff90232a52d667a407fac81ee4db028b94e5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_x7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_x7.rom", 0x00000, 0x80000, CRC(4e71c9c7) SHA1(8a7ec42dfb4a6902ba745548b40e84de5305c295))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ngs_u2.rom", 0x000000, 0x080000, CRC(e9fe68fe) SHA1(3d7631aa5ddd52f7c3c00cd091e212430faea249))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ngs_u3.rom", 0x100000, 0x080000, CRC(368cfd89) SHA1(40ddc12b2cabbcf73ababf753f3a2fd4bcc10737))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ngs_u4.rom", 0x200000, 0x080000, CRC(8e79a513) SHA1(4b763d7445acd921a0a6d64d18b5df8ff9e3257e))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ngs_u5.rom", 0x300000, 0x080000, CRC(46049eb0) SHA1(02991bf1d33ac1df91f459b2d37cf7e07e347b04))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ngs_u6.rom", 0x400000, 0x080000, CRC(e0124da0) SHA1(bfdba059d084c93122ad291aa8def61f43c26d47))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ngs_u7.rom", 0x500000, 0x080000, CRC(dc1c74d0) SHA1(21b6b4d2cdd5086bcbbc7ee7a2abdc550a45d2e3))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_s7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_lx7.rom", 0x00000, 0x80000, CRC(d439fdbb) SHA1(12d1c72cd6cc18db53e51ebb4c1e55ca9bcf9908))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2-sp1.rom", 0x000000, 0x080000, CRC(bdef8b2c) SHA1(188d8d2a652844e9885bd9e9ad4143927ddc6fee))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_p5)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("sttng_p5.u6", 0x00000, 0x80000, CRC(c1b80a8e) SHA1(90dd99efd41ec5405c631ad374a369f9fcb7217e))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ng_u2_s.l1", 0x000000, 0x080000, CRC(c3bd7bf5) SHA1(2476ff90232a52d667a407fac81ee4db028b94e5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_g7)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_lg7.rom", 0x00000, 0x80000, CRC(e723b8a1) SHA1(77c3f8ea378772ce45bb8de818069fc08cbc4574))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ng_u2_s.l1", 0x000000, 0x080000, CRC(c3bd7bf5) SHA1(2476ff90232a52d667a407fac81ee4db028b94e5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_l1)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_lx1.rom", 0x00000, 0x80000, CRC(390befc0) SHA1(2059891e3fc3034d600274c3915371123c964d28))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ng_u2_s.l1", 0x000000, 0x080000, CRC(c3bd7bf5) SHA1(2476ff90232a52d667a407fac81ee4db028b94e5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END
ROM_START(sttng_l2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("trek_lx2.rom", 0x00000, 0x80000, CRC(e2557554) SHA1(7d8502ab9df340d60fd72e6964740bc7a2da2065))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("ng_u2_s.l1", 0x000000, 0x080000, CRC(c3bd7bf5) SHA1(2476ff90232a52d667a407fac81ee4db028b94e5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("ng_u3_s.l1", 0x100000, 0x080000, CRC(9456cac7) SHA1(83e415e0f21bb5418f3677dbc13433e056c523ab))
	ROM_RELOAD(0x100000+0x080000, 0x080000)
	ROM_LOAD("ng_u4_s.l1", 0x200000, 0x080000, CRC(179d22a4) SHA1(456b7189e23d4e2bd7e2a6249fa2a73bf0e12194))
	ROM_RELOAD(0x200000+0x080000, 0x080000)
	ROM_LOAD("ng_u5_s.l1", 0x300000, 0x080000, CRC(231a3e72) SHA1(081b1a042e62ccb723788059d6c1e00b9b32c778))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
	ROM_LOAD("ng_u6_s.l1", 0x400000, 0x080000, CRC(bb21377d) SHA1(229fb42a1f8b22727a809e5d63f26f045a2adda5))
	ROM_RELOAD(0x400000+0x080000, 0x080000)
	ROM_LOAD("ng_u7_s.l1", 0x500000, 0x080000, CRC(d81b39f0) SHA1(3443e7327c755b85a5b390f7fcd0e9923890425a))
	ROM_RELOAD(0x500000+0x080000, 0x080000)
	ROM_LOAD("ng_u8_s.l1", 0x600000, 0x080000, CRC(c9fb065e) SHA1(c148178ee0ea787acc88078db01d17073e75fdc7))
	ROM_RELOAD(0x600000+0x080000, 0x080000)
ROM_END

/*-------------
/ Addams Family Values (Coin Dropper)
/--------------*/
ROM_START(afv_l4)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1", ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("afv_u6.l4", 0x00000, 0x80000, CRC(37369339) SHA1(e44a91faca80ffa00d6db78e2df7aa9bf14e957c))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afv_su2.l1", 0x000000, 0x080000, CRC(1aa878fc) SHA1(59a89071001b5da6ab56d691721a015773f5f0b5))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
ROM_END

GAME(1994,	dm_lx4,		0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (LX-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	dm_pa2,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (PA-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	dm_px5,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (PX-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	dm_la1,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (LA-1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	dm_lx3,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (LX-3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	dm_h5,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (H-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1995,	dm_h6,		dm_lx4,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Demolition Man (H-6)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_l7,		0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (L-7)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_lg7,		ij_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (LG-7)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_l6,		ij_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (L-6)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_l5,		ij_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (L-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_l4,		ij_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (L-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	ij_l3,		ij_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Indiana Jones (L-3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	jd_l7,		0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Bally",				"Judge Dredd (L-7)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	jd_l1,		jd_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Bally",				"Judge Dredd (L-1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	jd_l6,		jd_l7,		wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Bally",				"Judge Dredd (L-6)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	pop_lx5,	0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Bally",				"Popeye Saves The Earth (LX-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	pop_pa3,	pop_lx5,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Bally",				"Popeye Saves The Earth (PA-3)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	sttng_l7,	0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LX-7)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	sttng_x7,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LX-7 Special)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	sttng_p5,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (P-5)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	sttng_s7,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LX-7) SP1",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1994,	sttng_g7,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LG-7)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	sttng_l1,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LX-1)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	sttng_l2,	sttng_l7,	wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Star Trek: The Next Generation (LX-2)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)
GAME(1993,	afv_l4,		0,			wpc_dcs,	wpc_dcs,	wpc_dcs,	ROT0,	"Williams",				"Addams Family Values (Coin Dropper L-4)",				GAME_NOT_WORKING | GAME_NO_SOUND | GAME_MECHANICAL)

