#! /usr/bin/env python
#------------------------------------------------------------------------
# This is a sample script showing how to use the interface
#------------------------------------------------------------------------
import os
import sys

print os.environ['PYTHONPATH']

import LDASframe
import frameCPP
import numpy as np

#------------------------------------------------------------------------
# Local Variables
#------------------------------------------------------------------------

TMP_DIR = os.environ['HOME'] + "/tmp"

frame_files = TMP_DIR + "/H-SIDv1_H1H2_250mHz-821935753-26.gwf"

start = 821935753
end = start + 16
channels = [ "H1:AdjacentPSD" ]

#------------------------------------------------------------------------
# 
#------------------------------------------------------------------------
def TestOpenData( ):
    try:
        libGWF = LDASframe
        #----------------------------------------------------------------
        # Open, scan the TOC, and close a set of files.
        # This gets the meta data located in the TOC and makes it
        # available to the caller via the catalog interface
        #------------------------------------------------------------------
        try:
            catalog = libGWF.Catalog( frame_files )
        except Exception, e:
            print "cannot open files", e
        #----------------------------------------------------------------
        # Display the data range
    	#----------------------------------------------------------------
        print 'start time: {0}.{1:09}'\
              .format( catalog.GpsStartTime.seconds,
                       catalog.GpsStartTime.nanoseconds )
        print 'end time: {0}.{1:09}'\
              .format( catalog.GpsEndTime.seconds,
                       catalog.GpsEndTime.nanoseconds )
    	#----------------------------------------------------------------
        # Obtain the catalog of channels
    	#----------------------------------------------------------------
        # channelDict = catalog.Channels( )
    	#----------------------------------------------------------------
        # Read a collection of channels
    	#----------------------------------------------------------------
        dataDict = catalog.Fetch( start, end, channels[ 0 ] )
        #----------------------------------------------------------------
        # Display some meta data about the channels
        #----------------------------------------------------------------
        as_q = dataDict[ channels[ 0 ] ]
        print "Channel: as_q.name: ", as_q.name
        print "Channel: as_q.unitY: ", as_q.unitY
        for v in as_q.data:
            dim = v.GetDim( 0 )
            dx = dim.dx
            print "dx: ", dx
    except Exception, e:
        print "FAILED: ", e
    return

#------------------------------------------------------------------------
# 
#------------------------------------------------------------------------
def TestCreateRDS( ):
    try:
        print "frame_files is of type: ", type(frame_files)
        print "start is of type: ", type(start)
        print "end is of type: ", type(end)
        print "channels is of type: ", type(channels)
        frame = LDASframe.createRDSFrame( frame_files, start, end, channels )
        as_q = frame.GetChannel( channels[ 0 ] )
        print "Channel Type: ", type(as_q)
        print "Channel: as_q.name: ", as_q.name
        print "Channel: as_q.unitY: ", as_q.unitY
        print "Channel.data[0] (type): ", type(as_q.data[0])
        print "Channel.data[0].name: ", as_q.data[0].name
        # print "fr_chan: name: ", fr_chan[0].name
        #----------------------------------------------------------------
        # Create an output stream and write the frame to that stream
        #----------------------------------------------------------------
        filename = 'python_createRDS_out.gwf'
        framestream = frameCPP.OFrameFStream( filename )
        framestream.WriteFrame( frame.AsFrameH( ), frameCPP.FrVect.RAW, 0 )
    except Exception, e:
        print "FAILED: ", e
    return

#------------------------------------------------------------------------
#------------------------------------------------------------------------

if os.path.exists( frame_files ):
    TestCreateRDS( )
    TestOpenData( )

sys.exit( 0 )
