/* -*- mode: c++; c-basic-offset: 3 -*- */
#ifndef RDS_REDUCE_FRAME_HH
#define RDS_REDUCE_FRAME_HH

#include "frameAPI/rdsframe.hh"   

//-----------------------------------------------------------------------------
//   
//: Functional to create RDS frames.
//   
class ReduceRawFrame
   : private RDSFrame
{
public:
   //---------------------------------------------------------------------------
   /// \brief Constructor.
   ///
   /// \param[in] frame_files
   ///     A list of frame file names.
   /// \param[in] channels
   ///     A list of channels to extract from  original frames
   ///     (only channel names are allowed).
   /// \param[in] UserOptions
   ///     User specified options.
   ///
   /// \return
   ///     New instance of this object.
   //---------------------------------------------------------------------------
   ReduceRawFrame( const char* frame_files, 
                   const char* channels,
		   const RDSFrame::Options& UserOptions );

   //---------------------------------------------------------------------------
   /// \brief Constructor.
   ///
   /// \param[in] frame_files
   ///     A list of frame file names.
   /// \param[in] channels
   ///     A list of channels to extract from  original frames
   ///     (only channel names are allowed).
   /// \param[in] UserOptions
   ///     User specified options.
   ///
   /// \return
   ///     New instance of this object.
   //---------------------------------------------------------------------------
   ReduceRawFrame( const frame_file_container_type& frame_files, 
                   const channel_container_type& channels,
		   const RDSFrame::Options& UserOptions );

   //---------------------------------------------------------------------------
   /// \brief Destructor
   //---------------------------------------------------------------------------
   virtual ~ReduceRawFrame();
   
   virtual void writeFrameToStream( );

   // Expose the main hook for processing information
   using RDSFrame::ProcessRequest;

protected:
   virtual void processChannel( fr_adc_data_type Adc );

   virtual void processChannel( fr_proc_data_type Proc );

   virtual void rangeOptimizer( const time_type& UserStart,
				const time_type& UserStop,
				time_type& DataStart,
				time_type& DataStop ) const;
			
   virtual stop_request_type stopRequest( ) const;

};

#endif   
