#include <sstream>

#include "framecpp/FrRawData.hh"

#include "Channel.hh"
#include "Frame.hh"

namespace
{
  class AdcChannel
    : public ::FrameAPI::Channel
  {
  public:
    typedef ::FrameCPP::FrRawData::firstAdc_type::value_type	channel_type;

    AdcChannel( channel_type Channel );

    virtual data_type& RefData( ) const;
#if 0
  protected:
    virtual const frvect_type& getDataVector( ) const;
#endif /* 0 */

  private:
    channel_type	m_channel;
  };

  class ProcChannel
    : public ::FrameAPI::Channel
  {
  public:
    typedef ::FrameCPP::FrameH::procData_type::value_type	channel_type;

    ProcChannel( channel_type Channel );

    virtual data_type& RefData( ) const;
#if 0
  protected:
    virtual const frvect_type& getDataVector( ) const;
#endif /* 0 */

  private:
    channel_type	m_channel;
  };
}

namespace FrameAPI
{

  //=====================================================================

  Frame::NoChannelFound::
  NoChannelFound( const std::string& ChannelName )
    : std::runtime_error( message( ChannelName ) )
  {
  }

  std::string Frame::NoChannelFound::
  message( const std::string& ChannelName )
  {
    std::ostringstream	msg;

    msg << "Unable to find channel: " << ChannelName
      ;
    return msg.str( );
  }

  //=====================================================================

  Frame::frameh_type Frame::
  operator=( frameh_type RHS )
  {
    return frameh_type::operator=( RHS );
  }

  Frame::channel_type Frame::
  GetChannel( const std::string& ChannelName ) const
  {
    channel_type	retval;
    //-------------------------------------------------------------------
    // First check if the channel has already been "cached"
    //-------------------------------------------------------------------
    {
      channel_container_type::const_iterator
	cur = m_channels.find( ChannelName );
      if ( cur != m_channels.end( ) )
      {
	retval = cur->second;
      }
    }
    if ( ( ! retval )
	 && ( *this ) )
    {
      //-----------------------------------------------------------------
      // Look in the Adc list
      //-----------------------------------------------------------------
      FrameCPP::FrameH::rawData_type	rd( (*this)->GetRawData( ) );
      if ( rd )
      {
	FrameCPP::FrRawData::firstAdc_type&
	  adc( rd->RefFirstAdc( ) );
	FrameCPP::FrRawData::firstAdc_type::const_iterator
	  cur( adc.find( ChannelName ) );

	if ( cur != adc.end( ) )
	{
	  retval.reset( new AdcChannel( *cur ) );
	}
      }
      if ( ! retval )
      {
	//---------------------------------------------------------------
	// Look in the Proc list
	//---------------------------------------------------------------
	FrameCPP::FrameH::procData_type::const_iterator
	  cur( (*this)->RefProcData( ).find( ChannelName ) );

	if ( cur != (*this)->RefProcData( ).end( ) )
	{
	  retval.reset( new ProcChannel( *cur ) );
	}
      }
      if ( ! retval )
      {
	//---------------------------------------------------------------
	// Look in the SimData list
	//---------------------------------------------------------------
      }
      if ( retval )
      {
	//---------------------------------------------------------------
	// Cache the found channel
	//---------------------------------------------------------------
	m_channels[ ChannelName ] = retval;
      }
      else
      {
	throw NoChannelFound( ChannelName );
      }
    }
    return retval;
  }
}

namespace
{

  //=====================================================================
  AdcChannel::
  AdcChannel( channel_type Channel )
    : m_channel( Channel )
  {
  }

#if 0
  const AdcChannel::frvect_type& AdcChannel::
  getDataVector( ) const
  {
    return m_channel->RefData( );
  }
#else
  AdcChannel::data_type& AdcChannel::
  RefData( ) const
  {
    return m_channel->RefData( );
  }
#endif /* 0 */

  //=====================================================================
  ProcChannel::
  ProcChannel( channel_type Channel )
    : m_channel( Channel )
  {
  }

#if 0
  const ProcChannel::frvect_type& ProcChannel::
  getDataVector( ) const
  {
    return m_channel->RefData( );
  }
#else
  ProcChannel::data_type& ProcChannel::
  RefData( ) const
  {
    return m_channel->RefData( );
  }
#endif /* 0 */

}
