/* -*- mode: c++ -*- */

#ifndef diskCachePythonI
#define diskCachePythonI

#if defined(SWIGPYTHON)

%exception
{
  //---------------------------------------------------------------------
  // Ensure that no exceptions leave the C++ layer
  //---------------------------------------------------------------------
  try
  {
    $action;
  }
  catch( const std::exception& Exception )
  {
    //-------------------------------------------------------------------
    // Handle exceptions derived from std::exception
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( Exception.what( ) ) );
    goto fail;
  }
  catch( ... )
  {
    //-------------------------------------------------------------------
    // Catch everything else to make sure they do not leak outside
    //-------------------------------------------------------------------
    PyErr_SetString( PyExc_IndexError,
		     const_cast<char*>( "unknown error" ) );
    goto fail;
  }
}


%include "ServerInterface_typemaps_python.i"
%include "diskscan_python.i"

%import diskcacheAPI/diskCache.i

#endif /* defined(SWIGPYTHON) */

#endif /* diskCachePythonI */
