// -*- mode: c++; c-basic-offset: 4; indent-tabs-mode: nil; -*-

#ifndef DISKCACHE_API__CACHE__QUERY_PARAMS_HH
#define DISKCACHE_API__CACHE__QUERY_PARAMS_HH

#include <map>
#include <stdexcept>
#include <string>

namespace diskCache
{
  namespace Cache
  {
    class Registry;
    class QueryAnswer;

    class QueryParams
    {
    public:
      class MissingVariableError
	: std::runtime_error
      {
      public:
	MissingVariableError( const std::string& Variable );

      private:
	static std::string format( const std::string& Variable );
      };

      typedef std::map< std::string, std::string > container_type;

      void AddParam( const std::string& Variable,
		     const std::string& Value );

      const container_type& Params( ) const;

      const std::string& Value( const std::string& Variable ) const;

      //-----------------------------------------------------------------
      /// \brief Optimize the query.
      //-----------------------------------------------------------------
      void Translate( QueryAnswer& Answer,
		      const Registry& Indexes ) const;

    private:
      container_type	m_symbol_table;
    }; // class - QueryParams

    inline void QueryParams::
    AddParam( const std::string& Variable,
	      const std::string& Value )
    {
      m_symbol_table[ Variable ] = Value;
    } // method - QueryParams::AddParam

    inline const QueryParams::container_type& QueryParams::
    Params( ) const
    {
      return m_symbol_table;
    } // method - QueryParams::Params

    inline const std::string& QueryParams::
    Value( const std::string& Variable ) const
    {
      container_type::const_iterator
	index_name_pos( m_symbol_table.find( Variable ) );

      if ( index_name_pos == m_symbol_table.end( ) )
      {
	throw MissingVariableError( Variable );
      }
      return index_name_pos->second;
    }

  } // namespace - Cache
} // namespace - diskCache

#endif /* DISKCACHE_API__CACHE__QUERY_PARAMS_HH */
