// -*- Mode: C++; c-basic-offset: 2; -*-
#if defined(SWIGPYTHON)

%include "ldas_python.i"
%include "dc_python.swig"

//=======================================================================
// Typemap - Python
//=======================================================================

%typemap(out) string, std::string
{
  $result = PyString_FromString(const_cast< char* >( $1.c_str( ) ) );
}
//-----------------------------------------------------------------------
// Exception handling - Python
//-----------------------------------------------------------------------
%exception
{
    try
    {
        $action;
    }
    catch( const LdasException& e )
    {
      std::string	error;

      for ( size_t x = 0,
	      end = e.getSize( );
	    x != end;
	    ++x )
      {
	if ( x )
	{
	  error += "\n";
	}
	error += e.getError( x ).getMessage( );
      }
      PyErr_SetString( PyExc_Exception,
		       const_cast< char* >( error.c_str( ) ) );
      return NULL;
    }      
    catch ( SwigException& e )
    {
      PyErr_SetString( PyExc_Exception,
		       const_cast< char* >( e.getResult( ).c_str( ) ) );
      return NULL;
    }
    catch ( std::runtime_error& e )
    {
      PyErr_SetString( PyExc_Exception,
		       const_cast< char* >( e.what( ) ) );
      return NULL;
    }
    catch ( std::exception& e )
    {
      PyErr_SetString( PyExc_Exception,
		       const_cast< char* >( e.what( ) ) );
      return NULL;
    }
    catch( ... )
    {
      std::string	error("Unknown exception caught: ");
      std::string	info("Unable to retrieve more information about this exception");

      error += info;
      PyErr_SetString(PyExc_Exception,
		      const_cast< char* >( error.c_str( ) ) );
      return NULL;
    }
}
#endif // defined(SWIGPYTHON)
