/* -*- mode: c++; c-basic-offset: 3; indent-tabs-mode: nil; -*- */
#include "ldastoolsal/AtExit.hh"

#include "counter.hh"
   
using LDASTools::AL::ReadWriteLock;

using namespace diskCache;
   
   
//------------------------------------------------------------------------------
///      
/// \brief Constructor
///
/// \param[in,out] counter
///     Variable holding initial value for the thread count.
///
/// \param[in] lock
///     Thread syncronization.
///
/// Increments counter by 1.
///
diskCache::ThreadCounter::
ThreadCounter( INT_2S& counter,
               LDASTools::AL::ReadWriteLock::baton_type lock )
   : mCounter( counter ), mCounterLock( lock )
{
   ReadWriteLock counter_lock( mCounterLock, ReadWriteLock::WRITE,
			      __FILE__, __LINE__ );
   ++mCounter;
}   
   

//------------------------------------------------------------------------------
///
/// \brief Destructor
///
/// Decrements counter by 1.
///
diskCache::ThreadCounter::
~ThreadCounter()
{
   ReadWriteLock counter_lock( mCounterLock, ReadWriteLock::WRITE,
                               __FILE__, __LINE__ );
      
   --mCounter;
}   
      
