#ifndef DISKCACHE_API__VARIABLES_HH
#define DISKCACHE_API__VARIABLES_HH

#include <sstream>

#include "ldastoolsal/Memory.hh"

#include "ldastoolsal/Singleton.hh"

namespace diskCache
{
  namespace Common
  {
    class Variables
      : public LDASTools::AL::Singleton< Variables >
    {
    public:
      typedef void (*reader_ss)( std::ostringstream& Value );
      typedef void (*writer_str)( const std::string& Value );

      Variables( );
      ~Variables( );

      static void Init( const std::string& Var, reader_ss RFunc, writer_str WFunc, const std::string& Default );

      static void Cache( const std::string& Var, const std::string& Value );

      static void Get( const std::string& Var, std::ostringstream& Value );

      static void Set( const std::string& Var );

      static void Set( const std::string& Var, const std::string& Value );

      static void SetReader( const std::string& Var, reader_ss Func );

      static void SetWriter( const std::string& Var, writer_str Func );

    private:
      class pdata_storage_type;
      typedef std::unique_ptr< pdata_storage_type > pdata_type;
      
      pdata_type	pdata;
    };
  }
}

#endif /* DISKCACHE_API__VARIABLES_HH */

