#include <diskcache_config.h>

#include "diskcacheAPI/Streams/Binary.hh"

#include "diskcacheAPI/Cache/DirectoryManager.hh"

namespace diskCache
{
  namespace Cache
  {
    using Streams::IBinary;
    using Streams::OBinary;

    template<>
    IBinary& DirectoryManager::
    Read( IBinary& Stream )
    {

      {
	//---------------------------------------------------------------
	// Read the list of directories to exclude
	//---------------------------------------------------------------
	Directory::excluded_directories_type	xdirs;

	Stream >> xdirs
	  ;
	Directory::ExcludedDirectories( xdirs );
      }
      try
      {
	//-------------------------------------------------------------
	// For the sake of speed, lock once
	//-------------------------------------------------------------
	directory_container_rw_type
	  container( directory_container_rw( ) );

	container.Var( ).clear( );
	while( Stream.Readable( ) )
	{
	  LDASTools::AL::SharedPtr< Directory >
	    dir( new Directory );

#if DEBUG_MOUNT_POINT_MANAGER
	  std::cerr << "DEBUG: about to read directory"
		    << std::endl
	    ;
#endif /* DEBUG_MOUNT_POINT_MANAGER */
	  dir->Read( Stream );
	  //-------------------------------------------------------------
	  // Record the directory
	  //-------------------------------------------------------------
	  if ( dir )
	  {
#if DEBUG_MOUNT_POINT_MANAGER
	    std::cerr << "DEBUG: managing directory: " << dir->Fullname( )
		      << std::endl
	      ;
#endif /* DEBUG_MOUNT_POINT_MANAGER */
	    container.Var( )[ dir->Fullname( ) ] = dir;
	    
	  }
	}
      }
      catch( const std::istream::failure& Exception )
      {
	if ( ! Stream.eof( ) )
	{
	  //-------------------------------------------------------------
	  // Rethrow the exception since it is unexpected
	  //-------------------------------------------------------------
	  throw;
	}
	//---------------------------------------------------------------
	// Came to the end of the file. Nothing to concearn ourselves
	//   about.
	//---------------------------------------------------------------
      }
      return Stream;
    }

    template<>
    OBinary& DirectoryManager::
    Write( OBinary& Stream )
    {
      {
	//---------------------------------------------------------------
	// Write the list of directories to exclude
	//---------------------------------------------------------------
	Stream << Directory::ExcludedDirectories( ).Var( )
	  ;
      }
      const directory_container_ro_type
	container( directory_container_ro( ) );

      for ( directory_container_type::const_iterator
	      cur = container.Var( ).begin( ),
	      last = container.Var( ).end( );
	    cur != last;
	    ++cur )
      {
	cur->second->Write( Stream );
      }
      return Stream;
    }

  } // namespace - diskCache::Cache
} // namespace - diskCache
