dnl======================================================================
dnl AX_LDAS_PROG_LIBTOOL
dnl   Check on how to setup libtool
dnl Depends:
dnl======================================================================

AC_DEFUN([AX_LDAS_PROG_LIBTOOL],
[
  dnl -------------------------------------------------------------------
  dnl Need to ensure the correct usage of the C compiler
  dnl -------------------------------------------------------------------
  AC_REQUIRE([AX_LDAS_PROG_CC])
  AC_REQUIRE([AX_LDAS_PROG_CXX])
  dnl -------------------------------------------------------------------
  dnl This hack is needed until libtool 1.5.22 is out. It will properly
  dnl    configure for 64bit Solaris.
  dnl -------------------------------------------------------------------
  ac_save_CC=$CC
  ac_save_CXX=$CXX
  CC="$CC $CFLAGS"
  CXX="$CXX $CXXFLAGS"
  AC_LANG_PUSH([C])
  AC_PROG_LIBTOOL
  AM_PROG_LIBTOOL
  AC_LANG_POP([C])
  case "$LDAS_CXX_FLAVOR" in
  SunPRO)
	if echo $CXXFLAGS | grep -e -library=stlport4 > /dev/null 2>&1
	then
		dnl -----------------------------------------------------
		dnl libtool currently assumes the default std C++ library.
		dnl   LDAS requires the stlport4 library instead.
		dnl -----------------------------------------------------
		mv libtool libtool.orig
		sed -e 's/-lCstd -lCrun/-library=stlport4/g' libtool.orig > libtool
		chmod +x libtool
	fi
	;;
  esac
  CC=$ac_save_CC
  CXX=$ac_save_CXX
])
