#include <ldastoolsal_config.h>

#include "streamexception.hh"

//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// \param in Input Stream
/// \param library Name of library or api
/// \param info Additional information about th exception
/// \param file Name of file where exception was thrown
/// \param line Line of file where exception was thrown
///
StreamException::StreamException(
    std::istream& in, int library, const std::string& info,
    const char* file, size_t line )
        : LdasException()
{
    if ( in.eof() )
    {
        addError( library, END_OF_FILE, "end_of_file", info, file, line );
    }
    else if ( in.bad() )
    {
        addError( library, BAD_STREAM, "bad_stream", info, file, line );
    }
    else if ( in.fail() )
    {
        addError( library, FAIL_STREAM, "fail_stream", info, file, line );
    }
    else
    {
        addError( library, UNKNOWN_ERROR, "unknown_error", info, file, line );
    }
}


//-----------------------------------------------------------------------------
/// \brief  Constructor.
///
/// \param out Output stream
/// \param library Name of library or api
/// \param info Additional information about the exception
/// \param file Name of file where exception was thrown
/// \param line Line of file where exception was thrown
///
StreamException::StreamException(
    std::ostream& out, int library, const std::string& info, const char* file,
    size_t line )
        : LdasException()
{
    if ( out.eof() )
    {
        addError( library, END_OF_FILE, "end_of_file", info, file, line );
    }
    else if ( out.bad() )
    {
        addError( library, BAD_STREAM, "bad_stream", info, file, line );
    }
    else if ( out.fail() )
    {
        addError( library, FAIL_STREAM, "fail_stream", info, file, line );
    }
    else
    {
        addError( library, UNKNOWN_ERROR, "unknown_error", info, file, line );
    }
}


