#ifndef _LALSIM_IMR_PHENOMX_QNM_H
#define _LALSIM_IMR_PHENOMX_QNM_H

/*
 * Copyright (C) 2018 Sascha Husa, Geraint Pratten
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with with program; see the file COPYING. If not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA  02110-1301  USA
 */


/*
 * \author Sascha Husa
 * \author Geraint Pratten
 *
 */


#ifdef __cplusplus
extern "C" {
#endif

#include <lal/LALDatatypes.h>
#include <lal/LALConstants.h>
#include <lal/LALStdlib.h>

#define QNMfits 1

#if QNMfits == 1
 static double evaluate_QNMfit_fring22(double finalDimlessSpin);
 static double evaluate_QNMfit_fdamp22(double finalDimlessSpin);

#else
 static double interpolateQNMData_fring_22(double finalDimlessSpin);
 static double interpolateQNMData_fdamp_22(double finalDimlessSpin);

#endif
 
/*
 	Data from: 
 	Berti et al, CQG, 26, 163001, (2009); arXiv:0905.2975
 	https://pages.jh.edu/~eberti2/ringdown/
*/

/* dimensionless Kerr parameter a */
static const int QNMData_a_length = 1200;
static const double QNMData_a[] = {
-1., -0.9983319432860718, -0.9966638865721434, -0.9949958298582152, -0.9933277731442869, -0.9916597164303587,\
-0.9899916597164303, -0.9883236030025021, -0.9866555462885738, -0.9849874895746455, -0.9833194328607172, -0.981651376146789,\
-0.9799833194328608, -0.9783152627189324, -0.9766472060050042, -0.9749791492910759, -0.9733110925771477, -0.9716430358632193,\
-0.9699749791492911, -0.9683069224353628, -0.9666388657214345, -0.9649708090075062, -0.963302752293578, -0.9616346955796498,\
-0.9599666388657214, -0.9582985821517932, -0.9566305254378649, -0.9549624687239366, -0.9532944120100083, -0.9516263552960801,\
-0.9499582985821518, -0.9482902418682235, -0.9466221851542952, -0.944954128440367, -0.9432860717264387, -0.9416180150125104,\
-0.9399499582985822, -0.9382819015846539, -0.9366138448707256, -0.9349457881567973, -0.9332777314428691, -0.9316096747289407,\
-0.9299416180150125, -0.9282735613010842, -0.926605504587156, -0.9249374478732277, -0.9232693911592994, -0.9216013344453712,\
-0.9199332777314428, -0.9182652210175146, -0.9165971643035863, -0.9149291075896581, -0.9132610508757297, -0.9115929941618015,\
-0.9099249374478732, -0.908256880733945, -0.9065888240200167, -0.9049207673060884, -0.9032527105921602, -0.9015846538782318,\
-0.8999165971643036, -0.8982485404503753, -0.896580483736447, -0.8949124270225187, -0.8932443703085905, -0.8915763135946623,\
-0.8899082568807339, -0.8882402001668057, -0.8865721434528774, -0.8849040867389492, -0.8832360300250208, -0.8815679733110926,\
-0.8798999165971643, -0.878231859883236, -0.8765638031693077, -0.8748957464553795, -0.8732276897414513, -0.8715596330275229,\
-0.8698915763135947, -0.8682235195996664, -0.8665554628857381, -0.8648874061718098, -0.8632193494578816, -0.8615512927439533,\
-0.859883236030025, -0.8582151793160967, -0.8565471226021685, -0.8548790658882403, -0.8532110091743119, -0.8515429524603837,\
-0.8498748957464554, -0.8482068390325271, -0.8465387823185988, -0.8448707256046706, -0.8432026688907422, -0.841534612176814,\
-0.8398665554628857, -0.8381984987489575, -0.8365304420350292, -0.8348623853211009, -0.8331943286071727, -0.8315262718932444,\
-0.8298582151793161, -0.8281901584653878, -0.8265221017514596, -0.8248540450375312, -0.823185988323603, -0.8215179316096747,\
-0.8198498748957465, -0.8181818181818182, -0.8165137614678899, -0.8148457047539617, -0.8131776480400333, -0.8115095913261051,\
-0.8098415346121768, -0.8081734778982486, -0.8065054211843202, -0.804837364470392, -0.8031693077564637, -0.8015012510425354,\
-0.7998331943286072, -0.7981651376146789, -0.7964970809007507, -0.7948290241868223, -0.7931609674728941, -0.7914929107589658,\
-0.7898248540450375, -0.7881567973311092, -0.786488740617181, -0.7848206839032527, -0.7831526271893244, -0.7814845704753962,\
-0.7798165137614679, -0.7781484570475397, -0.7764804003336113, -0.7748123436196831, -0.7731442869057548, -0.7714762301918265,\
-0.7698081734778982, -0.76814011676397, -0.7664720600500416, -0.7648040033361134, -0.7631359466221852, -0.7614678899082569,\
-0.7597998331943286, -0.7581317764804003, -0.7564637197664721, -0.7547956630525438, -0.7531276063386155, -0.7514595496246872,\
-0.749791492910759, -0.7481234361968306, -0.7464553794829024, -0.7447873227689742, -0.7431192660550459, -0.7414512093411176,\
-0.7397831526271893, -0.7381150959132611, -0.7364470391993327, -0.7347789824854045, -0.7331109257714762, -0.731442869057548,\
-0.7297748123436196, -0.7281067556296914, -0.7264386989157632, -0.7247706422018348, -0.7231025854879066, -0.7214345287739783,\
-0.7197664720600501, -0.7180984153461217, -0.7164303586321935, -0.7147623019182652, -0.713094245204337, -0.7114261884904087,\
-0.7097581317764804, -0.7080900750625522, -0.7064220183486238, -0.7047539616346956, -0.7030859049207673, -0.7014178482068391,\
-0.6997497914929107, -0.6980817347789825, -0.6964136780650542, -0.6947456213511259, -0.6930775646371977, -0.6914095079232694,\
-0.6897414512093412, -0.6880733944954128, -0.6864053377814846, -0.6847372810675563, -0.683069224353628, -0.6814011676396997,\
-0.6797331109257715, -0.6780650542118432, -0.6763969974979149, -0.6747289407839867, -0.6730608840700584, -0.6713928273561302,\
-0.6697247706422018, -0.6680567139282736, -0.6663886572143453, -0.664720600500417, -0.6630525437864887, -0.6613844870725605,\
-0.6597164303586321, -0.6580483736447039, -0.6563803169307757, -0.6547122602168474, -0.6530442035029191, -0.6513761467889908,\
-0.6497080900750626, -0.6480400333611342, -0.646371976647206, -0.6447039199332777, -0.6430358632193495, -0.6413678065054211,\
-0.6396997497914929, -0.6380316930775647, -0.6363636363636364, -0.6346955796497081, -0.6330275229357798, -0.6313594662218516,\
-0.6296914095079232, -0.628023352793995, -0.6263552960800667, -0.6246872393661385, -0.6230191826522101, -0.6213511259382819,\
-0.6196830692243537, -0.6180150125104253, -0.6163469557964971, -0.6146788990825688, -0.6130108423686406, -0.6113427856547122,\
-0.609674728940784, -0.6080066722268557, -0.6063386155129274, -0.6046705587989991, -0.6030025020850709, -0.6013344453711427,\
-0.5996663886572143, -0.5979983319432861, -0.5963302752293578, -0.5946622185154296, -0.5929941618015012, -0.591326105087573,\
-0.5896580483736447, -0.5879899916597164, -0.5863219349457881, -0.5846538782318599, -0.5829858215179317, -0.5813177648040033,\
-0.5796497080900751, -0.5779816513761468, -0.5763135946622185, -0.5746455379482902, -0.572977481234362, -0.5713094245204337,\
-0.5696413678065054, -0.5679733110925771, -0.5663052543786489, -0.5646371976647206, -0.5629691409507923, -0.5613010842368641,\
-0.5596330275229358, -0.5579649708090075, -0.5562969140950792, -0.554628857381151, -0.5529608006672226, -0.5512927439532944,\
-0.5496246872393661, -0.5479566305254379, -0.5462885738115096, -0.5446205170975813, -0.5429524603836531, -0.5412844036697247,\
-0.5396163469557965, -0.5379482902418682, -0.53628023352794, -0.5346121768140116, -0.5329441201000834, -0.5312760633861552,\
-0.5296080066722268, -0.5279399499582986, -0.5262718932443703, -0.5246038365304421, -0.5229357798165137, -0.5212677231025855,\
-0.5195996663886572, -0.517931609674729, -0.5162635529608006, -0.5145954962468724, -0.5129274395329442, -0.5112593828190158,\
-0.5095913261050876, -0.5079232693911593, -0.5062552126772311, -0.5045871559633027, -0.5029190992493745, -0.5012510425354462,\
-0.49958298582151794, -0.49791492910758967, -0.4962468723936614, -0.4945788156797331, -0.49291075896580483, -0.49124270225187655,\
-0.48957464553794827, -0.48790658882402, -0.48623853211009177, -0.4845704753961635, -0.4829024186822352, -0.48123436196830693,\
-0.47956630525437866, -0.4778982485404504, -0.4762301918265221, -0.4745621351125938, -0.47289407839866554, -0.47122602168473726,\
-0.469557964970809, -0.46788990825688076, -0.4662218515429525, -0.4645537948290242, -0.4628857381150959, -0.46121768140116765,\
-0.45954962468723937, -0.4578815679733111, -0.4562135112593828, -0.45454545454545453, -0.45287739783152625, -0.451209341117598,\
-0.44954128440366975, -0.44787322768974147, -0.4462051709758132, -0.4445371142618849, -0.44286905754795663, -0.44120100083402836,\
-0.4395329441201001, -0.4378648874061718, -0.4361968306922435, -0.43452877397831524, -0.43286071726438696, -0.43119266055045874,\
-0.42952460383653046, -0.4278565471226022, -0.4261884904086739, -0.4245204336947456, -0.42285237698081735, -0.42118432026688907,\
-0.4195162635529608, -0.4178482068390325, -0.41618015012510423, -0.41451209341117595, -0.41284403669724773, -0.41117597998331945,\
-0.40950792326939117, -0.4078398665554629, -0.4061718098415346, -0.40450375312760634, -0.40283569641367806, -0.4011676396997498,\
-0.3994995829858215, -0.3978315262718932, -0.396163469557965, -0.3944954128440367, -0.39282735613010844, -0.39115929941618016,\
-0.3894912427022519, -0.3878231859883236, -0.3861551292743953, -0.38448707256046705, -0.38281901584653877, -0.3811509591326105,\
-0.3794829024186822, -0.377814845704754, -0.3761467889908257, -0.37447873227689743, -0.37281067556296915, -0.3711426188490409,\
-0.3694745621351126, -0.3678065054211843, -0.36613844870725604, -0.36447039199332776, -0.3628023352793995, -0.3611342785654712,\
-0.359466221851543, -0.3577981651376147, -0.3561301084236864, -0.35446205170975814, -0.35279399499582986, -0.3511259382819016,\
-0.3494578815679733, -0.347789824854045, -0.34612176814011675, -0.34445371142618847, -0.3427856547122602, -0.34111759799833197,\
-0.3394495412844037, -0.3377814845704754, -0.33611342785654713, -0.33444537114261885, -0.3327773144286906, -0.3311092577147623,\
-0.329441201000834, -0.32777314428690574, -0.32610508757297746, -0.3244370308590492, -0.32276897414512096, -0.3211009174311927,\
-0.3194328607172644, -0.3177648040033361, -0.31609674728940784, -0.31442869057547956, -0.3127606338615513, -0.311092577147623,\
-0.3094245204336947, -0.30775646371976645, -0.3060884070058382, -0.30442035029190995, -0.30275229357798167, -0.3010842368640534,\
-0.2994161801501251, -0.29774812343619683, -0.29608006672226855, -0.2944120100083403, -0.292743953294412, -0.2910758965804837,\
-0.28940783986655544, -0.2877397831526272, -0.28607172643869894, -0.28440366972477066, -0.2827356130108424, -0.2810675562969141,\
-0.2793994995829858, -0.27773144286905754, -0.27606338615512926, -0.274395329441201, -0.2727272727272727, -0.27105921601334443,\
-0.2693911592994162, -0.2677231025854879, -0.26605504587155965, -0.26438698915763137, -0.2627189324437031, -0.2610508757297748,\
-0.25938281901584653, -0.25771476230191825, -0.25604670558799, -0.2543786488740617, -0.2527105921601334, -0.2510425354462052,\
-0.2493744787322769, -0.24770642201834864, -0.24603836530442036, -0.24437030859049208, -0.2427022518765638, -0.24103419516263552,\
-0.23936613844870724, -0.237698081734779, -0.23603002502085071, -0.23436196830692244, -0.23269391159299416, -0.23102585487906588,\
-0.22935779816513763, -0.22768974145120935, -0.22602168473728107, -0.2243536280233528, -0.2226855713094245, -0.22101751459549623,\
-0.21934945788156798, -0.2176814011676397, -0.21601334445371143, -0.21434528773978315, -0.21267723102585487, -0.21100917431192662,\
-0.20934111759799834, -0.20767306088407006, -0.20600500417014178, -0.2043369474562135, -0.20266889074228525, -0.20100083402835697,\
-0.1993327773144287, -0.19766472060050042, -0.19599666388657214, -0.19432860717264386, -0.1926605504587156, -0.19099249374478733,\
-0.18932443703085905, -0.18765638031693077, -0.1859883236030025, -0.18432026688907424, -0.18265221017514596, -0.18098415346121768,\
-0.1793160967472894, -0.17764804003336113, -0.17597998331943285, -0.1743119266055046, -0.17264386989157632, -0.17097581317764804,\
-0.16930775646371976, -0.16763969974979148, -0.16597164303586323, -0.16430358632193495, -0.16263552960800667, -0.1609674728940784,\
-0.15929941618015012, -0.15763135946622187, -0.1559633027522936, -0.1542952460383653, -0.15262718932443703, -0.15095913261050875,\
-0.14929107589658047, -0.14762301918265222, -0.14595496246872394, -0.14428690575479566, -0.14261884904086738, -0.1409507923269391,\
-0.13928273561301086, -0.13761467889908258, -0.1359466221851543, -0.13427856547122602, -0.13261050875729774, -0.13094245204336946,\
-0.1292743953294412, -0.12760633861551293, -0.12593828190158465, -0.12427022518765637, -0.12260216847372811, -0.12093411175979983,\
-0.11926605504587157, -0.11759799833194329, -0.11592994161801501, -0.11426188490408674, -0.11259382819015847, -0.11092577147623019,\
-0.10925771476230192, -0.10758965804837364, -0.10592160133444536, -0.1042535446205171, -0.10258548790658882, -0.10091743119266056,\
-0.09924937447873228, -0.097581317764804, -0.09591326105087573, -0.09424520433694746, -0.09257714762301918, -0.09090909090909091,\
-0.08924103419516263, -0.08757297748123437, -0.08590492076730609, -0.08423686405337781, -0.08256880733944955, -0.08090075062552127,\
-0.07923269391159299, -0.07756463719766472, -0.07589658048373644, -0.07422852376980818, -0.0725604670558799, -0.07089241034195162,\
-0.06922435362802336, -0.06755629691409508, -0.0658882402001668, -0.06422018348623854, -0.06255212677231026, -0.060884070058381985,\
-0.05921601334445371, -0.057547956630525435, -0.05587989991659716, -0.05421184320266889, -0.05254378648874062, -0.05087572977481234,\
-0.04920767306088407, -0.0475396163469558, -0.045871559633027525, -0.04420350291909925, -0.042535446205170975, -0.0408673894912427,\
-0.03919933277731443, -0.03753127606338615, -0.03586321934945788, -0.03419516263552961, -0.03252710592160134, -0.030859049207673062,\
-0.029190992493744787, -0.027522935779816515, -0.02585487906588824, -0.02418682235195997, -0.022518765638031693, -0.020850708924103418,\
-0.019182652210175146, -0.01751459549624687, -0.0158465387823186, -0.014178482068390326, -0.012510425354462052, -0.010842368640533779,\
-0.009174311926605505, -0.007506255212677231, -0.005838198498748957, -0.004170141784820684, -0.0025020850708924102, -0.0008340283569641367,\
0.0008340283569641367, 0.0025020850708924102, 0.004170141784820684, 0.005838198498748957, 0.007506255212677231, 0.009174311926605505,\
0.010842368640533779, 0.012510425354462052, 0.014178482068390326, 0.0158465387823186, 0.01751459549624687, 0.019182652210175146,\
0.020850708924103418, 0.022518765638031693, 0.02418682235195997, 0.02585487906588824, 0.027522935779816515, 0.029190992493744787,\
0.030859049207673062, 0.03252710592160134, 0.03419516263552961, 0.03586321934945788, 0.03753127606338615, 0.03919933277731443,\
0.0408673894912427, 0.042535446205170975, 0.04420350291909925, 0.045871559633027525, 0.0475396163469558, 0.04920767306088407,\
0.05087572977481234, 0.05254378648874062, 0.05421184320266889, 0.05587989991659716, 0.057547956630525435, 0.05921601334445371,\
0.060884070058381985, 0.06255212677231026, 0.06422018348623854, 0.0658882402001668, 0.06755629691409508, 0.06922435362802336,\
0.07089241034195162, 0.0725604670558799, 0.07422852376980818, 0.07589658048373644, 0.07756463719766472, 0.07923269391159299,\
0.08090075062552127, 0.08256880733944955, 0.08423686405337781, 0.08590492076730609, 0.08757297748123437, 0.08924103419516263,\
0.09090909090909091, 0.09257714762301918, 0.09424520433694746, 0.09591326105087573, 0.097581317764804, 0.09924937447873228,\
0.10091743119266056, 0.10258548790658882, 0.1042535446205171, 0.10592160133444536, 0.10758965804837364, 0.10925771476230192,\
0.11092577147623019, 0.11259382819015847, 0.11426188490408674, 0.11592994161801501, 0.11759799833194329, 0.11926605504587157,\
0.12093411175979983, 0.12260216847372811, 0.12427022518765637, 0.12593828190158465, 0.12760633861551293, 0.1292743953294412,\
0.13094245204336946, 0.13261050875729774, 0.13427856547122602, 0.1359466221851543, 0.13761467889908258, 0.13928273561301086,\
0.1409507923269391, 0.14261884904086738, 0.14428690575479566, 0.14595496246872394, 0.14762301918265222, 0.14929107589658047,\
0.15095913261050875, 0.15262718932443703, 0.1542952460383653, 0.1559633027522936, 0.15763135946622187, 0.15929941618015012,\
0.1609674728940784, 0.16263552960800667, 0.16430358632193495, 0.16597164303586323, 0.16763969974979148, 0.16930775646371976,\
0.17097581317764804, 0.17264386989157632, 0.1743119266055046, 0.17597998331943285, 0.17764804003336113, 0.1793160967472894,\
0.18098415346121768, 0.18265221017514596, 0.18432026688907424, 0.1859883236030025, 0.18765638031693077, 0.18932443703085905,\
0.19099249374478733, 0.1926605504587156, 0.19432860717264386, 0.19599666388657214, 0.19766472060050042, 0.1993327773144287,\
0.20100083402835697, 0.20266889074228525, 0.2043369474562135, 0.20600500417014178, 0.20767306088407006, 0.20934111759799834,\
0.21100917431192662, 0.21267723102585487, 0.21434528773978315, 0.21601334445371143, 0.2176814011676397, 0.21934945788156798,\
0.22101751459549623, 0.2226855713094245, 0.2243536280233528, 0.22602168473728107, 0.22768974145120935, 0.22935779816513763,\
0.23102585487906588, 0.23269391159299416, 0.23436196830692244, 0.23603002502085071, 0.237698081734779, 0.23936613844870724,\
0.24103419516263552, 0.2427022518765638, 0.24437030859049208, 0.24603836530442036, 0.24770642201834864, 0.2493744787322769,\
0.2510425354462052, 0.2527105921601334, 0.2543786488740617, 0.25604670558799, 0.25771476230191825, 0.25938281901584653,\
0.2610508757297748, 0.2627189324437031, 0.26438698915763137, 0.26605504587155965, 0.2677231025854879, 0.2693911592994162,\
0.27105921601334443, 0.2727272727272727, 0.274395329441201, 0.27606338615512926, 0.27773144286905754, 0.2793994995829858,\
0.2810675562969141, 0.2827356130108424, 0.28440366972477066, 0.28607172643869894, 0.2877397831526272, 0.28940783986655544,\
0.2910758965804837, 0.292743953294412, 0.2944120100083403, 0.29608006672226855, 0.29774812343619683, 0.2994161801501251,\
0.3010842368640534, 0.30275229357798167, 0.30442035029190995, 0.3060884070058382, 0.30775646371976645, 0.3094245204336947,\
0.311092577147623, 0.3127606338615513, 0.31442869057547956, 0.31609674728940784, 0.3177648040033361, 0.3194328607172644,\
0.3211009174311927, 0.32276897414512096, 0.3244370308590492, 0.32610508757297746, 0.32777314428690574, 0.329441201000834,\
0.3311092577147623, 0.3327773144286906, 0.33444537114261885, 0.33611342785654713, 0.3377814845704754, 0.3394495412844037,\
0.34111759799833197, 0.3427856547122602, 0.34445371142618847, 0.34612176814011675, 0.347789824854045, 0.3494578815679733,\
0.3511259382819016, 0.35279399499582986, 0.35446205170975814, 0.3561301084236864, 0.3577981651376147, 0.359466221851543,\
0.3611342785654712, 0.3628023352793995, 0.36447039199332776, 0.36613844870725604, 0.3678065054211843, 0.3694745621351126,\
0.3711426188490409, 0.37281067556296915, 0.37447873227689743, 0.3761467889908257, 0.377814845704754, 0.3794829024186822,\
0.3811509591326105, 0.38281901584653877, 0.38448707256046705, 0.3861551292743953, 0.3878231859883236, 0.3894912427022519,\
0.39115929941618016, 0.39282735613010844, 0.3944954128440367, 0.396163469557965, 0.3978315262718932, 0.3994995829858215,\
0.4011676396997498, 0.40283569641367806, 0.40450375312760634, 0.4061718098415346, 0.4078398665554629, 0.40950792326939117,\
0.41117597998331945, 0.41284403669724773, 0.41451209341117595, 0.41618015012510423, 0.4178482068390325, 0.4195162635529608,\
0.42118432026688907, 0.42285237698081735, 0.4245204336947456, 0.4261884904086739, 0.4278565471226022, 0.42952460383653046,\
0.43119266055045874, 0.43286071726438696, 0.43452877397831524, 0.4361968306922435, 0.4378648874061718, 0.4395329441201001,\
0.44120100083402836, 0.44286905754795663, 0.4445371142618849, 0.4462051709758132, 0.44787322768974147, 0.44954128440366975,\
0.451209341117598, 0.45287739783152625, 0.45454545454545453, 0.4562135112593828, 0.4578815679733111, 0.45954962468723937,\
0.46121768140116765, 0.4628857381150959, 0.4645537948290242, 0.4662218515429525, 0.46788990825688076, 0.469557964970809,\
0.47122602168473726, 0.47289407839866554, 0.4745621351125938, 0.4762301918265221, 0.4778982485404504, 0.47956630525437866,\
0.48123436196830693, 0.4829024186822352, 0.4845704753961635, 0.48623853211009177, 0.48790658882402, 0.48957464553794827,\
0.49124270225187655, 0.49291075896580483, 0.4945788156797331, 0.4962468723936614, 0.49791492910758967, 0.49958298582151794,\
0.5012510425354462, 0.5029190992493745, 0.5045871559633027, 0.5062552126772311, 0.5079232693911593, 0.5095913261050876,\
0.5112593828190158, 0.5129274395329442, 0.5145954962468724, 0.5162635529608006, 0.517931609674729, 0.5195996663886572,\
0.5212677231025855, 0.5229357798165137, 0.5246038365304421, 0.5262718932443703, 0.5279399499582986, 0.5296080066722268,\
0.5312760633861552, 0.5329441201000834, 0.5346121768140116, 0.53628023352794, 0.5379482902418682, 0.5396163469557965,\
0.5412844036697247, 0.5429524603836531, 0.5446205170975813, 0.5462885738115096, 0.5479566305254379, 0.5496246872393661,\
0.5512927439532944, 0.5529608006672226, 0.554628857381151, 0.5562969140950792, 0.5579649708090075, 0.5596330275229358,\
0.5613010842368641, 0.5629691409507923, 0.5646371976647206, 0.5663052543786489, 0.5679733110925771, 0.5696413678065054,\
0.5713094245204337, 0.572977481234362, 0.5746455379482902, 0.5763135946622185, 0.5779816513761468, 0.5796497080900751,\
0.5813177648040033, 0.5829858215179317, 0.5846538782318599, 0.5863219349457881, 0.5879899916597164, 0.5896580483736447,\
0.591326105087573, 0.5929941618015012, 0.5946622185154296, 0.5963302752293578, 0.5979983319432861, 0.5996663886572143,\
0.6013344453711427, 0.6030025020850709, 0.6046705587989991, 0.6063386155129274, 0.6080066722268557, 0.609674728940784,\
0.6113427856547122, 0.6130108423686406, 0.6146788990825688, 0.6163469557964971, 0.6180150125104253, 0.6196830692243537,\
0.6213511259382819, 0.6230191826522101, 0.6246872393661385, 0.6263552960800667, 0.628023352793995, 0.6296914095079232,\
0.6313594662218516, 0.6330275229357798, 0.6346955796497081, 0.6363636363636364, 0.6380316930775647, 0.6396997497914929,\
0.6413678065054211, 0.6430358632193495, 0.6447039199332777, 0.646371976647206, 0.6480400333611342, 0.6497080900750626,\
0.6513761467889908, 0.6530442035029191, 0.6547122602168474, 0.6563803169307757, 0.6580483736447039, 0.6597164303586321,\
0.6613844870725605, 0.6630525437864887, 0.664720600500417, 0.6663886572143453, 0.6680567139282736, 0.6697247706422018,\
0.6713928273561302, 0.6730608840700584, 0.6747289407839867, 0.6763969974979149, 0.6780650542118432, 0.6797331109257715,\
0.6814011676396997, 0.683069224353628, 0.6847372810675563, 0.6864053377814846, 0.6880733944954128, 0.6897414512093412,\
0.6914095079232694, 0.6930775646371977, 0.6947456213511259, 0.6964136780650542, 0.6980817347789825, 0.6997497914929107,\
0.7014178482068391, 0.7030859049207673, 0.7047539616346956, 0.7064220183486238, 0.7080900750625522, 0.7097581317764804,\
0.7114261884904087, 0.713094245204337, 0.7147623019182652, 0.7164303586321935, 0.7180984153461217, 0.7197664720600501,\
0.7214345287739783, 0.7231025854879066, 0.7247706422018348, 0.7264386989157632, 0.7281067556296914, 0.7297748123436196,\
0.731442869057548, 0.7331109257714762, 0.7347789824854045, 0.7364470391993327, 0.7381150959132611, 0.7397831526271893,\
0.7414512093411176, 0.7431192660550459, 0.7447873227689742, 0.7464553794829024, 0.7481234361968306, 0.749791492910759,\
0.7514595496246872, 0.7531276063386155, 0.7547956630525438, 0.7564637197664721, 0.7581317764804003, 0.7597998331943286,\
0.7614678899082569, 0.7631359466221852, 0.7648040033361134, 0.7664720600500416, 0.76814011676397, 0.7698081734778982,\
0.7714762301918265, 0.7731442869057548, 0.7748123436196831, 0.7764804003336113, 0.7781484570475397, 0.7798165137614679,\
0.7814845704753962, 0.7831526271893244, 0.7848206839032527, 0.786488740617181, 0.7881567973311092, 0.7898248540450375,\
0.7914929107589658, 0.7931609674728941, 0.7948290241868223, 0.7964970809007507, 0.7981651376146789, 0.7998331943286072,\
0.8015012510425354, 0.8031693077564637, 0.804837364470392, 0.8065054211843202, 0.8081734778982486, 0.8098415346121768,\
0.8115095913261051, 0.8131776480400333, 0.8148457047539617, 0.8165137614678899, 0.8181818181818182, 0.8198498748957465,\
0.8215179316096747, 0.823185988323603, 0.8248540450375312, 0.8265221017514596, 0.8281901584653878, 0.8298582151793161,\
0.8315262718932444, 0.8331943286071727, 0.8348623853211009, 0.8365304420350292, 0.8381984987489575, 0.8398665554628857,\
0.841534612176814, 0.8432026688907422, 0.8448707256046706, 0.8465387823185988, 0.8482068390325271, 0.8498748957464554,\
0.8515429524603837, 0.8532110091743119, 0.8548790658882403, 0.8565471226021685, 0.8582151793160967, 0.859883236030025,\
0.8615512927439533, 0.8632193494578816, 0.8648874061718098, 0.8665554628857381, 0.8682235195996664, 0.8698915763135947,\
0.8715596330275229, 0.8732276897414513, 0.8748957464553795, 0.8765638031693077, 0.878231859883236, 0.8798999165971643,\
0.8815679733110926, 0.8832360300250208, 0.8849040867389492, 0.8865721434528774, 0.8882402001668057, 0.8899082568807339,\
0.8915763135946623, 0.8932443703085905, 0.8949124270225187, 0.896580483736447, 0.8982485404503753, 0.8999165971643036,\
0.9015846538782318, 0.9032527105921602, 0.9049207673060884, 0.9065888240200167, 0.908256880733945, 0.9099249374478732,\
0.9115929941618015, 0.9132610508757297, 0.9149291075896581, 0.9165971643035863, 0.9182652210175146, 0.9199332777314428,\
0.9216013344453712, 0.9232693911592994, 0.9249374478732277, 0.926605504587156, 0.9282735613010842, 0.9299416180150125,\
0.9316096747289407, 0.9332777314428691, 0.9349457881567973, 0.9366138448707256, 0.9382819015846539, 0.9399499582985822,\
0.9416180150125104, 0.9432860717264387, 0.944954128440367, 0.9466221851542952, 0.9482902418682235, 0.9499582985821518,\
0.9516263552960801, 0.9532944120100083, 0.9549624687239366, 0.9566305254378649, 0.9582985821517932, 0.9599666388657214,\
0.9616346955796498, 0.963302752293578, 0.9649708090075062, 0.9666388657214345, 0.9683069224353628, 0.9699749791492911,\
0.9716430358632193, 0.9733110925771477, 0.9749791492910759, 0.9766472060050042, 0.9783152627189324, 0.9799833194328608,\
0.981651376146789, 0.9833194328607172, 0.9849874895746455, 0.9866555462885738, 0.9883236030025021, 0.9899916597164303,\
0.9916597164303587, 0.9933277731442869, 0.9949958298582152, 0.9966638865721434, 0.9983319432860718, 1.
};/* end of data for QNMData_a */

/* fring for Mode 22 according to Berti et al, CQG, 26, 163001, (2009); arXiv:0905.2975 */
static const int QNMData_fring_22_length = 1200;
static const double QNMData_fring_22[] = {
0.04640083138658345, 0.046416045285288365, 0.046431221903556134, 0.04644633303324355, 0.046461350466207404, 0.0464762459943045,\
0.04649099140939163, 0.046505590357034846, 0.046520172888280434, 0.046534803653796704, 0.04654949035004092, 0.04656422577735437,\
0.04657900074341005, 0.04659380753972615, 0.04660864046649851, 0.0466234956120709, 0.046638370328431655, 0.04665326289175636,\
0.04666817224107223, 0.04668309770712659, 0.04669803889655771, 0.04671299558734215, 0.046727967686475164, 0.04674295517194224,\
0.046757958057529934, 0.046772976345848476, 0.046788010095221454, 0.04680305936287465, 0.04681812421218104, 0.04683320467701052,\
0.04684830082621223, 0.046863412705774134, 0.046878540369418804, 0.04689368384461222, 0.04690884319602748, 0.04692401843400433,\
0.046939209616607774, 0.04695441677124491, 0.04696963994438345, 0.04698487916745876, 0.04700013446398896, 0.04701540587150822,\
0.04703069342739411, 0.04704599715182191, 0.04706131709080824, 0.047076653270592454, 0.047092005714512115, 0.0471073744505355,\
0.047122759536119094, 0.0471381609688458, 0.04715357879601272, 0.04716901304751874, 0.047184463749948564, 0.047199930940509734,\
0.047215414644735026, 0.04723091490178183, 0.0472464317300051, 0.04726196516739749, 0.04727751526169452, 0.047293082009867045,\
0.04730866547663811, 0.04732426567609586, 0.04733988262845993, 0.04735551640597694, 0.04737116698855076, 0.04738683445482311,\
0.0474025188118124, 0.047418220098173675, 0.047433938347383235, 0.04744967359156163, 0.04746542584914413, 0.04748119517037804,\
0.04749698159007448, 0.0475127851389163, 0.047528605830676626, 0.04754444371600672, 0.047560298824854144, 0.04757617119809698,\
0.0475920608631721, 0.04760796784455911, 0.04762389219279064, 0.047639833924829386, 0.04765579307905283, 0.0476717696940082,\
0.047687763796659385, 0.047703775432360034, 0.04771980463319255, 0.047735851415733034, 0.04775191583277254, 0.04776799791612676,\
0.04778409769711027, 0.04780021520606504, 0.047816350476269934, 0.047832503561359346, 0.04784867447693275, 0.0478648632755591,\
0.04788106996184503, 0.04789729460221568, 0.047913537214713794, 0.04792979783967174, 0.04794607652390947, 0.04796237327552489,\
0.04797868815260338, 0.04799502118294788, 0.048011372403329845, 0.04802774186069244, 0.04804412956887076, 0.04806053558473838,\
0.04807695992968822, 0.048093402638321944, 0.04810986376499624, 0.0481263433428112, 0.048142841384172734, 0.04815935796087274,\
0.0481758930783604, 0.04819244678792947, 0.04820901913366398, 0.04822561013794186, 0.0482422198460762, 0.048258848302542665,\
0.04827549552989936, 0.048292161565343446, 0.04830884645675486, 0.04832555024556013, 0.04834227296626944, 0.04835901464892196,\
0.04837577533000013, 0.04839255505923284, 0.04840935387028627, 0.04842617180031043, 0.048443008888979074, 0.04845986517007509,\
0.04847674069593977, 0.048493635480251235, 0.048510549589583084, 0.04852748305250568, 0.0485444358976066, 0.04856140817913823,\
0.048578399926150845, 0.04859541119324516, 0.04861244199604985, 0.04862949236721213, 0.04864656239545641, 0.04866365208806359,\
0.048680761493203314, 0.04869789065125766, 0.04871503958913544, 0.04873220835744691, 0.048749396998717866, 0.04876660555692777,\
0.04878383406095885, 0.04880108256074607, 0.048818351086993936, 0.04883563970134531, 0.04885294842314372, 0.0488702772942541,\
0.04888762637104158, 0.048904995686355125, 0.048922385290254645, 0.04893979521163742, 0.04895722549997, 0.04897467619692568,\
0.04899214734040893, 0.049009638976453426, 0.049027151146086106, 0.049044683899824124, 0.04906223726942281, 0.04907981129835546,\
0.04909740604073947, 0.04911502152528176, 0.04913265780347175, 0.049150314921015806, 0.049167992909142116, 0.04918569181289315,\
0.049203411689653254, 0.049221152586075595, 0.04923891452520733, 0.04925669756485148, 0.049274501737255075, 0.04929232711278088,\
0.049310173696213495, 0.049328041574874415, 0.049345930765989844, 0.049363841316960616, 0.049381773276815547, 0.049399726691204314,\
0.049417701616154955, 0.04943569807710016, 0.049453716119530367, 0.04947175581701263, 0.04948981718612529, 0.049507900278435595,\
0.049526005145640525, 0.04954413184641428, 0.04956228039670222, 0.04958045087170554, 0.04959864328976231, 0.04961685773500671,\
0.04963509421511142, 0.04965335280546644, 0.04967163353756218, 0.049689936459145136, 0.04970826162551469, 0.04972660908237226,\
0.04974497888122275, 0.049763371051759556, 0.049781785659566084, 0.049800222757829485, 0.04981868236729268, 0.049837164560333186,\
0.04985566938305525, 0.04987419688422461, 0.0498927470949873, 0.04991132008096813, 0.049929915898170064, 0.049948534574124855,\
0.04996717617439864, 0.04998584074354783, 0.05000452833887103, 0.05002323898900747, 0.05004197277539656, 0.05006072972204698,\
0.05007950988090344, 0.0500983133159333, 0.05011714006947681, 0.0501359902047214, 0.05015486375090459, 0.05017376077263721,\
0.05019268131722949, 0.05021162543287373, 0.05023059318450996, 0.050249584611107394, 0.05026859977549954, 0.050287638719384735,\
0.05030670149717526, 0.0503257881540156, 0.05034489877353903, 0.05036403335651832, 0.050383192002612154, 0.05040237474890266,\
0.05042158164174317, 0.050440812742846265, 0.05046006808833395, 0.05047934776253666, 0.05049865179397568, 0.050517980251718324,\
0.05053733317896132, 0.05055671064064799, 0.05057611266861909, 0.050595539351143436, 0.05061499071619598, 0.05063446682555602,\
0.050653967745234084, 0.05067349352504582, 0.050693044201216834, 0.050712619861889144, 0.05073222054663685, 0.05075184630819724,\
0.050771497202081156, 0.05079117329842625, 0.05081087463030111, 0.050830601278496444, 0.0508503532966209, 0.05087013072968228,\
0.05088993362872194, 0.05090976207209568, 0.050929616108211034, 0.05094949579512016, 0.05096940119052355, 0.05098933235995948,\
0.05100928933327537, 0.05102927221566828, 0.05104928101774452, 0.05106931583908438, 0.05108937670816926, 0.05110946369323228,\
0.0511295768637469, 0.05114971628253486, 0.05116988199510067, 0.05119007406338287, 0.0512102925502112, 0.05123053750847175,\
0.051250809021103086, 0.05127110711958714, 0.05129143188334149, 0.05131178337710238, 0.051332161652914536, 0.05135256677512661,\
0.05137299880740934, 0.05139345779148646, 0.05141394381879378, 0.05143445695561748, 0.05145499722831299, 0.05147556472647982,\
0.05149615951298624, 0.0515167816505525, 0.051537431186738696, 0.051558108201745015, 0.051578812738874755, 0.05159954489715709,\
0.051620304714722065, 0.051641092260274336, 0.051661907598562797, 0.05168275079300234, 0.051703621908285424, 0.05172452103011201,\
0.05174544818950133, 0.05176640348299105, 0.05178738695946276, 0.0518083986865329, 0.051829438726130043, 0.05185050717416496,\
0.05187160406269102, 0.05189272945585858, 0.051913883458791145, 0.05193506611662089, 0.051956277475378114, 0.051977517644343774,\
0.05199878666575308, 0.05202008461882329, 0.052041411561096595, 0.0520627675694109, 0.05208415272068886, 0.052105567060545574,\
0.05212701068680378, 0.05214848364955848, 0.05216998603043312, 0.05219151788396809, 0.05221307930194529, 0.05223467033499639,\
0.05225629106087619, 0.05227794156322106, 0.052299621904578535, 0.05232133215561966, 0.05234307237882843, 0.052364842669152506,\
0.052386643065340036, 0.05240847368041487, 0.05243033455970757, 0.052452225795841446, 0.0524741474281821, 0.05249609957093054,\
0.05251808228376514, 0.052540095621421284, 0.05256213968202921, 0.052584214531752806, 0.052606320247210896, 0.05262845690221681,\
0.05265062458762773, 0.05267282334948495, 0.05269505327275708, 0.05271731445486177, 0.052739606942525954, 0.052761930838124166,\
0.052784286203975586, 0.05280667313100323, 0.052829091672623785, 0.05285154194183919, 0.05287402397916999, 0.05289653787992338,\
0.05291908372654381, 0.05294166161342361, 0.05296427157484512, 0.052986913727622785, 0.053009588141609144, 0.05303229489562243,\
0.05305503408303269, 0.05307780575678394, 0.053100610014509865, 0.05312344693180525, 0.053146316601207326, 0.05316921910972022,\
0.05319215450593079, 0.053215122907175026, 0.05323812438347006, 0.053261159026563434, 0.053284226892079886, 0.05330732808607429,\
0.053330462704425215, 0.053353630806121384, 0.05337683247722243, 0.053400067814285745, 0.053423336914968464, 0.05344663982743775,\
0.05346997666857617, 0.05349334751606103, 0.053516752446365175, 0.05354019157272944, 0.053563664938810804, 0.05358717267519189,\
0.05361071485214486, 0.05363429154364783, 0.05365790287033108, 0.05368154888782735, 0.05370522969508792, 0.05372894539385669,\
0.053752696061051444, 0.053776481798337404, 0.053800302685099825, 0.05382415880965255, 0.05384805027996812, 0.053871977166666876,\
0.053895939572774346, 0.053919937584768166, 0.05394397129960855, 0.053968040813376965, 0.05399214621525908, 0.05401628758634181,\
0.05404046504228144, 0.054064678658980014, 0.054088928548528994, 0.05411321478302749, 0.05413753747035756, 0.054161896707643264,\
0.05418629259740106, 0.054210725217819486, 0.05423519467749454, 0.05425970107020181, 0.054284244482617636, 0.05430882503148726,\
0.05433344281383338, 0.05435809790798193, 0.05438279041817893, 0.05440752046452551, 0.05443228812707754, 0.054457093508754835,\
0.05448193671725085, 0.054506817843942845, 0.054531736997288964, 0.05455669427056419, 0.054581689758571944, 0.05460672359270678,\
0.05463179585107996, 0.054656906648533676, 0.05468205607774541, 0.05470724423487869, 0.054732471254076286, 0.05475773722213824,\
0.05478304223126789, 0.054808386417210246, 0.054833769849128265, 0.05485919267809142, 0.05488465496411754, 0.05491015684448605,\
0.05493569841828071, 0.05496127978355831, 0.05498690106859987, 0.055012562356617944, 0.05503826378519088, 0.05506400543902898,\
0.05508978745343008, 0.05511560990625767, 0.05514147294603834, 0.055167376654561194, 0.05519332114267393, 0.05521930654818541,\
0.05524533296667673, 0.055271400511897835, 0.055297509287412956, 0.05532365943317287, 0.05534985104532537, 0.05537608424460922,\
0.0554023591388297, 0.055428675853745855, 0.05545503449337319, 0.05548143518038537, 0.05550787803567391, 0.055534363179108696,\
0.05556089072203235, 0.05558746079276706, 0.05561407350465249, 0.05564072896166252, 0.05566742730150821, 0.05569416864650448,\
0.05572095311268288, 0.05574778081815047, 0.05577465189191901, 0.05580156644853604, 0.05582852460590799, 0.05585552651151354,\
0.05588257227002919, 0.05590966201480146, 0.05593679585575743, 0.05596397393344603, 0.055991196374327264, 0.05601846329164129,\
0.056045774825968446, 0.05607313110316331, 0.05610053224737768, 0.05612797838346555, 0.05615546965571739, 0.05618300617404836,\
0.056210588080984426, 0.056238215511439954, 0.05626588859205143, 0.05629360744724898, 0.056321372210433734, 0.056349183019342476,\
0.056377040021547024, 0.05640494331850579, 0.056432893084057405, 0.05646088941264146, 0.05648893247737326, 0.056517022398672775,\
0.056545159303523274, 0.05657334334336537, 0.0566015746555521, 0.05662985336551876, 0.056658179641914774, 0.056686553586743293,\
0.05671497536330199, 0.0567434451148402, 0.05677196297828451, 0.05680052909534249, 0.056829143590513984, 0.056857806641478624,\
0.05688651837370633, 0.056915278941370676, 0.05694408848202213, 0.05697294714171106, 0.057001855064766786, 0.05703081240521512,\
0.05705981930170699, 0.05708887591398755, 0.05711798238395735, 0.05714713887397098, 0.057176345526559307, 0.05720560248445631,\
0.05723490990671166, 0.05726426793965907, 0.057293676750477425, 0.05732313648995693, 0.05735264730158331, 0.05738220935411579,\
0.057411822786245174, 0.05744148777640781, 0.05747120446880723, 0.05750097302258963, 0.057530793594380576, 0.057560666345005576,\
0.05759059144048778, 0.05762056904189127, 0.05765059930591788, 0.057680682390089874, 0.05771081846720325, 0.05774100768407587,\
0.0577712502359182, 0.05780154626870946, 0.05783189594013837, 0.05786229942397183, 0.05789275692761997, 0.05792326855895615,\
0.05795383450454001, 0.05798445493964121, 0.05801513004046105, 0.05804585996684843, 0.058076644903464265, 0.05810748501136827,\
0.05813838046907996, 0.058169331450282545, 0.058200338146844714, 0.05823140071213771, 0.05826251932283224, 0.058293694185738786,\
0.058324925437837426, 0.058356213290897074, 0.05838755791336733, 0.0584189594814535, 0.05845041818485983, 0.05848193421418962,\
0.058513507739413564, 0.05854513894039099, 0.058576828017207, 0.05860857514408799, 0.058640380515156194, 0.05867224432040756,\
0.05870416673566146, 0.05873614797395607, 0.05876818819838471, 0.05880028761956125, 0.05883244643744913, 0.058864664810013574,\
0.05889694296645908, 0.058929281096982145, 0.05896167936835614, 0.05899413802423128, 0.05902665722237533, 0.05905923717061363,\
0.05909187809305216, 0.05912458016862594, 0.05915734359327818, 0.05919016859150924, 0.05922305534910527, 0.05925600408803763,\
0.059289014984606696, 0.05932208828288423, 0.059355224154907564, 0.05938842283783196, 0.059421684537515035, 0.05945500944514747,\
0.05948839778329334, 0.059521849778107525, 0.05955536562359741, 0.0595889455386083, 0.05962258974803167, 0.05965629847166624,\
0.05969007191581925, 0.05972391030292596, 0.05975781384532689, 0.05979178278121788, 0.059825817313376904, 0.0598599176911774,\
0.05989408412224005, 0.059928316830968116, 0.05996261606225925, 0.059996982021780464, 0.06003141494697049, 0.06006591506441675,\
0.06010048262310349, 0.06013511783372122, 0.06016982095255301, 0.06020459218446821, 0.06023943179845929, 0.06027433999865859,\
0.060309317057488765, 0.06034436319391422, 0.060379478647713376, 0.06041466367048005, 0.0604499185014342, 0.06048524339430952,\
0.06052063857798629, 0.060556104307576145, 0.06059164084319936, 0.060627248414596976, 0.06066292729300014, 0.06069867770999867,\
0.060734499934463136, 0.06077039422141819, 0.060806360827135045, 0.0608423999893577, 0.06087851199717229, 0.06091469708740355,\
0.06095095553372722, 0.06098728759448922, 0.06102369354314139, 0.06106017363520467, 0.06109672813738292, 0.061133357325239286,\
0.06117006147273227, 0.0612068408434555, 0.06124369570753412, 0.061280626338732554, 0.06131763303319828, 0.06135471604256311,\
0.06139187565276798, 0.061429112155273566, 0.06146642582735172, 0.06150381694355167, 0.061541285792193215, 0.06157883267103826,\
0.06161645785818982, 0.06165416163382778, 0.06169194430325959, 0.06172980616218852, 0.06176774749326967, 0.06180576859741373,\
0.061843869776511996, 0.0618820513184556, 0.06192031353709836, 0.06195865671837061, 0.06199708118320639, 0.06203558722721956,\
0.062074175166389786, 0.062112845303525045, 0.06215159793950075, 0.062190433400962565, 0.062229352009099556, 0.06226835406662883,\
0.062307439891305924, 0.062346609802283834, 0.06238586411505239, 0.06242520317476955, 0.06246462730134629, 0.06250413679465333,\
0.06254373201567948, 0.06258341327920552, 0.06262318091169097, 0.062663035258214, 0.0627029766574735, 0.06274300543066594,\
0.06278312194304485, 0.06282332651951957, 0.06286361949651191, 0.0629040012365073, 0.06294447207922008, 0.0629850323772214,\
0.06302568247879399, 0.0630664227422533, 0.06310725351894263, 0.06314817516250454, 0.06318918804840376, 0.06323029252772515,\
0.06327148895753487, 0.06331277772006413, 0.06335415918204067, 0.06339563368968242, 0.06343720165342936, 0.06347886342430777,\
0.06352061938532055, 0.06356246990407276, 0.06360441538670769, 0.0636464561969265, 0.06368859272765938, 0.06373082535915144,\
0.06377315449216911, 0.06381558052202675, 0.06385810383110951, 0.0639007248338041, 0.06394344391585431, 0.06398626150374771,\
0.06402917795890069, 0.06407219372805048, 0.06411530920847422, 0.0641585248131872, 0.06420184095073911, 0.06424525803022665,\
0.06428877650266862, 0.06433239676663029, 0.06437611924417067, 0.06441994438505232, 0.0644638725950837, 0.0645079043214758,\
0.06455204000158533, 0.06459628006437854, 0.06464062494963246, 0.06468507512256108, 0.06472963099829462, 0.06477429304540547,\
0.06481906171761459, 0.06486393745808361, 0.06490892073058402, 0.06495401199483243, 0.06499921171217206, 0.06504452035875109,\
0.06508993840127762, 0.06513546630268811, 0.06518110454632116, 0.06522685360663504, 0.06527271396111106, 0.06531868610340141,\
0.06536477052610928, 0.0654109676925432, 0.06545727812691549, 0.06550370231067269, 0.06555024075405877, 0.06559689395468106,\
0.0656436624139634, 0.06569054664507508, 0.0657375471647205, 0.06578466449110439, 0.06583189913820145, 0.06587925163765151,\
0.06592672250508938, 0.06597431227535999, 0.06602202149360943, 0.06606985067900314, 0.06611780037898167, 0.0661658711385298,\
0.06621406351803585, 0.06626237805764086, 0.06631081529980379, 0.06635937583041122, 0.06640806018627524, 0.06645686895851512,\
0.06650580269746152, 0.06655486199510312, 0.06660404741789622, 0.0666533595370666, 0.06670279896727109, 0.06675236628226792,\
0.06680206207201661, 0.0668518869337789, 0.06690184149224354, 0.06695192633159326, 0.06700214205981939, 0.06705248930804779,\
0.06710296868772789, 0.0671535808077126, 0.06720432631929955, 0.06725520584380416, 0.06730622002234782, 0.0673573694963128,\
0.06740865488745204, 0.06746007688369324, 0.06751163610037941, 0.0675633332261847, 0.06761516891745487, 0.06766714384514232,\
0.06771925866662029, 0.06777151407838464, 0.0678239107377375, 0.06787644936601138, 0.0679291306283833, 0.06798195524443583,\
0.06803492389848348, 0.0680880373127645, 0.06814129618011397, 0.06819470123238736, 0.06824825319952076, 0.0683019527869961,\
0.06835580075889039, 0.06840979781843042, 0.06846394474873219, 0.06851824226735115, 0.068572691140973, 0.0686272921439019,\
0.06868204601675153, 0.06873695356005836, 0.06879201553279835, 0.06884723272279125, 0.06890260592859003, 0.06895813592415304,\
0.0690138235311319, 0.06906966956328889, 0.06912567480947326, 0.06918184010880743, 0.06923816627865814, 0.06929465415597137,\
0.06935130456880825, 0.06940811839031165, 0.0694650964417054, 0.06952223959200644, 0.06957954870973097, 0.06963702466088795,\
0.06969466833061633, 0.0697524805923507, 0.06981046235764361, 0.06986861451073419, 0.06992693795854302, 0.06998543361070782,\
0.0700441023993864, 0.07010294523785494, 0.07016196307007304, 0.07022115684315737, 0.0702805274859328, 0.07034007599196863,\
0.07039980329249869, 0.07045971036982943, 0.0705197982108741, 0.07058006781027264, 0.07064052014090759, 0.07070115621522008,\
0.07076197706060115, 0.07082298369030879, 0.07088417712465003, 0.07094555841795919, 0.071007128588873, 0.07106888872630526,\
0.0711308398665611, 0.07119298309355798, 0.07125531948864441, 0.07131785014016573, 0.07138057614521566, 0.07144349861839537,\
0.07150661866009027, 0.0715699374261787, 0.07163345602180472, 0.07169717561393328, 0.07176109735157056, 0.07182522240431403,\
0.07188955195466692, 0.07195408716323029, 0.07201882924326333, 0.07208377940139873, 0.07214893884235823, 0.07221430880248401,\
0.0722798905264521, 0.07234568525558366, 0.07241169423262778, 0.07247791875463301, 0.07254436009691936, 0.07261101954250888,\
0.07267789839223045, 0.07274499797429165, 0.07281231961121863, 0.07287986464581257, 0.07294763441561943, 0.07301563029205138,\
0.0730838536540936, 0.07315230589526768, 0.07322098839669215, 0.07328990258898221, 0.07335904987645504, 0.07342843171880731,\
0.0734980495658183, 0.0735679048754462, 0.073637999121921, 0.07370833381237711, 0.07377891044941164, 0.07384973054825084,\
0.07392079563222681, 0.07399210726857526, 0.07406366700659678, 0.07413547645127638, 0.07420753715673667, 0.07427985075028914,\
0.07435241885258666, 0.07442524310338856, 0.07449832514984121, 0.0745716666804213, 0.07464526936316082, 0.07471913490684799,\
0.07479326503091133, 0.07486766146193444, 0.07494232595726458, 0.07501726029975939, 0.0750924662593657, 0.07516794564193771,\
0.07524370027585418, 0.07531973198530086, 0.07539604265587285, 0.07547263413700128, 0.07554950835150229, 0.07562666718521435,\
0.07570411260554205, 0.07578184652400113, 0.0758598709456061, 0.07593818785633712, 0.07601679926004865, 0.07609570720999645,\
0.07617491374540698, 0.07625442093749107, 0.07633423089843855, 0.07641434573370401, 0.07649476760853598, 0.07657549865561925,\
0.0766565410813123, 0.07673789709315082, 0.07681956891177961, 0.07690155880823485, 0.07698386907000049, 0.07706650197339734,\
0.07714945987892498, 0.07723274511626924, 0.07731636007294448, 0.07740030716175496, 0.07748458880553763, 0.07756920746890943,\
0.07765416563512754, 0.07773946581807967, 0.07782511056387659, 0.07791110242207207, 0.07799744401489915, 0.0780841379485141,\
0.07817118688219482, 0.07825859350414585, 0.0783463605306955, 0.07843449071897814, 0.0785229868267978, 0.07861185165811725,\
0.078701088077669, 0.07879069895782038, 0.07888068718729427, 0.07897105571633443, 0.07906180751947077, 0.07915294560878924,\
0.07924447303665512, 0.07933639286511265, 0.07942870823467718, 0.07952142228900282, 0.07961453820634579, 0.07970805924895973,\
0.07980198865096313, 0.07989632974632434, 0.0799910858652042, 0.08008626042060565, 0.08018185682217184, 0.08027787855608903,\
0.08037432913014558, 0.08047121212093167, 0.08056853110169002, 0.08066628974772122, 0.08076449174864171, 0.08086314082333707,\
0.08096224079285823, 0.08106179547984614, 0.08116180876548947, 0.08126228457365747, 0.08136322692856465, 0.08146463982166169,\
0.08156652737984972, 0.0816688937207933, 0.08177174306360964, 0.0818750796349511, 0.08197890777355235, 0.08208323181925367,\
0.08218805621000065, 0.08229338543449269, 0.08239922402752002, 0.08250557659110601, 0.08261244780681609, 0.08271984238633709,\
0.08282776515752181, 0.0829362209494269, 0.08304521471682066, 0.08315475144082256, 0.08326483620916482, 0.08337547415956897,\
0.08348667047955963, 0.08359843048954044, 0.08371075954070682, 0.08382366306338905, 0.08393714657986563, 0.08405121569604358,\
0.08416587608047828, 0.08428113350063914, 0.08439699380472947, 0.08451346292237703, 0.08463054687905852, 0.08474825177956008,\
0.08486658384081218, 0.08498554935062397, 0.08510515469384028, 0.08522540637963524, 0.08534631097252628, 0.08546787519493489,\
0.08559010582319196, 0.08571300975732761, 0.0858365940216728, 0.08596086572359748, 0.08608583209617825, 0.08621150048179996,\
0.08633787837414943, 0.08646497332494285, 0.08659279305062317, 0.08672134541108852, 0.08685063834317595, 0.0869806799601738,\
0.08711147847938984, 0.08724304227105094, 0.08737537985574355, 0.08750849985867377, 0.08764241110311914, 0.08777712250949475,\
0.08791264320999935, 0.08804898244931711, 0.0881861496681494, 0.08832415441753184, 0.08846300647916285, 0.08860271578659114,\
0.08874329241511333, 0.08888474669701181, 0.08902708907563113, 0.08917033021260895, 0.0893144809922803, 0.08945955245263719,\
0.0896055558839363, 0.08975250274147618, 0.08990040472125423, 0.0900492737506019, 0.09019912196270165, 0.09034996172484319,\
0.09050180567461333, 0.09065466664895834, 0.09080855778364749, 0.09096349241909975, 0.0911194842303707, 0.09127654710215084,\
0.09143469524056524, 0.0915939431149938, 0.0917543055203753, 0.0919157975151559, 0.0920784345236995, 0.09224223224802222,\
0.09240720674015328, 0.09257337439178968, 0.09274075195366428, 0.09290935653416398, 0.09307920559817354, 0.0932503170146962,\
0.09342270905992375, 0.09359640037252465, 0.09377141004679895, 0.09394775760562567, 0.09412546300226368, 0.09430454667568179,\
0.09448502951819723, 0.0946669329160876, 0.09485027876222256, 0.09503508948944778, 0.0952213880575951, 0.09540919796213405,\
0.09559854331315247, 0.09578944878387911, 0.09598193969063046, 0.09617604197364465, 0.09637178222117793, 0.09656918772478809,\
0.09676828648507613, 0.09696910720412343, 0.09717167938052965, 0.09737603326696033, 0.09758219994959934, 0.0977902113478564,\
0.09800010028875847, 0.09821190045891505, 0.09842564653121755, 0.09864137413441629, 0.09885911995371714, 0.09907892169096667,\
0.09930081818969386, 0.0995248494047596, 0.09975105651687356, 0.09997948195233253, 0.10021016940568744, 0.10044316395503443,\
0.10067851205476118, 0.10091626166601178, 0.10115646227055433, 0.10139916493874025, 0.10164442243626409, 0.1018922892862284,\
0.10214282183140477, 0.10239607832024927, 0.10265211905413205, 0.1029110063890347, 0.10317280495055849, 0.1034375816037667,\
0.10370540573209426, 0.10397634920372437, 0.10425048662547307, 0.10452789539950766, 0.10480865592094149, 0.10509285172265592,\
0.10538056963488093, 0.10567189998373067, 0.10596693680744682, 0.10626577797274908, 0.10656852555753041, 0.10687528593525741,\
0.1071861701346488, 0.10750129408120764, 0.10782077892717895, 0.10814475135735895, 0.10847334392613198, 0.1088066955015286,\
0.10914495162619439, 0.10948826499345861, 0.10983679592730254, 0.1101907129548019, 0.1105501933384177, 0.11091542376443077,\
0.11128660098844369, 0.11166393269624493, 0.11204763825276545, 0.1124379496710892, 0.1128351126975813, 0.11323938781757713,\
0.1136510516852244, 0.11407039839545753, 0.11449774110252182, 0.11493341374486335, 0.11537777303628288, 0.1158312006269911,\
0.11629410562512456, 0.116766927347042, 0.11725013850497187, 0.11774424888433493, 0.11824980940199216, 0.11876741688875031,\
0.11929771956077777, 0.11984142331063923, 0.12039929912782288, 0.12097219167213774, 0.1215610294228461, 0.1221668365896629,\
0.12279074749447122, 0.12343402356078188, 0.12409807403808233, 0.12478448116027412, 0.125495031053594, 0.12623175221607383,\
0.1269969636518144, 0.1277933361619404, 0.12862397120438523, 0.1294925038128886, 0.1304032397718238, 0.13136134116730017,\
0.13237308374729248, 0.13344622272811538, 0.13459052904212898, 0.13581860396558676, 0.13714717245609775, 0.13859924310304023,\
0.14019735579091797, 0.1419421626126953, 0.1438299027176266, 0.14585681525496572, 0.148019139373967, 0.15031311422388427
};/* end of data for QNMData_fring_22 */

/* fdamp for Mode 22 according to Berti et al, CQG, 26, 163001, (2009) */
static const int QNMData_fdamp_22_length = 1200;
static const double QNMData_fdamp_22[] = {
0.014023091005783306, 0.01402073291567241, 0.014018717953515789, 0.014017079898000143, 0.01401585252781218, 0.0140150696216386,\
0.014014764958166104, 0.014014933310341177, 0.014015392038911478, 0.0140159924187949, 0.01401665931260062, 0.014017355307007125,\
0.014018062100438294, 0.014018771032989418, 0.01401947827262184, 0.014020182362638136, 0.014020882975920485, 0.014021580283405596,\
0.014022274639406323, 0.014022966435643977, 0.014023656034927265, 0.014024343740589126, 0.014025029803661628, 0.014025714416934032,\
0.014026397755656459, 0.01402707987925098, 0.014027760893581672, 0.01402844086031029, 0.014029119819272785, 0.014029797800172253,\
0.014030474818905235, 0.014031150888151963, 0.01403182601502976, 0.014032500199308984, 0.014033173442471047, 0.014033845743834357,\
0.014034517097999131, 0.014035187501195728, 0.014035856951880402, 0.014036525442756196, 0.014037192971351574, 0.014037859532226858,\
0.014038525121330726, 0.014039189735134404, 0.014039853368523305, 0.014040516019731034, 0.014041177682531663, 0.014041838355593389,\
0.014042498035127162, 0.01404315671797984, 0.014043814399184812, 0.014044471079632385, 0.014045126752871055, 0.014045781417936842,\
0.014046435072957511, 0.014047087713680323, 0.014047739338443362, 0.014048389943931752, 0.014049039527689816, 0.014049688087435706,\
0.014050335621992371, 0.014050982128346377, 0.014051627602327343, 0.01405227204388785, 0.014052915447907434, 0.014053557815233065,\
0.014054199141523019, 0.014054839425753415, 0.014055478663189439, 0.014056116854102527, 0.014056753994090093, 0.014057390082642156,\
0.014058025114809516, 0.014058659091504697, 0.014059292006272723, 0.014059923861245896, 0.014060554651132004, 0.014061184372796015,\
0.014061813026515782, 0.01406244060755965, 0.014063067115297584, 0.014063692545173131, 0.014064316897281201, 0.014064940167330032,\
0.014065562354804946, 0.014066183454358006, 0.014066803466110235, 0.01406742238705225, 0.014068040212283117, 0.01406865694302957,\
0.014069272574746976, 0.014069887105178898, 0.014070500530756761, 0.014071112852365498, 0.01407172406327499, 0.01407233416446183,\
0.014072943151919017, 0.014073551022479374, 0.014074157774749763, 0.014074763405929332, 0.014075367912728337, 0.014075971294971013,\
0.014076573546710608, 0.014077174668340835, 0.014077774654752715, 0.014078373505252874, 0.01407897121626927, 0.014079567787468534,\
0.01408016321313049, 0.01408075749265052, 0.01408135062213047, 0.014081942600918803, 0.014082533425207133, 0.01408312309155044,\
0.014083711599168311, 0.014084298944341158, 0.014084885125206902, 0.014085470138466739, 0.014086053981152721, 0.014086636651608277,\
0.014087218146969945, 0.014087798464359716, 0.014088377602079781, 0.014088955555639689, 0.014089532324324052, 0.014090107904822761,\
0.014090682293192614, 0.014091255488882723, 0.014091827487975515, 0.014092398287907803, 0.014092967886219892, 0.014093536279997095,\
0.014094103467756929, 0.014094669445415412, 0.014095234210263234, 0.014095797761103514, 0.014096360093952843, 0.014096921205606799,\
0.01409748109448454, 0.01409803975737829, 0.014098597193616641, 0.014099153365821643, 0.014099708335510263, 0.014100262067744687,\
0.014100814560653359, 0.01410136581223634, 0.014101915818149001, 0.014102464576854616, 0.014103012084099647, 0.014103558339526829,\
0.014104103337974397, 0.01410464707687779, 0.01410518955614958, 0.014105730770447758, 0.01410627071754479, 0.014106809394352115,\
0.014107346799290618, 0.014107882928353643, 0.014108417778183745, 0.014108951348182555, 0.014109483633900948, 0.014110014632672887,\
0.014110544342131735, 0.014111072759365845, 0.014111599880451364, 0.014112125703915636, 0.014112650226453777, 0.01411317344494448,\
0.014113695356123562, 0.014114215958621225, 0.014114735249064208, 0.014115253223072999, 0.014115769879317985, 0.014116285214496318,\
0.014116799224879758, 0.014117311908668778, 0.01411782326274485, 0.014118333284165651, 0.014118841968799317, 0.01411934931570914,\
0.014119855319823902, 0.014120359981136043, 0.01412086329237721, 0.014121365254908933, 0.014121865863019022, 0.014122365115226538,\
0.014122863008488105, 0.01412335953749925, 0.014123854702520134, 0.01412434849756578, 0.014124840921759436, 0.014125331971644502,\
0.014125821644121449, 0.014126309936147977, 0.014126796844188945, 0.014127282365379695, 0.01412776649652548, 0.014128249234065396,\
0.014128730577433189, 0.014129210520380034, 0.014129689061503364, 0.014130166197595138, 0.014130641925472255, 0.014131116241991778,\
0.014131589143874582, 0.01413206062716303, 0.01413253069090912, 0.014132999330673381, 0.01413346654268895, 0.014133932323294436,\
0.014134396671454854, 0.014134859583204285, 0.01413532105497732, 0.014135781083278443, 0.01413623966472284, 0.014136696797591823,\
0.014137152476991518, 0.014137606701412725, 0.014138059466247988, 0.014138510767912157, 0.014138960605117566, 0.014139408972405098,\
0.014139855868228647, 0.014140301286816762, 0.014140745228625833, 0.01414118768713632, 0.01414162865935375, 0.014142068143703746,\
0.014142506135202907, 0.014142942632573775, 0.014143377630006587, 0.014143811126154798, 0.014144243116139786, 0.014144673596719124,\
0.014145102564675664, 0.014145530017145531, 0.014145955951040557, 0.014146380360750348, 0.014146803246452722, 0.01414722460127355,\
0.014147644422909583, 0.014148062708234333, 0.014148479454169149, 0.014148894656898916, 0.014149308311553041, 0.014149720416813156,\
0.014150130966915146, 0.014150539960611884, 0.014150947393095126, 0.01415135326111705, 0.014151757559764873, 0.014152160287741583,\
0.01415256144013386, 0.014152961013304497, 0.014153359007136613, 0.014153755410742059, 0.014154150225595385, 0.01415454344588375,\
0.0141549350710647, 0.014155325094074332, 0.01415571351307772, 0.014156100322773993, 0.014156485521841466, 0.014156869103486548,\
0.014157251067391066, 0.014157631408168427, 0.014158010121254574, 0.014158387203630883, 0.014158762651182585, 0.014159136461031493,\
0.014159508629594862, 0.01415987915152788, 0.014160248024094066, 0.014160615241350316, 0.014160980802624044, 0.014161344701792776,\
0.01416170693643168, 0.014162067501848761, 0.014162426393517205, 0.014162783609453666, 0.014163139142782794, 0.014163492992650583,\
0.014163845152365519, 0.014164195619525095, 0.014164544390181498, 0.014164891459599824, 0.014165236823640747, 0.014165580478421936,\
0.014165922421055792, 0.014166262645923798, 0.01416660115002394, 0.014166937928280686, 0.014167272976755735, 0.014167606290932585,\
0.01416793786806809, 0.014168267704002183, 0.01416859579297018, 0.014168922131698401, 0.014169246714970688, 0.014169569540465953,\
0.014169890602858356, 0.014170209897094594, 0.014170527419991575, 0.014170843166828321, 0.01417115713286861, 0.01417146931527375,\
0.014171779708340765, 0.014172088307138802, 0.014172395108645703, 0.014172700107999144, 0.014173003302021982, 0.014173304683285485,\
0.014173604249094326, 0.01417390199625945, 0.014174197918487445, 0.014174492010785302, 0.014174784270175255, 0.0141750746922631,\
0.014175363271246195, 0.014175650002362919, 0.014175934882430172, 0.014176217906769706, 0.014176499068499143, 0.014176778365757332,\
0.014177055792024641, 0.014177331342712672, 0.014177605014783186, 0.014177876801744527, 0.014178146699884717, 0.014178414703482259,\
0.014178680808506578, 0.014178945008492367, 0.014179207300767827, 0.014179467681040994, 0.014179726141547153, 0.014179982679277128,\
0.014180237288959662, 0.014180489966372622, 0.014180740704854398, 0.014180989500989468, 0.0141812363488144, 0.014181481245173747,\
0.014181724181442519, 0.014181965156285024, 0.01418220416289832, 0.014182441195905754, 0.014182676249934906, 0.014182909320740502,\
0.01418314040366973, 0.014183369491661883, 0.014183596581790426, 0.014183821666254712, 0.014184044741828012, 0.014184265803422795,\
0.014184484844158282, 0.014184701858813232, 0.014184916843227278, 0.014185129791096039, 0.014185340698482908, 0.01418554955800345,\
0.014185756364912596, 0.014185961113906147, 0.01418616379956459, 0.014186364415654289, 0.014186562957101054, 0.014186759419602546,\
0.014186953794951707, 0.01418714608007017, 0.014187336268791872, 0.014187524354263454, 0.014187710329484918, 0.014187894193399928,\
0.014188075936010942, 0.014188255553150555, 0.014188433040232075, 0.01418860838821527, 0.014188781594152062, 0.014188952651992288,\
0.014189121553042345, 0.014189288294420257, 0.014189452869308696, 0.014189615270938778, 0.014189775494646426, 0.014189933532303795,\
0.0141900893803399, 0.014190243030481012, 0.014190394477140197, 0.014190543713402186, 0.014190690735903826, 0.014190835537250856,\
0.014190978110244485, 0.014191118449778984, 0.014191256549235374, 0.014191392400345828, 0.014191525998224515, 0.014191657337949476,\
0.014191786411330789, 0.014191913212185388, 0.014192037734208237, 0.014192159970275937, 0.01419227991443369, 0.0141923975608467,\
0.014192512901623093, 0.014192625930949531, 0.014192736642480875, 0.014192845027839152, 0.014192951081536691, 0.0141930547971732,\
0.014193156167111129, 0.014193255183818648, 0.014193351841447127, 0.014193446134557999, 0.014193538053934694, 0.014193627593440119,\
0.014193714747117022, 0.014193799505761572, 0.01419388186315409, 0.014193961813073402, 0.014194039347495848, 0.014194114459265165,\
0.014194187143140252, 0.01419425738760862, 0.014194325190097288, 0.014194390540581883, 0.01419445343185067, 0.014194513858093479,\
0.014194571809489543, 0.014194627280360094, 0.014194680263397803, 0.01419473075024032, 0.01419477873325098, 0.014194824204279104,\
0.014194867157058847, 0.014194907583416372, 0.014194945476878778, 0.014194980827275654, 0.01419501362690765, 0.014195043870639848,\
0.014195071548618342, 0.01419509665203217, 0.014195119174950512, 0.014195139109211425, 0.014195156444785858, 0.014195171175461253,\
0.014195183293127304, 0.014195192789311596, 0.014195199654348734, 0.014195203882291074, 0.014195205463415949, 0.014195204390715036,\
0.014195200654257537, 0.014195194245723903, 0.0141951851585689, 0.014195173381959804, 0.01419515890966224, 0.014195141729742546,\
0.014195121837803025, 0.014195099222186975, 0.014195073874695825, 0.014195045787393853, 0.014195014950370904, 0.014194981357194342,\
0.014194944994485731, 0.014194905858071094, 0.014194863935939253, 0.014194819220234559, 0.014194771702867873, 0.014194721372103505,\
0.01419466822024318, 0.014194612238818167, 0.014194553416520398, 0.014194491746251467, 0.014194427217252073, 0.014194359820488178,\
0.014194289546384511, 0.014194216385641896, 0.014194140328682922, 0.014194061366199757, 0.014193979487944151, 0.014193894684133365,\
0.014193806944579284, 0.014193716260928402, 0.014193622622078069, 0.014193526019268548, 0.014193426441533112, 0.014193323877675827,\
0.014193218321148126, 0.014193109757776089, 0.01419299818106485, 0.01419288357673561, 0.01419276593895786, 0.014192645253560666,\
0.014192521512219865, 0.014192394704645327, 0.014192264818153109, 0.014192131844583535, 0.014191995773142018, 0.014191856590359405,\
0.014191714288851916, 0.014191568855108055, 0.014191420280251525, 0.014191268552767707, 0.01419111366073014, 0.014190955594008474,\
0.014190794341203098, 0.014190629892027892, 0.014190462233290194, 0.01419029135577161, 0.014190117246639893, 0.01418993989567902,\
0.01418975929008574, 0.014189575418998254, 0.014189388271035145, 0.014189197834904632, 0.014189004096840777, 0.014188807047626694,\
0.014188606673781884, 0.014188402962652802, 0.014188195904685928, 0.014187985486287658, 0.014187771695561454, 0.014187554520376138,\
0.014187333947298274, 0.014187109965875529, 0.014186882562756818, 0.014186651724277998, 0.014186417441150706, 0.014186179697076204,\
0.014185938482079028, 0.01418569378178105, 0.01418544558338013, 0.014185193874664673, 0.014184938643094565, 0.014184679874519102,\
0.01418441755623592, 0.014184151675627537, 0.014183882218340169, 0.014183609170791592, 0.014183332520376816, 0.014183052253984346,\
0.01418276835715573, 0.014182480817043569, 0.014182189619103787, 0.014181894749953386, 0.014181596194757187, 0.014181293940598779,\
0.014180987973979197, 0.014180678279154483, 0.014180364843392641, 0.014180047650552845, 0.014179726613784792, 0.01417940186672159,\
0.014179073321032113, 0.014178740962103368, 0.014178404773965106, 0.014178064741007235, 0.014177720850526345, 0.014177373086637315,\
0.014177021433417137, 0.01417666587577837, 0.014176306399569119, 0.01417594298995275, 0.014175575630219841, 0.014175204304223138,\
0.014174828997585638, 0.014174449693365003, 0.0141740663777928, 0.014173679033248501, 0.014173287644753677, 0.014172892195681621,\
0.014172492669421203, 0.014172089050652361, 0.01417168132249019, 0.014171269467379427, 0.014170853470804339, 0.014170433314828685,\
0.01417000898358082, 0.014169580458762302, 0.014169147723265673, 0.014168710761717376, 0.014168269556922939, 0.01416782408948395,\
0.014167374345310672, 0.01416692030278435, 0.01416646194705543, 0.014165999260706472, 0.01416553222397828, 0.014165060820416665,\
0.014164585030712589, 0.014164104838761227, 0.01416362022357378, 0.014163131168655533, 0.014162637655636884, 0.014162139665294131,\
0.01416163717864765, 0.014161130178302577, 0.014160618642941283, 0.014160102555351845, 0.01415958189482876, 0.01415905664343747,\
0.014158526777834026, 0.014157992276970604, 0.014157453125721026, 0.014156909305413636, 0.014156360795109863, 0.014155807576001277,\
0.01415524962609109, 0.014154686925889495, 0.014154119455797415, 0.01415354719527399, 0.014152970199765252, 0.014152388301106255,\
0.014151801550202745, 0.01415120992359207, 0.014150613401587174, 0.014150011962661148, 0.014149405585784071, 0.014148794248631585,\
0.014148177928874937, 0.014147556606146123, 0.01414693025643752, 0.014146298859436175, 0.014145662392448029, 0.014145020831599908,\
0.01414437415742398, 0.014143722342964895, 0.014143065369355652, 0.014142403210600691, 0.01414173584511795, 0.01414106324906092,\
0.01414038540000816, 0.014139702272245988, 0.01413901384381967, 0.014138320088747975, 0.014137620985031253, 0.014136916508611062,\
0.014136206633622353, 0.014135491334631258, 0.014134770588162503, 0.014134044370625244, 0.014133312655781152, 0.014132575416701544,\
0.014131832630158794, 0.01413108427100524, 0.01413033031248222, 0.014129570727248866, 0.014128805492109363, 0.014128034579317005,\
0.014127257961758915, 0.014126475613383897, 0.014125687508130065, 0.014124893618856132, 0.01412409391744918, 0.014123288377211942,\
0.014122476970887565, 0.014121659669983916, 0.014120836448178792, 0.014120007276074358, 0.014119172126193109, 0.014118330969033496,\
0.014117483776358963, 0.014116630520006142, 0.014115771169619047, 0.014114905697743648, 0.014114034073580405, 0.014113156267767274,\
0.014112272250413501, 0.014111381992587999, 0.014110485462917308, 0.014109582630522598, 0.014108673464971652, 0.014107757937367788,\
0.014106836014463907, 0.01410590766430495, 0.014104972858560081, 0.014104031562721064, 0.014103083744890667, 0.014102129374813328,\
0.014101168418284033, 0.01410020084361369, 0.014099226618312961, 0.014098245707682939, 0.014097258077997292, 0.0140962636988641,\
0.0140952625334802, 0.014094254549906478, 0.014093239711634781, 0.014092217986236461, 0.014091189336950041, 0.014090153731249501,\
0.014089111130742123, 0.014088061503350142, 0.014087004811830754, 0.01408594101815321, 0.014084870088561057, 0.01408379198647456,\
0.014082706673198008, 0.014081614113041003, 0.0140805142691036, 0.014079407102389889, 0.014078292575916553, 0.014077170651246392,\
0.014076041289816325, 0.014074904452979745, 0.014073760102359957, 0.014072608197574369, 0.014071448699658146, 0.014070281569035163,\
0.014069106764224244, 0.014067924245903732, 0.014066733974656513, 0.014065535906792142, 0.01406433000250774, 0.01406311621960538,\
0.01406189451618789, 0.01406066484962191, 0.014059427177365686, 0.014058181456793179, 0.014056927645676436, 0.014055665698813596,\
0.014054395573216184, 0.01405311722529565, 0.014051830608150647, 0.014050535678481142, 0.014049232391675267, 0.01404792070145724,\
0.014046600561334908, 0.014045271924523737, 0.014043934747534889, 0.01404258897937611, 0.014041234575987258, 0.014039871487879833,\
0.014038499668191548, 0.014037119066971455, 0.014035729632269463, 0.01403433132319618, 0.014032924085717944, 0.014031507869603757,\
0.014030082624155286, 0.01402864830013213, 0.014027204845583757, 0.014025752208583481, 0.014024290338183028, 0.014022819181943076,\
0.014021338687016653, 0.01401984880051768, 0.014018349466237878, 0.014016840634639783, 0.014015322248076344, 0.014013794252108929,\
0.014012256592867877, 0.0140107092143585, 0.014009152059196886, 0.01400758507053925, 0.014006008193330713, 0.014004421368680301,\
0.014002824539366741, 0.014001217645037426, 0.013999600629238823, 0.013997973432102129, 0.013996335992766713, 0.013994688252056558,\
0.013993030147245625, 0.013991361619296738, 0.013989682604329898, 0.01398799304118639, 0.01398629286716261, 0.01398458201839084,\
0.013982860431072379, 0.01398112804094968, 0.013979384782336944, 0.01397763059189501, 0.01397586540084346, 0.013974089145731335,\
0.01397230175518683, 0.013970503165918422, 0.013968693307484566, 0.0139668721110892, 0.013965039507372913, 0.013963195427550621,\
0.013961339799451345, 0.013959472553092721, 0.01395759361508075, 0.013955702916071152, 0.013953800380868636, 0.013951885936220815,\
0.013949959508932509, 0.013948021021334873, 0.013946070401606414, 0.013944107571372032, 0.013942132455667706, 0.013940144973938317,\
0.013938145051540056, 0.013936132607542477, 0.013934107563149684, 0.013932069841722546, 0.013930019355795803, 0.013927956027013468,\
0.013925879773573737, 0.013923790510626694, 0.013921688156844454, 0.01391957262737653, 0.013917443835152518, 0.013915301697655872,\
0.013913146124945168, 0.013910977030573136, 0.013908794327562955, 0.013906597925226867, 0.013904387734373259, 0.013902163664504403,\
0.013899925625385497, 0.01389767352264961, 0.013895407264469362, 0.013893126756744834, 0.013890831905103514, 0.013888522613171046,\
0.01388619878463324, 0.013883860324097556, 0.01388150713031896, 0.013879139106419344, 0.013876756151753863, 0.013874358164310468,\
0.01387194504328618, 0.013869516686717877, 0.01386707298932237, 0.013864613846743574, 0.013862139154403768, 0.01385964880374819,\
0.01385714268968079, 0.0138546207018417, 0.013852082729590329, 0.013849528664891171, 0.013846958393970522, 0.013844371805405225,\
0.013841768784798536, 0.013839149216078999, 0.013836512985889112, 0.013833859974618182, 0.013831190064415352, 0.013828503139126406,\
0.013825799073255372, 0.013823077748596318, 0.013820339042066289, 0.013817582828895622, 0.013814808983926166, 0.013812017380657285,\
0.013809207892174692, 0.01380638038857305, 0.013803534740646781, 0.013800670817607563, 0.013797788485480338, 0.013794887611264238,\
0.013791968058823711, 0.01378902969268268, 0.013786072374021444, 0.013783095963947285, 0.013780100321359883, 0.013777085299359176,\
0.013774050764768961, 0.01377099656677384, 0.01376792255911772, 0.01376482859529384, 0.013761714525100744, 0.013758580197569146,\
0.013755425459038361, 0.013752250158485762, 0.013749054138621424, 0.013745837241111152, 0.013742599309472364, 0.013739340183749378,\
0.013736059700312208, 0.013732757695097814, 0.013729434004965388, 0.013726088461761687, 0.013722720895473915, 0.01371933113806531,\
0.013715919015889746, 0.013712484353943557, 0.013709026979187288, 0.013705546710274125, 0.013702043370870085, 0.013698516777572592,\
0.013694966747183221, 0.013691393093071191, 0.013687795630675365, 0.01368417416918341, 0.01368052851692466, 0.013676858480206982,\
0.013673163864367026, 0.013669444473114448, 0.013665700103288249, 0.01366193055409652, 0.013658135622992137, 0.013654315102680736,\
0.013650468784423445, 0.0136465964570567, 0.013642697908036426, 0.013638772922204896, 0.01363482128046459, 0.013630842762794903,\
0.013626837145887898, 0.013622804206348288, 0.013618743713687764, 0.013614655440764402, 0.013610539151564655, 0.013606394613399995,\
0.013602221585448448, 0.0135980198285018, 0.013593789098129172, 0.013589529147216988, 0.013585239728030114, 0.013580920589570587,\
0.013576571473198917, 0.013572192123872968, 0.013567782279716117, 0.01356334167805217, 0.013558870049418664, 0.013554367125691741,\
0.013549832633637602, 0.013545266295310297, 0.013540667835944327, 0.01353603696617865, 0.013531373400856027, 0.01352667685280669,\
0.013521947026184084, 0.01351718362681765, 0.013512386353433662, 0.013507554901127043, 0.013502688964868316, 0.01349778823240712,\
0.013492852387112186, 0.013487881113362948, 0.013482874085389918, 0.013477830979312771, 0.01347275146255969, 0.013467635202205636,\
0.013462481857817215, 0.013457291087956383, 0.013452062544341744, 0.013446795875485501, 0.013441490725047982, 0.013436146734230443,\
0.013430763538676426, 0.013425340764960712, 0.013419878043591326, 0.013414374992759728, 0.01340883122970479, 0.01340324636522493,\
0.013397620006332508, 0.013391951754883611, 0.013386241205936423, 0.013380487950106898, 0.013374691574806051, 0.013368851659960755,\
0.013362967778600215, 0.013357039502966229, 0.013351066394240352, 0.013345048010723531, 0.01333898390532056, 0.013332873622963528,\
0.013326716704404325, 0.013320512683210396, 0.013314261086440207, 0.013307961435915961, 0.013301613246270815, 0.013295216027062838,\
0.013288769277562685, 0.013282272493206555, 0.013275725162745892, 0.013269126765712715, 0.013262476776152972, 0.013255774660869937,\
0.01324901987840269, 0.01324221187918041, 0.013235350109186026, 0.013228434001658476, 0.013221462985372266, 0.01321443648179027,\
0.013207353900567294, 0.01320021464459221, 0.013193018105373227, 0.013185763677984512, 0.01317845073453016, 0.013171078642476878,\
0.013163646761940057, 0.013156154442539057, 0.013148601022874476, 0.013140985836297305, 0.01313330820062799, 0.013125567427222274,\
0.013117762816140518, 0.013109893657473566, 0.01310195923009179, 0.013093958803641816, 0.013085891634971666, 0.01307775696866308,\
0.013069554041528928, 0.013061282074582459, 0.01305294028008011, 0.013044527856386852, 0.013036043989245821, 0.013027487853420717,\
0.013018858611177853, 0.013010155408423162, 0.013001377380660168, 0.012992523647542987, 0.012983593316789685, 0.012974585481865896,\
0.012965499218955363, 0.012956333593003796, 0.012947087651868205, 0.012937760427194606, 0.012928350938400987, 0.012918858184514593,\
0.01290928115090077, 0.012899618806971977, 0.012889870101043808, 0.012880033968787038, 0.012870109322613316, 0.012860095064394604,\
0.012849990068771341, 0.01283979319845126, 0.012829503291789456, 0.012819119170456458, 0.012808639634504593, 0.012798063464858988,\
0.012787389417611563, 0.012776616230941848, 0.01276574262014602, 0.012754767276204377, 0.012743688868507725, 0.012732506043333354,\
0.012721217420087229, 0.012709821596327628, 0.012698317148906915, 0.012686702611361336, 0.012674976509056723, 0.012663137332324836,\
0.012651183545182056, 0.012639113583829197, 0.012626925852857816, 0.01261461873189764, 0.01260219056359108, 0.012589639665955487,\
0.012576964320150688, 0.012564162774909534, 0.012551233249708962, 0.01253817392328594, 0.01252498294515821, 0.012511658423552566,\
0.01249819843213641, 0.012484601006860831, 0.012470864144787229, 0.01245698580122314, 0.012442963891448285, 0.012428796287253038,\
0.01241448082227898, 0.01240001527851976, 0.01238539739726454, 0.01237062487081388, 0.012355695345502578, 0.012340606417067173,\
0.012325355628642757, 0.012309940476197661, 0.012294358397016945, 0.012278606777871657, 0.012262682944465442, 0.012246584167592577,\
0.012230307658322573, 0.01221385056380981, 0.012197209969749878, 0.012180382895710665, 0.012163366297027314, 0.012146157055772438,\
0.012128751987451135, 0.012111147828283021, 0.012093341245822516, 0.012075328826695148, 0.012057107077715247, 0.012038672422353399,\
0.012020021201048779, 0.012001149658082652, 0.011982053967454182, 0.011962730191531457, 0.011943174301685497, 0.011923382168802017,\
0.011903349562131944, 0.011883072145791235, 0.011862545472303294, 0.011841764981657529, 0.011820725997795064, 0.011799423720391635,\
0.011777853228591158, 0.011756009467912627, 0.011733887250342427, 0.011711481252019953, 0.011688786001616205, 0.011665795880376075,\
0.011642505115539098, 0.01161890777309494, 0.011594997753952641, 0.011570768786215801, 0.011546214419626612, 0.011521328020147315,\
0.011496102758509033, 0.011470531605745338, 0.011444607327417563, 0.01141832247044249, 0.011391669356693064, 0.01136464007740015,\
0.011337226475496056, 0.011309420145555233, 0.011281212413781659, 0.011252594333214995, 0.011223556669604565, 0.011194089888218269,\
0.011164184143653963, 0.01113382926152445, 0.011103014727152328, 0.011071729670727783, 0.011039962848679058, 0.011007702635386696,\
0.010974936973193464, 0.010941653396846463, 0.010907838989700132, 0.010873480359581893, 0.010838563624991181, 0.010803074383814965,\
0.010766997685892898, 0.01073031801462699, 0.010693019242145777, 0.010655084611272644, 0.010616496695408349, 0.01057723735715634,\
0.010537287721322832, 0.010496628118919967, 0.010455238052940645, 0.010413096147830415, 0.010370180091096332, 0.01032646658757884,\
0.010281931291223482, 0.010236548745645658, 0.010190292310461323, 0.010143134088431708, 0.01009504483937559, 0.010045993895842166,\
0.009995949066671918, 0.00994487652750819, 0.00989274071036916, 0.00983950417131604, 0.009785127480894629, 0.009729569035958481,\
0.009672784921357492, 0.009614728724484347, 0.009555351338844527, 0.00949460074410494, 0.00943242176935106, 0.009368755818550492,\
0.009303540585816412, 0.009236709715381614, 0.009168192440815022, 0.009097913173426144, 0.009025791037842592, 0.008951739356879531,\
0.00887566506682176, 0.008797468051053593, 0.0087170403971518, 0.008634265527365553, 0.008549017228621189, 0.008461158518926887,\
0.00837054035955161, 0.008277000116495467, 0.008180359848530674, 0.008080424222163816, 0.007976978101109537, 0.007869783683362608,\
0.007758577080669007, 0.0076430642172667426, 0.007522915870611559, 0.007397761623485299, 0.007267182410050874, 0.0071307012731812065,\
0.0069877717286391935, 0.006837762987626562, 0.006679940913802502, 0.006513443052964721, 0.006337245548935072, 0.00615011810765746,\
0.005950561643572311, 0.005736719543007996, 0.0055062475465691195, 0.005256115992273224, 0.004982295815215829, 0.00467923404381926,\
0.004341484797159593, 0.0039688904372225655, 0.0035623595594009, 0.0031228007590874234, 0.002651122631674851, 0.0021482337725560186
};/* end of data for QNMData_fdamp_22 */

#ifdef __cplusplus
}
#endif

#endif /* _LALSIM_IMR_PHENOMX_QNM_H */
