%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalsimulation
Version: 1.6.0
Release: 1%{?dist}
Summary: LSC Algorithm Simulation Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: gsl-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.16.1
BuildRequires: lal-python >= 6.16.1
BuildRequires: lal-octave >= 6.16.1
Requires: gsl
Requires: lal >= 6.16.1
Prefix: %{_prefix}

%description
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains the shared-object libraries needed to run applications
that use the LAL Simulation library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Simulation
Group: LAL
Requires: %{name} = %{version}
Requires: gsl-devel
Requires: lal-devel >= 6.16.1
%description devel
The LSC Algorithm Simulation Library for gravitational wave data analysis. This
package contains files needed build applications that use the LAL Simulation
library.

%package python
Summary: Python bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.16.1
%description python
This package provides the Python Bindings for LALSimulation.

%package octave
Summary: Octave bindings for LALSimulation
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.16.1
%description octave
This package provides the Octave Bindings for LALSimulation.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-openmp
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_bindir}/lalsim*
%{_datarootdir}/lalsimulation/LALSimNeutronStarEOS_*
%{_datarootdir}/lalsimulation/LIGO-P1200087-v18*
%{_datarootdir}/lalsimulation/LIGO-T0900288-v3*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalsimulation/*.py
%{_libdir}/python*/site-packages/lalsimulation/*.pyc
%{_libdir}/python*/site-packages/lalsimulation/_lalsimulation.so*
%exclude %{_libdir}/python*/site-packages/lalsimulation/*.pyo

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalsimulation.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.6.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.5.0-1
- Pre O2 packaging test release
