%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalpulsar
Version: 1.16.0
Release: 1%{?dist}
Summary: LSC Algorithm Pulsar Library
License: GPLv2+
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: gsl-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.18.0
BuildRequires: lal-octave >= 6.18.0
BuildRequires: lal-python >= 6.18.0
BuildRequires: lalxml-devel >= 1.2.4
BuildRequires: lalxml-octave >= 1.2.4
BuildRequires: lalxml-python >= 1.2.4
Requires: cfitsio
Requires: fftw
Requires: gsl
Requires: lal >= 6.18.0
Requires: lalxml >= 1.2.4
Prefix: %{_prefix}

%description
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Pulsar
Group: LAL
Requires: %{name} = %{version}
Requires: cfitsio-devel
Requires: fftw-devel
Requires: fftw-static
Requires: gsl-devel
Requires: lal-devel >= 6.18.0
Requires: lalxml-devel >= 1.2.4
%description devel
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Pulsar library.

%package python
Summary: Python bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.18.0
Requires: lalxml-python >= 1.2.4
%description python
This package provides the Python bindings for LALPulsar.

%package octave
Summary: Octave bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.18.0
Requires: lalxml-octave >= 1.2.4
%description octave
This package provides the Octave bindings for LALPulsar.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-cfitsio
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
find $RPM_BUILD_ROOT%{_libdir} -name '*.la' -delete

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_bindir}/lalpulsar_version
%{_datarootdir}/lalpulsar/*
%{_libdir}/*.so.*
%{_sysconfdir}/*

%files devel
%defattr(-,root,root)
%{_includedir}/lal
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/pkgconfig/*

%files python
%defattr(-,root,root)
%{_libdir}/python*

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalpulsar.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Tue Feb 07 2017 Adam Mercer <adam.mercer@ligo.org> 1.16.0-1
- O2 release

* Mon Sep 26 2016 Adam Mercer <adam.mercer@ligo.org> 1.15.0-1
- ER10 release

* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.14.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.13.0-1
- Pre O2 packaging test release
