/*
 * LALPulsarVCSInfo.h - LALPulsar VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALPULSARVCSINFOHEADER_H
#define _LALPULSARVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALPulsarVCSInfo.h>
#include <lal/LALPulsarConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information defines */
#define LALPULSAR_NAME "LALPulsar"
#define LALPULSAR_VCS_ID "fac0378b007ef7c15e7ab6c37d688dfe9f07d031"
#define LALPULSAR_VCS_DATE "2016-10-10 17:31:35 +0000"
#define LALPULSAR_VCS_BRANCH "None"
#define LALPULSAR_VCS_TAG "lalpulsar-v1.15.0"
#define LALPULSAR_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_STATUS "CLEAN: All modifications committed"

/* Identable VCS information defines */
#define LALPULSAR_VCS_IDENT_ID "$" "LALPulsarId: fac0378b007ef7c15e7ab6c37d688dfe9f07d031 " "$"
#define LALPULSAR_VCS_IDENT_DATE "$" "LALPulsarDate: 2016-10-10 17:31:35 +0000 " "$"
#define LALPULSAR_VCS_IDENT_BRANCH "$" "LALPulsarBranch: None " "$"
#define LALPULSAR_VCS_IDENT_TAG "$" "LALPulsarTag: lalpulsar-v1.15.0 " "$"
#define LALPULSAR_VCS_IDENT_AUTHOR "$" "LALPulsarAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALPULSAR_VCS_IDENT_COMMITTER "$" "LALPulsarCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALPULSAR_VCS_IDENT_STATUS "$" "LALPulsarStatus: CLEAN: All modifications committed " "$"

/* Header VCS information structure */
static const LALVCSInfo lalPulsarVCSInfoHeader = { \
  LALPULSAR_NAME, \
  LALPULSAR_VERSION, \
  LALPULSAR_VCS_ID, \
  LALPULSAR_VCS_DATE, \
  LALPULSAR_VCS_BRANCH, \
  LALPULSAR_VCS_TAG, \
  LALPULSAR_VCS_AUTHOR, \
  LALPULSAR_VCS_COMMITTER, \
  LALPULSAR_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALPULSARVCSINFOHEADER_H */

/** \endcond */

/*
 * vim: tw=0 ts=2 et
 */
