%define _prefix /usr
%define _mandir %{_prefix}/share/man
%define _sysconfdir %{_prefix}/etc

Name: lalpulsar
Version: 1.14.0
Release: 1%{?dist}
Summary: LSC Algorithm Pulsar Library
License: GPL
Group: LAL
Source: %{name}-%{version}.tar.xz
URL: https://wiki.ligo.org/DASWG/LALSuite
Packager: Adam Mercer <adam.mercer@ligo.org>
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: cfitsio-devel
BuildRequires: fftw-devel
BuildRequires: gsl-devel
BuildRequires: numpy
BuildRequires: octave-devel
BuildRequires: python-devel
BuildRequires: swig
BuildRequires: lal-devel >= 6.16.1
BuildRequires: lal-python >= 6.16.1
BuildRequires: lal-octave >= 6.16.1
BuildRequires: lalxml-devel >= 1.2.2
BuildRequires: lalxml-python >= 1.2.2
BuildRequires: lalxml-octave >= 1.2.2
Requires: cfitsio
Requires: fftw
Requires: gsl
Requires: lal >= 6.16.1
Requires: lalxml >= 1.2.2
Prefix: %{_prefix}

%description
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains the shared-object libraries needed to run applications
that use the LAL Pulsar library.

%package devel
Summary: Files and documentation needed for compiling programs that use LAL Pulsar
Group: LAL
Requires: %{name} = %{version}
Requires: cfitsio-devel
Requires: fftw-devel
Requires: fftw-static
Requires: gsl-devel
Requires: lal-devel >= 6.16.1
Requires: lalxml-devel >= 1.2.2
%description devel
The LSC Algorithm Pulsar Library for gravitational wave data analysis.
This package contains files needed build applications that use the LAL
Pulsar library.

%package python
Summary: Python bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: numpy
Requires: python
Requires: lal-python >= 6.16.1
Requires: lalxml-python >= 1.2.2
%description python
This package provides the Python bindings for LALPulsar.

%package octave
Summary: Octave bindings for LALPulsar
Group: LAL
Requires: %{name} = %{version}
Requires: octave
Requires: lal-octave >= 6.16.1
Requires: lalxml-octave >= 1.2.2
%description octave
This package provides the Octave bindings for LALPulsar.

%prep
%setup -q

%build
%configure --disable-gcc-flags --enable-swig --enable-cfitsio
%{__make} V=1

%check
%{__make} V=1 check

%install
%make_install
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

%post
ldconfig

%postun
ldconfig

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -Rf ${RPM_BUILD_ROOT}
rm -Rf ${RPM_BUILD_DIR}/%{name}-%{version}

%files
%defattr(-,root,root)
%{_libdir}/*.so*
%{_sysconfdir}/*
%{_prefix}/share/lalpulsar/*

%files devel
%defattr(-,root,root)
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%{_includedir}/lal

%files python
%defattr(-,root,root)
%{_libdir}/python*/site-packages/lalpulsar/*.py
%{_libdir}/python*/site-packages/lalpulsar/*.pyc
%{_libdir}/python*/site-packages/lalpulsar/_lalpulsar.so*
%exclude %{_libdir}/python*/site-packages/lalpulsar/*.pyo

%files octave
%defattr(-,root,root)
%{_prefix}/lib*/octave/*/site/oct/*/lalpulsar.oct*

# dates should be formatted using: 'date +"%a %b %d %Y"'
%changelog
* Thu Jun 23 2016 Adam Mercer <adam.mercer@ligo.org> 1.14.0-1
- ER9 release

* Fri Mar 25 2016 Adam Mercer <adam.mercer@ligo.org> 1.13.0-1
- Pre O2 packaging test release
