/*
 * LALPulsarVCSInfo.h - LALPulsar VCS Information Header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Copyright (C) 2009-2013 Adam Mercer
 * Copyright (C) 2014 Karl Wette
 */

#ifndef _LALPULSARVCSINFOHEADER_H
#define _LALPULSARVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALPulsarVCSInfo.h>
#include <lal/LALPulsarConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* vcs information defines */
#define LALPULSAR_NAME "LALPulsar"
#define LALPULSAR_VCS_ID "1e77f8656b089809dcd03c125ecc4c325e70f8e5"
#define LALPULSAR_VCS_DATE "2015-08-3 22:14:28 +0000"
#define LALPULSAR_VCS_BRANCH "None"
#define LALPULSAR_VCS_TAG "lalpulsar-v1.12.0"
#define LALPULSAR_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALPULSAR_VCS_STATUS "CLEAN: All modifications committed"

/* vcs information defines - identable*/
#define LALPULSAR_VCS_IDENT_ID "$" "LALPulsarId: 1e77f8656b089809dcd03c125ecc4c325e70f8e5 " "$"
#define LALPULSAR_VCS_IDENT_DATE "$" "LALPulsarDate: 2015-08-3 22:14:28 +0000 " "$"
#define LALPULSAR_VCS_IDENT_BRANCH "$" "LALPulsarBranch: None " "$"
#define LALPULSAR_VCS_IDENT_TAG "$" "LALPulsarTag: lalpulsar-v1.12.0 " "$"
#define LALPULSAR_VCS_IDENT_AUTHOR "$" "LALPulsarAuthor: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALPULSAR_VCS_IDENT_COMMITTER "$" "LALPulsarCommitter: Adam Mercer <adam.mercer@ligo.org> " "$"
#define LALPULSAR_VCS_IDENT_STATUS "$" "LALPulsarStatus: CLEAN: All modifications committed " "$"

/* header vcs information structure */
static const struct tagLALVCSInfo lalPulsarVCSInfoHeader = { \
  LALPULSAR_NAME, \
  LALPULSAR_VERSION, \
  LALPULSAR_VCS_ID, \
  LALPULSAR_VCS_DATE, \
  LALPULSAR_VCS_BRANCH, \
  LALPULSAR_VCS_TAG, \
  LALPULSAR_VCS_AUTHOR, \
  LALPULSAR_VCS_COMMITTER, \
  LALPULSAR_VCS_STATUS \
};

#ifdef __cplusplus
}
#endif

#endif /* _LALPULSARVCSINFOHEADER_H */

/*
 * vim: tw=0 ts=2 et
 */
